/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.ClosedLostReason;
import software.amazon.awssdk.services.partnercentralselling.model.LifeCycleNextStepsHistoryListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.NextStepsHistory;
import software.amazon.awssdk.services.partnercentralselling.model.ReviewStatus;
import software.amazon.awssdk.services.partnercentralselling.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifeCycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifeCycle> {
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(LifeCycle.getter(LifeCycle::stageAsString)).setter(LifeCycle.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<String> CLOSED_LOST_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClosedLostReason").getter(LifeCycle.getter(LifeCycle::closedLostReasonAsString)).setter(LifeCycle.setter(Builder::closedLostReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedLostReason").build()}).build();
    private static final SdkField<String> NEXT_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextSteps").getter(LifeCycle.getter(LifeCycle::nextSteps)).setter(LifeCycle.setter(Builder::nextSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSteps").build()}).build();
    private static final SdkField<String> TARGET_CLOSE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCloseDate").getter(LifeCycle.getter(LifeCycle::targetCloseDate)).setter(LifeCycle.setter(Builder::targetCloseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCloseDate").build()}).build();
    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatus").getter(LifeCycle.getter(LifeCycle::reviewStatusAsString)).setter(LifeCycle.setter(Builder::reviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()}).build();
    private static final SdkField<String> REVIEW_COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewComments").getter(LifeCycle.getter(LifeCycle::reviewComments)).setter(LifeCycle.setter(Builder::reviewComments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewComments").build()}).build();
    private static final SdkField<String> REVIEW_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatusReason").getter(LifeCycle.getter(LifeCycle::reviewStatusReason)).setter(LifeCycle.setter(Builder::reviewStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatusReason").build()}).build();
    private static final SdkField<List<NextStepsHistory>> NEXT_STEPS_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NextStepsHistory").getter(LifeCycle.getter(LifeCycle::nextStepsHistory)).setter(LifeCycle.setter(Builder::nextStepsHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextStepsHistory").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NextStepsHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, CLOSED_LOST_REASON_FIELD, NEXT_STEPS_FIELD, TARGET_CLOSE_DATE_FIELD, REVIEW_STATUS_FIELD, REVIEW_COMMENTS_FIELD, REVIEW_STATUS_REASON_FIELD, NEXT_STEPS_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifeCycle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stage;
    private final String closedLostReason;
    private final String nextSteps;
    private final String targetCloseDate;
    private final String reviewStatus;
    private final String reviewComments;
    private final String reviewStatusReason;
    private final List<NextStepsHistory> nextStepsHistory;

    private LifeCycle(BuilderImpl builder) {
        this.stage = builder.stage;
        this.closedLostReason = builder.closedLostReason;
        this.nextSteps = builder.nextSteps;
        this.targetCloseDate = builder.targetCloseDate;
        this.reviewStatus = builder.reviewStatus;
        this.reviewComments = builder.reviewComments;
        this.reviewStatusReason = builder.reviewStatusReason;
        this.nextStepsHistory = builder.nextStepsHistory;
    }

    public final Stage stage() {
        return Stage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final ClosedLostReason closedLostReason() {
        return ClosedLostReason.fromValue(this.closedLostReason);
    }

    public final String closedLostReasonAsString() {
        return this.closedLostReason;
    }

    public final String nextSteps() {
        return this.nextSteps;
    }

    public final String targetCloseDate() {
        return this.targetCloseDate;
    }

    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(this.reviewStatus);
    }

    public final String reviewStatusAsString() {
        return this.reviewStatus;
    }

    public final String reviewComments() {
        return this.reviewComments;
    }

    public final String reviewStatusReason() {
        return this.reviewStatusReason;
    }

    public final boolean hasNextStepsHistory() {
        return this.nextStepsHistory != null && !(this.nextStepsHistory instanceof SdkAutoConstructList);
    }

    public final List<NextStepsHistory> nextStepsHistory() {
        return this.nextStepsHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.closedLostReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCloseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewComments());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextStepsHistory() ? this.nextStepsHistory() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycle)) {
            return false;
        }
        LifeCycle other = (LifeCycle)obj;
        return Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.closedLostReasonAsString(), other.closedLostReasonAsString()) && Objects.equals(this.nextSteps(), other.nextSteps()) && Objects.equals(this.targetCloseDate(), other.targetCloseDate()) && Objects.equals(this.reviewStatusAsString(), other.reviewStatusAsString()) && Objects.equals(this.reviewComments(), other.reviewComments()) && Objects.equals(this.reviewStatusReason(), other.reviewStatusReason()) && this.hasNextStepsHistory() == other.hasNextStepsHistory() && Objects.equals(this.nextStepsHistory(), other.nextStepsHistory());
    }

    public final String toString() {
        return ToString.builder((String)"LifeCycle").add("Stage", (Object)this.stageAsString()).add("ClosedLostReason", (Object)this.closedLostReasonAsString()).add("NextSteps", (Object)(this.nextSteps() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetCloseDate", (Object)this.targetCloseDate()).add("ReviewStatus", (Object)this.reviewStatusAsString()).add("ReviewComments", (Object)this.reviewComments()).add("ReviewStatusReason", (Object)this.reviewStatusReason()).add("NextStepsHistory", this.hasNextStepsHistory() ? this.nextStepsHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "ClosedLostReason": {
                return Optional.ofNullable(clazz.cast(this.closedLostReasonAsString()));
            }
            case "NextSteps": {
                return Optional.ofNullable(clazz.cast(this.nextSteps()));
            }
            case "TargetCloseDate": {
                return Optional.ofNullable(clazz.cast(this.targetCloseDate()));
            }
            case "ReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusAsString()));
            }
            case "ReviewComments": {
                return Optional.ofNullable(clazz.cast(this.reviewComments()));
            }
            case "ReviewStatusReason": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusReason()));
            }
            case "NextStepsHistory": {
                return Optional.ofNullable(clazz.cast(this.nextStepsHistory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Stage", STAGE_FIELD);
        map.put("ClosedLostReason", CLOSED_LOST_REASON_FIELD);
        map.put("NextSteps", NEXT_STEPS_FIELD);
        map.put("TargetCloseDate", TARGET_CLOSE_DATE_FIELD);
        map.put("ReviewStatus", REVIEW_STATUS_FIELD);
        map.put("ReviewComments", REVIEW_COMMENTS_FIELD);
        map.put("ReviewStatusReason", REVIEW_STATUS_REASON_FIELD);
        map.put("NextStepsHistory", NEXT_STEPS_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifeCycle, T> g) {
        return obj -> g.apply((LifeCycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stage;
        private String closedLostReason;
        private String nextSteps;
        private String targetCloseDate;
        private String reviewStatus;
        private String reviewComments;
        private String reviewStatusReason;
        private List<NextStepsHistory> nextStepsHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycle model) {
            this.stage(model.stage);
            this.closedLostReason(model.closedLostReason);
            this.nextSteps(model.nextSteps);
            this.targetCloseDate(model.targetCloseDate);
            this.reviewStatus(model.reviewStatus);
            this.reviewComments(model.reviewComments);
            this.reviewStatusReason(model.reviewStatusReason);
            this.nextStepsHistory(model.nextStepsHistory);
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getClosedLostReason() {
            return this.closedLostReason;
        }

        public final void setClosedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
        }

        @Override
        public final Builder closedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
            return this;
        }

        @Override
        public final Builder closedLostReason(ClosedLostReason closedLostReason) {
            this.closedLostReason(closedLostReason == null ? null : closedLostReason.toString());
            return this;
        }

        public final String getNextSteps() {
            return this.nextSteps;
        }

        public final void setNextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
        }

        @Override
        public final Builder nextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
            return this;
        }

        public final String getTargetCloseDate() {
            return this.targetCloseDate;
        }

        public final void setTargetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
        }

        @Override
        public final Builder targetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
            return this;
        }

        public final String getReviewStatus() {
            return this.reviewStatus;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final String getReviewComments() {
            return this.reviewComments;
        }

        public final void setReviewComments(String reviewComments) {
            this.reviewComments = reviewComments;
        }

        @Override
        public final Builder reviewComments(String reviewComments) {
            this.reviewComments = reviewComments;
            return this;
        }

        public final String getReviewStatusReason() {
            return this.reviewStatusReason;
        }

        public final void setReviewStatusReason(String reviewStatusReason) {
            this.reviewStatusReason = reviewStatusReason;
        }

        @Override
        public final Builder reviewStatusReason(String reviewStatusReason) {
            this.reviewStatusReason = reviewStatusReason;
            return this;
        }

        public final List<NextStepsHistory.Builder> getNextStepsHistory() {
            List<NextStepsHistory.Builder> result = LifeCycleNextStepsHistoryListCopier.copyToBuilder(this.nextStepsHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNextStepsHistory(Collection<NextStepsHistory.BuilderImpl> nextStepsHistory) {
            this.nextStepsHistory = LifeCycleNextStepsHistoryListCopier.copyFromBuilder(nextStepsHistory);
        }

        @Override
        public final Builder nextStepsHistory(Collection<NextStepsHistory> nextStepsHistory) {
            this.nextStepsHistory = LifeCycleNextStepsHistoryListCopier.copy(nextStepsHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(NextStepsHistory ... nextStepsHistory) {
            this.nextStepsHistory(Arrays.asList(nextStepsHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(Consumer<NextStepsHistory.Builder> ... nextStepsHistory) {
            this.nextStepsHistory(Stream.of(nextStepsHistory).map(c -> (NextStepsHistory)((NextStepsHistory.Builder)NextStepsHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LifeCycle build() {
            return new LifeCycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifeCycle> {
        public Builder stage(String var1);

        public Builder stage(Stage var1);

        public Builder closedLostReason(String var1);

        public Builder closedLostReason(ClosedLostReason var1);

        public Builder nextSteps(String var1);

        public Builder targetCloseDate(String var1);

        public Builder reviewStatus(String var1);

        public Builder reviewStatus(ReviewStatus var1);

        public Builder reviewComments(String var1);

        public Builder reviewStatusReason(String var1);

        public Builder nextStepsHistory(Collection<NextStepsHistory> var1);

        public Builder nextStepsHistory(NextStepsHistory ... var1);

        public Builder nextStepsHistory(Consumer<NextStepsHistory.Builder> ... var1);
    }
}

