/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceSnapshotJobsResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListResourceSnapshotJobsResponse> {
    private static final SdkField<List<ResourceSnapshotJobSummary>> RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSnapshotJobSummaries").getter(ListResourceSnapshotJobsResponse.getter(ListResourceSnapshotJobsResponse::resourceSnapshotJobSummaries)).setter(ListResourceSnapshotJobsResponse.setter(Builder::resourceSnapshotJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSnapshotJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceSnapshotJobsResponse.getter(ListResourceSnapshotJobsResponse::nextToken)).setter(ListResourceSnapshotJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceSnapshotJobsResponse.memberNameToFieldInitializer();
    private final List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries;
    private final String nextToken;

    private ListResourceSnapshotJobsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSnapshotJobSummaries = builder.resourceSnapshotJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceSnapshotJobSummaries() {
        return this.resourceSnapshotJobSummaries != null && !(this.resourceSnapshotJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries() {
        return this.resourceSnapshotJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSnapshotJobSummaries() ? this.resourceSnapshotJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSnapshotJobsResponse)) {
            return false;
        }
        ListResourceSnapshotJobsResponse other = (ListResourceSnapshotJobsResponse)((Object)obj);
        return this.hasResourceSnapshotJobSummaries() == other.hasResourceSnapshotJobSummaries() && Objects.equals(this.resourceSnapshotJobSummaries(), other.resourceSnapshotJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceSnapshotJobsResponse").add("ResourceSnapshotJobSummaries", this.hasResourceSnapshotJobSummaries() ? this.resourceSnapshotJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSnapshotJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceSnapshotJobSummaries", RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSnapshotJobsResponse, T> g) {
        return obj -> g.apply((ListResourceSnapshotJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSnapshotJobsResponse model) {
            super(model);
            this.resourceSnapshotJobSummaries(model.resourceSnapshotJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceSnapshotJobSummary.Builder> getResourceSnapshotJobSummaries() {
            List<ResourceSnapshotJobSummary.Builder> result = ResourceSnapshotJobSummaryListCopier.copyToBuilder(this.resourceSnapshotJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSnapshotJobSummaries(Collection<ResourceSnapshotJobSummary.BuilderImpl> resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries = ResourceSnapshotJobSummaryListCopier.copyFromBuilder(resourceSnapshotJobSummaries);
        }

        @Override
        public final Builder resourceSnapshotJobSummaries(Collection<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries = ResourceSnapshotJobSummaryListCopier.copy(resourceSnapshotJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotJobSummaries(ResourceSnapshotJobSummary ... resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries(Arrays.asList(resourceSnapshotJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotJobSummaries(Consumer<ResourceSnapshotJobSummary.Builder> ... resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries(Stream.of(resourceSnapshotJobSummaries).map(c -> (ResourceSnapshotJobSummary)((ResourceSnapshotJobSummary.Builder)ResourceSnapshotJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceSnapshotJobsResponse build() {
            return new ListResourceSnapshotJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceSnapshotJobsResponse> {
        public Builder resourceSnapshotJobSummaries(Collection<ResourceSnapshotJobSummary> var1);

        public Builder resourceSnapshotJobSummaries(ResourceSnapshotJobSummary ... var1);

        public Builder resourceSnapshotJobSummaries(Consumer<ResourceSnapshotJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

