/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.partnercentralselling.internal.PartnerCentralSellingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.partnercentralselling.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ConflictException;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingException;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralselling.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ValidationException;
import software.amazon.awssdk.services.partnercentralselling.transform.AcceptEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.AssignOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.AssociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateEngagementRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateResourceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.DeleteResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.DisassociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetAwsOpportunitySummaryRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetEngagementRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetResourceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetSellingSystemSettingsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementByAcceptingInvitationTasksRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementFromOpportunityTasksRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementInvitationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementMembersRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementResourceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListOpportunitiesRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListResourceSnapshotJobsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListResourceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.PutSellingSystemSettingsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.RejectEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementByAcceptingInvitationTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementFromOpportunityTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StopResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.SubmitOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.UpdateOpportunityRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link PartnerCentralSellingAsyncClient}.
 *
 * @see PartnerCentralSellingAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPartnerCentralSellingAsyncClient implements PartnerCentralSellingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPartnerCentralSellingAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPartnerCentralSellingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "PartnerCentral_Selling" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Use the <code>AcceptEngagementInvitation</code> action to accept an engagement invitation shared by AWS.
     * Accepting the invitation indicates your willingness to participate in the engagement, granting you access to all
     * engagement-related data.
     * </p>
     *
     * @param acceptEngagementInvitationRequest
     * @return A Java Future containing the result of the AcceptEngagementInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.AcceptEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AcceptEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptEngagementInvitationResponse> acceptEngagementInvitation(
            AcceptEngagementInvitationRequest acceptEngagementInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptEngagementInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptEngagementInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptEngagementInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptEngagementInvitationRequest, AcceptEngagementInvitationResponse>()
                            .withOperationName("AcceptEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptEngagementInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptEngagementInvitationRequest));
            CompletableFuture<AcceptEngagementInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables you to reassign an existing <code>Opportunity</code> to another user within your Partner Central account.
     * The specified user receives the opportunity, and it appears on their Partner Central dashboard, allowing them to
     * take necessary actions or proceed with the opportunity.
     * </p>
     * <p>
     * This is useful for distributing opportunities to the appropriate team members or departments within your
     * organization, ensuring that each opportunity is handled by the right person. By default, the opportunity owner is
     * the one who creates it. Currently, there's no API to enumerate the list of available users.
     * </p>
     *
     * @param assignOpportunityRequest
     * @return A Java Future containing the result of the AssignOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.AssignOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssignOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignOpportunityResponse> assignOpportunity(AssignOpportunityRequest assignOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssignOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssignOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssignOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignOpportunityRequest, AssignOpportunityResponse>()
                            .withOperationName("AssignOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssignOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(assignOpportunityRequest));
            CompletableFuture<AssignOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables you to create a formal association between an <code>Opportunity</code> and various related entities,
     * enriching the context and details of the opportunity for better collaboration and decision making. You can
     * associate an opportunity with the following entity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Partner Solution: A software product or consulting practice created and delivered by Partners. Partner Solutions
     * help customers address business challenges using Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Products: Amazon Web Services offers many products and services that provide scalable,
     * reliable, and cost-effective infrastructure solutions. For the latest list of Amazon Web Services products, see
     * <a href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     * Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Allows Amazon Web Services Marketplace sellers to extend custom
     * pricing and terms to individual Amazon Web Services customers. Sellers can negotiate custom prices, payment
     * schedules, and end user license terms through private offers, enabling Amazon Web Services customers to acquire
     * software solutions tailored to their specific needs. For more information, see <a
     * href="https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-private-offers.html">Private offers in
     * Amazon Web Services Marketplace</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain identifiers for these entities, use the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Solution: Use the <code>ListSolutions</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Products: For the latest list of Amazon Web Services products, see <a
     * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
     * >Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Use the <a
     * href="https://docs.aws.amazon.com/marketplace/latest/APIReference/catalog-apis.html">Using the Amazon Web
     * Services Marketplace Catalog API</a> to list entities. Specifically, use the <code>ListEntities</code> operation
     * to retrieve a list of private offers. The request returns the details of available private offers. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
     * >ListEntities</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateOpportunityRequest
     * @return A Java Future containing the result of the AssociateOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.AssociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateOpportunityResponse> associateOpportunity(
            AssociateOpportunityRequest associateOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateOpportunityRequest, AssociateOpportunityResponse>()
                            .withOperationName("AssociateOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateOpportunityRequest));
            CompletableFuture<AssociateOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The <code>CreateEngagement</code> action allows you to create an <code>Engagement</code>, which serves as a
     * collaborative space between different parties such as AWS Partners and AWS Sellers. This action automatically
     * adds the caller's AWS account as an active member of the newly created <code>Engagement</code>.
     * </p>
     *
     * @param createEngagementRequest
     * @return A Java Future containing the result of the CreateEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.CreateEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEngagementResponse> createEngagement(CreateEngagementRequest createEngagementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEngagementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEngagementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEngagement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEngagementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEngagementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEngagementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEngagementRequest, CreateEngagementResponse>()
                            .withOperationName("CreateEngagement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEngagementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEngagementRequest));
            CompletableFuture<CreateEngagementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action creates an invitation from a sender to a single receiver to join an engagement.
     * </p>
     *
     * @param createEngagementInvitationRequest
     * @return A Java Future containing the result of the CreateEngagementInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.CreateEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEngagementInvitationResponse> createEngagementInvitation(
            CreateEngagementInvitationRequest createEngagementInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEngagementInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEngagementInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEngagementInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEngagementInvitationRequest, CreateEngagementInvitationResponse>()
                            .withOperationName("CreateEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEngagementInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEngagementInvitationRequest));
            CompletableFuture<CreateEngagementInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <code>Opportunity</code> record in Partner Central. Use this operation to create a potential business
     * opportunity for submission to Amazon Web Services. Creating an opportunity sets
     * <code>Lifecycle.ReviewStatus</code> to <code>Pending Submission</code>.
     * </p>
     * <p>
     * To submit an opportunity, follow these steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * To create the opportunity, use <code>CreateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To associate a solution with the opportunity, use <code>AssociateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To start the engagement with AWS, use <code>StartEngagementFromOpportunity</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After submission, you can't edit the opportunity until the review is complete. But opportunities in the
     * <code>Pending Submission</code> state must have complete details. You can update the opportunity while it's in
     * the <code>Pending Submission</code> state.
     * </p>
     * <p>
     * There's a set of mandatory fields to create opportunities, but consider providing optional fields to enrich the
     * opportunity record.
     * </p>
     *
     * @param createOpportunityRequest
     * @return A Java Future containing the result of the CreateOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.CreateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOpportunityResponse> createOpportunity(CreateOpportunityRequest createOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOpportunityRequest, CreateOpportunityResponse>()
                            .withOperationName("CreateOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOpportunityRequest));
            CompletableFuture<CreateOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action allows you to create an immutable snapshot of a specific resource, such as an opportunity, within the
     * context of an engagement. The snapshot captures a subset of the resource's data based on the schema defined by
     * the provided template.
     * </p>
     *
     * @param createResourceSnapshotRequest
     * @return A Java Future containing the result of the CreateResourceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.CreateResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceSnapshotResponse> createResourceSnapshot(
            CreateResourceSnapshotRequest createResourceSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateResourceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceSnapshotRequest, CreateResourceSnapshotResponse>()
                            .withOperationName("CreateResourceSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceSnapshotRequest));
            CompletableFuture<CreateResourceSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to create a job to generate a snapshot of the specified resource within an engagement. It
     * initiates an asynchronous process to create a resource snapshot. The job creates a new snapshot only if the
     * resource state has changed, adhering to the same access control and immutability rules as direct snapshot
     * creation.
     * </p>
     *
     * @param createResourceSnapshotJobRequest
     * @return A Java Future containing the result of the CreateResourceSnapshotJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.CreateResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceSnapshotJobResponse> createResourceSnapshotJob(
            CreateResourceSnapshotJobRequest createResourceSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateResourceSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceSnapshotJobRequest, CreateResourceSnapshotJobResponse>()
                            .withOperationName("CreateResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceSnapshotJobRequest));
            CompletableFuture<CreateResourceSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to deletes a previously created resource snapshot job. The job must be in a stopped state before
     * it can be deleted.
     * </p>
     *
     * @param deleteResourceSnapshotJobRequest
     * @return A Java Future containing the result of the DeleteResourceSnapshotJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.DeleteResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DeleteResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceSnapshotJobResponse> deleteResourceSnapshotJob(
            DeleteResourceSnapshotJobRequest deleteResourceSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourceSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceSnapshotJobRequest, DeleteResourceSnapshotJobResponse>()
                            .withOperationName("DeleteResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceSnapshotJobRequest));
            CompletableFuture<DeleteResourceSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to remove an existing association between an <code>Opportunity</code> and related entities, such as a
     * Partner Solution, Amazon Web Services product, or an Amazon Web Services Marketplace offer. This operation is the
     * counterpart to <code>AssociateOpportunity</code>, and it provides flexibility to manage associations as business
     * needs change.
     * </p>
     * <p>
     * Use this operation to update the associations of an <code>Opportunity</code> due to changes in the related
     * entities, or if an association was made in error. Ensuring accurate associations helps maintain clarity and
     * accuracy to track and manage business opportunities. When you replace an entity, first attach the new entity and
     * then disassociate the one to be removed, especially if it's the last remaining entity that's required.
     * </p>
     *
     * @param disassociateOpportunityRequest
     * @return A Java Future containing the result of the DisassociateOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.DisassociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DisassociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateOpportunityResponse> disassociateOpportunity(
            DisassociateOpportunityRequest disassociateOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateOpportunityRequest, DisassociateOpportunityResponse>()
                            .withOperationName("DisassociateOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateOpportunityRequest));
            CompletableFuture<DisassociateOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a summary of an AWS Opportunity. This summary includes high-level details about the opportunity sourced
     * from AWS, such as lifecycle information, customer details, and involvement type. It is useful for tracking
     * updates on the AWS opportunity corresponding to an opportunity in the partner's account.
     * </p>
     *
     * @param getAwsOpportunitySummaryRequest
     * @return A Java Future containing the result of the GetAwsOpportunitySummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetAwsOpportunitySummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetAwsOpportunitySummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAwsOpportunitySummaryResponse> getAwsOpportunitySummary(
            GetAwsOpportunitySummaryRequest getAwsOpportunitySummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAwsOpportunitySummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAwsOpportunitySummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAwsOpportunitySummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAwsOpportunitySummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAwsOpportunitySummaryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetAwsOpportunitySummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAwsOpportunitySummaryRequest, GetAwsOpportunitySummaryResponse>()
                            .withOperationName("GetAwsOpportunitySummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAwsOpportunitySummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAwsOpportunitySummaryRequest));
            CompletableFuture<GetAwsOpportunitySummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to retrieve the engagement record for a given <code>EngagementIdentifier</code>.
     * </p>
     *
     * @param getEngagementRequest
     * @return A Java Future containing the result of the GetEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEngagementResponse> getEngagement(GetEngagementRequest getEngagementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEngagementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngagementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngagement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEngagementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEngagementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetEngagementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEngagementRequest, GetEngagementResponse>()
                            .withOperationName("GetEngagement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEngagementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEngagementRequest));
            CompletableFuture<GetEngagementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of an engagement invitation shared by AWS with a partner. The information includes aspects
     * such as customer, project details, and lifecycle information. To connect an engagement invitation with an
     * opportunity, match the invitation’s <code>Payload.Project.Title</code> with opportunity
     * <code>Project.Title</code>.
     * </p>
     *
     * @param getEngagementInvitationRequest
     * @return A Java Future containing the result of the GetEngagementInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetEngagementInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEngagementInvitationResponse> getEngagementInvitation(
            GetEngagementInvitationRequest getEngagementInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngagementInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEngagementInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetEngagementInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEngagementInvitationRequest, GetEngagementInvitationResponse>()
                            .withOperationName("GetEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEngagementInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEngagementInvitationRequest));
            CompletableFuture<GetEngagementInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Fetches the <code>Opportunity</code> record from Partner Central by a given <code>Identifier</code>.
     * </p>
     * <p>
     * Use the <code>ListOpportunities</code> action or the event notification (from Amazon EventBridge) to obtain this
     * identifier.
     * </p>
     *
     * @param getOpportunityRequest
     * @return A Java Future containing the result of the GetOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpportunityResponse> getOpportunity(GetOpportunityRequest getOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpportunityRequest, GetOpportunityResponse>()
                            .withOperationName("GetOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOpportunityRequest));
            CompletableFuture<GetOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to retrieve a specific snapshot record.
     * </p>
     *
     * @param getResourceSnapshotRequest
     * @return A Java Future containing the result of the GetResourceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceSnapshotResponse> getResourceSnapshot(
            GetResourceSnapshotRequest getResourceSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetResourceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceSnapshotRequest, GetResourceSnapshotResponse>()
                            .withOperationName("GetResourceSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourceSnapshotRequest));
            CompletableFuture<GetResourceSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to retrieves information about a specific resource snapshot job.
     * </p>
     *
     * @param getResourceSnapshotJobRequest
     * @return A Java Future containing the result of the GetResourceSnapshotJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceSnapshotJobResponse> getResourceSnapshotJob(
            GetResourceSnapshotJobRequest getResourceSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetResourceSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceSnapshotJobRequest, GetResourceSnapshotJobResponse>()
                            .withOperationName("GetResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourceSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourceSnapshotJobRequest));
            CompletableFuture<GetResourceSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param getSellingSystemSettingsRequest
     * @return A Java Future containing the result of the GetSellingSystemSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.GetSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSellingSystemSettingsResponse> getSellingSystemSettings(
            GetSellingSystemSettingsRequest getSellingSystemSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSellingSystemSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSellingSystemSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSellingSystemSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSellingSystemSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSellingSystemSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetSellingSystemSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSellingSystemSettingsRequest, GetSellingSystemSettingsResponse>()
                            .withOperationName("GetSellingSystemSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSellingSystemSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSellingSystemSettingsRequest));
            CompletableFuture<GetSellingSystemSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed StartEngagementByAcceptingInvitationTask tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     * @return A Java Future containing the result of the ListEngagementByAcceptingInvitationTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementByAcceptingInvitationTasksResponse> listEngagementByAcceptingInvitationTasks(
            ListEngagementByAcceptingInvitationTasksRequest listEngagementByAcceptingInvitationTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listEngagementByAcceptingInvitationTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementByAcceptingInvitationTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementByAcceptingInvitationTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementByAcceptingInvitationTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListEngagementByAcceptingInvitationTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementByAcceptingInvitationTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementByAcceptingInvitationTasksRequest, ListEngagementByAcceptingInvitationTasksResponse>()
                            .withOperationName("ListEngagementByAcceptingInvitationTasks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementByAcceptingInvitationTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementByAcceptingInvitationTasksRequest));
            CompletableFuture<ListEngagementByAcceptingInvitationTasksResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed <code>EngagementFromOpportunity</code> tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     * @return A Java Future containing the result of the ListEngagementFromOpportunityTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementFromOpportunityTasksResponse> listEngagementFromOpportunityTasks(
            ListEngagementFromOpportunityTasksRequest listEngagementFromOpportunityTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementFromOpportunityTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementFromOpportunityTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementFromOpportunityTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementFromOpportunityTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListEngagementFromOpportunityTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementFromOpportunityTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementFromOpportunityTasksRequest, ListEngagementFromOpportunityTasksResponse>()
                            .withOperationName("ListEngagementFromOpportunityTasks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementFromOpportunityTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementFromOpportunityTasksRequest));
            CompletableFuture<ListEngagementFromOpportunityTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of engagement invitations sent to the partner. This allows partners to view all pending or past
     * engagement invitations, helping them track opportunities shared by AWS.
     * </p>
     *
     * @param listEngagementInvitationsRequest
     * @return A Java Future containing the result of the ListEngagementInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementInvitationsResponse> listEngagementInvitations(
            ListEngagementInvitationsRequest listEngagementInvitationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementInvitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEngagementInvitationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementInvitationsRequest, ListEngagementInvitationsResponse>()
                            .withOperationName("ListEngagementInvitations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementInvitationsRequest));
            CompletableFuture<ListEngagementInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of member partners in an Engagement. This operation can only be invoked by members of the
     * Engagement. The <code>ListEngagementMembers</code> operation allows you to fetch information about the members of
     * a specific Engagement. This action is restricted to members of the Engagement being queried.
     * </p>
     *
     * @param listEngagementMembersRequest
     * @return A Java Future containing the result of the ListEngagementMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementMembersResponse> listEngagementMembers(
            ListEngagementMembersRequest listEngagementMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEngagementMembersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementMembersRequest, ListEngagementMembersResponse>()
                            .withOperationName("ListEngagementMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementMembersRequest));
            CompletableFuture<ListEngagementMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the associations between resources and engagements where the caller is a member and has at least one
     * snapshot in the engagement.
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     * @return A Java Future containing the result of the ListEngagementResourceAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementResourceAssociationsResponse> listEngagementResourceAssociations(
            ListEngagementResourceAssociationsRequest listEngagementResourceAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementResourceAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementResourceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementResourceAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementResourceAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListEngagementResourceAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementResourceAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementResourceAssociationsRequest, ListEngagementResourceAssociationsResponse>()
                            .withOperationName("ListEngagementResourceAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementResourceAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementResourceAssociationsRequest));
            CompletableFuture<ListEngagementResourceAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action allows users to retrieve a list of Engagement records from Partner Central. This action can be used
     * to manage and track various engagements across different stages of the partner selling process.
     * </p>
     *
     * @param listEngagementsRequest
     * @return A Java Future containing the result of the ListEngagements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEngagementsResponse> listEngagements(ListEngagementsRequest listEngagementsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEngagementsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEngagementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEngagementsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEngagementsRequest, ListEngagementsResponse>()
                            .withOperationName("ListEngagements").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEngagementsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEngagementsRequest));
            CompletableFuture<ListEngagementsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request accepts a list of filters that retrieve opportunity subsets as well as sort options. This feature is
     * available to partners from <a href="https://partnercentral.awspartner.com/">Partner Central</a> using the
     * <code>ListOpportunities</code> API action.
     * </p>
     * <p>
     * To synchronize your system with Amazon Web Services, list only the opportunities that were newly created or
     * updated. We recommend you rely on events emitted by the service into your Amazon Web Services account’s Amazon
     * EventBridge default event bus. You can also use the <code>ListOpportunities</code> action.
     * </p>
     * <p>
     * We recommend the following approach:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Find the latest <code>LastModifiedDate</code> that you stored, and only use the values that came from Amazon Web
     * Services. Don’t use values generated by your system.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you send a <code>ListOpportunities</code> request, submit the date in ISO 8601 format in the
     * <code>AfterLastModifiedDate</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services only returns opportunities created or updated on or after that date and time. Use
     * <code>NextToken</code> to iterate over all pages.
     * </p>
     * </li>
     * </ol>
     *
     * @param listOpportunitiesRequest
     * @return A Java Future containing the result of the ListOpportunities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpportunitiesResponse> listOpportunities(ListOpportunitiesRequest listOpportunitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOpportunitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpportunitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpportunities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOpportunitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOpportunitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOpportunitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpportunitiesRequest, ListOpportunitiesResponse>()
                            .withOperationName("ListOpportunities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOpportunitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOpportunitiesRequest));
            CompletableFuture<ListOpportunitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists resource snapshot jobs owned by the customer. This operation supports various filtering scenarios,
     * including listing all jobs owned by the caller, jobs for a specific engagement, jobs with a specific status, or
     * any combination of these filters.
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     * @return A Java Future containing the result of the ListResourceSnapshotJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceSnapshotJobsResponse> listResourceSnapshotJobs(
            ListResourceSnapshotJobsRequest listResourceSnapshotJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceSnapshotJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceSnapshotJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceSnapshotJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceSnapshotJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceSnapshotJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourceSnapshotJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceSnapshotJobsRequest, ListResourceSnapshotJobsResponse>()
                            .withOperationName("ListResourceSnapshotJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceSnapshotJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceSnapshotJobsRequest));
            CompletableFuture<ListResourceSnapshotJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of resource view snapshots based on specified criteria. This operation supports various use
     * cases, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fetching all snapshots associated with an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieving snapshots of a specific resource type within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Obtaining snapshots for a particular resource using a specified template.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accessing the latest snapshot of a resource within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Filtering snapshots by resource owner.
     * </p>
     * </li>
     * </ul>
     *
     * @param listResourceSnapshotsRequest
     * @return A Java Future containing the result of the ListResourceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceSnapshotsResponse> listResourceSnapshots(
            ListResourceSnapshotsRequest listResourceSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourceSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceSnapshotsRequest, ListResourceSnapshotsResponse>()
                            .withOperationName("ListResourceSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceSnapshotsRequest));
            CompletableFuture<ListResourceSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of Partner Solutions that the partner registered on Partner Central. This API is used to
     * generate a list of solutions that an end user selects from for association with an opportunity.
     * </p>
     *
     * @param listSolutionsRequest
     * @return A Java Future containing the result of the ListSolutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSolutionsResponse> listSolutions(ListSolutionsRequest listSolutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSolutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSolutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSolutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSolutionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSolutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSolutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSolutionsRequest, ListSolutionsResponse>()
                            .withOperationName("ListSolutions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSolutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSolutionsRequest));
            CompletableFuture<ListSolutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param putSellingSystemSettingsRequest
     * @return A Java Future containing the result of the PutSellingSystemSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.PutSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/PutSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSellingSystemSettingsResponse> putSellingSystemSettings(
            PutSellingSystemSettingsRequest putSellingSystemSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSellingSystemSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSellingSystemSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSellingSystemSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSellingSystemSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutSellingSystemSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutSellingSystemSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSellingSystemSettingsRequest, PutSellingSystemSettingsResponse>()
                            .withOperationName("PutSellingSystemSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutSellingSystemSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putSellingSystemSettingsRequest));
            CompletableFuture<PutSellingSystemSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action rejects an <code>EngagementInvitation</code> that AWS shared. Rejecting an invitation indicates that
     * the partner doesn't want to pursue the opportunity, and all related data will become inaccessible thereafter.
     * </p>
     *
     * @param rejectEngagementInvitationRequest
     * @return A Java Future containing the result of the RejectEngagementInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.RejectEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/RejectEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectEngagementInvitationResponse> rejectEngagementInvitation(
            RejectEngagementInvitationRequest rejectEngagementInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectEngagementInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RejectEngagementInvitationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RejectEngagementInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectEngagementInvitationRequest, RejectEngagementInvitationResponse>()
                            .withOperationName("RejectEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectEngagementInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectEngagementInvitationRequest));
            CompletableFuture<RejectEngagementInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action starts the engagement by accepting an <code>EngagementInvitation</code>. The task is asynchronous and
     * involves the following steps: accepting the invitation, creating an opportunity in the partner’s account from the
     * AWS opportunity, and copying details for tracking. When completed, an <code>Opportunity Created</code> event is
     * generated, indicating that the opportunity has been successfully created in the partner's account.
     * </p>
     *
     * @param startEngagementByAcceptingInvitationTaskRequest
     * @return A Java Future containing the result of the StartEngagementByAcceptingInvitationTask operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.StartEngagementByAcceptingInvitationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementByAcceptingInvitationTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEngagementByAcceptingInvitationTaskResponse> startEngagementByAcceptingInvitationTask(
            StartEngagementByAcceptingInvitationTaskRequest startEngagementByAcceptingInvitationTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                startEngagementByAcceptingInvitationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startEngagementByAcceptingInvitationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEngagementByAcceptingInvitationTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEngagementByAcceptingInvitationTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartEngagementByAcceptingInvitationTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartEngagementByAcceptingInvitationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEngagementByAcceptingInvitationTaskRequest, StartEngagementByAcceptingInvitationTaskResponse>()
                            .withOperationName("StartEngagementByAcceptingInvitationTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartEngagementByAcceptingInvitationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startEngagementByAcceptingInvitationTaskRequest));
            CompletableFuture<StartEngagementByAcceptingInvitationTaskResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Similar to <code>StartEngagementByAcceptingInvitationTask</code>, this action is asynchronous and performs
     * multiple steps before completion. This action orchestrates a comprehensive workflow that combines multiple API
     * operations into a single task to create and initiate an engagement from an existing opportunity. It automatically
     * executes a sequence of operations including <code>GetOpportunity</code>, <code>CreateEngagement</code> (if it
     * doesn't exist), <code>CreateResourceSnapshot</code>, <code>CreateResourceSnapshotJob</code>,
     * <code>CreateEngagementInvitation</code> (if not already invited/accepted), and <code>SubmitOpportunity</code>.
     * </p>
     *
     * @param startEngagementFromOpportunityTaskRequest
     * @return A Java Future containing the result of the StartEngagementFromOpportunityTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ServiceQuotaExceededException This error occurs when the request would cause a service quota to be
     *         exceeded. Service quotas represent the maximum allowed use of a specific resource, and this error
     *         indicates that the request would surpass that limit.</p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.StartEngagementFromOpportunityTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementFromOpportunityTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEngagementFromOpportunityTaskResponse> startEngagementFromOpportunityTask(
            StartEngagementFromOpportunityTaskRequest startEngagementFromOpportunityTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEngagementFromOpportunityTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startEngagementFromOpportunityTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEngagementFromOpportunityTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEngagementFromOpportunityTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartEngagementFromOpportunityTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartEngagementFromOpportunityTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEngagementFromOpportunityTaskRequest, StartEngagementFromOpportunityTaskResponse>()
                            .withOperationName("StartEngagementFromOpportunityTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartEngagementFromOpportunityTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startEngagementFromOpportunityTaskRequest));
            CompletableFuture<StartEngagementFromOpportunityTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a resource snapshot job that has been previously created.
     * </p>
     *
     * @param startResourceSnapshotJobRequest
     * @return A Java Future containing the result of the StartResourceSnapshotJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.StartResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartResourceSnapshotJobResponse> startResourceSnapshotJob(
            StartResourceSnapshotJobRequest startResourceSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartResourceSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartResourceSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartResourceSnapshotJobRequest, StartResourceSnapshotJobResponse>()
                            .withOperationName("StartResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartResourceSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startResourceSnapshotJobRequest));
            CompletableFuture<StartResourceSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a resource snapshot job. The job must be started prior to being stopped.
     * </p>
     *
     * @param stopResourceSnapshotJobRequest
     * @return A Java Future containing the result of the StopResourceSnapshotJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.StopResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StopResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopResourceSnapshotJobResponse> stopResourceSnapshotJob(
            StopResourceSnapshotJobRequest stopResourceSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopResourceSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopResourceSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopResourceSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopResourceSnapshotJobRequest, StopResourceSnapshotJobResponse>()
                            .withOperationName("StopResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopResourceSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopResourceSnapshotJobRequest));
            CompletableFuture<StopResourceSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this action to submit an Opportunity that was previously created by partner for AWS review. After you perform
     * this action, the Opportunity becomes non-editable until it is reviewed by AWS and has
     * <code> LifeCycle.ReviewStatus </code> as either <code>Approved</code> or <code>Action Required</code>.
     * </p>
     *
     * @param submitOpportunityRequest
     * @return A Java Future containing the result of the SubmitOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.SubmitOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/SubmitOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SubmitOpportunityResponse> submitOpportunity(SubmitOpportunityRequest submitOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, submitOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SubmitOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SubmitOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<SubmitOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SubmitOpportunityRequest, SubmitOpportunityResponse>()
                            .withOperationName("SubmitOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SubmitOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(submitOpportunityRequest));
            CompletableFuture<SubmitOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the <code>Opportunity</code> record identified by a given <code>Identifier</code>. This operation allows
     * you to modify the details of an existing opportunity to reflect the latest information and progress. Use this
     * action to keep the opportunity record up-to-date and accurate.
     * </p>
     * <p>
     * When you perform updates, include the entire payload with each request. If any field is omitted, the API assumes
     * that the field is set to <code>null</code>. The best practice is to always perform a <code>GetOpportunity</code>
     * to retrieve the latest values, then send the complete payload with the updated values to be changed.
     * </p>
     *
     * @param updateOpportunityRequest
     * @return A Java Future containing the result of the UpdateOpportunity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This error occurs when the request can’t be processed due to a conflict with the
     *         target resource's current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.</li>
     *         <li>ThrottlingException This error occurs when there are too many requests sent. Review the provided
     *         quotas and adapt your usage to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.</li>
     *         <li>AccessDeniedException This error occurs when you don't have permission to perform the requested
     *         action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.</li>
     *         <li>InternalServerException This error occurs when the specified resource can’t be found or doesn't
     *         exist. Resource ID and type might be incorrect.</p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service or business
     *         validation rules.</p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.</li>
     *         <li>ResourceNotFoundException This error occurs when the specified resource can't be found. The resource
     *         might not exist, or isn't visible with the current credentials.</p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralSellingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralSellingAsyncClient.UpdateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UpdateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOpportunityResponse> updateOpportunity(UpdateOpportunityRequest updateOpportunityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpportunity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOpportunityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateOpportunityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOpportunityRequest, UpdateOpportunityResponse>()
                            .withOperationName("UpdateOpportunity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOpportunityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOpportunityRequest));
            CompletableFuture<UpdateOpportunityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final PartnerCentralSellingServiceClientConfiguration serviceClientConfiguration() {
        return new PartnerCentralSellingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PartnerCentralSellingException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PartnerCentralSellingServiceClientConfigurationBuilder serviceConfigBuilder = new PartnerCentralSellingServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
