/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateOpportunityRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<AssociateOpportunityRequest.Builder, AssociateOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(AssociateOpportunityRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> OPPORTUNITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityIdentifier").getter(getter(AssociateOpportunityRequest::opportunityIdentifier))
            .setter(setter(Builder::opportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build())
            .build();

    private static final SdkField<String> RELATED_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedEntityType").getter(getter(AssociateOpportunityRequest::relatedEntityTypeAsString))
            .setter(setter(Builder::relatedEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityType").build()).build();

    private static final SdkField<String> RELATED_ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedEntityIdentifier").getter(getter(AssociateOpportunityRequest::relatedEntityIdentifier))
            .setter(setter(Builder::relatedEntityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            OPPORTUNITY_IDENTIFIER_FIELD, RELATED_ENTITY_TYPE_FIELD, RELATED_ENTITY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String opportunityIdentifier;

    private final String relatedEntityType;

    private final String relatedEntityIdentifier;

    private AssociateOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.relatedEntityType = builder.relatedEntityType;
        this.relatedEntityIdentifier = builder.relatedEntityIdentifier;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity association is
     * made in. Use <code>AWS</code> to associate opportunities in the Amazon Web Services catalog, and
     * <code>Sandbox</code> for testing in secure, isolated environments.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
     *         association is made in. Use <code>AWS</code> to associate opportunities in the Amazon Web Services
     *         catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Requires the <code>Opportunity</code>'s unique identifier when you want to associate it with a related entity.
     * Provide the correct identifier so the intended opportunity is updated with the association.
     * </p>
     * 
     * @return Requires the <code>Opportunity</code>'s unique identifier when you want to associate it with a related
     *         entity. Provide the correct identifier so the intended opportunity is updated with the association.
     */
    public final String opportunityIdentifier() {
        return opportunityIdentifier;
    }

    /**
     * <p>
     * Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to categorize
     * and properly process the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedEntityType}
     * will return {@link RelatedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedEntityTypeAsString}.
     * </p>
     * 
     * @return Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
     *         categorize and properly process the association.
     * @see RelatedEntityType
     */
    public final RelatedEntityType relatedEntityType() {
        return RelatedEntityType.fromValue(relatedEntityType);
    }

    /**
     * <p>
     * Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to categorize
     * and properly process the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedEntityType}
     * will return {@link RelatedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedEntityTypeAsString}.
     * </p>
     * 
     * @return Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
     *         categorize and properly process the association.
     * @see RelatedEntityType
     */
    public final String relatedEntityTypeAsString() {
        return relatedEntityType;
    }

    /**
     * <p>
     * Requires the related entity's unique identifier when you want to associate it with the <code> Opportunity</code>.
     * For Amazon Web Services Marketplace entities, provide the Amazon Resource Name (ARN). Use the <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web Services
     * Marketplace API</a> to obtain the ARN.
     * </p>
     * 
     * @return Requires the related entity's unique identifier when you want to associate it with the
     *         <code> Opportunity</code>. For Amazon Web Services Marketplace entities, provide the Amazon Resource Name
     *         (ARN). Use the <a
     *         href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web
     *         Services Marketplace API</a> to obtain the ARN.
     */
    public final String relatedEntityIdentifier() {
        return relatedEntityIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(opportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateOpportunityRequest)) {
            return false;
        }
        AssociateOpportunityRequest other = (AssociateOpportunityRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(opportunityIdentifier(), other.opportunityIdentifier())
                && Objects.equals(relatedEntityTypeAsString(), other.relatedEntityTypeAsString())
                && Objects.equals(relatedEntityIdentifier(), other.relatedEntityIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateOpportunityRequest").add("Catalog", catalog())
                .add("OpportunityIdentifier", opportunityIdentifier()).add("RelatedEntityType", relatedEntityTypeAsString())
                .add("RelatedEntityIdentifier", relatedEntityIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "OpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(opportunityIdentifier()));
        case "RelatedEntityType":
            return Optional.ofNullable(clazz.cast(relatedEntityTypeAsString()));
        case "RelatedEntityIdentifier":
            return Optional.ofNullable(clazz.cast(relatedEntityIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("RelatedEntityType", RELATED_ENTITY_TYPE_FIELD);
        map.put("RelatedEntityIdentifier", RELATED_ENTITY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateOpportunityRequest, T> g) {
        return obj -> g.apply((AssociateOpportunityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateOpportunityRequest> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
         * association is made in. Use <code>AWS</code> to associate opportunities in the Amazon Web Services catalog,
         * and <code>Sandbox</code> for testing in secure, isolated environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
         *        opportunity association is made in. Use <code>AWS</code> to associate opportunities in the Amazon Web
         *        Services catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Requires the <code>Opportunity</code>'s unique identifier when you want to associate it with a related
         * entity. Provide the correct identifier so the intended opportunity is updated with the association.
         * </p>
         * 
         * @param opportunityIdentifier
         *        Requires the <code>Opportunity</code>'s unique identifier when you want to associate it with a related
         *        entity. Provide the correct identifier so the intended opportunity is updated with the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityIdentifier(String opportunityIdentifier);

        /**
         * <p>
         * Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
         * categorize and properly process the association.
         * </p>
         * 
         * @param relatedEntityType
         *        Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
         *        categorize and properly process the association.
         * @see RelatedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedEntityType
         */
        Builder relatedEntityType(String relatedEntityType);

        /**
         * <p>
         * Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
         * categorize and properly process the association.
         * </p>
         * 
         * @param relatedEntityType
         *        Specifies the entity type that you're associating with the <code> Opportunity</code>. This helps to
         *        categorize and properly process the association.
         * @see RelatedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedEntityType
         */
        Builder relatedEntityType(RelatedEntityType relatedEntityType);

        /**
         * <p>
         * Requires the related entity's unique identifier when you want to associate it with the
         * <code> Opportunity</code>. For Amazon Web Services Marketplace entities, provide the Amazon Resource Name
         * (ARN). Use the <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html">
         * Amazon Web Services Marketplace API</a> to obtain the ARN.
         * </p>
         * 
         * @param relatedEntityIdentifier
         *        Requires the related entity's unique identifier when you want to associate it with the
         *        <code> Opportunity</code>. For Amazon Web Services Marketplace entities, provide the Amazon Resource
         *        Name (ARN). Use the <a
         *        href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web
         *        Services Marketplace API</a> to obtain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEntityIdentifier(String relatedEntityIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String opportunityIdentifier;

        private String relatedEntityType;

        private String relatedEntityIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateOpportunityRequest model) {
            super(model);
            catalog(model.catalog);
            opportunityIdentifier(model.opportunityIdentifier);
            relatedEntityType(model.relatedEntityType);
            relatedEntityIdentifier(model.relatedEntityIdentifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getOpportunityIdentifier() {
            return opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
        }

        @Override
        public final Builder opportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
            return this;
        }

        public final String getRelatedEntityType() {
            return relatedEntityType;
        }

        public final void setRelatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
        }

        @Override
        public final Builder relatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
            return this;
        }

        @Override
        public final Builder relatedEntityType(RelatedEntityType relatedEntityType) {
            this.relatedEntityType(relatedEntityType == null ? null : relatedEntityType.toString());
            return this;
        }

        public final String getRelatedEntityIdentifier() {
            return relatedEntityIdentifier;
        }

        public final void setRelatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
        }

        @Override
        public final Builder relatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateOpportunityRequest build() {
            return new AssociateOpportunityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
