/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tracks the lifecycle of the AWS opportunity, including stages such as qualification, validation, and closure. This
 * field helps partners understand the current status and progression of the opportunity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpportunityLifeCycle implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpportunityLifeCycle.Builder, AwsOpportunityLifeCycle> {
    private static final SdkField<String> TARGET_CLOSE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCloseDate").getter(getter(AwsOpportunityLifeCycle::targetCloseDate))
            .setter(setter(Builder::targetCloseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCloseDate").build()).build();

    private static final SdkField<String> CLOSED_LOST_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClosedLostReason").getter(getter(AwsOpportunityLifeCycle::closedLostReasonAsString))
            .setter(setter(Builder::closedLostReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedLostReason").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(AwsOpportunityLifeCycle::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final SdkField<String> NEXT_STEPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextSteps").getter(getter(AwsOpportunityLifeCycle::nextSteps)).setter(setter(Builder::nextSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSteps").build()).build();

    private static final SdkField<List<ProfileNextStepsHistory>> NEXT_STEPS_HISTORY_FIELD = SdkField
            .<List<ProfileNextStepsHistory>> builder(MarshallingType.LIST)
            .memberName("NextStepsHistory")
            .getter(getter(AwsOpportunityLifeCycle::nextStepsHistory))
            .setter(setter(Builder::nextStepsHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextStepsHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileNextStepsHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileNextStepsHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CLOSE_DATE_FIELD,
            CLOSED_LOST_REASON_FIELD, STAGE_FIELD, NEXT_STEPS_FIELD, NEXT_STEPS_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetCloseDate;

    private final String closedLostReason;

    private final String stage;

    private final String nextSteps;

    private final List<ProfileNextStepsHistory> nextStepsHistory;

    private AwsOpportunityLifeCycle(BuilderImpl builder) {
        this.targetCloseDate = builder.targetCloseDate;
        this.closedLostReason = builder.closedLostReason;
        this.stage = builder.stage;
        this.nextSteps = builder.nextSteps;
        this.nextStepsHistory = builder.nextStepsHistory;
    }

    /**
     * <p>
     * Indicates the expected date by which the opportunity is projected to close. This field helps in planning
     * resources and timelines for both the partner and AWS.
     * </p>
     * 
     * @return Indicates the expected date by which the opportunity is projected to close. This field helps in planning
     *         resources and timelines for both the partner and AWS.
     */
    public final String targetCloseDate() {
        return targetCloseDate;
    }

    /**
     * <p>
     * Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in understanding the
     * context behind the lost opportunity and aids in refining future strategies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closedLostReason}
     * will return {@link AwsClosedLostReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #closedLostReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in
     *         understanding the context behind the lost opportunity and aids in refining future strategies.
     * @see AwsClosedLostReason
     */
    public final AwsClosedLostReason closedLostReason() {
        return AwsClosedLostReason.fromValue(closedLostReason);
    }

    /**
     * <p>
     * Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in understanding the
     * context behind the lost opportunity and aids in refining future strategies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closedLostReason}
     * will return {@link AwsClosedLostReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #closedLostReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in
     *         understanding the context behind the lost opportunity and aids in refining future strategies.
     * @see AwsClosedLostReason
     */
    public final String closedLostReasonAsString() {
        return closedLostReason;
    }

    /**
     * <p>
     * Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
     * <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link AwsOpportunityStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
     *         <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's
     *         progress.
     * @see AwsOpportunityStage
     */
    public final AwsOpportunityStage stage() {
        return AwsOpportunityStage.fromValue(stage);
    }

    /**
     * <p>
     * Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
     * <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link AwsOpportunityStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
     *         <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's
     *         progress.
     * @see AwsOpportunityStage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Specifies the immediate next steps required to progress the opportunity. These steps are based on AWS guidance
     * and the current stage of the opportunity.
     * </p>
     * 
     * @return Specifies the immediate next steps required to progress the opportunity. These steps are based on AWS
     *         guidance and the current stage of the opportunity.
     */
    public final String nextSteps() {
        return nextSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the NextStepsHistory property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNextStepsHistory() {
        return nextStepsHistory != null && !(nextStepsHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a historical log of previous next steps that were taken to move the opportunity forward. This helps in
     * tracking the decision-making process and identifying any delays or obstacles encountered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNextStepsHistory} method.
     * </p>
     * 
     * @return Provides a historical log of previous next steps that were taken to move the opportunity forward. This
     *         helps in tracking the decision-making process and identifying any delays or obstacles encountered.
     */
    public final List<ProfileNextStepsHistory> nextStepsHistory() {
        return nextStepsHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetCloseDate());
        hashCode = 31 * hashCode + Objects.hashCode(closedLostReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextSteps());
        hashCode = 31 * hashCode + Objects.hashCode(hasNextStepsHistory() ? nextStepsHistory() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityLifeCycle)) {
            return false;
        }
        AwsOpportunityLifeCycle other = (AwsOpportunityLifeCycle) obj;
        return Objects.equals(targetCloseDate(), other.targetCloseDate())
                && Objects.equals(closedLostReasonAsString(), other.closedLostReasonAsString())
                && Objects.equals(stageAsString(), other.stageAsString()) && Objects.equals(nextSteps(), other.nextSteps())
                && hasNextStepsHistory() == other.hasNextStepsHistory()
                && Objects.equals(nextStepsHistory(), other.nextStepsHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpportunityLifeCycle").add("TargetCloseDate", targetCloseDate())
                .add("ClosedLostReason", closedLostReasonAsString()).add("Stage", stageAsString())
                .add("NextSteps", nextSteps() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextStepsHistory", hasNextStepsHistory() ? nextStepsHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetCloseDate":
            return Optional.ofNullable(clazz.cast(targetCloseDate()));
        case "ClosedLostReason":
            return Optional.ofNullable(clazz.cast(closedLostReasonAsString()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "NextSteps":
            return Optional.ofNullable(clazz.cast(nextSteps()));
        case "NextStepsHistory":
            return Optional.ofNullable(clazz.cast(nextStepsHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetCloseDate", TARGET_CLOSE_DATE_FIELD);
        map.put("ClosedLostReason", CLOSED_LOST_REASON_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("NextSteps", NEXT_STEPS_FIELD);
        map.put("NextStepsHistory", NEXT_STEPS_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityLifeCycle, T> g) {
        return obj -> g.apply((AwsOpportunityLifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpportunityLifeCycle> {
        /**
         * <p>
         * Indicates the expected date by which the opportunity is projected to close. This field helps in planning
         * resources and timelines for both the partner and AWS.
         * </p>
         * 
         * @param targetCloseDate
         *        Indicates the expected date by which the opportunity is projected to close. This field helps in
         *        planning resources and timelines for both the partner and AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCloseDate(String targetCloseDate);

        /**
         * <p>
         * Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in understanding
         * the context behind the lost opportunity and aids in refining future strategies.
         * </p>
         * 
         * @param closedLostReason
         *        Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in
         *        understanding the context behind the lost opportunity and aids in refining future strategies.
         * @see AwsClosedLostReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsClosedLostReason
         */
        Builder closedLostReason(String closedLostReason);

        /**
         * <p>
         * Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in understanding
         * the context behind the lost opportunity and aids in refining future strategies.
         * </p>
         * 
         * @param closedLostReason
         *        Indicates the reason why an opportunity was marked as <code>Closed Lost</code>. This helps in
         *        understanding the context behind the lost opportunity and aids in refining future strategies.
         * @see AwsClosedLostReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsClosedLostReason
         */
        Builder closedLostReason(AwsClosedLostReason closedLostReason);

        /**
         * <p>
         * Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
         * <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's progress.
         * </p>
         * 
         * @param stage
         *        Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
         *        <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's
         *        progress.
         * @see AwsOpportunityStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsOpportunityStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
         * <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's progress.
         * </p>
         * 
         * @param stage
         *        Represents the current stage of the opportunity in its lifecycle, such as <code>Qualification</code>,
         *        <code>Validation</code>, or <code>Closed Won</code>. This helps in understanding the opportunity's
         *        progress.
         * @see AwsOpportunityStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsOpportunityStage
         */
        Builder stage(AwsOpportunityStage stage);

        /**
         * <p>
         * Specifies the immediate next steps required to progress the opportunity. These steps are based on AWS
         * guidance and the current stage of the opportunity.
         * </p>
         * 
         * @param nextSteps
         *        Specifies the immediate next steps required to progress the opportunity. These steps are based on AWS
         *        guidance and the current stage of the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSteps(String nextSteps);

        /**
         * <p>
         * Provides a historical log of previous next steps that were taken to move the opportunity forward. This helps
         * in tracking the decision-making process and identifying any delays or obstacles encountered.
         * </p>
         * 
         * @param nextStepsHistory
         *        Provides a historical log of previous next steps that were taken to move the opportunity forward. This
         *        helps in tracking the decision-making process and identifying any delays or obstacles encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStepsHistory(Collection<ProfileNextStepsHistory> nextStepsHistory);

        /**
         * <p>
         * Provides a historical log of previous next steps that were taken to move the opportunity forward. This helps
         * in tracking the decision-making process and identifying any delays or obstacles encountered.
         * </p>
         * 
         * @param nextStepsHistory
         *        Provides a historical log of previous next steps that were taken to move the opportunity forward. This
         *        helps in tracking the decision-making process and identifying any delays or obstacles encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStepsHistory(ProfileNextStepsHistory... nextStepsHistory);

        /**
         * <p>
         * Provides a historical log of previous next steps that were taken to move the opportunity forward. This helps
         * in tracking the decision-making process and identifying any delays or obstacles encountered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ProfileNextStepsHistory.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ProfileNextStepsHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ProfileNextStepsHistory.Builder#build()}
         * is called immediately and its result is passed to {@link #nextStepsHistory(List<ProfileNextStepsHistory>)}.
         * 
         * @param nextStepsHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ProfileNextStepsHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextStepsHistory(java.util.Collection<ProfileNextStepsHistory>)
         */
        Builder nextStepsHistory(Consumer<ProfileNextStepsHistory.Builder>... nextStepsHistory);
    }

    static final class BuilderImpl implements Builder {
        private String targetCloseDate;

        private String closedLostReason;

        private String stage;

        private String nextSteps;

        private List<ProfileNextStepsHistory> nextStepsHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityLifeCycle model) {
            targetCloseDate(model.targetCloseDate);
            closedLostReason(model.closedLostReason);
            stage(model.stage);
            nextSteps(model.nextSteps);
            nextStepsHistory(model.nextStepsHistory);
        }

        public final String getTargetCloseDate() {
            return targetCloseDate;
        }

        public final void setTargetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
        }

        @Override
        public final Builder targetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
            return this;
        }

        public final String getClosedLostReason() {
            return closedLostReason;
        }

        public final void setClosedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
        }

        @Override
        public final Builder closedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
            return this;
        }

        @Override
        public final Builder closedLostReason(AwsClosedLostReason closedLostReason) {
            this.closedLostReason(closedLostReason == null ? null : closedLostReason.toString());
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(AwsOpportunityStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getNextSteps() {
            return nextSteps;
        }

        public final void setNextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
        }

        @Override
        public final Builder nextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
            return this;
        }

        public final List<ProfileNextStepsHistory.Builder> getNextStepsHistory() {
            List<ProfileNextStepsHistory.Builder> result = AwsOpportunityLifeCycleNextStepsHistoryListCopier
                    .copyToBuilder(this.nextStepsHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNextStepsHistory(Collection<ProfileNextStepsHistory.BuilderImpl> nextStepsHistory) {
            this.nextStepsHistory = AwsOpportunityLifeCycleNextStepsHistoryListCopier.copyFromBuilder(nextStepsHistory);
        }

        @Override
        public final Builder nextStepsHistory(Collection<ProfileNextStepsHistory> nextStepsHistory) {
            this.nextStepsHistory = AwsOpportunityLifeCycleNextStepsHistoryListCopier.copy(nextStepsHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(ProfileNextStepsHistory... nextStepsHistory) {
            nextStepsHistory(Arrays.asList(nextStepsHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(Consumer<ProfileNextStepsHistory.Builder>... nextStepsHistory) {
            nextStepsHistory(Stream.of(nextStepsHistory).map(c -> ProfileNextStepsHistory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsOpportunityLifeCycle build() {
            return new AwsOpportunityLifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
