/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an Amazon Web Services team member for the engagement. This structure includes details such as name,
 * email, and business title.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsTeamMember implements SdkPojo, Serializable, ToCopyableBuilder<AwsTeamMember.Builder, AwsTeamMember> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(AwsTeamMember::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(AwsTeamMember::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(AwsTeamMember::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> BUSINESS_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessTitle").getter(getter(AwsTeamMember::businessTitleAsString))
            .setter(setter(Builder::businessTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessTitle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, FIRST_NAME_FIELD,
            LAST_NAME_FIELD, BUSINESS_TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String email;

    private final String firstName;

    private final String lastName;

    private final String businessTitle;

    private AwsTeamMember(BuilderImpl builder) {
        this.email = builder.email;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.businessTitle = builder.businessTitle;
    }

    /**
     * <p>
     * Provides the Amazon Web Services team member's email address.
     * </p>
     * 
     * @return Provides the Amazon Web Services team member's email address.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Provides the Amazon Web Services team member's first name.
     * </p>
     * 
     * @return Provides the Amazon Web Services team member's first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * Provides the Amazon Web Services team member's last name.
     * </p>
     * 
     * @return Provides the Amazon Web Services team member's last name.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * Specifies the Amazon Web Services team member's business title and indicates their organizational role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #businessTitle}
     * will return {@link AwsMemberBusinessTitle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #businessTitleAsString}.
     * </p>
     * 
     * @return Specifies the Amazon Web Services team member's business title and indicates their organizational role.
     * @see AwsMemberBusinessTitle
     */
    public final AwsMemberBusinessTitle businessTitle() {
        return AwsMemberBusinessTitle.fromValue(businessTitle);
    }

    /**
     * <p>
     * Specifies the Amazon Web Services team member's business title and indicates their organizational role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #businessTitle}
     * will return {@link AwsMemberBusinessTitle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #businessTitleAsString}.
     * </p>
     * 
     * @return Specifies the Amazon Web Services team member's business title and indicates their organizational role.
     * @see AwsMemberBusinessTitle
     */
    public final String businessTitleAsString() {
        return businessTitle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(businessTitleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsTeamMember)) {
            return false;
        }
        AwsTeamMember other = (AwsTeamMember) obj;
        return Objects.equals(email(), other.email()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName())
                && Objects.equals(businessTitleAsString(), other.businessTitleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsTeamMember").add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BusinessTitle", businessTitleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "BusinessTitle":
            return Optional.ofNullable(clazz.cast(businessTitleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Email", EMAIL_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("BusinessTitle", BUSINESS_TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsTeamMember, T> g) {
        return obj -> g.apply((AwsTeamMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsTeamMember> {
        /**
         * <p>
         * Provides the Amazon Web Services team member's email address.
         * </p>
         * 
         * @param email
         *        Provides the Amazon Web Services team member's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Provides the Amazon Web Services team member's first name.
         * </p>
         * 
         * @param firstName
         *        Provides the Amazon Web Services team member's first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * Provides the Amazon Web Services team member's last name.
         * </p>
         * 
         * @param lastName
         *        Provides the Amazon Web Services team member's last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * Specifies the Amazon Web Services team member's business title and indicates their organizational role.
         * </p>
         * 
         * @param businessTitle
         *        Specifies the Amazon Web Services team member's business title and indicates their organizational
         *        role.
         * @see AwsMemberBusinessTitle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsMemberBusinessTitle
         */
        Builder businessTitle(String businessTitle);

        /**
         * <p>
         * Specifies the Amazon Web Services team member's business title and indicates their organizational role.
         * </p>
         * 
         * @param businessTitle
         *        Specifies the Amazon Web Services team member's business title and indicates their organizational
         *        role.
         * @see AwsMemberBusinessTitle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsMemberBusinessTitle
         */
        Builder businessTitle(AwsMemberBusinessTitle businessTitle);
    }

    static final class BuilderImpl implements Builder {
        private String email;

        private String firstName;

        private String lastName;

        private String businessTitle;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsTeamMember model) {
            email(model.email);
            firstName(model.firstName);
            lastName(model.lastName);
            businessTitle(model.businessTitle);
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getBusinessTitle() {
            return businessTitle;
        }

        public final void setBusinessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
        }

        @Override
        public final Builder businessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
            return this;
        }

        @Override
        public final Builder businessTitle(AwsMemberBusinessTitle businessTitle) {
            this.businessTitle(businessTitle == null ? null : businessTitle.toString());
            return this;
        }

        @Override
        public AwsTeamMember build() {
            return new AwsTeamMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
