/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a <code>Customer</code> object's subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerSummary implements SdkPojo, Serializable, ToCopyableBuilder<CustomerSummary.Builder, CustomerSummary> {
    private static final SdkField<AccountSummary> ACCOUNT_FIELD = SdkField.<AccountSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Account").getter(getter(CustomerSummary::account)).setter(setter(Builder::account))
            .constructor(AccountSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccountSummary account;

    private CustomerSummary(BuilderImpl builder) {
        this.account = builder.account;
    }

    /**
     * <p>
     * An object that contains a customer's account details.
     * </p>
     * 
     * @return An object that contains a customer's account details.
     */
    public final AccountSummary account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerSummary)) {
            return false;
        }
        CustomerSummary other = (CustomerSummary) obj;
        return Objects.equals(account(), other.account());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerSummary").add("Account", account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Account", ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerSummary, T> g) {
        return obj -> g.apply((CustomerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerSummary> {
        /**
         * <p>
         * An object that contains a customer's account details.
         * </p>
         * 
         * @param account
         *        An object that contains a customer's account details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(AccountSummary account);

        /**
         * <p>
         * An object that contains a customer's account details.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountSummary.Builder} avoiding the need
         * to create one manually via {@link AccountSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #account(AccountSummary)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link AccountSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(AccountSummary)
         */
        default Builder account(Consumer<AccountSummary.Builder> account) {
            return account(AccountSummary.builder().applyMutation(account).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountSummary account;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerSummary model) {
            account(model.account);
        }

        public final AccountSummary.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(AccountSummary.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(AccountSummary account) {
            this.account = account;
            return this;
        }

        @Override
        public CustomerSummary build() {
            return new CustomerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
