/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateOpportunityRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<DisassociateOpportunityRequest.Builder, DisassociateOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(DisassociateOpportunityRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> OPPORTUNITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityIdentifier").getter(getter(DisassociateOpportunityRequest::opportunityIdentifier))
            .setter(setter(Builder::opportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build())
            .build();

    private static final SdkField<String> RELATED_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedEntityType").getter(getter(DisassociateOpportunityRequest::relatedEntityTypeAsString))
            .setter(setter(Builder::relatedEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityType").build()).build();

    private static final SdkField<String> RELATED_ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedEntityIdentifier").getter(getter(DisassociateOpportunityRequest::relatedEntityIdentifier))
            .setter(setter(Builder::relatedEntityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            OPPORTUNITY_IDENTIFIER_FIELD, RELATED_ENTITY_TYPE_FIELD, RELATED_ENTITY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String opportunityIdentifier;

    private final String relatedEntityType;

    private final String relatedEntityIdentifier;

    private DisassociateOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.relatedEntityType = builder.relatedEntityType;
        this.relatedEntityIdentifier = builder.relatedEntityIdentifier;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity disassociation
     * is made in. Use <code>AWS</code> to disassociate opportunities in the Amazon Web Services catalog, and
     * <code>Sandbox</code> for testing in secure, isolated environments.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
     *         disassociation is made in. Use <code>AWS</code> to disassociate opportunities in the Amazon Web Services
     *         catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The opportunity's unique identifier for when you want to disassociate it from related entities. This identifier
     * helps to ensure that the correct opportunity is updated.
     * </p>
     * <p>
     * Validation: Ensure that the provided identifier corresponds to an existing opportunity in the Amazon Web Services
     * system because incorrect identifiers result in an error and no changes are made.
     * </p>
     * 
     * @return The opportunity's unique identifier for when you want to disassociate it from related entities. This
     *         identifier helps to ensure that the correct opportunity is updated.</p>
     *         <p>
     *         Validation: Ensure that the provided identifier corresponds to an existing opportunity in the Amazon Web
     *         Services system because incorrect identifiers result in an error and no changes are made.
     */
    public final String opportunityIdentifier() {
        return opportunityIdentifier;
    }

    /**
     * <p>
     * The type of the entity that you're disassociating from the opportunity. When you specify the entity type, it
     * helps the system correctly process the disassociation request to ensure that the right connections are removed.
     * </p>
     * <p>
     * Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
     * Marketplaceoffer. Ensure that the value matches one of the expected entity types.
     * </p>
     * <p>
     * Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect entity
     * type results in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedEntityType}
     * will return {@link RelatedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedEntityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity that you're disassociating from the opportunity. When you specify the entity type,
     *         it helps the system correctly process the disassociation request to ensure that the right connections are
     *         removed.</p>
     *         <p>
     *         Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
     *         Marketplaceoffer. Ensure that the value matches one of the expected entity types.
     *         </p>
     *         <p>
     *         Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect
     *         entity type results in an error.
     * @see RelatedEntityType
     */
    public final RelatedEntityType relatedEntityType() {
        return RelatedEntityType.fromValue(relatedEntityType);
    }

    /**
     * <p>
     * The type of the entity that you're disassociating from the opportunity. When you specify the entity type, it
     * helps the system correctly process the disassociation request to ensure that the right connections are removed.
     * </p>
     * <p>
     * Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
     * Marketplaceoffer. Ensure that the value matches one of the expected entity types.
     * </p>
     * <p>
     * Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect entity
     * type results in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedEntityType}
     * will return {@link RelatedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedEntityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity that you're disassociating from the opportunity. When you specify the entity type,
     *         it helps the system correctly process the disassociation request to ensure that the right connections are
     *         removed.</p>
     *         <p>
     *         Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
     *         Marketplaceoffer. Ensure that the value matches one of the expected entity types.
     *         </p>
     *         <p>
     *         Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect
     *         entity type results in an error.
     * @see RelatedEntityType
     */
    public final String relatedEntityTypeAsString() {
        return relatedEntityType;
    }

    /**
     * <p>
     * The related entity's identifier that you want to disassociate from the opportunity. Depending on the type of
     * entity, this could be a simple identifier or an Amazon Resource Name (ARN) for entities managed through Amazon
     * Web Services Marketplace.
     * </p>
     * <p>
     * For Amazon Web Services Marketplace entities, use the Amazon Web Services Marketplace API to obtain the necessary
     * ARNs. For guidance on retrieving these ARNs, see <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web Services
     * MarketplaceUsing the Amazon Web Services Marketplace Catalog API</a>.
     * </p>
     * <p>
     * Validation: Ensure the identifier or ARN is valid and corresponds to an existing entity. An incorrect or invalid
     * identifier results in an error.
     * </p>
     * 
     * @return The related entity's identifier that you want to disassociate from the opportunity. Depending on the type
     *         of entity, this could be a simple identifier or an Amazon Resource Name (ARN) for entities managed
     *         through Amazon Web Services Marketplace.</p>
     *         <p>
     *         For Amazon Web Services Marketplace entities, use the Amazon Web Services Marketplace API to obtain the
     *         necessary ARNs. For guidance on retrieving these ARNs, see <a
     *         href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web
     *         Services MarketplaceUsing the Amazon Web Services Marketplace Catalog API</a>.
     *         </p>
     *         <p>
     *         Validation: Ensure the identifier or ARN is valid and corresponds to an existing entity. An incorrect or
     *         invalid identifier results in an error.
     */
    public final String relatedEntityIdentifier() {
        return relatedEntityIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(opportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateOpportunityRequest)) {
            return false;
        }
        DisassociateOpportunityRequest other = (DisassociateOpportunityRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(opportunityIdentifier(), other.opportunityIdentifier())
                && Objects.equals(relatedEntityTypeAsString(), other.relatedEntityTypeAsString())
                && Objects.equals(relatedEntityIdentifier(), other.relatedEntityIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateOpportunityRequest").add("Catalog", catalog())
                .add("OpportunityIdentifier", opportunityIdentifier()).add("RelatedEntityType", relatedEntityTypeAsString())
                .add("RelatedEntityIdentifier", relatedEntityIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "OpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(opportunityIdentifier()));
        case "RelatedEntityType":
            return Optional.ofNullable(clazz.cast(relatedEntityTypeAsString()));
        case "RelatedEntityIdentifier":
            return Optional.ofNullable(clazz.cast(relatedEntityIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("RelatedEntityType", RELATED_ENTITY_TYPE_FIELD);
        map.put("RelatedEntityIdentifier", RELATED_ENTITY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateOpportunityRequest, T> g) {
        return obj -> g.apply((DisassociateOpportunityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateOpportunityRequest> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
         * disassociation is made in. Use <code>AWS</code> to disassociate opportunities in the Amazon Web Services
         * catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
         *        opportunity disassociation is made in. Use <code>AWS</code> to disassociate opportunities in the
         *        Amazon Web Services catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The opportunity's unique identifier for when you want to disassociate it from related entities. This
         * identifier helps to ensure that the correct opportunity is updated.
         * </p>
         * <p>
         * Validation: Ensure that the provided identifier corresponds to an existing opportunity in the Amazon Web
         * Services system because incorrect identifiers result in an error and no changes are made.
         * </p>
         * 
         * @param opportunityIdentifier
         *        The opportunity's unique identifier for when you want to disassociate it from related entities. This
         *        identifier helps to ensure that the correct opportunity is updated.</p>
         *        <p>
         *        Validation: Ensure that the provided identifier corresponds to an existing opportunity in the Amazon
         *        Web Services system because incorrect identifiers result in an error and no changes are made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityIdentifier(String opportunityIdentifier);

        /**
         * <p>
         * The type of the entity that you're disassociating from the opportunity. When you specify the entity type, it
         * helps the system correctly process the disassociation request to ensure that the right connections are
         * removed.
         * </p>
         * <p>
         * Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
         * Marketplaceoffer. Ensure that the value matches one of the expected entity types.
         * </p>
         * <p>
         * Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect
         * entity type results in an error.
         * </p>
         * 
         * @param relatedEntityType
         *        The type of the entity that you're disassociating from the opportunity. When you specify the entity
         *        type, it helps the system correctly process the disassociation request to ensure that the right
         *        connections are removed.</p>
         *        <p>
         *        Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web
         *        Services Marketplaceoffer. Ensure that the value matches one of the expected entity types.
         *        </p>
         *        <p>
         *        Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or
         *        incorrect entity type results in an error.
         * @see RelatedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedEntityType
         */
        Builder relatedEntityType(String relatedEntityType);

        /**
         * <p>
         * The type of the entity that you're disassociating from the opportunity. When you specify the entity type, it
         * helps the system correctly process the disassociation request to ensure that the right connections are
         * removed.
         * </p>
         * <p>
         * Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web Services
         * Marketplaceoffer. Ensure that the value matches one of the expected entity types.
         * </p>
         * <p>
         * Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or incorrect
         * entity type results in an error.
         * </p>
         * 
         * @param relatedEntityType
         *        The type of the entity that you're disassociating from the opportunity. When you specify the entity
         *        type, it helps the system correctly process the disassociation request to ensure that the right
         *        connections are removed.</p>
         *        <p>
         *        Examples of entity types include Partner Solution, Amazon Web Services product, and Amazon Web
         *        Services Marketplaceoffer. Ensure that the value matches one of the expected entity types.
         *        </p>
         *        <p>
         *        Validation: Provide a valid entity type to help ensure successful disassociation. An invalid or
         *        incorrect entity type results in an error.
         * @see RelatedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedEntityType
         */
        Builder relatedEntityType(RelatedEntityType relatedEntityType);

        /**
         * <p>
         * The related entity's identifier that you want to disassociate from the opportunity. Depending on the type of
         * entity, this could be a simple identifier or an Amazon Resource Name (ARN) for entities managed through
         * Amazon Web Services Marketplace.
         * </p>
         * <p>
         * For Amazon Web Services Marketplace entities, use the Amazon Web Services Marketplace API to obtain the
         * necessary ARNs. For guidance on retrieving these ARNs, see <a
         * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web Services
         * MarketplaceUsing the Amazon Web Services Marketplace Catalog API</a>.
         * </p>
         * <p>
         * Validation: Ensure the identifier or ARN is valid and corresponds to an existing entity. An incorrect or
         * invalid identifier results in an error.
         * </p>
         * 
         * @param relatedEntityIdentifier
         *        The related entity's identifier that you want to disassociate from the opportunity. Depending on the
         *        type of entity, this could be a simple identifier or an Amazon Resource Name (ARN) for entities
         *        managed through Amazon Web Services Marketplace.</p>
         *        <p>
         *        For Amazon Web Services Marketplace entities, use the Amazon Web Services Marketplace API to obtain
         *        the necessary ARNs. For guidance on retrieving these ARNs, see <a
         *        href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html"> Amazon Web
         *        Services MarketplaceUsing the Amazon Web Services Marketplace Catalog API</a>.
         *        </p>
         *        <p>
         *        Validation: Ensure the identifier or ARN is valid and corresponds to an existing entity. An incorrect
         *        or invalid identifier results in an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEntityIdentifier(String relatedEntityIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String opportunityIdentifier;

        private String relatedEntityType;

        private String relatedEntityIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateOpportunityRequest model) {
            super(model);
            catalog(model.catalog);
            opportunityIdentifier(model.opportunityIdentifier);
            relatedEntityType(model.relatedEntityType);
            relatedEntityIdentifier(model.relatedEntityIdentifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getOpportunityIdentifier() {
            return opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
        }

        @Override
        public final Builder opportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
            return this;
        }

        public final String getRelatedEntityType() {
            return relatedEntityType;
        }

        public final void setRelatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
        }

        @Override
        public final Builder relatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
            return this;
        }

        @Override
        public final Builder relatedEntityType(RelatedEntityType relatedEntityType) {
            this.relatedEntityType(relatedEntityType == null ? null : relatedEntityType.toString());
            return this;
        }

        public final String getRelatedEntityIdentifier() {
            return relatedEntityIdentifier;
        }

        public final void setRelatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
        }

        @Override
        public final Builder relatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateOpportunityRequest build() {
            return new DisassociateOpportunityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
