/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the customer associated with the Engagement Invitation, including company information and
 * industry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementCustomer implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementCustomer.Builder, EngagementCustomer> {
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(EngagementCustomer::industryAsString)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(EngagementCustomer::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteUrl").getter(getter(EngagementCustomer::websiteUrl)).setter(setter(Builder::websiteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(EngagementCustomer::countryCodeAsString))
            .setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDUSTRY_FIELD,
            COMPANY_NAME_FIELD, WEBSITE_URL_FIELD, COUNTRY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String industry;

    private final String companyName;

    private final String websiteUrl;

    private final String countryCode;

    private EngagementCustomer(BuilderImpl builder) {
        this.industry = builder.industry;
        this.companyName = builder.companyName;
        this.websiteUrl = builder.websiteUrl;
        this.countryCode = builder.countryCode;
    }

    /**
     * <p>
     * Specifies the industry to which the customer’s company belongs. This field helps categorize the opportunity based
     * on the customer’s business sector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies the industry to which the customer’s company belongs. This field helps categorize the
     *         opportunity based on the customer’s business sector.
     * @see Industry
     */
    public final Industry industry() {
        return Industry.fromValue(industry);
    }

    /**
     * <p>
     * Specifies the industry to which the customer’s company belongs. This field helps categorize the opportunity based
     * on the customer’s business sector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies the industry to which the customer’s company belongs. This field helps categorize the
     *         opportunity based on the customer’s business sector.
     * @see Industry
     */
    public final String industryAsString() {
        return industry;
    }

    /**
     * <p>
     * Represents the name of the customer’s company associated with the Engagement Invitation. This field is used to
     * identify the customer.
     * </p>
     * 
     * @return Represents the name of the customer’s company associated with the Engagement Invitation. This field is
     *         used to identify the customer.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Provides the website URL of the customer’s company. This field helps partners verify the legitimacy and size of
     * the customer organization.
     * </p>
     * 
     * @return Provides the website URL of the customer’s company. This field helps partners verify the legitimacy and
     *         size of the customer organization.
     */
    public final String websiteUrl() {
        return websiteUrl;
    }

    /**
     * <p>
     * Indicates the country in which the customer’s company operates. This field is useful for understanding regional
     * requirements or compliance needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Indicates the country in which the customer’s company operates. This field is useful for understanding
     *         regional requirements or compliance needs.
     * @see CountryCode
     */
    public final CountryCode countryCode() {
        return CountryCode.fromValue(countryCode);
    }

    /**
     * <p>
     * Indicates the country in which the customer’s company operates. This field is useful for understanding regional
     * requirements or compliance needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Indicates the country in which the customer’s company operates. This field is useful for understanding
     *         regional requirements or compliance needs.
     * @see CountryCode
     */
    public final String countryCodeAsString() {
        return countryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(websiteUrl());
        hashCode = 31 * hashCode + Objects.hashCode(countryCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementCustomer)) {
            return false;
        }
        EngagementCustomer other = (EngagementCustomer) obj;
        return Objects.equals(industryAsString(), other.industryAsString()) && Objects.equals(companyName(), other.companyName())
                && Objects.equals(websiteUrl(), other.websiteUrl())
                && Objects.equals(countryCodeAsString(), other.countryCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementCustomer").add("Industry", industryAsString())
                .add("CompanyName", companyName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebsiteUrl", websiteUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CountryCode", countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Industry":
            return Optional.ofNullable(clazz.cast(industryAsString()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "WebsiteUrl":
            return Optional.ofNullable(clazz.cast(websiteUrl()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Industry", INDUSTRY_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementCustomer, T> g) {
        return obj -> g.apply((EngagementCustomer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementCustomer> {
        /**
         * <p>
         * Specifies the industry to which the customer’s company belongs. This field helps categorize the opportunity
         * based on the customer’s business sector.
         * </p>
         * 
         * @param industry
         *        Specifies the industry to which the customer’s company belongs. This field helps categorize the
         *        opportunity based on the customer’s business sector.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(String industry);

        /**
         * <p>
         * Specifies the industry to which the customer’s company belongs. This field helps categorize the opportunity
         * based on the customer’s business sector.
         * </p>
         * 
         * @param industry
         *        Specifies the industry to which the customer’s company belongs. This field helps categorize the
         *        opportunity based on the customer’s business sector.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(Industry industry);

        /**
         * <p>
         * Represents the name of the customer’s company associated with the Engagement Invitation. This field is used
         * to identify the customer.
         * </p>
         * 
         * @param companyName
         *        Represents the name of the customer’s company associated with the Engagement Invitation. This field is
         *        used to identify the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Provides the website URL of the customer’s company. This field helps partners verify the legitimacy and size
         * of the customer organization.
         * </p>
         * 
         * @param websiteUrl
         *        Provides the website URL of the customer’s company. This field helps partners verify the legitimacy
         *        and size of the customer organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteUrl(String websiteUrl);

        /**
         * <p>
         * Indicates the country in which the customer’s company operates. This field is useful for understanding
         * regional requirements or compliance needs.
         * </p>
         * 
         * @param countryCode
         *        Indicates the country in which the customer’s company operates. This field is useful for understanding
         *        regional requirements or compliance needs.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Indicates the country in which the customer’s company operates. This field is useful for understanding
         * regional requirements or compliance needs.
         * </p>
         * 
         * @param countryCode
         *        Indicates the country in which the customer’s company operates. This field is useful for understanding
         *        regional requirements or compliance needs.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(CountryCode countryCode);
    }

    static final class BuilderImpl implements Builder {
        private String industry;

        private String companyName;

        private String websiteUrl;

        private String countryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementCustomer model) {
            industry(model.industry);
            companyName(model.companyName);
            websiteUrl(model.websiteUrl);
            countryCode(model.countryCode);
        }

        public final String getIndustry() {
            return industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getWebsiteUrl() {
            return websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        @Override
        public EngagementCustomer build() {
            return new EngagementCustomer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
