/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains an <code>Engagement</code>'s subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementSummary.Builder, EngagementSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EngagementSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(EngagementSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EngagementSummary::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(EngagementSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(EngagementSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Integer> MEMBER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemberCount").getter(getter(EngagementSummary::memberCount)).setter(setter(Builder::memberCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            TITLE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, MEMBER_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String title;

    private final Instant createdAt;

    private final String createdBy;

    private final Integer memberCount;

    private EngagementSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.title = builder.title;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.memberCount = builder.memberCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created Engagement.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created Engagement.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the Engagement.
     * </p>
     * 
     * @return The unique identifier for the Engagement.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title of the Engagement.
     * </p>
     * 
     * @return The title of the Engagement.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The date and time when the Engagement was created.
     * </p>
     * 
     * @return The date and time when the Engagement was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Account ID of the Engagement creator.
     * </p>
     * 
     * @return The AWS Account ID of the Engagement creator.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The number of members in the Engagement.
     * </p>
     * 
     * @return The number of members in the Engagement.
     */
    public final Integer memberCount() {
        return memberCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(memberCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementSummary)) {
            return false;
        }
        EngagementSummary other = (EngagementSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(memberCount(), other.memberCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementSummary").add("Arn", arn()).add("Id", id()).add("Title", title())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MemberCount", memberCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "MemberCount":
            return Optional.ofNullable(clazz.cast(memberCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("MemberCount", MEMBER_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementSummary, T> g) {
        return obj -> g.apply((EngagementSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created Engagement.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the created Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the Engagement.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title of the Engagement.
         * </p>
         * 
         * @param title
         *        The title of the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The date and time when the Engagement was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the Engagement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Account ID of the Engagement creator.
         * </p>
         * 
         * @param createdBy
         *        The AWS Account ID of the Engagement creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The number of members in the Engagement.
         * </p>
         * 
         * @param memberCount
         *        The number of members in the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberCount(Integer memberCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String title;

        private Instant createdAt;

        private String createdBy;

        private Integer memberCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementSummary model) {
            arn(model.arn);
            id(model.id);
            title(model.title);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            memberCount(model.memberCount);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Integer getMemberCount() {
            return memberCount;
        }

        public final void setMemberCount(Integer memberCount) {
            this.memberCount = memberCount;
        }

        @Override
        public final Builder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        @Override
        public EngagementSummary build() {
            return new EngagementSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
