/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpportunityResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetOpportunityResponse.Builder, GetOpportunityResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetOpportunityResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> PRIMARY_NEEDS_FROM_AWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrimaryNeedsFromAws")
            .getter(getter(GetOpportunityResponse::primaryNeedsFromAwsAsStrings))
            .setter(setter(Builder::primaryNeedsFromAwsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNeedsFromAws").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NATIONAL_SECURITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NationalSecurity").getter(getter(GetOpportunityResponse::nationalSecurityAsString))
            .setter(setter(Builder::nationalSecurity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NationalSecurity").build()).build();

    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartnerOpportunityIdentifier")
            .getter(getter(GetOpportunityResponse::partnerOpportunityIdentifier))
            .setter(setter(Builder::partnerOpportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier")
                    .build()).build();

    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.<Customer> builder(MarshallingType.SDK_POJO)
            .memberName("Customer").getter(getter(GetOpportunityResponse::customer)).setter(setter(Builder::customer))
            .constructor(Customer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<Project> PROJECT_FIELD = SdkField.<Project> builder(MarshallingType.SDK_POJO)
            .memberName("Project").getter(getter(GetOpportunityResponse::project)).setter(setter(Builder::project))
            .constructor(Project::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityType").getter(getter(GetOpportunityResponse::opportunityTypeAsString))
            .setter(setter(Builder::opportunityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()).build();

    private static final SdkField<Marketing> MARKETING_FIELD = SdkField.<Marketing> builder(MarshallingType.SDK_POJO)
            .memberName("Marketing").getter(getter(GetOpportunityResponse::marketing)).setter(setter(Builder::marketing))
            .constructor(Marketing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketing").build()).build();

    private static final SdkField<SoftwareRevenue> SOFTWARE_REVENUE_FIELD = SdkField
            .<SoftwareRevenue> builder(MarshallingType.SDK_POJO).memberName("SoftwareRevenue")
            .getter(getter(GetOpportunityResponse::softwareRevenue)).setter(setter(Builder::softwareRevenue))
            .constructor(SoftwareRevenue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareRevenue").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetOpportunityResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetOpportunityResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate")
            .getter(getter(GetOpportunityResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(GetOpportunityResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<RelatedEntityIdentifiers> RELATED_ENTITY_IDENTIFIERS_FIELD = SdkField
            .<RelatedEntityIdentifiers> builder(MarshallingType.SDK_POJO).memberName("RelatedEntityIdentifiers")
            .getter(getter(GetOpportunityResponse::relatedEntityIdentifiers)).setter(setter(Builder::relatedEntityIdentifiers))
            .constructor(RelatedEntityIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifiers").build())
            .build();

    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.<LifeCycle> builder(MarshallingType.SDK_POJO)
            .memberName("LifeCycle").getter(getter(GetOpportunityResponse::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(LifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()).build();

    private static final SdkField<List<Contact>> OPPORTUNITY_TEAM_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("OpportunityTeam")
            .getter(getter(GetOpportunityResponse::opportunityTeam))
            .setter(setter(Builder::opportunityTeam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            PRIMARY_NEEDS_FROM_AWS_FIELD, NATIONAL_SECURITY_FIELD, PARTNER_OPPORTUNITY_IDENTIFIER_FIELD, CUSTOMER_FIELD,
            PROJECT_FIELD, OPPORTUNITY_TYPE_FIELD, MARKETING_FIELD, SOFTWARE_REVENUE_FIELD, ID_FIELD, ARN_FIELD,
            LAST_MODIFIED_DATE_FIELD, CREATED_DATE_FIELD, RELATED_ENTITY_IDENTIFIERS_FIELD, LIFE_CYCLE_FIELD,
            OPPORTUNITY_TEAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> primaryNeedsFromAws;

    private final String nationalSecurity;

    private final String partnerOpportunityIdentifier;

    private final Customer customer;

    private final Project project;

    private final String opportunityType;

    private final Marketing marketing;

    private final SoftwareRevenue softwareRevenue;

    private final String id;

    private final String arn;

    private final Instant lastModifiedDate;

    private final Instant createdDate;

    private final RelatedEntityIdentifiers relatedEntityIdentifiers;

    private final LifeCycle lifeCycle;

    private final List<Contact> opportunityTeam;

    private GetOpportunityResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.primaryNeedsFromAws = builder.primaryNeedsFromAws;
        this.nationalSecurity = builder.nationalSecurity;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
        this.customer = builder.customer;
        this.project = builder.project;
        this.opportunityType = builder.opportunityType;
        this.marketing = builder.marketing;
        this.softwareRevenue = builder.softwareRevenue;
        this.id = builder.id;
        this.arn = builder.arn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.createdDate = builder.createdDate;
        this.relatedEntityIdentifiers = builder.relatedEntityIdentifiers;
        this.lifeCycle = builder.lifeCycle;
        this.opportunityTeam = builder.opportunityTeam;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity information is
     * retrieved from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services catalog, and
     * <code>Sandbox</code> to retrieve opportunities in a secure and isolated testing environment.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
     *         information is retrieved from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services
     *         catalog, and <code>Sandbox</code> to retrieve opportunities in a secure and isolated testing environment.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Identifies the type of support the partner needs from Amazon Web Services.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
     * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
     * presentation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the partner's
     * proposed solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner may
     * be receiving an upfront discount on a service (for example: EDP deals).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the partner's
     * questions about the proposed solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed solutions
     * on Amazon Web Services versus on-premises or a traditional hosting environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example: joint
     * customer call, strategic positioning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon Web
     * Services RFx support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryNeedsFromAws} method.
     * </p>
     * 
     * @return Identifies the type of support the partner needs from Amazon Web Services.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
     *         solution architecture is aligned with Amazon Web Services best practices and poses minimal architectural
     *         risks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
     *         presentation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
     *         partner's proposed solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
     *         partner may be receiving an upfront discount on a service (for example: EDP deals).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
     *         partner's questions about the proposed solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
     *         solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
     *         example: joint customer call, strategic positioning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
     *         Amazon Web Services RFx support.
     *         </p>
     *         </li>
     */
    public final List<PrimaryNeedFromAws> primaryNeedsFromAws() {
        return PrimaryNeedsFromAwsCopier.copyStringToEnum(primaryNeedsFromAws);
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryNeedsFromAws property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryNeedsFromAws() {
        return primaryNeedsFromAws != null && !(primaryNeedsFromAws instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the type of support the partner needs from Amazon Web Services.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
     * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
     * presentation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the partner's
     * proposed solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner may
     * be receiving an upfront discount on a service (for example: EDP deals).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the partner's
     * questions about the proposed solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed solutions
     * on Amazon Web Services versus on-premises or a traditional hosting environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example: joint
     * customer call, strategic positioning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon Web
     * Services RFx support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryNeedsFromAws} method.
     * </p>
     * 
     * @return Identifies the type of support the partner needs from Amazon Web Services.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
     *         solution architecture is aligned with Amazon Web Services best practices and poses minimal architectural
     *         risks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
     *         presentation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
     *         partner's proposed solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
     *         partner may be receiving an upfront discount on a service (for example: EDP deals).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
     *         partner's questions about the proposed solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
     *         solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
     *         example: joint customer call, strategic positioning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
     *         Amazon Web Services RFx support.
     *         </p>
     *         </li>
     */
    public final List<String> primaryNeedsFromAwsAsStrings() {
        return primaryNeedsFromAws;
    }

    /**
     * <p>
     * Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must be set to
     * <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy and security
     * measures apply during the review and management process for opportunities marked as <code>NationalSecurity</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nationalSecurity}
     * will return {@link NationalSecurity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nationalSecurityAsString}.
     * </p>
     * 
     * @return Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must
     *         be set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy
     *         and security measures apply during the review and management process for opportunities marked as
     *         <code>NationalSecurity</code>.
     * @see NationalSecurity
     */
    public final NationalSecurity nationalSecurity() {
        return NationalSecurity.fromValue(nationalSecurity);
    }

    /**
     * <p>
     * Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must be set to
     * <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy and security
     * measures apply during the review and management process for opportunities marked as <code>NationalSecurity</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nationalSecurity}
     * will return {@link NationalSecurity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nationalSecurityAsString}.
     * </p>
     * 
     * @return Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must
     *         be set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy
     *         and security measures apply during the review and management process for opportunities marked as
     *         <code>NationalSecurity</code>.
     * @see NationalSecurity
     */
    public final String nationalSecurityAsString() {
        return nationalSecurity;
    }

    /**
     * <p>
     * Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to track and
     * reconcile because it's included in the outbound payload sent back to the partner.
     * </p>
     * 
     * @return Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to
     *         track and reconcile because it's included in the outbound payload sent back to the partner.
     */
    public final String partnerOpportunityIdentifier() {
        return partnerOpportunityIdentifier;
    }

    /**
     * <p>
     * Specifies details of the customer associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies details of the customer associated with the <code>Opportunity</code>.
     */
    public final Customer customer() {
        return customer;
    }

    /**
     * <p>
     * An object that contains project details summary for the <code>Opportunity</code>.
     * </p>
     * 
     * @return An object that contains project details summary for the <code>Opportunity</code>.
     */
    public final Project project() {
        return project;
    }

    /**
     * <p>
     * Specifies the opportunity type as renewal, new, or expansion.
     * </p>
     * <p>
     * Opportunity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * New opportunity: Represents a new business opportunity with a potential customer that's not previously engaged
     * with your solutions or services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a current
     * customer, which helps to ensure service continuity.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or subscription,
     * either by adding new services or increasing the volume of existing services.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies the opportunity type as renewal, new, or expansion.</p>
     *         <p>
     *         Opportunity types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         New opportunity: Represents a new business opportunity with a potential customer that's not previously
     *         engaged with your solutions or services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a
     *         current customer, which helps to ensure service continuity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
     *         subscription, either by adding new services or increasing the volume of existing services.
     *         </p>
     *         </li>
     * @see OpportunityType
     */
    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(opportunityType);
    }

    /**
     * <p>
     * Specifies the opportunity type as renewal, new, or expansion.
     * </p>
     * <p>
     * Opportunity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * New opportunity: Represents a new business opportunity with a potential customer that's not previously engaged
     * with your solutions or services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a current
     * customer, which helps to ensure service continuity.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or subscription,
     * either by adding new services or increasing the volume of existing services.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies the opportunity type as renewal, new, or expansion.</p>
     *         <p>
     *         Opportunity types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         New opportunity: Represents a new business opportunity with a potential customer that's not previously
     *         engaged with your solutions or services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a
     *         current customer, which helps to ensure service continuity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
     *         subscription, either by adding new services or increasing the volume of existing services.
     *         </p>
     *         </li>
     * @see OpportunityType
     */
    public final String opportunityTypeAsString() {
        return opportunityType;
    }

    /**
     * <p>
     * An object that contains marketing details for the <code>Opportunity</code>.
     * </p>
     * 
     * @return An object that contains marketing details for the <code>Opportunity</code>.
     */
    public final Marketing marketing() {
        return marketing;
    }

    /**
     * <p>
     * Specifies details of a customer's procurement terms. Required only for partners in eligible programs.
     * </p>
     * 
     * @return Specifies details of a customer's procurement terms. Required only for partners in eligible programs.
     */
    public final SoftwareRevenue softwareRevenue() {
        return softwareRevenue;
    }

    /**
     * <p>
     * Read-only, system generated <code>Opportunity</code> unique identifier.
     * </p>
     * 
     * @return Read-only, system generated <code>Opportunity</code> unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the opportunity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the opportunity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * <code>DateTime</code> when the opportunity was last modified.
     * </p>
     * 
     * @return <code>DateTime</code> when the opportunity was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * <code>DateTime</code> when the <code>Opportunity</code> was last created.
     * </p>
     * 
     * @return <code>DateTime</code> when the <code>Opportunity</code> was last created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Provides information about the associations of other entities with the opportunity. These entities include
     * identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and <code>AWSMarketplaceOffers</code>.
     * </p>
     * 
     * @return Provides information about the associations of other entities with the opportunity. These entities
     *         include identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and
     *         <code>AWSMarketplaceOffers</code>.
     */
    public final RelatedEntityIdentifiers relatedEntityIdentifiers() {
        return relatedEntityIdentifiers;
    }

    /**
     * <p>
     * An object that contains lifecycle details for the <code>Opportunity</code>.
     * </p>
     * 
     * @return An object that contains lifecycle details for the <code>Opportunity</code>.
     */
    public final LifeCycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpportunityTeam property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpportunityTeam() {
        return opportunityTeam != null && !(opportunityTeam instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the internal team handling the opportunity. Specify the members involved in collaborating on this
     * opportunity within the partner's organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpportunityTeam} method.
     * </p>
     * 
     * @return Represents the internal team handling the opportunity. Specify the members involved in collaborating on
     *         this opportunity within the partner's organization.
     */
    public final List<Contact> opportunityTeam() {
        return opportunityTeam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryNeedsFromAws() ? primaryNeedsFromAwsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nationalSecurityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partnerOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marketing());
        hashCode = 31 * hashCode + Objects.hashCode(softwareRevenue());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpportunityTeam() ? opportunityTeam() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpportunityResponse)) {
            return false;
        }
        GetOpportunityResponse other = (GetOpportunityResponse) obj;
        return Objects.equals(catalog(), other.catalog()) && hasPrimaryNeedsFromAws() == other.hasPrimaryNeedsFromAws()
                && Objects.equals(primaryNeedsFromAwsAsStrings(), other.primaryNeedsFromAwsAsStrings())
                && Objects.equals(nationalSecurityAsString(), other.nationalSecurityAsString())
                && Objects.equals(partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier())
                && Objects.equals(customer(), other.customer()) && Objects.equals(project(), other.project())
                && Objects.equals(opportunityTypeAsString(), other.opportunityTypeAsString())
                && Objects.equals(marketing(), other.marketing()) && Objects.equals(softwareRevenue(), other.softwareRevenue())
                && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(relatedEntityIdentifiers(), other.relatedEntityIdentifiers())
                && Objects.equals(lifeCycle(), other.lifeCycle()) && hasOpportunityTeam() == other.hasOpportunityTeam()
                && Objects.equals(opportunityTeam(), other.opportunityTeam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOpportunityResponse").add("Catalog", catalog())
                .add("PrimaryNeedsFromAws", hasPrimaryNeedsFromAws() ? primaryNeedsFromAwsAsStrings() : null)
                .add("NationalSecurity", nationalSecurityAsString())
                .add("PartnerOpportunityIdentifier", partnerOpportunityIdentifier()).add("Customer", customer())
                .add("Project", project()).add("OpportunityType", opportunityTypeAsString()).add("Marketing", marketing())
                .add("SoftwareRevenue", softwareRevenue()).add("Id", id()).add("Arn", arn())
                .add("LastModifiedDate", lastModifiedDate()).add("CreatedDate", createdDate())
                .add("RelatedEntityIdentifiers", relatedEntityIdentifiers()).add("LifeCycle", lifeCycle())
                .add("OpportunityTeam", hasOpportunityTeam() ? opportunityTeam() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "PrimaryNeedsFromAws":
            return Optional.ofNullable(clazz.cast(primaryNeedsFromAwsAsStrings()));
        case "NationalSecurity":
            return Optional.ofNullable(clazz.cast(nationalSecurityAsString()));
        case "PartnerOpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(partnerOpportunityIdentifier()));
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        case "OpportunityType":
            return Optional.ofNullable(clazz.cast(opportunityTypeAsString()));
        case "Marketing":
            return Optional.ofNullable(clazz.cast(marketing()));
        case "SoftwareRevenue":
            return Optional.ofNullable(clazz.cast(softwareRevenue()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "RelatedEntityIdentifiers":
            return Optional.ofNullable(clazz.cast(relatedEntityIdentifiers()));
        case "LifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "OpportunityTeam":
            return Optional.ofNullable(clazz.cast(opportunityTeam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("PrimaryNeedsFromAws", PRIMARY_NEEDS_FROM_AWS_FIELD);
        map.put("NationalSecurity", NATIONAL_SECURITY_FIELD);
        map.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("Marketing", MARKETING_FIELD);
        map.put("SoftwareRevenue", SOFTWARE_REVENUE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("RelatedEntityIdentifiers", RELATED_ENTITY_IDENTIFIERS_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOpportunityResponse, T> g) {
        return obj -> g.apply((GetOpportunityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOpportunityResponse> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
         * information is retrieved from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services
         * catalog, and <code>Sandbox</code> to retrieve opportunities in a secure and isolated testing environment.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
         *        opportunity information is retrieved from. Use <code>AWS</code> to retrieve opportunities in the
         *        Amazon Web Services catalog, and <code>Sandbox</code> to retrieve opportunities in a secure and
         *        isolated testing environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Identifies the type of support the partner needs from Amazon Web Services.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
         * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         * presentation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
         * partner's proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner
         * may be receiving an upfront discount on a service (for example: EDP deals).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         * partner's questions about the proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         * solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example:
         * joint customer call, strategic positioning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon
         * Web Services RFx support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from Amazon Web Services.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
         *        solution architecture is aligned with Amazon Web Services best practices and poses minimal
         *        architectural risks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         *        presentation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for
         *        the partner's proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
         *        partner may be receiving an upfront discount on a service (for example: EDP deals).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         *        partner's questions about the proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         *        solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
         *        example: joint customer call, strategic positioning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
         *        Amazon Web Services RFx support.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from Amazon Web Services.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
         * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         * presentation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
         * partner's proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner
         * may be receiving an upfront discount on a service (for example: EDP deals).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         * partner's questions about the proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         * solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example:
         * joint customer call, strategic positioning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon
         * Web Services RFx support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from Amazon Web Services.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
         *        solution architecture is aligned with Amazon Web Services best practices and poses minimal
         *        architectural risks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         *        presentation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for
         *        the partner's proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
         *        partner may be receiving an upfront discount on a service (for example: EDP deals).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         *        partner's questions about the proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         *        solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
         *        example: joint customer call, strategic positioning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
         *        Amazon Web Services RFx support.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAwsWithStrings(String... primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from Amazon Web Services.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
         * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         * presentation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
         * partner's proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner
         * may be receiving an upfront discount on a service (for example: EDP deals).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         * partner's questions about the proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         * solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example:
         * joint customer call, strategic positioning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon
         * Web Services RFx support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from Amazon Web Services.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
         *        solution architecture is aligned with Amazon Web Services best practices and poses minimal
         *        architectural risks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         *        presentation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for
         *        the partner's proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
         *        partner may be receiving an upfront discount on a service (for example: EDP deals).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         *        partner's questions about the proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         *        solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
         *        example: joint customer call, strategic positioning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
         *        Amazon Web Services RFx support.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from Amazon Web Services.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed solution
         * architecture is aligned with Amazon Web Services best practices and poses minimal architectural risks.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         * presentation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for the
         * partner's proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a partner
         * may be receiving an upfront discount on a service (for example: EDP deals).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         * partner's questions about the proposed solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         * solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for example:
         * joint customer call, strategic positioning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs Amazon
         * Web Services RFx support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from Amazon Web Services.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cosell—Architectural Validation: Confirmation from Amazon Web Services that the partner's proposed
         *        solution architecture is aligned with Amazon Web Services best practices and poses minimal
         *        architectural risks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Business Presentation: Request Amazon Web Services seller's participation in a joint customer
         *        presentation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Competitive Information: Access to Amazon Web Services competitive resources and support for
         *        the partner's proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for support situations where a
         *        partner may be receiving an upfront discount on a service (for example: EDP deals).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Technical Consultation: Connect with an Amazon Web Services Solutions Architect to address the
         *        partner's questions about the proposed solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Total Cost of Ownership Evaluation: Assistance with quoting different cost savings of proposed
         *        solutions on Amazon Web Services versus on-premises or a traditional hosting environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Deal Support: Request Amazon Web Services seller's support to progress the opportunity (for
         *        example: joint customer call, strategic positioning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cosell—Support for Public Tender/RFx: Opportunity related to the public sector where the partner needs
         *        Amazon Web Services RFx support.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAws(PrimaryNeedFromAws... primaryNeedsFromAws);

        /**
         * <p>
         * Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must be
         * set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy and
         * security measures apply during the review and management process for opportunities marked as
         * <code>NationalSecurity</code>.
         * </p>
         * 
         * @param nationalSecurity
         *        Indicates whether the <code>Opportunity</code> pertains to a national security project. This field
         *        must be set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional
         *        privacy and security measures apply during the review and management process for opportunities marked
         *        as <code>NationalSecurity</code>.
         * @see NationalSecurity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NationalSecurity
         */
        Builder nationalSecurity(String nationalSecurity);

        /**
         * <p>
         * Indicates whether the <code>Opportunity</code> pertains to a national security project. This field must be
         * set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional privacy and
         * security measures apply during the review and management process for opportunities marked as
         * <code>NationalSecurity</code>.
         * </p>
         * 
         * @param nationalSecurity
         *        Indicates whether the <code>Opportunity</code> pertains to a national security project. This field
         *        must be set to <code>true</code> only when the customer's industry is <i>Government</i>. Additional
         *        privacy and security measures apply during the review and management process for opportunities marked
         *        as <code>NationalSecurity</code>.
         * @see NationalSecurity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NationalSecurity
         */
        Builder nationalSecurity(NationalSecurity nationalSecurity);

        /**
         * <p>
         * Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to track
         * and reconcile because it's included in the outbound payload sent back to the partner.
         * </p>
         * 
         * @param partnerOpportunityIdentifier
         *        Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to
         *        track and reconcile because it's included in the outbound payload sent back to the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier);

        /**
         * <p>
         * Specifies details of the customer associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param customer
         *        Specifies details of the customer associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(Customer customer);

        /**
         * <p>
         * Specifies details of the customer associated with the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Customer.Builder} avoiding the need to
         * create one manually via {@link Customer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Customer.Builder#build()} is called immediately and its result is
         * passed to {@link #customer(Customer)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link Customer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(Customer)
         */
        default Builder customer(Consumer<Customer.Builder> customer) {
            return customer(Customer.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * An object that contains project details summary for the <code>Opportunity</code>.
         * </p>
         * 
         * @param project
         *        An object that contains project details summary for the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(Project project);

        /**
         * <p>
         * An object that contains project details summary for the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Project.Builder} avoiding the need to
         * create one manually via {@link Project#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Project.Builder#build()} is called immediately and its result is
         * passed to {@link #project(Project)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link Project.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(Project)
         */
        default Builder project(Consumer<Project.Builder> project) {
            return project(Project.builder().applyMutation(project).build());
        }

        /**
         * <p>
         * Specifies the opportunity type as renewal, new, or expansion.
         * </p>
         * <p>
         * Opportunity types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * New opportunity: Represents a new business opportunity with a potential customer that's not previously
         * engaged with your solutions or services.
         * </p>
         * </li>
         * <li>
         * <p>
         * Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a current
         * customer, which helps to ensure service continuity.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
         * subscription, either by adding new services or increasing the volume of existing services.
         * </p>
         * </li>
         * </ul>
         * 
         * @param opportunityType
         *        Specifies the opportunity type as renewal, new, or expansion.</p>
         *        <p>
         *        Opportunity types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        New opportunity: Represents a new business opportunity with a potential customer that's not previously
         *        engaged with your solutions or services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a
         *        current customer, which helps to ensure service continuity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
         *        subscription, either by adding new services or increasing the volume of existing services.
         *        </p>
         *        </li>
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(String opportunityType);

        /**
         * <p>
         * Specifies the opportunity type as renewal, new, or expansion.
         * </p>
         * <p>
         * Opportunity types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * New opportunity: Represents a new business opportunity with a potential customer that's not previously
         * engaged with your solutions or services.
         * </p>
         * </li>
         * <li>
         * <p>
         * Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a current
         * customer, which helps to ensure service continuity.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
         * subscription, either by adding new services or increasing the volume of existing services.
         * </p>
         * </li>
         * </ul>
         * 
         * @param opportunityType
         *        Specifies the opportunity type as renewal, new, or expansion.</p>
         *        <p>
         *        Opportunity types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        New opportunity: Represents a new business opportunity with a potential customer that's not previously
         *        engaged with your solutions or services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Renewal opportunity: Represents an opportunity to renew an existing contract or subscription with a
         *        current customer, which helps to ensure service continuity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expansion opportunity: Represents an opportunity to expand the scope of a customer's contract or
         *        subscription, either by adding new services or increasing the volume of existing services.
         *        </p>
         *        </li>
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(OpportunityType opportunityType);

        /**
         * <p>
         * An object that contains marketing details for the <code>Opportunity</code>.
         * </p>
         * 
         * @param marketing
         *        An object that contains marketing details for the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketing(Marketing marketing);

        /**
         * <p>
         * An object that contains marketing details for the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Marketing.Builder} avoiding the need to
         * create one manually via {@link Marketing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Marketing.Builder#build()} is called immediately and its result
         * is passed to {@link #marketing(Marketing)}.
         * 
         * @param marketing
         *        a consumer that will call methods on {@link Marketing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketing(Marketing)
         */
        default Builder marketing(Consumer<Marketing.Builder> marketing) {
            return marketing(Marketing.builder().applyMutation(marketing).build());
        }

        /**
         * <p>
         * Specifies details of a customer's procurement terms. Required only for partners in eligible programs.
         * </p>
         * 
         * @param softwareRevenue
         *        Specifies details of a customer's procurement terms. Required only for partners in eligible programs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareRevenue(SoftwareRevenue softwareRevenue);

        /**
         * <p>
         * Specifies details of a customer's procurement terms. Required only for partners in eligible programs.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareRevenue.Builder} avoiding the
         * need to create one manually via {@link SoftwareRevenue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareRevenue.Builder#build()} is called immediately and its
         * result is passed to {@link #softwareRevenue(SoftwareRevenue)}.
         * 
         * @param softwareRevenue
         *        a consumer that will call methods on {@link SoftwareRevenue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareRevenue(SoftwareRevenue)
         */
        default Builder softwareRevenue(Consumer<SoftwareRevenue.Builder> softwareRevenue) {
            return softwareRevenue(SoftwareRevenue.builder().applyMutation(softwareRevenue).build());
        }

        /**
         * <p>
         * Read-only, system generated <code>Opportunity</code> unique identifier.
         * </p>
         * 
         * @param id
         *        Read-only, system generated <code>Opportunity</code> unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the opportunity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that uniquely identifies the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * <code>DateTime</code> when the opportunity was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        <code>DateTime</code> when the opportunity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * <code>DateTime</code> when the <code>Opportunity</code> was last created.
         * </p>
         * 
         * @param createdDate
         *        <code>DateTime</code> when the <code>Opportunity</code> was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Provides information about the associations of other entities with the opportunity. These entities include
         * identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and
         * <code>AWSMarketplaceOffers</code>.
         * </p>
         * 
         * @param relatedEntityIdentifiers
         *        Provides information about the associations of other entities with the opportunity. These entities
         *        include identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and
         *        <code>AWSMarketplaceOffers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers);

        /**
         * <p>
         * Provides information about the associations of other entities with the opportunity. These entities include
         * identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and
         * <code>AWSMarketplaceOffers</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedEntityIdentifiers.Builder}
         * avoiding the need to create one manually via {@link RelatedEntityIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedEntityIdentifiers.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedEntityIdentifiers(RelatedEntityIdentifiers)}.
         * 
         * @param relatedEntityIdentifiers
         *        a consumer that will call methods on {@link RelatedEntityIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedEntityIdentifiers(RelatedEntityIdentifiers)
         */
        default Builder relatedEntityIdentifiers(Consumer<RelatedEntityIdentifiers.Builder> relatedEntityIdentifiers) {
            return relatedEntityIdentifiers(RelatedEntityIdentifiers.builder().applyMutation(relatedEntityIdentifiers).build());
        }

        /**
         * <p>
         * An object that contains lifecycle details for the <code>Opportunity</code>.
         * </p>
         * 
         * @param lifeCycle
         *        An object that contains lifecycle details for the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(LifeCycle lifeCycle);

        /**
         * <p>
         * An object that contains lifecycle details for the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycle.Builder} avoiding the need to
         * create one manually via {@link LifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifeCycle(LifeCycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link LifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(LifeCycle)
         */
        default Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return lifeCycle(LifeCycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on this
         * opportunity within the partner's organization.
         * </p>
         * 
         * @param opportunityTeam
         *        Represents the internal team handling the opportunity. Specify the members involved in collaborating
         *        on this opportunity within the partner's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(Collection<Contact> opportunityTeam);

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on this
         * opportunity within the partner's organization.
         * </p>
         * 
         * @param opportunityTeam
         *        Represents the internal team handling the opportunity. Specify the members involved in collaborating
         *        on this opportunity within the partner's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(Contact... opportunityTeam);

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on this
         * opportunity within the partner's organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Contact#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #opportunityTeam(List<Contact>)}.
         * 
         * @param opportunityTeam
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opportunityTeam(java.util.Collection<Contact>)
         */
        Builder opportunityTeam(Consumer<Contact.Builder>... opportunityTeam);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String catalog;

        private List<String> primaryNeedsFromAws = DefaultSdkAutoConstructList.getInstance();

        private String nationalSecurity;

        private String partnerOpportunityIdentifier;

        private Customer customer;

        private Project project;

        private String opportunityType;

        private Marketing marketing;

        private SoftwareRevenue softwareRevenue;

        private String id;

        private String arn;

        private Instant lastModifiedDate;

        private Instant createdDate;

        private RelatedEntityIdentifiers relatedEntityIdentifiers;

        private LifeCycle lifeCycle;

        private List<Contact> opportunityTeam = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpportunityResponse model) {
            super(model);
            catalog(model.catalog);
            primaryNeedsFromAwsWithStrings(model.primaryNeedsFromAws);
            nationalSecurity(model.nationalSecurity);
            partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
            customer(model.customer);
            project(model.project);
            opportunityType(model.opportunityType);
            marketing(model.marketing);
            softwareRevenue(model.softwareRevenue);
            id(model.id);
            arn(model.arn);
            lastModifiedDate(model.lastModifiedDate);
            createdDate(model.createdDate);
            relatedEntityIdentifiers(model.relatedEntityIdentifiers);
            lifeCycle(model.lifeCycle);
            opportunityTeam(model.opportunityTeam);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getPrimaryNeedsFromAws() {
            if (primaryNeedsFromAws instanceof SdkAutoConstructList) {
                return null;
            }
            return primaryNeedsFromAws;
        }

        public final void setPrimaryNeedsFromAws(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
        }

        @Override
        public final Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAwsWithStrings(String... primaryNeedsFromAws) {
            primaryNeedsFromAwsWithStrings(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        @Override
        public final Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copyEnumToString(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAws(PrimaryNeedFromAws... primaryNeedsFromAws) {
            primaryNeedsFromAws(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        public final String getNationalSecurity() {
            return nationalSecurity;
        }

        public final void setNationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
        }

        @Override
        public final Builder nationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
            return this;
        }

        @Override
        public final Builder nationalSecurity(NationalSecurity nationalSecurity) {
            this.nationalSecurity(nationalSecurity == null ? null : nationalSecurity.toString());
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        public final Customer.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final Project.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final String getOpportunityType() {
            return opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final Marketing.Builder getMarketing() {
            return marketing != null ? marketing.toBuilder() : null;
        }

        public final void setMarketing(Marketing.BuilderImpl marketing) {
            this.marketing = marketing != null ? marketing.build() : null;
        }

        @Override
        public final Builder marketing(Marketing marketing) {
            this.marketing = marketing;
            return this;
        }

        public final SoftwareRevenue.Builder getSoftwareRevenue() {
            return softwareRevenue != null ? softwareRevenue.toBuilder() : null;
        }

        public final void setSoftwareRevenue(SoftwareRevenue.BuilderImpl softwareRevenue) {
            this.softwareRevenue = softwareRevenue != null ? softwareRevenue.build() : null;
        }

        @Override
        public final Builder softwareRevenue(SoftwareRevenue softwareRevenue) {
            this.softwareRevenue = softwareRevenue;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final RelatedEntityIdentifiers.Builder getRelatedEntityIdentifiers() {
            return relatedEntityIdentifiers != null ? relatedEntityIdentifiers.toBuilder() : null;
        }

        public final void setRelatedEntityIdentifiers(RelatedEntityIdentifiers.BuilderImpl relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers != null ? relatedEntityIdentifiers.build() : null;
        }

        @Override
        public final Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final List<Contact.Builder> getOpportunityTeam() {
            List<Contact.Builder> result = PartnerOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<Contact.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<Contact> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Contact... opportunityTeam) {
            opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<Contact.Builder>... opportunityTeam) {
            opportunityTeam(Stream.of(opportunityTeam).map(c -> Contact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetOpportunityResponse build() {
            return new GetOpportunityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
