/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceSnapshotJobsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListResourceSnapshotJobsResponse.Builder, ListResourceSnapshotJobsResponse> {
    private static final SdkField<List<ResourceSnapshotJobSummary>> RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD = SdkField
            .<List<ResourceSnapshotJobSummary>> builder(MarshallingType.LIST)
            .memberName("ResourceSnapshotJobSummaries")
            .getter(getter(ListResourceSnapshotJobsResponse::resourceSnapshotJobSummaries))
            .setter(setter(Builder::resourceSnapshotJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSnapshotJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSnapshotJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceSnapshotJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries;

    private final String nextToken;

    private ListResourceSnapshotJobsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSnapshotJobSummaries = builder.resourceSnapshotJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceSnapshotJobSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceSnapshotJobSummaries() {
        return resourceSnapshotJobSummaries != null && !(resourceSnapshotJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resource snapshot job summary objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceSnapshotJobSummaries} method.
     * </p>
     * 
     * @return An array of resource snapshot job summary objects.
     */
    public final List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries() {
        return resourceSnapshotJobSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. If there are no additional results, this value is null.
     * </p>
     * 
     * @return The token to retrieve the next set of results. If there are no additional results, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceSnapshotJobSummaries() ? resourceSnapshotJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSnapshotJobsResponse)) {
            return false;
        }
        ListResourceSnapshotJobsResponse other = (ListResourceSnapshotJobsResponse) obj;
        return hasResourceSnapshotJobSummaries() == other.hasResourceSnapshotJobSummaries()
                && Objects.equals(resourceSnapshotJobSummaries(), other.resourceSnapshotJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceSnapshotJobsResponse")
                .add("ResourceSnapshotJobSummaries", hasResourceSnapshotJobSummaries() ? resourceSnapshotJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceSnapshotJobSummaries":
            return Optional.ofNullable(clazz.cast(resourceSnapshotJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceSnapshotJobSummaries", RESOURCE_SNAPSHOT_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSnapshotJobsResponse, T> g) {
        return obj -> g.apply((ListResourceSnapshotJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceSnapshotJobsResponse> {
        /**
         * <p>
         * An array of resource snapshot job summary objects.
         * </p>
         * 
         * @param resourceSnapshotJobSummaries
         *        An array of resource snapshot job summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobSummaries(Collection<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries);

        /**
         * <p>
         * An array of resource snapshot job summary objects.
         * </p>
         * 
         * @param resourceSnapshotJobSummaries
         *        An array of resource snapshot job summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobSummaries(ResourceSnapshotJobSummary... resourceSnapshotJobSummaries);

        /**
         * <p>
         * An array of resource snapshot job summary objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #resourceSnapshotJobSummaries(List<ResourceSnapshotJobSummary>)}.
         * 
         * @param resourceSnapshotJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSnapshotJobSummaries(java.util.Collection<ResourceSnapshotJobSummary>)
         */
        Builder resourceSnapshotJobSummaries(Consumer<ResourceSnapshotJobSummary.Builder>... resourceSnapshotJobSummaries);

        /**
         * <p>
         * The token to retrieve the next set of results. If there are no additional results, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. If there are no additional results, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private List<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSnapshotJobsResponse model) {
            super(model);
            resourceSnapshotJobSummaries(model.resourceSnapshotJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<ResourceSnapshotJobSummary.Builder> getResourceSnapshotJobSummaries() {
            List<ResourceSnapshotJobSummary.Builder> result = ResourceSnapshotJobSummaryListCopier
                    .copyToBuilder(this.resourceSnapshotJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSnapshotJobSummaries(
                Collection<ResourceSnapshotJobSummary.BuilderImpl> resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries = ResourceSnapshotJobSummaryListCopier
                    .copyFromBuilder(resourceSnapshotJobSummaries);
        }

        @Override
        public final Builder resourceSnapshotJobSummaries(Collection<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries) {
            this.resourceSnapshotJobSummaries = ResourceSnapshotJobSummaryListCopier.copy(resourceSnapshotJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotJobSummaries(ResourceSnapshotJobSummary... resourceSnapshotJobSummaries) {
            resourceSnapshotJobSummaries(Arrays.asList(resourceSnapshotJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotJobSummaries(
                Consumer<ResourceSnapshotJobSummary.Builder>... resourceSnapshotJobSummaries) {
            resourceSnapshotJobSummaries(Stream.of(resourceSnapshotJobSummaries)
                    .map(c -> ResourceSnapshotJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceSnapshotJobsResponse build() {
            return new ListResourceSnapshotJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
