/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the <code>Opportunity</code>'s project details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Project implements SdkPojo, Serializable, ToCopyableBuilder<Project.Builder, Project> {
    private static final SdkField<List<String>> DELIVERY_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeliveryModels")
            .getter(getter(Project::deliveryModelsAsStrings))
            .setter(setter(Builder::deliveryModelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField
            .<List<ExpectedCustomerSpend>> builder(MarshallingType.LIST)
            .memberName("ExpectedCustomerSpend")
            .getter(getter(Project::expectedCustomerSpend))
            .setter(setter(Builder::expectedCustomerSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedCustomerSpend> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedCustomerSpend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Project::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<List<String>> APN_PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApnPrograms")
            .getter(getter(Project::apnPrograms))
            .setter(setter(Builder::apnPrograms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApnPrograms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_BUSINESS_PROBLEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerBusinessProblem").getter(getter(Project::customerBusinessProblem))
            .setter(setter(Builder::customerBusinessProblem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerBusinessProblem").build())
            .build();

    private static final SdkField<String> CUSTOMER_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerUseCase").getter(getter(Project::customerUseCase)).setter(setter(Builder::customerUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUseCase").build()).build();

    private static final SdkField<String> RELATED_OPPORTUNITY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RelatedOpportunityIdentifier")
            .getter(getter(Project::relatedOpportunityIdentifier))
            .setter(setter(Builder::relatedOpportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpportunityIdentifier")
                    .build()).build();

    private static final SdkField<List<String>> SALES_ACTIVITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SalesActivities")
            .getter(getter(Project::salesActivitiesAsStrings))
            .setter(setter(Builder::salesActivitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesActivities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPETITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompetitorName").getter(getter(Project::competitorNameAsString)).setter(setter(Builder::competitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompetitorName").build()).build();

    private static final SdkField<String> OTHER_COMPETITOR_NAMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherCompetitorNames").getter(getter(Project::otherCompetitorNames))
            .setter(setter(Builder::otherCompetitorNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCompetitorNames").build())
            .build();

    private static final SdkField<String> OTHER_SOLUTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherSolutionDescription").getter(getter(Project::otherSolutionDescription))
            .setter(setter(Builder::otherSolutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherSolutionDescription").build())
            .build();

    private static final SdkField<String> ADDITIONAL_COMMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalComments").getter(getter(Project::additionalComments))
            .setter(setter(Builder::additionalComments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalComments").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODELS_FIELD,
            EXPECTED_CUSTOMER_SPEND_FIELD, TITLE_FIELD, APN_PROGRAMS_FIELD, CUSTOMER_BUSINESS_PROBLEM_FIELD,
            CUSTOMER_USE_CASE_FIELD, RELATED_OPPORTUNITY_IDENTIFIER_FIELD, SALES_ACTIVITIES_FIELD, COMPETITOR_NAME_FIELD,
            OTHER_COMPETITOR_NAMES_FIELD, OTHER_SOLUTION_DESCRIPTION_FIELD, ADDITIONAL_COMMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> deliveryModels;

    private final List<ExpectedCustomerSpend> expectedCustomerSpend;

    private final String title;

    private final List<String> apnPrograms;

    private final String customerBusinessProblem;

    private final String customerUseCase;

    private final String relatedOpportunityIdentifier;

    private final List<String> salesActivities;

    private final String competitorName;

    private final String otherCompetitorNames;

    private final String otherSolutionDescription;

    private final String additionalComments;

    private Project(BuilderImpl builder) {
        this.deliveryModels = builder.deliveryModels;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
        this.title = builder.title;
        this.apnPrograms = builder.apnPrograms;
        this.customerBusinessProblem = builder.customerBusinessProblem;
        this.customerUseCase = builder.customerUseCase;
        this.relatedOpportunityIdentifier = builder.relatedOpportunityIdentifier;
        this.salesActivities = builder.salesActivities;
        this.competitorName = builder.competitorName;
        this.otherCompetitorNames = builder.otherCompetitorNames;
        this.otherSolutionDescription = builder.otherSolutionDescription;
        this.additionalComments = builder.additionalComments;
    }

    /**
     * <p>
     * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
     * context. You can select multiple options.
     * </p>
     * <p>
     * Options' descriptions from the <code>Delivery Model</code> field are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
     * Services environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting, design,
     * implementation, billing support, cost optimization, technical support).
     * </p>
     * </li>
     * <li>
     * <p>
     * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     * enterprise cloud adoption (For example: Advisory or transformation planning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Resell: Amazon Web Services accounts and billing management for your customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Delivery model not described above.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Specifies the deployment or consumption model for your solution or service in the
     *         <code>Opportunity</code>'s context. You can select multiple options.</p>
     *         <p>
     *         Options' descriptions from the <code>Delivery Model</code> field are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
     *         Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon
     *         Web Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
     *         design, implementation, billing support, cost optimization, technical support).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     *         enterprise cloud adoption (For example: Advisory or transformation planning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resell: Amazon Web Services accounts and billing management for your customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Delivery model not described above.
     *         </p>
     *         </li>
     */
    public final List<DeliveryModel> deliveryModels() {
        return DeliveryModelsCopier.copyStringToEnum(deliveryModels);
    }

    /**
     * For responses, this returns true if the service returned a value for the DeliveryModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeliveryModels() {
        return deliveryModels != null && !(deliveryModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
     * context. You can select multiple options.
     * </p>
     * <p>
     * Options' descriptions from the <code>Delivery Model</code> field are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
     * Services environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting, design,
     * implementation, billing support, cost optimization, technical support).
     * </p>
     * </li>
     * <li>
     * <p>
     * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     * enterprise cloud adoption (For example: Advisory or transformation planning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Resell: Amazon Web Services accounts and billing management for your customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Delivery model not described above.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Specifies the deployment or consumption model for your solution or service in the
     *         <code>Opportunity</code>'s context. You can select multiple options.</p>
     *         <p>
     *         Options' descriptions from the <code>Delivery Model</code> field are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
     *         Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon
     *         Web Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
     *         design, implementation, billing support, cost optimization, technical support).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     *         enterprise cloud adoption (For example: Advisory or transformation planning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resell: Amazon Web Services accounts and billing management for your customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Delivery model not described above.
     *         </p>
     *         </li>
     */
    public final List<String> deliveryModelsAsStrings() {
        return deliveryModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedCustomerSpend property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedCustomerSpend() {
        return expectedCustomerSpend != null && !(expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the estimated amount that the customer is expected to spend on AWS services related to the
     * opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedCustomerSpend} method.
     * </p>
     * 
     * @return Represents the estimated amount that the customer is expected to spend on AWS services related to the
     *         opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
     */
    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return expectedCustomerSpend;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s title or name.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s title or name.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApnPrograms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApnPrograms() {
        return apnPrograms != null && !(apnPrograms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN programs
     * refer to specific partner programs or initiatives that can impact the <code>Opportunity</code>.
     * </p>
     * <p>
     * Valid values:
     * <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApnPrograms} method.
     * </p>
     * 
     * @return Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN
     *         programs refer to specific partner programs or initiatives that can impact the <code>Opportunity</code>
     *         .</p>
     *         <p>
     *         Valid values:
     *         <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
     */
    public final List<String> apnPrograms() {
        return apnPrograms;
    }

    /**
     * <p>
     * Describes the problem the end customer has, and how the partner is helping. Utilize this field to provide a
     * concise narrative that outlines the customer's business challenge or issue. Elaborate on how the partner's
     * solution or offerings align to resolve the customer's business problem. Include relevant information about the
     * partner's value proposition, unique selling points, and expertise to tackle the issue. Offer insights on how the
     * proposed solution meets the customer's needs and provides value. Use concise language and precise descriptions to
     * convey the context and significance of the <code>Opportunity</code>. The content in this field helps Amazon Web
     * Services understand the nature of the <code>Opportunity</code> and the strategic fit of the partner's solution.
     * </p>
     * 
     * @return Describes the problem the end customer has, and how the partner is helping. Utilize this field to provide
     *         a concise narrative that outlines the customer's business challenge or issue. Elaborate on how the
     *         partner's solution or offerings align to resolve the customer's business problem. Include relevant
     *         information about the partner's value proposition, unique selling points, and expertise to tackle the
     *         issue. Offer insights on how the proposed solution meets the customer's needs and provides value. Use
     *         concise language and precise descriptions to convey the context and significance of the
     *         <code>Opportunity</code>. The content in this field helps Amazon Web Services understand the nature of
     *         the <code>Opportunity</code> and the strategic fit of the partner's solution.
     */
    public final String customerBusinessProblem() {
        return customerBusinessProblem;
    }

    /**
     * <p>
     * Specifies the proposed solution focus or type of workload for the Opportunity. This field captures the primary
     * use case or objective of the proposed solution, and provides context and clarity to the addressed workload.
     * </p>
     * <p>
     * Valid values:
     * <code>AI Machine Learning and Analytics | Archiving | Big Data: Data Warehouse/Data Integration/ETL/Data Lake/BI | Blockchain | Business Applications: Mainframe Modernization | Business Applications &amp; Contact Center | Business Applications &amp; SAP Production | Centralized Operations Management | Cloud Management Tools | Cloud Management Tools &amp; DevOps with Continuous Integration &amp; Continuous Delivery (CICD) | Configuration, Compliance &amp; Auditing | Connected Services | Containers &amp; Serverless | Content Delivery &amp; Edge Services | Database | Edge Computing/End User Computing | Energy | Enterprise Governance &amp; Controls | Enterprise Resource Planning | Financial Services | Healthcare and Life Sciences | High Performance Computing | Hybrid Application Platform | Industrial Software | IOT | Manufacturing, Supply Chain and Operations | Media &amp; High performance computing (HPC) | Migration/Database Migration | Monitoring, logging and performance | Monitoring &amp; Observability | Networking | Outpost | SAP | Security &amp; Compliance | Storage &amp; Backup | Training | VMC | VMWare | Web development &amp; DevOps</code>
     * </p>
     * 
     * @return Specifies the proposed solution focus or type of workload for the Opportunity. This field captures the
     *         primary use case or objective of the proposed solution, and provides context and clarity to the addressed
     *         workload.</p>
     *         <p>
     *         Valid values:
     *         <code>AI Machine Learning and Analytics | Archiving | Big Data: Data Warehouse/Data Integration/ETL/Data Lake/BI | Blockchain | Business Applications: Mainframe Modernization | Business Applications &amp; Contact Center | Business Applications &amp; SAP Production | Centralized Operations Management | Cloud Management Tools | Cloud Management Tools &amp; DevOps with Continuous Integration &amp; Continuous Delivery (CICD) | Configuration, Compliance &amp; Auditing | Connected Services | Containers &amp; Serverless | Content Delivery &amp; Edge Services | Database | Edge Computing/End User Computing | Energy | Enterprise Governance &amp; Controls | Enterprise Resource Planning | Financial Services | Healthcare and Life Sciences | High Performance Computing | Hybrid Application Platform | Industrial Software | IOT | Manufacturing, Supply Chain and Operations | Media &amp; High performance computing (HPC) | Migration/Database Migration | Monitoring, logging and performance | Monitoring &amp; Observability | Networking | Outpost | SAP | Security &amp; Compliance | Storage &amp; Backup | Training | VMC | VMWare | Web development &amp; DevOps</code>
     */
    public final String customerUseCase() {
        return customerUseCase;
    }

    /**
     * <p>
     * Specifies the current opportunity's parent opportunity identifier.
     * </p>
     * 
     * @return Specifies the current opportunity's parent opportunity identifier.
     */
    public final String relatedOpportunityIdentifier() {
        return relatedOpportunityIdentifier;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities help
     * drive Amazon Web Services assignment priority.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
     * introduce your solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer has shown interest in solution: After initial discussions, the customer is interested in your solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's business
     * problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
     * </p>
     * </li>
     * <li>
     * <p>
     * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
     * scope and deliverables.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSalesActivities} method.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
     *         activities help drive Amazon Web Services assignment priority.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Initialized discussions with customer: Initial conversations with the customer to understand their needs
     *         and introduce your solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer has shown interest in solution: After initial discussions, the customer is interested in your
     *         solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
     *         customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In evaluation/planning stage: The customer is evaluating the solution and planning potential
     *         implementation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
     *         business problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
     *         project scope and deliverables.
     *         </p>
     *         </li>
     */
    public final List<SalesActivity> salesActivities() {
        return SalesActivitiesCopier.copyStringToEnum(salesActivities);
    }

    /**
     * For responses, this returns true if the service returned a value for the SalesActivities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSalesActivities() {
        return salesActivities != null && !(salesActivities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities help
     * drive Amazon Web Services assignment priority.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
     * introduce your solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer has shown interest in solution: After initial discussions, the customer is interested in your solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's business
     * problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
     * </p>
     * </li>
     * <li>
     * <p>
     * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
     * scope and deliverables.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSalesActivities} method.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
     *         activities help drive Amazon Web Services assignment priority.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Initialized discussions with customer: Initial conversations with the customer to understand their needs
     *         and introduce your solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer has shown interest in solution: After initial discussions, the customer is interested in your
     *         solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
     *         customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In evaluation/planning stage: The customer is evaluating the solution and planning potential
     *         implementation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
     *         business problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
     *         project scope and deliverables.
     *         </p>
     *         </li>
     */
    public final List<String> salesActivitiesAsStrings() {
        return salesActivities;
    }

    /**
     * <p>
     * Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not in the
     * picklist.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #competitorName}
     * will return {@link CompetitorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #competitorNameAsString}.
     * </p>
     * 
     * @return Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not
     *         in the picklist.
     * @see CompetitorName
     */
    public final CompetitorName competitorName() {
        return CompetitorName.fromValue(competitorName);
    }

    /**
     * <p>
     * Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not in the
     * picklist.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #competitorName}
     * will return {@link CompetitorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #competitorNameAsString}.
     * </p>
     * 
     * @return Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not
     *         in the picklist.
     * @see CompetitorName
     */
    public final String competitorNameAsString() {
        return competitorName;
    }

    /**
     * <p>
     * Only allowed when <code>CompetitorNames</code> has <code>Other</code> selected.
     * </p>
     * 
     * @return Only allowed when <code>CompetitorNames</code> has <code>Other</code> selected.
     */
    public final String otherCompetitorNames() {
        return otherCompetitorNames;
    }

    /**
     * <p>
     * Specifies the offered solution for the customer's business problem when the
     * <code> RelatedEntityIdentifiers.Solutions</code> field value is <code>Other</code>.
     * </p>
     * 
     * @return Specifies the offered solution for the customer's business problem when the
     *         <code> RelatedEntityIdentifiers.Solutions</code> field value is <code>Other</code>.
     */
    public final String otherSolutionDescription() {
        return otherSolutionDescription;
    }

    /**
     * <p>
     * Captures additional comments or information for the <code>Opportunity</code> that weren't captured in other
     * fields.
     * </p>
     * 
     * @return Captures additional comments or information for the <code>Opportunity</code> that weren't captured in
     *         other fields.
     */
    public final String additionalComments() {
        return additionalComments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliveryModels() ? deliveryModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedCustomerSpend() ? expectedCustomerSpend() : null);
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasApnPrograms() ? apnPrograms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerBusinessProblem());
        hashCode = 31 * hashCode + Objects.hashCode(customerUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(relatedOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSalesActivities() ? salesActivitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(competitorNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otherCompetitorNames());
        hashCode = 31 * hashCode + Objects.hashCode(otherSolutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(additionalComments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        return hasDeliveryModels() == other.hasDeliveryModels()
                && Objects.equals(deliveryModelsAsStrings(), other.deliveryModelsAsStrings())
                && hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend()
                && Objects.equals(expectedCustomerSpend(), other.expectedCustomerSpend())
                && Objects.equals(title(), other.title()) && hasApnPrograms() == other.hasApnPrograms()
                && Objects.equals(apnPrograms(), other.apnPrograms())
                && Objects.equals(customerBusinessProblem(), other.customerBusinessProblem())
                && Objects.equals(customerUseCase(), other.customerUseCase())
                && Objects.equals(relatedOpportunityIdentifier(), other.relatedOpportunityIdentifier())
                && hasSalesActivities() == other.hasSalesActivities()
                && Objects.equals(salesActivitiesAsStrings(), other.salesActivitiesAsStrings())
                && Objects.equals(competitorNameAsString(), other.competitorNameAsString())
                && Objects.equals(otherCompetitorNames(), other.otherCompetitorNames())
                && Objects.equals(otherSolutionDescription(), other.otherSolutionDescription())
                && Objects.equals(additionalComments(), other.additionalComments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Project").add("DeliveryModels", hasDeliveryModels() ? deliveryModelsAsStrings() : null)
                .add("ExpectedCustomerSpend", hasExpectedCustomerSpend() ? expectedCustomerSpend() : null)
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApnPrograms", hasApnPrograms() ? apnPrograms() : null)
                .add("CustomerBusinessProblem", customerBusinessProblem() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomerUseCase", customerUseCase()).add("RelatedOpportunityIdentifier", relatedOpportunityIdentifier())
                .add("SalesActivities", hasSalesActivities() ? salesActivitiesAsStrings() : null)
                .add("CompetitorName", competitorNameAsString()).add("OtherCompetitorNames", otherCompetitorNames())
                .add("OtherSolutionDescription", otherSolutionDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdditionalComments", additionalComments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryModels":
            return Optional.ofNullable(clazz.cast(deliveryModelsAsStrings()));
        case "ExpectedCustomerSpend":
            return Optional.ofNullable(clazz.cast(expectedCustomerSpend()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "ApnPrograms":
            return Optional.ofNullable(clazz.cast(apnPrograms()));
        case "CustomerBusinessProblem":
            return Optional.ofNullable(clazz.cast(customerBusinessProblem()));
        case "CustomerUseCase":
            return Optional.ofNullable(clazz.cast(customerUseCase()));
        case "RelatedOpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(relatedOpportunityIdentifier()));
        case "SalesActivities":
            return Optional.ofNullable(clazz.cast(salesActivitiesAsStrings()));
        case "CompetitorName":
            return Optional.ofNullable(clazz.cast(competitorNameAsString()));
        case "OtherCompetitorNames":
            return Optional.ofNullable(clazz.cast(otherCompetitorNames()));
        case "OtherSolutionDescription":
            return Optional.ofNullable(clazz.cast(otherSolutionDescription()));
        case "AdditionalComments":
            return Optional.ofNullable(clazz.cast(additionalComments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryModels", DELIVERY_MODELS_FIELD);
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("ApnPrograms", APN_PROGRAMS_FIELD);
        map.put("CustomerBusinessProblem", CUSTOMER_BUSINESS_PROBLEM_FIELD);
        map.put("CustomerUseCase", CUSTOMER_USE_CASE_FIELD);
        map.put("RelatedOpportunityIdentifier", RELATED_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("SalesActivities", SALES_ACTIVITIES_FIELD);
        map.put("CompetitorName", COMPETITOR_NAME_FIELD);
        map.put("OtherCompetitorNames", OTHER_COMPETITOR_NAMES_FIELD);
        map.put("OtherSolutionDescription", OTHER_SOLUTION_DESCRIPTION_FIELD);
        map.put("AdditionalComments", ADDITIONAL_COMMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies the deployment or consumption model for your solution or service in the
         *        <code>Opportunity</code>'s context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(Collection<String> deliveryModels);

        /**
         * <p>
         * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies the deployment or consumption model for your solution or service in the
         *        <code>Opportunity</code>'s context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(String... deliveryModels);

        /**
         * <p>
         * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies the deployment or consumption model for your solution or service in the
         *        <code>Opportunity</code>'s context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(Collection<DeliveryModel> deliveryModels);

        /**
         * <p>
         * Specifies the deployment or consumption model for your solution or service in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies the deployment or consumption model for your solution or service in the
         *        <code>Opportunity</code>'s context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(DeliveryModel... deliveryModels);

        /**
         * <p>
         * Represents the estimated amount that the customer is expected to spend on AWS services related to the
         * opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Represents the estimated amount that the customer is expected to spend on AWS services related to the
         *        opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend);

        /**
         * <p>
         * Represents the estimated amount that the customer is expected to spend on AWS services related to the
         * opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Represents the estimated amount that the customer is expected to spend on AWS services related to the
         *        opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend);

        /**
         * <p>
         * Represents the estimated amount that the customer is expected to spend on AWS services related to the
         * opportunity. This helps in evaluating the potential financial value of the opportunity for AWS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder#build()} is
         * called immediately and its result is passed to {@link #expectedCustomerSpend(List<ExpectedCustomerSpend>)}.
         * 
         * @param expectedCustomerSpend
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedCustomerSpend(java.util.Collection<ExpectedCustomerSpend>)
         */
        Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s title or name.
         * </p>
         * 
         * @param title
         *        Specifies the <code>Opportunity</code>'s title or name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN programs
         * refer to specific partner programs or initiatives that can impact the <code>Opportunity</code>.
         * </p>
         * <p>
         * Valid values:
         * <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
         * </p>
         * 
         * @param apnPrograms
         *        Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN
         *        programs refer to specific partner programs or initiatives that can impact the
         *        <code>Opportunity</code>.</p>
         *        <p>
         *        Valid values:
         *        <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnPrograms(Collection<String> apnPrograms);

        /**
         * <p>
         * Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN programs
         * refer to specific partner programs or initiatives that can impact the <code>Opportunity</code>.
         * </p>
         * <p>
         * Valid values:
         * <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
         * </p>
         * 
         * @param apnPrograms
         *        Specifies the Amazon Partner Network (APN) program that influenced the <code>Opportunity</code>. APN
         *        programs refer to specific partner programs or initiatives that can impact the
         *        <code>Opportunity</code>.</p>
         *        <p>
         *        Valid values:
         *        <code>APN Immersion Days | APN Solution Space | ATO (Authority to Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV Workload Migration | Migration Acceleration Program | P3 | Partner Launch Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator Program | WWPS NDPP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnPrograms(String... apnPrograms);

        /**
         * <p>
         * Describes the problem the end customer has, and how the partner is helping. Utilize this field to provide a
         * concise narrative that outlines the customer's business challenge or issue. Elaborate on how the partner's
         * solution or offerings align to resolve the customer's business problem. Include relevant information about
         * the partner's value proposition, unique selling points, and expertise to tackle the issue. Offer insights on
         * how the proposed solution meets the customer's needs and provides value. Use concise language and precise
         * descriptions to convey the context and significance of the <code>Opportunity</code>. The content in this
         * field helps Amazon Web Services understand the nature of the <code>Opportunity</code> and the strategic fit
         * of the partner's solution.
         * </p>
         * 
         * @param customerBusinessProblem
         *        Describes the problem the end customer has, and how the partner is helping. Utilize this field to
         *        provide a concise narrative that outlines the customer's business challenge or issue. Elaborate on how
         *        the partner's solution or offerings align to resolve the customer's business problem. Include relevant
         *        information about the partner's value proposition, unique selling points, and expertise to tackle the
         *        issue. Offer insights on how the proposed solution meets the customer's needs and provides value. Use
         *        concise language and precise descriptions to convey the context and significance of the
         *        <code>Opportunity</code>. The content in this field helps Amazon Web Services understand the nature of
         *        the <code>Opportunity</code> and the strategic fit of the partner's solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerBusinessProblem(String customerBusinessProblem);

        /**
         * <p>
         * Specifies the proposed solution focus or type of workload for the Opportunity. This field captures the
         * primary use case or objective of the proposed solution, and provides context and clarity to the addressed
         * workload.
         * </p>
         * <p>
         * Valid values:
         * <code>AI Machine Learning and Analytics | Archiving | Big Data: Data Warehouse/Data Integration/ETL/Data Lake/BI | Blockchain | Business Applications: Mainframe Modernization | Business Applications &amp; Contact Center | Business Applications &amp; SAP Production | Centralized Operations Management | Cloud Management Tools | Cloud Management Tools &amp; DevOps with Continuous Integration &amp; Continuous Delivery (CICD) | Configuration, Compliance &amp; Auditing | Connected Services | Containers &amp; Serverless | Content Delivery &amp; Edge Services | Database | Edge Computing/End User Computing | Energy | Enterprise Governance &amp; Controls | Enterprise Resource Planning | Financial Services | Healthcare and Life Sciences | High Performance Computing | Hybrid Application Platform | Industrial Software | IOT | Manufacturing, Supply Chain and Operations | Media &amp; High performance computing (HPC) | Migration/Database Migration | Monitoring, logging and performance | Monitoring &amp; Observability | Networking | Outpost | SAP | Security &amp; Compliance | Storage &amp; Backup | Training | VMC | VMWare | Web development &amp; DevOps</code>
         * </p>
         * 
         * @param customerUseCase
         *        Specifies the proposed solution focus or type of workload for the Opportunity. This field captures the
         *        primary use case or objective of the proposed solution, and provides context and clarity to the
         *        addressed workload.</p>
         *        <p>
         *        Valid values:
         *        <code>AI Machine Learning and Analytics | Archiving | Big Data: Data Warehouse/Data Integration/ETL/Data Lake/BI | Blockchain | Business Applications: Mainframe Modernization | Business Applications &amp; Contact Center | Business Applications &amp; SAP Production | Centralized Operations Management | Cloud Management Tools | Cloud Management Tools &amp; DevOps with Continuous Integration &amp; Continuous Delivery (CICD) | Configuration, Compliance &amp; Auditing | Connected Services | Containers &amp; Serverless | Content Delivery &amp; Edge Services | Database | Edge Computing/End User Computing | Energy | Enterprise Governance &amp; Controls | Enterprise Resource Planning | Financial Services | Healthcare and Life Sciences | High Performance Computing | Hybrid Application Platform | Industrial Software | IOT | Manufacturing, Supply Chain and Operations | Media &amp; High performance computing (HPC) | Migration/Database Migration | Monitoring, logging and performance | Monitoring &amp; Observability | Networking | Outpost | SAP | Security &amp; Compliance | Storage &amp; Backup | Training | VMC | VMWare | Web development &amp; DevOps</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerUseCase(String customerUseCase);

        /**
         * <p>
         * Specifies the current opportunity's parent opportunity identifier.
         * </p>
         * 
         * @param relatedOpportunityIdentifier
         *        Specifies the current opportunity's parent opportunity identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedOpportunityIdentifier(String relatedOpportunityIdentifier);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities
         * help drive Amazon Web Services assignment priority.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
         * introduce your solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer has shown interest in solution: After initial discussions, the customer is interested in your
         * solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
         * business problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
         * scope and deliverables.
         * </p>
         * </li>
         * </ul>
         * 
         * @param salesActivities
         *        Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
         *        activities help drive Amazon Web Services assignment priority.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Initialized discussions with customer: Initial conversations with the customer to understand their
         *        needs and introduce your solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer has shown interest in solution: After initial discussions, the customer is interested in your
         *        solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
         *        customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In evaluation/planning stage: The customer is evaluating the solution and planning potential
         *        implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agreed on solution to Business Problem: Both parties agree on how the solution addresses the
         *        customer's business problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
         *        project scope and deliverables.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivitiesWithStrings(Collection<String> salesActivities);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities
         * help drive Amazon Web Services assignment priority.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
         * introduce your solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer has shown interest in solution: After initial discussions, the customer is interested in your
         * solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
         * business problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
         * scope and deliverables.
         * </p>
         * </li>
         * </ul>
         * 
         * @param salesActivities
         *        Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
         *        activities help drive Amazon Web Services assignment priority.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Initialized discussions with customer: Initial conversations with the customer to understand their
         *        needs and introduce your solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer has shown interest in solution: After initial discussions, the customer is interested in your
         *        solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
         *        customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In evaluation/planning stage: The customer is evaluating the solution and planning potential
         *        implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agreed on solution to Business Problem: Both parties agree on how the solution addresses the
         *        customer's business problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
         *        project scope and deliverables.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivitiesWithStrings(String... salesActivities);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities
         * help drive Amazon Web Services assignment priority.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
         * introduce your solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer has shown interest in solution: After initial discussions, the customer is interested in your
         * solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
         * business problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
         * scope and deliverables.
         * </p>
         * </li>
         * </ul>
         * 
         * @param salesActivities
         *        Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
         *        activities help drive Amazon Web Services assignment priority.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Initialized discussions with customer: Initial conversations with the customer to understand their
         *        needs and introduce your solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer has shown interest in solution: After initial discussions, the customer is interested in your
         *        solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
         *        customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In evaluation/planning stage: The customer is evaluating the solution and planning potential
         *        implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agreed on solution to Business Problem: Both parties agree on how the solution addresses the
         *        customer's business problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
         *        project scope and deliverables.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivities(Collection<SalesActivity> salesActivities);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These activities
         * help drive Amazon Web Services assignment priority.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Initialized discussions with customer: Initial conversations with the customer to understand their needs and
         * introduce your solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer has shown interest in solution: After initial discussions, the customer is interested in your
         * solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * In evaluation/planning stage: The customer is evaluating the solution and planning potential implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Agreed on solution to Business Problem: Both parties agree on how the solution addresses the customer's
         * business problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the project
         * scope and deliverables.
         * </p>
         * </li>
         * </ul>
         * 
         * @param salesActivities
         *        Specifies the <code>Opportunity</code>'s sales activities conducted with the end customer. These
         *        activities help drive Amazon Web Services assignment priority.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Initialized discussions with customer: Initial conversations with the customer to understand their
         *        needs and introduce your solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer has shown interest in solution: After initial discussions, the customer is interested in your
         *        solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Conducted POC/demo: You conducted a proof of concept (POC) or demonstration of the solution for the
         *        customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In evaluation/planning stage: The customer is evaluating the solution and planning potential
         *        implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agreed on solution to Business Problem: Both parties agree on how the solution addresses the
         *        customer's business problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed Action Plan: A detailed action plan is complete and outlines the steps for implementation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Finalized Deployment Need: Both parties agree with and finalized the deployment needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOW Signed: Both parties signed a statement of work (SOW), and formalize the agreement and detail the
         *        project scope and deliverables.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivities(SalesActivity... salesActivities);

        /**
         * <p>
         * Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not in
         * the picklist.
         * </p>
         * 
         * @param competitorName
         *        Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value
         *        not in the picklist.
         * @see CompetitorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompetitorName
         */
        Builder competitorName(String competitorName);

        /**
         * <p>
         * Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value not in
         * the picklist.
         * </p>
         * 
         * @param competitorName
         *        Name of the <code>Opportunity</code>'s competitor (if any). Use <code>Other</code> to submit a value
         *        not in the picklist.
         * @see CompetitorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompetitorName
         */
        Builder competitorName(CompetitorName competitorName);

        /**
         * <p>
         * Only allowed when <code>CompetitorNames</code> has <code>Other</code> selected.
         * </p>
         * 
         * @param otherCompetitorNames
         *        Only allowed when <code>CompetitorNames</code> has <code>Other</code> selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherCompetitorNames(String otherCompetitorNames);

        /**
         * <p>
         * Specifies the offered solution for the customer's business problem when the
         * <code> RelatedEntityIdentifiers.Solutions</code> field value is <code>Other</code>.
         * </p>
         * 
         * @param otherSolutionDescription
         *        Specifies the offered solution for the customer's business problem when the
         *        <code> RelatedEntityIdentifiers.Solutions</code> field value is <code>Other</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherSolutionDescription(String otherSolutionDescription);

        /**
         * <p>
         * Captures additional comments or information for the <code>Opportunity</code> that weren't captured in other
         * fields.
         * </p>
         * 
         * @param additionalComments
         *        Captures additional comments or information for the <code>Opportunity</code> that weren't captured in
         *        other fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalComments(String additionalComments);
    }

    static final class BuilderImpl implements Builder {
        private List<String> deliveryModels = DefaultSdkAutoConstructList.getInstance();

        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();

        private String title;

        private List<String> apnPrograms = DefaultSdkAutoConstructList.getInstance();

        private String customerBusinessProblem;

        private String customerUseCase;

        private String relatedOpportunityIdentifier;

        private List<String> salesActivities = DefaultSdkAutoConstructList.getInstance();

        private String competitorName;

        private String otherCompetitorNames;

        private String otherSolutionDescription;

        private String additionalComments;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            deliveryModelsWithStrings(model.deliveryModels);
            expectedCustomerSpend(model.expectedCustomerSpend);
            title(model.title);
            apnPrograms(model.apnPrograms);
            customerBusinessProblem(model.customerBusinessProblem);
            customerUseCase(model.customerUseCase);
            relatedOpportunityIdentifier(model.relatedOpportunityIdentifier);
            salesActivitiesWithStrings(model.salesActivities);
            competitorName(model.competitorName);
            otherCompetitorNames(model.otherCompetitorNames);
            otherSolutionDescription(model.otherSolutionDescription);
            additionalComments(model.additionalComments);
        }

        public final Collection<String> getDeliveryModels() {
            if (deliveryModels instanceof SdkAutoConstructList) {
                return null;
            }
            return deliveryModels;
        }

        public final void setDeliveryModels(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
        }

        @Override
        public final Builder deliveryModelsWithStrings(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModelsWithStrings(String... deliveryModels) {
            deliveryModelsWithStrings(Arrays.asList(deliveryModels));
            return this;
        }

        @Override
        public final Builder deliveryModels(Collection<DeliveryModel> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copyEnumToString(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModels(DeliveryModel... deliveryModels) {
            deliveryModels(Arrays.asList(deliveryModels));
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier
                    .copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend) {
            expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend) {
            expectedCustomerSpend(Stream.of(expectedCustomerSpend)
                    .map(c -> ExpectedCustomerSpend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getApnPrograms() {
            if (apnPrograms instanceof SdkAutoConstructList) {
                return null;
            }
            return apnPrograms;
        }

        public final void setApnPrograms(Collection<String> apnPrograms) {
            this.apnPrograms = ApnProgramsCopier.copy(apnPrograms);
        }

        @Override
        public final Builder apnPrograms(Collection<String> apnPrograms) {
            this.apnPrograms = ApnProgramsCopier.copy(apnPrograms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apnPrograms(String... apnPrograms) {
            apnPrograms(Arrays.asList(apnPrograms));
            return this;
        }

        public final String getCustomerBusinessProblem() {
            return customerBusinessProblem;
        }

        public final void setCustomerBusinessProblem(String customerBusinessProblem) {
            this.customerBusinessProblem = customerBusinessProblem;
        }

        @Override
        public final Builder customerBusinessProblem(String customerBusinessProblem) {
            this.customerBusinessProblem = customerBusinessProblem;
            return this;
        }

        public final String getCustomerUseCase() {
            return customerUseCase;
        }

        public final void setCustomerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
        }

        @Override
        public final Builder customerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
            return this;
        }

        public final String getRelatedOpportunityIdentifier() {
            return relatedOpportunityIdentifier;
        }

        public final void setRelatedOpportunityIdentifier(String relatedOpportunityIdentifier) {
            this.relatedOpportunityIdentifier = relatedOpportunityIdentifier;
        }

        @Override
        public final Builder relatedOpportunityIdentifier(String relatedOpportunityIdentifier) {
            this.relatedOpportunityIdentifier = relatedOpportunityIdentifier;
            return this;
        }

        public final Collection<String> getSalesActivities() {
            if (salesActivities instanceof SdkAutoConstructList) {
                return null;
            }
            return salesActivities;
        }

        public final void setSalesActivities(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
        }

        @Override
        public final Builder salesActivitiesWithStrings(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivitiesWithStrings(String... salesActivities) {
            salesActivitiesWithStrings(Arrays.asList(salesActivities));
            return this;
        }

        @Override
        public final Builder salesActivities(Collection<SalesActivity> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copyEnumToString(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivities(SalesActivity... salesActivities) {
            salesActivities(Arrays.asList(salesActivities));
            return this;
        }

        public final String getCompetitorName() {
            return competitorName;
        }

        public final void setCompetitorName(String competitorName) {
            this.competitorName = competitorName;
        }

        @Override
        public final Builder competitorName(String competitorName) {
            this.competitorName = competitorName;
            return this;
        }

        @Override
        public final Builder competitorName(CompetitorName competitorName) {
            this.competitorName(competitorName == null ? null : competitorName.toString());
            return this;
        }

        public final String getOtherCompetitorNames() {
            return otherCompetitorNames;
        }

        public final void setOtherCompetitorNames(String otherCompetitorNames) {
            this.otherCompetitorNames = otherCompetitorNames;
        }

        @Override
        public final Builder otherCompetitorNames(String otherCompetitorNames) {
            this.otherCompetitorNames = otherCompetitorNames;
            return this;
        }

        public final String getOtherSolutionDescription() {
            return otherSolutionDescription;
        }

        public final void setOtherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
        }

        @Override
        public final Builder otherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
            return this;
        }

        public final String getAdditionalComments() {
            return additionalComments;
        }

        public final void setAdditionalComments(String additionalComments) {
            this.additionalComments = additionalComments;
        }

        @Override
        public final Builder additionalComments(String additionalComments) {
            this.additionalComments = additionalComments;
            return this;
        }

        @Override
        public Project build() {
            return new Project(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
