/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the project associated with the Engagement Invitation, including the business problem and
 * expected outcomes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectDetails implements SdkPojo, Serializable, ToCopyableBuilder<ProjectDetails.Builder, ProjectDetails> {
    private static final SdkField<String> BUSINESS_PROBLEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessProblem").getter(getter(ProjectDetails::businessProblem))
            .setter(setter(Builder::businessProblem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessProblem").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ProjectDetails::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> TARGET_COMPLETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCompletionDate").getter(getter(ProjectDetails::targetCompletionDate))
            .setter(setter(Builder::targetCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCompletionDate").build())
            .build();

    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField
            .<List<ExpectedCustomerSpend>> builder(MarshallingType.LIST)
            .memberName("ExpectedCustomerSpend")
            .getter(getter(ProjectDetails::expectedCustomerSpend))
            .setter(setter(Builder::expectedCustomerSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedCustomerSpend> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedCustomerSpend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_PROBLEM_FIELD,
            TITLE_FIELD, TARGET_COMPLETION_DATE_FIELD, EXPECTED_CUSTOMER_SPEND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String businessProblem;

    private final String title;

    private final String targetCompletionDate;

    private final List<ExpectedCustomerSpend> expectedCustomerSpend;

    private ProjectDetails(BuilderImpl builder) {
        this.businessProblem = builder.businessProblem;
        this.title = builder.title;
        this.targetCompletionDate = builder.targetCompletionDate;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
    }

    /**
     * <p>
     * Describes the business problem that the project aims to solve. This information is crucial for understanding the
     * project’s goals and objectives.
     * </p>
     * 
     * @return Describes the business problem that the project aims to solve. This information is crucial for
     *         understanding the project’s goals and objectives.
     */
    public final String businessProblem() {
        return businessProblem;
    }

    /**
     * <p>
     * Specifies the title of the project. This title helps partners quickly identify and understand the focus of the
     * project.
     * </p>
     * 
     * @return Specifies the title of the project. This title helps partners quickly identify and understand the focus
     *         of the project.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Specifies the estimated date of project completion. This field helps track the project timeline and manage
     * expectations.
     * </p>
     * 
     * @return Specifies the estimated date of project completion. This field helps track the project timeline and
     *         manage expectations.
     */
    public final String targetCompletionDate() {
        return targetCompletionDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedCustomerSpend property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedCustomerSpend() {
        return expectedCustomerSpend != null && !(expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains revenue estimates for the partner related to the project. This field provides an idea of the financial
     * potential of the opportunity for the partner.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedCustomerSpend} method.
     * </p>
     * 
     * @return Contains revenue estimates for the partner related to the project. This field provides an idea of the
     *         financial potential of the opportunity for the partner.
     */
    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return expectedCustomerSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessProblem());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(targetCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedCustomerSpend() ? expectedCustomerSpend() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDetails)) {
            return false;
        }
        ProjectDetails other = (ProjectDetails) obj;
        return Objects.equals(businessProblem(), other.businessProblem()) && Objects.equals(title(), other.title())
                && Objects.equals(targetCompletionDate(), other.targetCompletionDate())
                && hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend()
                && Objects.equals(expectedCustomerSpend(), other.expectedCustomerSpend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectDetails")
                .add("BusinessProblem", businessProblem() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title()).add("TargetCompletionDate", targetCompletionDate())
                .add("ExpectedCustomerSpend", hasExpectedCustomerSpend() ? expectedCustomerSpend() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BusinessProblem":
            return Optional.ofNullable(clazz.cast(businessProblem()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "TargetCompletionDate":
            return Optional.ofNullable(clazz.cast(targetCompletionDate()));
        case "ExpectedCustomerSpend":
            return Optional.ofNullable(clazz.cast(expectedCustomerSpend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BusinessProblem", BUSINESS_PROBLEM_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("TargetCompletionDate", TARGET_COMPLETION_DATE_FIELD);
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectDetails, T> g) {
        return obj -> g.apply((ProjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectDetails> {
        /**
         * <p>
         * Describes the business problem that the project aims to solve. This information is crucial for understanding
         * the project’s goals and objectives.
         * </p>
         * 
         * @param businessProblem
         *        Describes the business problem that the project aims to solve. This information is crucial for
         *        understanding the project’s goals and objectives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessProblem(String businessProblem);

        /**
         * <p>
         * Specifies the title of the project. This title helps partners quickly identify and understand the focus of
         * the project.
         * </p>
         * 
         * @param title
         *        Specifies the title of the project. This title helps partners quickly identify and understand the
         *        focus of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Specifies the estimated date of project completion. This field helps track the project timeline and manage
         * expectations.
         * </p>
         * 
         * @param targetCompletionDate
         *        Specifies the estimated date of project completion. This field helps track the project timeline and
         *        manage expectations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCompletionDate(String targetCompletionDate);

        /**
         * <p>
         * Contains revenue estimates for the partner related to the project. This field provides an idea of the
         * financial potential of the opportunity for the partner.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Contains revenue estimates for the partner related to the project. This field provides an idea of the
         *        financial potential of the opportunity for the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend);

        /**
         * <p>
         * Contains revenue estimates for the partner related to the project. This field provides an idea of the
         * financial potential of the opportunity for the partner.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Contains revenue estimates for the partner related to the project. This field provides an idea of the
         *        financial potential of the opportunity for the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend);

        /**
         * <p>
         * Contains revenue estimates for the partner related to the project. This field provides an idea of the
         * financial potential of the opportunity for the partner.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder#build()} is
         * called immediately and its result is passed to {@link #expectedCustomerSpend(List<ExpectedCustomerSpend>)}.
         * 
         * @param expectedCustomerSpend
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedCustomerSpend(java.util.Collection<ExpectedCustomerSpend>)
         */
        Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend);
    }

    static final class BuilderImpl implements Builder {
        private String businessProblem;

        private String title;

        private String targetCompletionDate;

        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDetails model) {
            businessProblem(model.businessProblem);
            title(model.title);
            targetCompletionDate(model.targetCompletionDate);
            expectedCustomerSpend(model.expectedCustomerSpend);
        }

        public final String getBusinessProblem() {
            return businessProblem;
        }

        public final void setBusinessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
        }

        @Override
        public final Builder businessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getTargetCompletionDate() {
            return targetCompletionDate;
        }

        public final void setTargetCompletionDate(String targetCompletionDate) {
            this.targetCompletionDate = targetCompletionDate;
        }

        @Override
        public final Builder targetCompletionDate(String targetCompletionDate) {
            this.targetCompletionDate = targetCompletionDate;
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier
                    .copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend) {
            expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend) {
            expectedCustomerSpend(Stream.of(expectedCustomerSpend)
                    .map(c -> ExpectedCustomerSpend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProjectDetails build() {
            return new ProjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
