/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a <code>Project</code> object's subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProjectSummary.Builder, ProjectSummary> {
    private static final SdkField<List<String>> DELIVERY_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeliveryModels")
            .getter(getter(ProjectSummary::deliveryModelsAsStrings))
            .setter(setter(Builder::deliveryModelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField
            .<List<ExpectedCustomerSpend>> builder(MarshallingType.LIST)
            .memberName("ExpectedCustomerSpend")
            .getter(getter(ProjectSummary::expectedCustomerSpend))
            .setter(setter(Builder::expectedCustomerSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedCustomerSpend> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedCustomerSpend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODELS_FIELD,
            EXPECTED_CUSTOMER_SPEND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> deliveryModels;

    private final List<ExpectedCustomerSpend> expectedCustomerSpend;

    private ProjectSummary(BuilderImpl builder) {
        this.deliveryModels = builder.deliveryModels;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
    }

    /**
     * <p>
     * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s context.
     * You can select multiple options.
     * </p>
     * <p>
     * Options' descriptions from the <code>Delivery Model</code> field are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
     * Services environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting, design,
     * implementation, billing support, cost optimization, technical support).
     * </p>
     * </li>
     * <li>
     * <p>
     * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     * enterprise cloud adoption (For example: Advisory or transformation planning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Resell: Amazon Web Services accounts and billing management for your customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Delivery model not described above.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
     *         context. You can select multiple options.</p>
     *         <p>
     *         Options' descriptions from the <code>Delivery Model</code> field are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
     *         Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon
     *         Web Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
     *         design, implementation, billing support, cost optimization, technical support).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     *         enterprise cloud adoption (For example: Advisory or transformation planning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resell: Amazon Web Services accounts and billing management for your customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Delivery model not described above.
     *         </p>
     *         </li>
     */
    public final List<DeliveryModel> deliveryModels() {
        return DeliveryModelsCopier.copyStringToEnum(deliveryModels);
    }

    /**
     * For responses, this returns true if the service returned a value for the DeliveryModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeliveryModels() {
        return deliveryModels != null && !(deliveryModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s context.
     * You can select multiple options.
     * </p>
     * <p>
     * Options' descriptions from the <code>Delivery Model</code> field are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
     * Services environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting, design,
     * implementation, billing support, cost optimization, technical support).
     * </p>
     * </li>
     * <li>
     * <p>
     * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     * enterprise cloud adoption (For example: Advisory or transformation planning).
     * </p>
     * </li>
     * <li>
     * <p>
     * Resell: Amazon Web Services accounts and billing management for your customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Delivery model not described above.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
     *         context. You can select multiple options.</p>
     *         <p>
     *         Options' descriptions from the <code>Delivery Model</code> field are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
     *         Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon
     *         Web Services environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
     *         design, implementation, billing support, cost optimization, technical support).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
     *         enterprise cloud adoption (For example: Advisory or transformation planning).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resell: Amazon Web Services accounts and billing management for your customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Delivery model not described above.
     *         </p>
     *         </li>
     */
    public final List<String> deliveryModelsAsStrings() {
        return deliveryModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedCustomerSpend property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedCustomerSpend() {
        return expectedCustomerSpend != null && !(expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a summary of the expected customer spend for the project, offering a high-level view of the potential
     * financial impact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedCustomerSpend} method.
     * </p>
     * 
     * @return Provides a summary of the expected customer spend for the project, offering a high-level view of the
     *         potential financial impact.
     */
    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return expectedCustomerSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliveryModels() ? deliveryModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedCustomerSpend() ? expectedCustomerSpend() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSummary)) {
            return false;
        }
        ProjectSummary other = (ProjectSummary) obj;
        return hasDeliveryModels() == other.hasDeliveryModels()
                && Objects.equals(deliveryModelsAsStrings(), other.deliveryModelsAsStrings())
                && hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend()
                && Objects.equals(expectedCustomerSpend(), other.expectedCustomerSpend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectSummary").add("DeliveryModels", hasDeliveryModels() ? deliveryModelsAsStrings() : null)
                .add("ExpectedCustomerSpend", hasExpectedCustomerSpend() ? expectedCustomerSpend() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryModels":
            return Optional.ofNullable(clazz.cast(deliveryModelsAsStrings()));
        case "ExpectedCustomerSpend":
            return Optional.ofNullable(clazz.cast(expectedCustomerSpend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryModels", DELIVERY_MODELS_FIELD);
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectSummary, T> g) {
        return obj -> g.apply((ProjectSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectSummary> {
        /**
         * <p>
         * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         *        context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(Collection<String> deliveryModels);

        /**
         * <p>
         * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         *        context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(String... deliveryModels);

        /**
         * <p>
         * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         *        context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(Collection<DeliveryModel> deliveryModels);

        /**
         * <p>
         * Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         * context. You can select multiple options.
         * </p>
         * <p>
         * Options' descriptions from the <code>Delivery Model</code> field are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web Services
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's Amazon Web
         * Services environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         * design, implementation, billing support, cost optimization, technical support).
         * </p>
         * </li>
         * <li>
         * <p>
         * Professional Services: Offerings to help enterprise end customers achieve specific business outcomes for
         * enterprise cloud adoption (For example: Advisory or transformation planning).
         * </p>
         * </li>
         * <li>
         * <p>
         * Resell: Amazon Web Services accounts and billing management for your customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Delivery model not described above.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryModels
         *        Specifies your solution or service's deployment or consumption model in the <code>Opportunity</code>'s
         *        context. You can select multiple options.</p>
         *        <p>
         *        Options' descriptions from the <code>Delivery Model</code> field are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or PaaS in your Amazon Web
         *        Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or AMI in the end customer's
         *        Amazon Web Services environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Managed Services: The end customer's Amazon Web Services business management (For example: Consulting,
         *        design, implementation, billing support, cost optimization, technical support).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Professional Services: Offerings to help enterprise end customers achieve specific business outcomes
         *        for enterprise cloud adoption (For example: Advisory or transformation planning).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resell: Amazon Web Services accounts and billing management for your customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Delivery model not described above.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(DeliveryModel... deliveryModels);

        /**
         * <p>
         * Provides a summary of the expected customer spend for the project, offering a high-level view of the
         * potential financial impact.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Provides a summary of the expected customer spend for the project, offering a high-level view of the
         *        potential financial impact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend);

        /**
         * <p>
         * Provides a summary of the expected customer spend for the project, offering a high-level view of the
         * potential financial impact.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Provides a summary of the expected customer spend for the project, offering a high-level view of the
         *        potential financial impact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend);

        /**
         * <p>
         * Provides a summary of the expected customer spend for the project, offering a high-level view of the
         * potential financial impact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder#build()} is
         * called immediately and its result is passed to {@link #expectedCustomerSpend(List<ExpectedCustomerSpend>)}.
         * 
         * @param expectedCustomerSpend
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedCustomerSpend(java.util.Collection<ExpectedCustomerSpend>)
         */
        Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend);
    }

    static final class BuilderImpl implements Builder {
        private List<String> deliveryModels = DefaultSdkAutoConstructList.getInstance();

        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSummary model) {
            deliveryModelsWithStrings(model.deliveryModels);
            expectedCustomerSpend(model.expectedCustomerSpend);
        }

        public final Collection<String> getDeliveryModels() {
            if (deliveryModels instanceof SdkAutoConstructList) {
                return null;
            }
            return deliveryModels;
        }

        public final void setDeliveryModels(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
        }

        @Override
        public final Builder deliveryModelsWithStrings(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModelsWithStrings(String... deliveryModels) {
            deliveryModelsWithStrings(Arrays.asList(deliveryModels));
            return this;
        }

        @Override
        public final Builder deliveryModels(Collection<DeliveryModel> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copyEnumToString(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModels(DeliveryModel... deliveryModels) {
            deliveryModels(Arrays.asList(deliveryModels));
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier
                    .copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend) {
            expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend) {
            expectedCustomerSpend(Stream.of(expectedCustomerSpend)
                    .map(c -> ExpectedCustomerSpend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProjectSummary build() {
            return new ProjectSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
