/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the project view of an opportunity resource shared through a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectView implements SdkPojo, Serializable, ToCopyableBuilder<ProjectView.Builder, ProjectView> {
    private static final SdkField<List<String>> DELIVERY_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeliveryModels")
            .getter(getter(ProjectView::deliveryModelsAsStrings))
            .setter(setter(Builder::deliveryModelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField
            .<List<ExpectedCustomerSpend>> builder(MarshallingType.LIST)
            .memberName("ExpectedCustomerSpend")
            .getter(getter(ProjectView::expectedCustomerSpend))
            .setter(setter(Builder::expectedCustomerSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedCustomerSpend> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedCustomerSpend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerUseCase").getter(getter(ProjectView::customerUseCase)).setter(setter(Builder::customerUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUseCase").build()).build();

    private static final SdkField<List<String>> SALES_ACTIVITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SalesActivities")
            .getter(getter(ProjectView::salesActivitiesAsStrings))
            .setter(setter(Builder::salesActivitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesActivities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OTHER_SOLUTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherSolutionDescription").getter(getter(ProjectView::otherSolutionDescription))
            .setter(setter(Builder::otherSolutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherSolutionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODELS_FIELD,
            EXPECTED_CUSTOMER_SPEND_FIELD, CUSTOMER_USE_CASE_FIELD, SALES_ACTIVITIES_FIELD, OTHER_SOLUTION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> deliveryModels;

    private final List<ExpectedCustomerSpend> expectedCustomerSpend;

    private final String customerUseCase;

    private final List<String> salesActivities;

    private final String otherSolutionDescription;

    private ProjectView(BuilderImpl builder) {
        this.deliveryModels = builder.deliveryModels;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
        this.customerUseCase = builder.customerUseCase;
        this.salesActivities = builder.salesActivities;
        this.otherSolutionDescription = builder.otherSolutionDescription;
    }

    /**
     * <p>
     * Describes the deployment or consumption model for the partner solution or offering. This field indicates how the
     * project's solution will be delivered or implemented for the customer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Describes the deployment or consumption model for the partner solution or offering. This field indicates
     *         how the project's solution will be delivered or implemented for the customer.
     */
    public final List<DeliveryModel> deliveryModels() {
        return DeliveryModelsCopier.copyStringToEnum(deliveryModels);
    }

    /**
     * For responses, this returns true if the service returned a value for the DeliveryModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeliveryModels() {
        return deliveryModels != null && !(deliveryModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the deployment or consumption model for the partner solution or offering. This field indicates how the
     * project's solution will be delivered or implemented for the customer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryModels} method.
     * </p>
     * 
     * @return Describes the deployment or consumption model for the partner solution or offering. This field indicates
     *         how the project's solution will be delivered or implemented for the customer.
     */
    public final List<String> deliveryModelsAsStrings() {
        return deliveryModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedCustomerSpend property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedCustomerSpend() {
        return expectedCustomerSpend != null && !(expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the anticipated customer spend related to this project. This may include details such
     * as amount, frequency, and currency of expected expenditure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedCustomerSpend} method.
     * </p>
     * 
     * @return Provides information about the anticipated customer spend related to this project. This may include
     *         details such as amount, frequency, and currency of expected expenditure.
     */
    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return expectedCustomerSpend;
    }

    /**
     * <p>
     * Specifies the proposed solution focus or type of workload for the project.
     * </p>
     * 
     * @return Specifies the proposed solution focus or type of workload for the project.
     */
    public final String customerUseCase() {
        return customerUseCase;
    }

    /**
     * <p>
     * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This field is
     * conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment priority on the AWS
     * side. It provides insight into the engagement level with the customer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSalesActivities} method.
     * </p>
     * 
     * @return Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
     *         field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
     *         priority on the AWS side. It provides insight into the engagement level with the customer.
     */
    public final List<SalesActivity> salesActivities() {
        return SalesActivitiesCopier.copyStringToEnum(salesActivities);
    }

    /**
     * For responses, this returns true if the service returned a value for the SalesActivities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSalesActivities() {
        return salesActivities != null && !(salesActivities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This field is
     * conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment priority on the AWS
     * side. It provides insight into the engagement level with the customer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSalesActivities} method.
     * </p>
     * 
     * @return Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
     *         field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
     *         priority on the AWS side. It provides insight into the engagement level with the customer.
     */
    public final List<String> salesActivitiesAsStrings() {
        return salesActivities;
    }

    /**
     * <p>
     * Offers a description of other solutions if the standard solutions do not adequately cover the project's scope.
     * </p>
     * 
     * @return Offers a description of other solutions if the standard solutions do not adequately cover the project's
     *         scope.
     */
    public final String otherSolutionDescription() {
        return otherSolutionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliveryModels() ? deliveryModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedCustomerSpend() ? expectedCustomerSpend() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(hasSalesActivities() ? salesActivitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(otherSolutionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectView)) {
            return false;
        }
        ProjectView other = (ProjectView) obj;
        return hasDeliveryModels() == other.hasDeliveryModels()
                && Objects.equals(deliveryModelsAsStrings(), other.deliveryModelsAsStrings())
                && hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend()
                && Objects.equals(expectedCustomerSpend(), other.expectedCustomerSpend())
                && Objects.equals(customerUseCase(), other.customerUseCase())
                && hasSalesActivities() == other.hasSalesActivities()
                && Objects.equals(salesActivitiesAsStrings(), other.salesActivitiesAsStrings())
                && Objects.equals(otherSolutionDescription(), other.otherSolutionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectView").add("DeliveryModels", hasDeliveryModels() ? deliveryModelsAsStrings() : null)
                .add("ExpectedCustomerSpend", hasExpectedCustomerSpend() ? expectedCustomerSpend() : null)
                .add("CustomerUseCase", customerUseCase())
                .add("SalesActivities", hasSalesActivities() ? salesActivitiesAsStrings() : null)
                .add("OtherSolutionDescription", otherSolutionDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryModels":
            return Optional.ofNullable(clazz.cast(deliveryModelsAsStrings()));
        case "ExpectedCustomerSpend":
            return Optional.ofNullable(clazz.cast(expectedCustomerSpend()));
        case "CustomerUseCase":
            return Optional.ofNullable(clazz.cast(customerUseCase()));
        case "SalesActivities":
            return Optional.ofNullable(clazz.cast(salesActivitiesAsStrings()));
        case "OtherSolutionDescription":
            return Optional.ofNullable(clazz.cast(otherSolutionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryModels", DELIVERY_MODELS_FIELD);
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        map.put("CustomerUseCase", CUSTOMER_USE_CASE_FIELD);
        map.put("SalesActivities", SALES_ACTIVITIES_FIELD);
        map.put("OtherSolutionDescription", OTHER_SOLUTION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectView, T> g) {
        return obj -> g.apply((ProjectView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectView> {
        /**
         * <p>
         * Describes the deployment or consumption model for the partner solution or offering. This field indicates how
         * the project's solution will be delivered or implemented for the customer.
         * </p>
         * 
         * @param deliveryModels
         *        Describes the deployment or consumption model for the partner solution or offering. This field
         *        indicates how the project's solution will be delivered or implemented for the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(Collection<String> deliveryModels);

        /**
         * <p>
         * Describes the deployment or consumption model for the partner solution or offering. This field indicates how
         * the project's solution will be delivered or implemented for the customer.
         * </p>
         * 
         * @param deliveryModels
         *        Describes the deployment or consumption model for the partner solution or offering. This field
         *        indicates how the project's solution will be delivered or implemented for the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModelsWithStrings(String... deliveryModels);

        /**
         * <p>
         * Describes the deployment or consumption model for the partner solution or offering. This field indicates how
         * the project's solution will be delivered or implemented for the customer.
         * </p>
         * 
         * @param deliveryModels
         *        Describes the deployment or consumption model for the partner solution or offering. This field
         *        indicates how the project's solution will be delivered or implemented for the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(Collection<DeliveryModel> deliveryModels);

        /**
         * <p>
         * Describes the deployment or consumption model for the partner solution or offering. This field indicates how
         * the project's solution will be delivered or implemented for the customer.
         * </p>
         * 
         * @param deliveryModels
         *        Describes the deployment or consumption model for the partner solution or offering. This field
         *        indicates how the project's solution will be delivered or implemented for the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryModels(DeliveryModel... deliveryModels);

        /**
         * <p>
         * Provides information about the anticipated customer spend related to this project. This may include details
         * such as amount, frequency, and currency of expected expenditure.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Provides information about the anticipated customer spend related to this project. This may include
         *        details such as amount, frequency, and currency of expected expenditure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend);

        /**
         * <p>
         * Provides information about the anticipated customer spend related to this project. This may include details
         * such as amount, frequency, and currency of expected expenditure.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Provides information about the anticipated customer spend related to this project. This may include
         *        details such as amount, frequency, and currency of expected expenditure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend);

        /**
         * <p>
         * Provides information about the anticipated customer spend related to this project. This may include details
         * such as amount, frequency, and currency of expected expenditure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder#build()} is
         * called immediately and its result is passed to {@link #expectedCustomerSpend(List<ExpectedCustomerSpend>)}.
         * 
         * @param expectedCustomerSpend
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedCustomerSpend(java.util.Collection<ExpectedCustomerSpend>)
         */
        Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend);

        /**
         * <p>
         * Specifies the proposed solution focus or type of workload for the project.
         * </p>
         * 
         * @param customerUseCase
         *        Specifies the proposed solution focus or type of workload for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerUseCase(String customerUseCase);

        /**
         * <p>
         * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
         * field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
         * priority on the AWS side. It provides insight into the engagement level with the customer.
         * </p>
         * 
         * @param salesActivities
         *        Lists the pre-sales activities that have occurred with the end-customer related to the opportunity.
         *        This field is conditionally mandatory when the project is qualified for Co-Sell and helps drive
         *        assignment priority on the AWS side. It provides insight into the engagement level with the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivitiesWithStrings(Collection<String> salesActivities);

        /**
         * <p>
         * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
         * field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
         * priority on the AWS side. It provides insight into the engagement level with the customer.
         * </p>
         * 
         * @param salesActivities
         *        Lists the pre-sales activities that have occurred with the end-customer related to the opportunity.
         *        This field is conditionally mandatory when the project is qualified for Co-Sell and helps drive
         *        assignment priority on the AWS side. It provides insight into the engagement level with the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivitiesWithStrings(String... salesActivities);

        /**
         * <p>
         * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
         * field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
         * priority on the AWS side. It provides insight into the engagement level with the customer.
         * </p>
         * 
         * @param salesActivities
         *        Lists the pre-sales activities that have occurred with the end-customer related to the opportunity.
         *        This field is conditionally mandatory when the project is qualified for Co-Sell and helps drive
         *        assignment priority on the AWS side. It provides insight into the engagement level with the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivities(Collection<SalesActivity> salesActivities);

        /**
         * <p>
         * Lists the pre-sales activities that have occurred with the end-customer related to the opportunity. This
         * field is conditionally mandatory when the project is qualified for Co-Sell and helps drive assignment
         * priority on the AWS side. It provides insight into the engagement level with the customer.
         * </p>
         * 
         * @param salesActivities
         *        Lists the pre-sales activities that have occurred with the end-customer related to the opportunity.
         *        This field is conditionally mandatory when the project is qualified for Co-Sell and helps drive
         *        assignment priority on the AWS side. It provides insight into the engagement level with the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesActivities(SalesActivity... salesActivities);

        /**
         * <p>
         * Offers a description of other solutions if the standard solutions do not adequately cover the project's
         * scope.
         * </p>
         * 
         * @param otherSolutionDescription
         *        Offers a description of other solutions if the standard solutions do not adequately cover the
         *        project's scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherSolutionDescription(String otherSolutionDescription);
    }

    static final class BuilderImpl implements Builder {
        private List<String> deliveryModels = DefaultSdkAutoConstructList.getInstance();

        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();

        private String customerUseCase;

        private List<String> salesActivities = DefaultSdkAutoConstructList.getInstance();

        private String otherSolutionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectView model) {
            deliveryModelsWithStrings(model.deliveryModels);
            expectedCustomerSpend(model.expectedCustomerSpend);
            customerUseCase(model.customerUseCase);
            salesActivitiesWithStrings(model.salesActivities);
            otherSolutionDescription(model.otherSolutionDescription);
        }

        public final Collection<String> getDeliveryModels() {
            if (deliveryModels instanceof SdkAutoConstructList) {
                return null;
            }
            return deliveryModels;
        }

        public final void setDeliveryModels(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
        }

        @Override
        public final Builder deliveryModelsWithStrings(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModelsWithStrings(String... deliveryModels) {
            deliveryModelsWithStrings(Arrays.asList(deliveryModels));
            return this;
        }

        @Override
        public final Builder deliveryModels(Collection<DeliveryModel> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copyEnumToString(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModels(DeliveryModel... deliveryModels) {
            deliveryModels(Arrays.asList(deliveryModels));
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier
                    .copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend) {
            expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend) {
            expectedCustomerSpend(Stream.of(expectedCustomerSpend)
                    .map(c -> ExpectedCustomerSpend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCustomerUseCase() {
            return customerUseCase;
        }

        public final void setCustomerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
        }

        @Override
        public final Builder customerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
            return this;
        }

        public final Collection<String> getSalesActivities() {
            if (salesActivities instanceof SdkAutoConstructList) {
                return null;
            }
            return salesActivities;
        }

        public final void setSalesActivities(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
        }

        @Override
        public final Builder salesActivitiesWithStrings(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivitiesWithStrings(String... salesActivities) {
            salesActivitiesWithStrings(Arrays.asList(salesActivities));
            return this;
        }

        @Override
        public final Builder salesActivities(Collection<SalesActivity> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copyEnumToString(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivities(SalesActivity... salesActivities) {
            salesActivities(Arrays.asList(salesActivities));
            return this;
        }

        public final String getOtherSolutionDescription() {
            return otherSolutionDescription;
        }

        public final void setOtherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
        }

        @Override
        public final Builder otherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
            return this;
        }

        @Override
        public ProjectView build() {
            return new ProjectView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
