/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ReasonCode {
    INVITATION_ACCESS_DENIED("InvitationAccessDenied"),

    INVITATION_VALIDATION_FAILED("InvitationValidationFailed"),

    ENGAGEMENT_ACCESS_DENIED("EngagementAccessDenied"),

    OPPORTUNITY_ACCESS_DENIED("OpportunityAccessDenied"),

    RESOURCE_SNAPSHOT_JOB_ACCESS_DENIED("ResourceSnapshotJobAccessDenied"),

    RESOURCE_SNAPSHOT_JOB_VALIDATION_FAILED("ResourceSnapshotJobValidationFailed"),

    RESOURCE_SNAPSHOT_JOB_CONFLICT("ResourceSnapshotJobConflict"),

    ENGAGEMENT_VALIDATION_FAILED("EngagementValidationFailed"),

    ENGAGEMENT_CONFLICT("EngagementConflict"),

    OPPORTUNITY_SUBMISSION_FAILED("OpportunitySubmissionFailed"),

    ENGAGEMENT_INVITATION_CONFLICT("EngagementInvitationConflict"),

    INTERNAL_ERROR("InternalError"),

    OPPORTUNITY_VALIDATION_FAILED("OpportunityValidationFailed"),

    OPPORTUNITY_CONFLICT("OpportunityConflict"),

    RESOURCE_SNAPSHOT_ACCESS_DENIED("ResourceSnapshotAccessDenied"),

    RESOURCE_SNAPSHOT_VALIDATION_FAILED("ResourceSnapshotValidationFailed"),

    RESOURCE_SNAPSHOT_CONFLICT("ResourceSnapshotConflict"),

    SERVICE_QUOTA_EXCEEDED("ServiceQuotaExceeded"),

    REQUEST_THROTTLED("RequestThrottled"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReasonCode> VALUE_MAP = EnumUtils.uniqueIndex(ReasonCode.class, ReasonCode::toString);

    private final String value;

    private ReasonCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ReasonCode corresponding to the value
     */
    public static ReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ReasonCode}s
     */
    public static Set<ReasonCode> knownValues() {
        Set<ReasonCode> knownValues = EnumSet.allOf(ReasonCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
