/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectEngagementInvitationRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<RejectEngagementInvitationRequest.Builder, RejectEngagementInvitationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(RejectEngagementInvitationRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(RejectEngagementInvitationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RejectionReason").getter(getter(RejectEngagementInvitationRequest::rejectionReason))
            .setter(setter(Builder::rejectionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectionReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            IDENTIFIER_FIELD, REJECTION_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String identifier;

    private final String rejectionReason;

    private RejectEngagementInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.identifier = builder.identifier;
        this.rejectionReason = builder.rejectionReason;
    }

    /**
     * <p>
     * This is the catalog that's associated with the engagement invitation. Acceptable values are <code>AWS</code> or
     * <code>Sandbox</code>, and these values determine the environment in which the opportunity is managed.
     * </p>
     * 
     * @return This is the catalog that's associated with the engagement invitation. Acceptable values are
     *         <code>AWS</code> or <code>Sandbox</code>, and these values determine the environment in which the
     *         opportunity is managed.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * This is the unique identifier of the rejected <code>EngagementInvitation</code>. Providing the correct identifier
     * helps to ensure that the intended invitation is rejected.
     * </p>
     * 
     * @return This is the unique identifier of the rejected <code>EngagementInvitation</code>. Providing the correct
     *         identifier helps to ensure that the intended invitation is rejected.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * This describes the reason for rejecting the engagement invitation, which helps AWS track usage patterns.
     * Acceptable values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Customer problem unclear:</i> The customer's problem isn't understood.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Next steps unclear:</i> The next steps required to proceed aren't understood.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Unable to support:</i> The partner is unable to provide support due to resource or capability constraints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Duplicate of partner referral:</i> The opportunity is a duplicate of an existing referral.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Other:</i> Any reason not covered by other values.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This describes the reason for rejecting the engagement invitation, which helps AWS track usage patterns.
     *         Acceptable values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Customer problem unclear:</i> The customer's problem isn't understood.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Next steps unclear:</i> The next steps required to proceed aren't understood.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Unable to support:</i> The partner is unable to provide support due to resource or capability
     *         constraints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Duplicate of partner referral:</i> The opportunity is a duplicate of an existing referral.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Other:</i> Any reason not covered by other values.
     *         </p>
     *         </li>
     */
    public final String rejectionReason() {
        return rejectionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectEngagementInvitationRequest)) {
            return false;
        }
        RejectEngagementInvitationRequest other = (RejectEngagementInvitationRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(rejectionReason(), other.rejectionReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectEngagementInvitationRequest").add("Catalog", catalog()).add("Identifier", identifier())
                .add("RejectionReason", rejectionReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "RejectionReason":
            return Optional.ofNullable(clazz.cast(rejectionReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("RejectionReason", REJECTION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectEngagementInvitationRequest, T> g) {
        return obj -> g.apply((RejectEngagementInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RejectEngagementInvitationRequest> {
        /**
         * <p>
         * This is the catalog that's associated with the engagement invitation. Acceptable values are <code>AWS</code>
         * or <code>Sandbox</code>, and these values determine the environment in which the opportunity is managed.
         * </p>
         * 
         * @param catalog
         *        This is the catalog that's associated with the engagement invitation. Acceptable values are
         *        <code>AWS</code> or <code>Sandbox</code>, and these values determine the environment in which the
         *        opportunity is managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * This is the unique identifier of the rejected <code>EngagementInvitation</code>. Providing the correct
         * identifier helps to ensure that the intended invitation is rejected.
         * </p>
         * 
         * @param identifier
         *        This is the unique identifier of the rejected <code>EngagementInvitation</code>. Providing the correct
         *        identifier helps to ensure that the intended invitation is rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * This describes the reason for rejecting the engagement invitation, which helps AWS track usage patterns.
         * Acceptable values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Customer problem unclear:</i> The customer's problem isn't understood.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Next steps unclear:</i> The next steps required to proceed aren't understood.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Unable to support:</i> The partner is unable to provide support due to resource or capability constraints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Duplicate of partner referral:</i> The opportunity is a duplicate of an existing referral.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Other:</i> Any reason not covered by other values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rejectionReason
         *        This describes the reason for rejecting the engagement invitation, which helps AWS track usage
         *        patterns. Acceptable values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Customer problem unclear:</i> The customer's problem isn't understood.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Next steps unclear:</i> The next steps required to proceed aren't understood.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Unable to support:</i> The partner is unable to provide support due to resource or capability
         *        constraints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Duplicate of partner referral:</i> The opportunity is a duplicate of an existing referral.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Other:</i> Any reason not covered by other values.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionReason(String rejectionReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String identifier;

        private String rejectionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectEngagementInvitationRequest model) {
            super(model);
            catalog(model.catalog);
            identifier(model.identifier);
            rejectionReason(model.rejectionReason);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRejectionReason() {
            return rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectEngagementInvitationRequest build() {
            return new RejectEngagementInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
