/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the payload of a resource snapshot. This structure is designed to accommodate different types of resource
 * snapshots, currently supporting opportunity summaries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSnapshotPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSnapshotPayload.Builder, ResourceSnapshotPayload> {
    private static final SdkField<OpportunitySummaryView> OPPORTUNITY_SUMMARY_FIELD = SdkField
            .<OpportunitySummaryView> builder(MarshallingType.SDK_POJO).memberName("OpportunitySummary")
            .getter(getter(ResourceSnapshotPayload::opportunitySummary)).setter(setter(Builder::opportunitySummary))
            .constructor(OpportunitySummaryView::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunitySummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPPORTUNITY_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpportunitySummaryView opportunitySummary;

    private final Type type;

    private ResourceSnapshotPayload(BuilderImpl builder) {
        this.opportunitySummary = builder.opportunitySummary;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that contains an <code>opportunity</code>'s subset of fields.
     * </p>
     * 
     * @return An object that contains an <code>opportunity</code>'s subset of fields.
     */
    public final OpportunitySummaryView opportunitySummary() {
        return opportunitySummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opportunitySummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSnapshotPayload)) {
            return false;
        }
        ResourceSnapshotPayload other = (ResourceSnapshotPayload) obj;
        return Objects.equals(opportunitySummary(), other.opportunitySummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSnapshotPayload").add("OpportunitySummary", opportunitySummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpportunitySummary":
            return Optional.ofNullable(clazz.cast(opportunitySummary()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #opportunitySummary()} initialized to the given value.
     *
     * <p>
     * An object that contains an <code>opportunity</code>'s subset of fields.
     * </p>
     * 
     * @param opportunitySummary
     *        An object that contains an <code>opportunity</code>'s subset of fields.
     */
    public static ResourceSnapshotPayload fromOpportunitySummary(OpportunitySummaryView opportunitySummary) {
        return builder().opportunitySummary(opportunitySummary).build();
    }

    /**
     * Create an instance of this class with {@link #opportunitySummary()} initialized to the given value.
     *
     * <p>
     * An object that contains an <code>opportunity</code>'s subset of fields.
     * </p>
     * 
     * @param opportunitySummary
     *        An object that contains an <code>opportunity</code>'s subset of fields.
     */
    public static ResourceSnapshotPayload fromOpportunitySummary(Consumer<OpportunitySummaryView.Builder> opportunitySummary) {
        OpportunitySummaryView.Builder builder = OpportunitySummaryView.builder();
        opportunitySummary.accept(builder);
        return fromOpportunitySummary(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpportunitySummary", OPPORTUNITY_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSnapshotPayload, T> g) {
        return obj -> g.apply((ResourceSnapshotPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSnapshotPayload> {
        /**
         * <p>
         * An object that contains an <code>opportunity</code>'s subset of fields.
         * </p>
         * 
         * @param opportunitySummary
         *        An object that contains an <code>opportunity</code>'s subset of fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunitySummary(OpportunitySummaryView opportunitySummary);

        /**
         * <p>
         * An object that contains an <code>opportunity</code>'s subset of fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpportunitySummaryView.Builder} avoiding
         * the need to create one manually via {@link OpportunitySummaryView#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpportunitySummaryView.Builder#build()} is called immediately and
         * its result is passed to {@link #opportunitySummary(OpportunitySummaryView)}.
         * 
         * @param opportunitySummary
         *        a consumer that will call methods on {@link OpportunitySummaryView.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opportunitySummary(OpportunitySummaryView)
         */
        default Builder opportunitySummary(Consumer<OpportunitySummaryView.Builder> opportunitySummary) {
            return opportunitySummary(OpportunitySummaryView.builder().applyMutation(opportunitySummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpportunitySummaryView opportunitySummary;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSnapshotPayload model) {
            opportunitySummary(model.opportunitySummary);
        }

        public final OpportunitySummaryView.Builder getOpportunitySummary() {
            return opportunitySummary != null ? opportunitySummary.toBuilder() : null;
        }

        public final void setOpportunitySummary(OpportunitySummaryView.BuilderImpl opportunitySummary) {
            Object oldValue = this.opportunitySummary;
            this.opportunitySummary = opportunitySummary != null ? opportunitySummary.build() : null;
            handleUnionValueChange(Type.OPPORTUNITY_SUMMARY, oldValue, this.opportunitySummary);
        }

        @Override
        public final Builder opportunitySummary(OpportunitySummaryView opportunitySummary) {
            Object oldValue = this.opportunitySummary;
            this.opportunitySummary = opportunitySummary;
            handleUnionValueChange(Type.OPPORTUNITY_SUMMARY, oldValue, this.opportunitySummary);
            return this;
        }

        @Override
        public ResourceSnapshotPayload build() {
            return new ResourceSnapshotPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceSnapshotPayload#type()
     */
    public enum Type {
        OPPORTUNITY_SUMMARY,

        UNKNOWN_TO_SDK_VERSION
    }
}
