/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies minimal information for the solution offered to solve the customer's business problem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionBase implements SdkPojo, Serializable, ToCopyableBuilder<SolutionBase.Builder, SolutionBase> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(SolutionBase::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SolutionBase::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(SolutionBase::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SolutionBase::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SolutionBase::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(SolutionBase::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(SolutionBase::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ID_FIELD,
            ARN_FIELD, NAME_FIELD, STATUS_FIELD, CATEGORY_FIELD, CREATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalog;

    private final String id;

    private final String arn;

    private final String name;

    private final String status;

    private final String category;

    private final Instant createdDate;

    private SolutionBase(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.category = builder.category;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * Specifies the catalog in which the solution is hosted, either <code>AWS</code> or <code>Sandbox</code>. This
     * helps partners differentiate between live solutions and those in testing environments.
     * </p>
     * 
     * @return Specifies the catalog in which the solution is hosted, either <code>AWS</code> or <code>Sandbox</code>.
     *         This helps partners differentiate between live solutions and those in testing environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Enables the association of solutions (offerings) to opportunities.
     * </p>
     * 
     * @return Enables the association of solutions (offerings) to opportunities.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The SolutionBase structure provides essential information about a solution.
     * </p>
     * 
     * @return The SolutionBase structure provides essential information about a solution.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the solution name.
     * </p>
     * 
     * @return Specifies the solution name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the solution's current status, which indicates its state in the system. Valid values:
     * <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon Web
     * Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions for
     * association to an opportunity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SolutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the solution's current status, which indicates its state in the system. Valid values:
     *         <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon
     *         Web Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions
     *         for association to an opportunity.
     * @see SolutionStatus
     */
    public final SolutionStatus status() {
        return SolutionStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the solution's current status, which indicates its state in the system. Valid values:
     * <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon Web
     * Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions for
     * association to an opportunity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SolutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the solution's current status, which indicates its state in the system. Valid values:
     *         <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon
     *         Web Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions
     *         for association to an opportunity.
     * @see SolutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the solution category, which helps to categorize and organize the solutions partners offer. Valid
     * values: <code>Software Product</code> | <code>Consulting Service</code> | <code>Hardware Product</code> |
     * <code>Communications Product</code> | <code>Professional Service</code> | <code>Managed Service</code> |
     * <code>Value-Added Resale Amazon Web Services Service</code> | <code>Distribution Service</code> |
     * <code>Training Service</code> | <code>Merger and Acquisition Advising Service</code>.
     * </p>
     * 
     * @return Specifies the solution category, which helps to categorize and organize the solutions partners offer.
     *         Valid values: <code>Software Product</code> | <code>Consulting Service</code> |
     *         <code>Hardware Product</code> | <code>Communications Product</code> | <code>Professional Service</code> |
     *         <code>Managed Service</code> | <code>Value-Added Resale Amazon Web Services Service</code> |
     *         <code>Distribution Service</code> | <code>Training Service</code> |
     *         <code>Merger and Acquisition Advising Service</code>.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * Indicates the solution creation date. This is useful to track and audit.
     * </p>
     * 
     * @return Indicates the solution creation date. This is useful to track and audit.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionBase)) {
            return false;
        }
        SolutionBase other = (SolutionBase) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(id(), other.id())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(category(), other.category())
                && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SolutionBase").add("Catalog", catalog()).add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Status", statusAsString()).add("Category", category()).add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SolutionBase, T> g) {
        return obj -> g.apply((SolutionBase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionBase> {
        /**
         * <p>
         * Specifies the catalog in which the solution is hosted, either <code>AWS</code> or <code>Sandbox</code>. This
         * helps partners differentiate between live solutions and those in testing environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the solution is hosted, either <code>AWS</code> or <code>Sandbox</code>
         *        . This helps partners differentiate between live solutions and those in testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Enables the association of solutions (offerings) to opportunities.
         * </p>
         * 
         * @param id
         *        Enables the association of solutions (offerings) to opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The SolutionBase structure provides essential information about a solution.
         * </p>
         * 
         * @param arn
         *        The SolutionBase structure provides essential information about a solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the solution name.
         * </p>
         * 
         * @param name
         *        Specifies the solution name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the solution's current status, which indicates its state in the system. Valid values:
         * <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon Web
         * Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions for
         * association to an opportunity.
         * </p>
         * 
         * @param status
         *        Specifies the solution's current status, which indicates its state in the system. Valid values:
         *        <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon
         *        Web Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions
         *        for association to an opportunity.
         * @see SolutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SolutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the solution's current status, which indicates its state in the system. Valid values:
         * <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon Web
         * Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions for
         * association to an opportunity.
         * </p>
         * 
         * @param status
         *        Specifies the solution's current status, which indicates its state in the system. Valid values:
         *        <code>Active</code> | <code>Inactive</code> | <code>Draft</code>. The status helps partners and Amazon
         *        Web Services track the solution's lifecycle and availability. Filter for <code>Active</code> solutions
         *        for association to an opportunity.
         * @see SolutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SolutionStatus
         */
        Builder status(SolutionStatus status);

        /**
         * <p>
         * Specifies the solution category, which helps to categorize and organize the solutions partners offer. Valid
         * values: <code>Software Product</code> | <code>Consulting Service</code> | <code>Hardware Product</code> |
         * <code>Communications Product</code> | <code>Professional Service</code> | <code>Managed Service</code> |
         * <code>Value-Added Resale Amazon Web Services Service</code> | <code>Distribution Service</code> |
         * <code>Training Service</code> | <code>Merger and Acquisition Advising Service</code>.
         * </p>
         * 
         * @param category
         *        Specifies the solution category, which helps to categorize and organize the solutions partners offer.
         *        Valid values: <code>Software Product</code> | <code>Consulting Service</code> |
         *        <code>Hardware Product</code> | <code>Communications Product</code> |
         *        <code>Professional Service</code> | <code>Managed Service</code> |
         *        <code>Value-Added Resale Amazon Web Services Service</code> | <code>Distribution Service</code> |
         *        <code>Training Service</code> | <code>Merger and Acquisition Advising Service</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * Indicates the solution creation date. This is useful to track and audit.
         * </p>
         * 
         * @param createdDate
         *        Indicates the solution creation date. This is useful to track and audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String catalog;

        private String id;

        private String arn;

        private String name;

        private String status;

        private String category;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionBase model) {
            catalog(model.catalog);
            id(model.id);
            arn(model.arn);
            name(model.name);
            status(model.status);
            category(model.category);
            createdDate(model.createdDate);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SolutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public SolutionBase build() {
            return new SolutionBase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
