/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEngagementByAcceptingInvitationTaskResponse extends PartnerCentralSellingResponse
        implements
        ToCopyableBuilder<StartEngagementByAcceptingInvitationTaskResponse.Builder, StartEngagementByAcceptingInvitationTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(StartEngagementByAcceptingInvitationTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(StartEngagementByAcceptingInvitationTaskResponse::taskArn))
            .setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(StartEngagementByAcceptingInvitationTaskResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskStatus").getter(getter(StartEngagementByAcceptingInvitationTaskResponse::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(StartEngagementByAcceptingInvitationTaskResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReasonCode").getter(getter(StartEngagementByAcceptingInvitationTaskResponse::reasonCodeAsString))
            .setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()).build();

    private static final SdkField<String> OPPORTUNITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityId").getter(getter(StartEngagementByAcceptingInvitationTaskResponse::opportunityId))
            .setter(setter(Builder::opportunityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityId").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotJobId")
            .getter(getter(StartEngagementByAcceptingInvitationTaskResponse::resourceSnapshotJobId))
            .setter(setter(Builder::resourceSnapshotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobId").build())
            .build();

    private static final SdkField<String> ENGAGEMENT_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementInvitationId")
            .getter(getter(StartEngagementByAcceptingInvitationTaskResponse::engagementInvitationId))
            .setter(setter(Builder::engagementInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementInvitationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD,
            START_TIME_FIELD, TASK_STATUS_FIELD, MESSAGE_FIELD, REASON_CODE_FIELD, OPPORTUNITY_ID_FIELD,
            RESOURCE_SNAPSHOT_JOB_ID_FIELD, ENGAGEMENT_INVITATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskId;

    private final String taskArn;

    private final Instant startTime;

    private final String taskStatus;

    private final String message;

    private final String reasonCode;

    private final String opportunityId;

    private final String resourceSnapshotJobId;

    private final String engagementInvitationId;

    private StartEngagementByAcceptingInvitationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.startTime = builder.startTime;
        this.taskStatus = builder.taskStatus;
        this.message = builder.message;
        this.reasonCode = builder.reasonCode;
        this.opportunityId = builder.opportunityId;
        this.resourceSnapshotJobId = builder.resourceSnapshotJobId;
        this.engagementInvitationId = builder.engagementInvitationId;
    }

    /**
     * <p>
     * The unique identifier of the task, used to track the task’s progress.
     * </p>
     * 
     * @return The unique identifier of the task, used to track the task’s progress.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task, used for tracking and managing the task within AWS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task, used for tracking and managing the task within AWS.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The timestamp indicating when the task was initiated. The format follows RFC 3339 section 5.6.
     * </p>
     * 
     * @return The timestamp indicating when the task was initiated. The format follows RFC 3339 section 5.6.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Indicates the current status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the task.
     * @see TaskStatus
     */
    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Indicates the current status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the task.
     * @see TaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * If the task fails, this field contains a detailed message describing the failure and possible recovery steps.
     * </p>
     * 
     * @return If the task fails, this field contains a detailed message describing the failure and possible recovery
     *         steps.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Indicates the reason for task failure using an enumerated code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link ReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return Indicates the reason for task failure using an enumerated code.
     * @see ReasonCode
     */
    public final ReasonCode reasonCode() {
        return ReasonCode.fromValue(reasonCode);
    }

    /**
     * <p>
     * Indicates the reason for task failure using an enumerated code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link ReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return Indicates the reason for task failure using an enumerated code.
     * @see ReasonCode
     */
    public final String reasonCodeAsString() {
        return reasonCode;
    }

    /**
     * <p>
     * Returns the original opportunity identifier passed in the request. This is the unique identifier for the
     * opportunity.
     * </p>
     * 
     * @return Returns the original opportunity identifier passed in the request. This is the unique identifier for the
     *         opportunity.
     */
    public final String opportunityId() {
        return opportunityId;
    }

    /**
     * <p>
     * The identifier of the Resource Snapshot Job created as part of this task.
     * </p>
     * 
     * @return The identifier of the Resource Snapshot Job created as part of this task.
     */
    public final String resourceSnapshotJobId() {
        return resourceSnapshotJobId;
    }

    /**
     * <p>
     * Returns the identifier of the engagement invitation that was accepted and used to create the opportunity.
     * </p>
     * 
     * @return Returns the identifier of the engagement invitation that was accepted and used to create the opportunity.
     */
    public final String engagementInvitationId() {
        return engagementInvitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(opportunityId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(engagementInvitationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementByAcceptingInvitationTaskResponse)) {
            return false;
        }
        StartEngagementByAcceptingInvitationTaskResponse other = (StartEngagementByAcceptingInvitationTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(reasonCodeAsString(), other.reasonCodeAsString())
                && Objects.equals(opportunityId(), other.opportunityId())
                && Objects.equals(resourceSnapshotJobId(), other.resourceSnapshotJobId())
                && Objects.equals(engagementInvitationId(), other.engagementInvitationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEngagementByAcceptingInvitationTaskResponse").add("TaskId", taskId())
                .add("TaskArn", taskArn()).add("StartTime", startTime()).add("TaskStatus", taskStatusAsString())
                .add("Message", message()).add("ReasonCode", reasonCodeAsString()).add("OpportunityId", opportunityId())
                .add("ResourceSnapshotJobId", resourceSnapshotJobId()).add("EngagementInvitationId", engagementInvitationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "TaskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ReasonCode":
            return Optional.ofNullable(clazz.cast(reasonCodeAsString()));
        case "OpportunityId":
            return Optional.ofNullable(clazz.cast(opportunityId()));
        case "ResourceSnapshotJobId":
            return Optional.ofNullable(clazz.cast(resourceSnapshotJobId()));
        case "EngagementInvitationId":
            return Optional.ofNullable(clazz.cast(engagementInvitationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TaskStatus", TASK_STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ReasonCode", REASON_CODE_FIELD);
        map.put("OpportunityId", OPPORTUNITY_ID_FIELD);
        map.put("ResourceSnapshotJobId", RESOURCE_SNAPSHOT_JOB_ID_FIELD);
        map.put("EngagementInvitationId", ENGAGEMENT_INVITATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementByAcceptingInvitationTaskResponse, T> g) {
        return obj -> g.apply((StartEngagementByAcceptingInvitationTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEngagementByAcceptingInvitationTaskResponse> {
        /**
         * <p>
         * The unique identifier of the task, used to track the task’s progress.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task, used to track the task’s progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task, used for tracking and managing the task within AWS.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task, used for tracking and managing the task within AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The timestamp indicating when the task was initiated. The format follows RFC 3339 section 5.6.
         * </p>
         * 
         * @param startTime
         *        The timestamp indicating when the task was initiated. The format follows RFC 3339 section 5.6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Indicates the current status of the task.
         * </p>
         * 
         * @param taskStatus
         *        Indicates the current status of the task.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Indicates the current status of the task.
         * </p>
         * 
         * @param taskStatus
         *        Indicates the current status of the task.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(TaskStatus taskStatus);

        /**
         * <p>
         * If the task fails, this field contains a detailed message describing the failure and possible recovery steps.
         * </p>
         * 
         * @param message
         *        If the task fails, this field contains a detailed message describing the failure and possible recovery
         *        steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Indicates the reason for task failure using an enumerated code.
         * </p>
         * 
         * @param reasonCode
         *        Indicates the reason for task failure using an enumerated code.
         * @see ReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReasonCode
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * Indicates the reason for task failure using an enumerated code.
         * </p>
         * 
         * @param reasonCode
         *        Indicates the reason for task failure using an enumerated code.
         * @see ReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReasonCode
         */
        Builder reasonCode(ReasonCode reasonCode);

        /**
         * <p>
         * Returns the original opportunity identifier passed in the request. This is the unique identifier for the
         * opportunity.
         * </p>
         * 
         * @param opportunityId
         *        Returns the original opportunity identifier passed in the request. This is the unique identifier for
         *        the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityId(String opportunityId);

        /**
         * <p>
         * The identifier of the Resource Snapshot Job created as part of this task.
         * </p>
         * 
         * @param resourceSnapshotJobId
         *        The identifier of the Resource Snapshot Job created as part of this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobId(String resourceSnapshotJobId);

        /**
         * <p>
         * Returns the identifier of the engagement invitation that was accepted and used to create the opportunity.
         * </p>
         * 
         * @param engagementInvitationId
         *        Returns the identifier of the engagement invitation that was accepted and used to create the
         *        opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementInvitationId(String engagementInvitationId);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String taskId;

        private String taskArn;

        private Instant startTime;

        private String taskStatus;

        private String message;

        private String reasonCode;

        private String opportunityId;

        private String resourceSnapshotJobId;

        private String engagementInvitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementByAcceptingInvitationTaskResponse model) {
            super(model);
            taskId(model.taskId);
            taskArn(model.taskArn);
            startTime(model.startTime);
            taskStatus(model.taskStatus);
            message(model.message);
            reasonCode(model.reasonCode);
            opportunityId(model.opportunityId);
            resourceSnapshotJobId(model.resourceSnapshotJobId);
            engagementInvitationId(model.engagementInvitationId);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(ReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final String getOpportunityId() {
            return opportunityId;
        }

        public final void setOpportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
        }

        @Override
        public final Builder opportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
            return this;
        }

        public final String getResourceSnapshotJobId() {
            return resourceSnapshotJobId;
        }

        public final void setResourceSnapshotJobId(String resourceSnapshotJobId) {
            this.resourceSnapshotJobId = resourceSnapshotJobId;
        }

        @Override
        public final Builder resourceSnapshotJobId(String resourceSnapshotJobId) {
            this.resourceSnapshotJobId = resourceSnapshotJobId;
            return this;
        }

        public final String getEngagementInvitationId() {
            return engagementInvitationId;
        }

        public final void setEngagementInvitationId(String engagementInvitationId) {
            this.engagementInvitationId = engagementInvitationId;
        }

        @Override
        public final Builder engagementInvitationId(String engagementInvitationId) {
            this.engagementInvitationId = engagementInvitationId;
            return this;
        }

        @Override
        public StartEngagementByAcceptingInvitationTaskResponse build() {
            return new StartEngagementByAcceptingInvitationTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
