/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitOpportunityRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<SubmitOpportunityRequest.Builder, SubmitOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(SubmitOpportunityRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(SubmitOpportunityRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> INVOLVEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvolvementType").getter(getter(SubmitOpportunityRequest::involvementTypeAsString))
            .setter(setter(Builder::involvementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementType").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(SubmitOpportunityRequest::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            IDENTIFIER_FIELD, INVOLVEMENT_TYPE_FIELD, VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String identifier;

    private final String involvementType;

    private final String visibility;

    private SubmitOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.identifier = builder.identifier;
        this.involvementType = builder.involvementType;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * Specifies the catalog related to the request. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS: Submits the opportunity request from the production AWS environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sandbox: Submits the opportunity request from a sandbox environment used for testing or development purposes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the catalog related to the request. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AWS: Submits the opportunity request from the production AWS environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sandbox: Submits the opportunity request from a sandbox environment used for testing or development
     *         purposes.
     *         </p>
     *         </li>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The identifier of the Opportunity previously created by partner and needs to be submitted.
     * </p>
     * 
     * @return The identifier of the Opportunity previously created by partner and needs to be submitted.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Specifies the level of AWS sellers' involvement on the opportunity. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to receive
     * deal assistance and support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share this
     * opportunity with AWS for visibility only, you will not receive deal assistance and support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the level of AWS sellers' involvement on the opportunity. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to
     *         receive deal assistance and support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share
     *         this opportunity with AWS for visibility only, you will not receive deal assistance and support.
     *         </p>
     *         </li>
     * @see SalesInvolvementType
     */
    public final SalesInvolvementType involvementType() {
        return SalesInvolvementType.fromValue(involvementType);
    }

    /**
     * <p>
     * Specifies the level of AWS sellers' involvement on the opportunity. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to receive
     * deal assistance and support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share this
     * opportunity with AWS for visibility only, you will not receive deal assistance and support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the level of AWS sellers' involvement on the opportunity. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to
     *         receive deal assistance and support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share
     *         this opportunity with AWS for visibility only, you will not receive deal assistance and support.
     *         </p>
     *         </li>
     * @see SalesInvolvementType
     */
    public final String involvementTypeAsString() {
        return involvementType;
    }

    /**
     * <p>
     * Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Full</code>: The opportunity is fully visible to AWS sales.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Full</code>: The opportunity is fully visible to AWS sales.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Full</code>: The opportunity is fully visible to AWS sales.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Full</code>: The opportunity is fully visible to AWS sales.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(involvementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitOpportunityRequest)) {
            return false;
        }
        SubmitOpportunityRequest other = (SubmitOpportunityRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(involvementTypeAsString(), other.involvementTypeAsString())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitOpportunityRequest").add("Catalog", catalog()).add("Identifier", identifier())
                .add("InvolvementType", involvementTypeAsString()).add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "InvolvementType":
            return Optional.ofNullable(clazz.cast(involvementTypeAsString()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("InvolvementType", INVOLVEMENT_TYPE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitOpportunityRequest, T> g) {
        return obj -> g.apply((SubmitOpportunityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SubmitOpportunityRequest> {
        /**
         * <p>
         * Specifies the catalog related to the request. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AWS: Submits the opportunity request from the production AWS environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Sandbox: Submits the opportunity request from a sandbox environment used for testing or development purposes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param catalog
         *        Specifies the catalog related to the request. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AWS: Submits the opportunity request from the production AWS environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sandbox: Submits the opportunity request from a sandbox environment used for testing or development
         *        purposes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The identifier of the Opportunity previously created by partner and needs to be submitted.
         * </p>
         * 
         * @param identifier
         *        The identifier of the Opportunity previously created by partner and needs to be submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies the level of AWS sellers' involvement on the opportunity. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to receive
         * deal assistance and support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share
         * this opportunity with AWS for visibility only, you will not receive deal assistance and support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param involvementType
         *        Specifies the level of AWS sellers' involvement on the opportunity. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to
         *        receive deal assistance and support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep.
         *        Share this opportunity with AWS for visibility only, you will not receive deal assistance and support.
         *        </p>
         *        </li>
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(String involvementType);

        /**
         * <p>
         * Specifies the level of AWS sellers' involvement on the opportunity. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to receive
         * deal assistance and support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep. Share
         * this opportunity with AWS for visibility only, you will not receive deal assistance and support.
         * </p>
         * </li>
         * </ul>
         * 
         * @param involvementType
         *        Specifies the level of AWS sellers' involvement on the opportunity. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Co-sell</code>: Indicates the user wants to co-sell with AWS. Share the opportunity with AWS to
         *        receive deal assistance and support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>For Visibility Only</code>: Indicates that the user does not need support from AWS Sales Rep.
         *        Share this opportunity with AWS for visibility only, you will not receive deal assistance and support.
         *        </p>
         *        </li>
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(SalesInvolvementType involvementType);

        /**
         * <p>
         * Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Full</code>: The opportunity is fully visible to AWS sales.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full.
         *        Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Full</code>: The opportunity is fully visible to AWS sales.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full. Valid
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Full</code>: The opportunity is fully visible to AWS sales.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        Determines whether to restrict visibility of the opportunity from AWS sales. Default value is Full.
         *        Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Full</code>: The opportunity is fully visible to AWS sales.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Limited</code>: The opportunity has restricted visibility to AWS sales.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String identifier;

        private String involvementType;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitOpportunityRequest model) {
            super(model);
            catalog(model.catalog);
            identifier(model.identifier);
            involvementType(model.involvementType);
            visibility(model.visibility);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getInvolvementType() {
            return involvementType;
        }

        public final void setInvolvementType(String involvementType) {
            this.involvementType = involvementType;
        }

        @Override
        public final Builder involvementType(String involvementType) {
            this.involvementType = involvementType;
            return this;
        }

        @Override
        public final Builder involvementType(SalesInvolvementType involvementType) {
            this.involvementType(involvementType == null ? null : involvementType.toString());
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitOpportunityRequest build() {
            return new SubmitOpportunityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
