/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.Contact;
import software.amazon.awssdk.services.partnercentralselling.model.Customer;
import software.amazon.awssdk.services.partnercentralselling.model.LifeCycle;
import software.amazon.awssdk.services.partnercentralselling.model.Marketing;
import software.amazon.awssdk.services.partnercentralselling.model.NationalSecurity;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityOrigin;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityType;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerOpportunityTeamMembersListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedFromAws;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedsFromAwsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.Project;
import software.amazon.awssdk.services.partnercentralselling.model.SoftwareRevenue;
import software.amazon.awssdk.services.partnercentralselling.model.Tag;
import software.amazon.awssdk.services.partnercentralselling.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOpportunityRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, CreateOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::catalog)).setter(CreateOpportunityRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> PRIMARY_NEEDS_FROM_AWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryNeedsFromAws").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::primaryNeedsFromAwsAsStrings)).setter(CreateOpportunityRequest.setter(Builder::primaryNeedsFromAwsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNeedsFromAws").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NATIONAL_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NationalSecurity").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::nationalSecurityAsString)).setter(CreateOpportunityRequest.setter(Builder::nationalSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NationalSecurity").build()}).build();
    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerOpportunityIdentifier").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::partnerOpportunityIdentifier)).setter(CreateOpportunityRequest.setter(Builder::partnerOpportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier").build()}).build();
    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::customer)).setter(CreateOpportunityRequest.setter(Builder::customer)).constructor(Customer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<Project> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::project)).setter(CreateOpportunityRequest.setter(Builder::project)).constructor(Project::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityType").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::opportunityTypeAsString)).setter(CreateOpportunityRequest.setter(Builder::opportunityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()}).build();
    private static final SdkField<Marketing> MARKETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Marketing").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::marketing)).setter(CreateOpportunityRequest.setter(Builder::marketing)).constructor(Marketing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketing").build()}).build();
    private static final SdkField<SoftwareRevenue> SOFTWARE_REVENUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareRevenue").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::softwareRevenue)).setter(CreateOpportunityRequest.setter(Builder::softwareRevenue)).constructor(SoftwareRevenue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareRevenue").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::clientToken)).setter(CreateOpportunityRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycle").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::lifeCycle)).setter(CreateOpportunityRequest.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::originAsString)).setter(CreateOpportunityRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<List<Contact>> OPPORTUNITY_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityTeam").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::opportunityTeam)).setter(CreateOpportunityRequest.setter(Builder::opportunityTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateOpportunityRequest.getter(CreateOpportunityRequest::tags)).setter(CreateOpportunityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, PRIMARY_NEEDS_FROM_AWS_FIELD, NATIONAL_SECURITY_FIELD, PARTNER_OPPORTUNITY_IDENTIFIER_FIELD, CUSTOMER_FIELD, PROJECT_FIELD, OPPORTUNITY_TYPE_FIELD, MARKETING_FIELD, SOFTWARE_REVENUE_FIELD, CLIENT_TOKEN_FIELD, LIFE_CYCLE_FIELD, ORIGIN_FIELD, OPPORTUNITY_TEAM_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOpportunityRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> primaryNeedsFromAws;
    private final String nationalSecurity;
    private final String partnerOpportunityIdentifier;
    private final Customer customer;
    private final Project project;
    private final String opportunityType;
    private final Marketing marketing;
    private final SoftwareRevenue softwareRevenue;
    private final String clientToken;
    private final LifeCycle lifeCycle;
    private final String origin;
    private final List<Contact> opportunityTeam;
    private final List<Tag> tags;

    private CreateOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.primaryNeedsFromAws = builder.primaryNeedsFromAws;
        this.nationalSecurity = builder.nationalSecurity;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
        this.customer = builder.customer;
        this.project = builder.project;
        this.opportunityType = builder.opportunityType;
        this.marketing = builder.marketing;
        this.softwareRevenue = builder.softwareRevenue;
        this.clientToken = builder.clientToken;
        this.lifeCycle = builder.lifeCycle;
        this.origin = builder.origin;
        this.opportunityTeam = builder.opportunityTeam;
        this.tags = builder.tags;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final List<PrimaryNeedFromAws> primaryNeedsFromAws() {
        return PrimaryNeedsFromAwsCopier.copyStringToEnum(this.primaryNeedsFromAws);
    }

    public final boolean hasPrimaryNeedsFromAws() {
        return this.primaryNeedsFromAws != null && !(this.primaryNeedsFromAws instanceof SdkAutoConstructList);
    }

    public final List<String> primaryNeedsFromAwsAsStrings() {
        return this.primaryNeedsFromAws;
    }

    public final NationalSecurity nationalSecurity() {
        return NationalSecurity.fromValue(this.nationalSecurity);
    }

    public final String nationalSecurityAsString() {
        return this.nationalSecurity;
    }

    public final String partnerOpportunityIdentifier() {
        return this.partnerOpportunityIdentifier;
    }

    public final Customer customer() {
        return this.customer;
    }

    public final Project project() {
        return this.project;
    }

    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(this.opportunityType);
    }

    public final String opportunityTypeAsString() {
        return this.opportunityType;
    }

    public final Marketing marketing() {
        return this.marketing;
    }

    public final SoftwareRevenue softwareRevenue() {
        return this.softwareRevenue;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final OpportunityOrigin origin() {
        return OpportunityOrigin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final boolean hasOpportunityTeam() {
        return this.opportunityTeam != null && !(this.opportunityTeam instanceof SdkAutoConstructList);
    }

    public final List<Contact> opportunityTeam() {
        return this.opportunityTeam;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nationalSecurityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketing());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareRevenue());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityTeam() ? this.opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpportunityRequest)) {
            return false;
        }
        CreateOpportunityRequest other = (CreateOpportunityRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasPrimaryNeedsFromAws() == other.hasPrimaryNeedsFromAws() && Objects.equals(this.primaryNeedsFromAwsAsStrings(), other.primaryNeedsFromAwsAsStrings()) && Objects.equals(this.nationalSecurityAsString(), other.nationalSecurityAsString()) && Objects.equals(this.partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier()) && Objects.equals(this.customer(), other.customer()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.opportunityTypeAsString(), other.opportunityTypeAsString()) && Objects.equals(this.marketing(), other.marketing()) && Objects.equals(this.softwareRevenue(), other.softwareRevenue()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.originAsString(), other.originAsString()) && this.hasOpportunityTeam() == other.hasOpportunityTeam() && Objects.equals(this.opportunityTeam(), other.opportunityTeam()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOpportunityRequest").add("Catalog", (Object)this.catalog()).add("PrimaryNeedsFromAws", this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null).add("NationalSecurity", (Object)this.nationalSecurityAsString()).add("PartnerOpportunityIdentifier", (Object)this.partnerOpportunityIdentifier()).add("Customer", (Object)this.customer()).add("Project", (Object)this.project()).add("OpportunityType", (Object)this.opportunityTypeAsString()).add("Marketing", (Object)this.marketing()).add("SoftwareRevenue", (Object)this.softwareRevenue()).add("ClientToken", (Object)this.clientToken()).add("LifeCycle", (Object)this.lifeCycle()).add("Origin", (Object)this.originAsString()).add("OpportunityTeam", this.hasOpportunityTeam() ? this.opportunityTeam() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "PrimaryNeedsFromAws": {
                return Optional.ofNullable(clazz.cast(this.primaryNeedsFromAwsAsStrings()));
            }
            case "NationalSecurity": {
                return Optional.ofNullable(clazz.cast(this.nationalSecurityAsString()));
            }
            case "PartnerOpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.partnerOpportunityIdentifier()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "OpportunityType": {
                return Optional.ofNullable(clazz.cast(this.opportunityTypeAsString()));
            }
            case "Marketing": {
                return Optional.ofNullable(clazz.cast(this.marketing()));
            }
            case "SoftwareRevenue": {
                return Optional.ofNullable(clazz.cast(this.softwareRevenue()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "OpportunityTeam": {
                return Optional.ofNullable(clazz.cast(this.opportunityTeam()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("PrimaryNeedsFromAws", PRIMARY_NEEDS_FROM_AWS_FIELD);
        map.put("NationalSecurity", NATIONAL_SECURITY_FIELD);
        map.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("Marketing", MARKETING_FIELD);
        map.put("SoftwareRevenue", SOFTWARE_REVENUE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOpportunityRequest, T> g) {
        return obj -> g.apply((CreateOpportunityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> primaryNeedsFromAws = DefaultSdkAutoConstructList.getInstance();
        private String nationalSecurity;
        private String partnerOpportunityIdentifier;
        private Customer customer;
        private Project project;
        private String opportunityType;
        private Marketing marketing;
        private SoftwareRevenue softwareRevenue;
        private String clientToken;
        private LifeCycle lifeCycle;
        private String origin;
        private List<Contact> opportunityTeam = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpportunityRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.primaryNeedsFromAwsWithStrings(model.primaryNeedsFromAws);
            this.nationalSecurity(model.nationalSecurity);
            this.partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
            this.customer(model.customer);
            this.project(model.project);
            this.opportunityType(model.opportunityType);
            this.marketing(model.marketing);
            this.softwareRevenue(model.softwareRevenue);
            this.clientToken(model.clientToken);
            this.lifeCycle(model.lifeCycle);
            this.origin(model.origin);
            this.opportunityTeam(model.opportunityTeam);
            this.tags(model.tags);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getPrimaryNeedsFromAws() {
            if (this.primaryNeedsFromAws instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryNeedsFromAws;
        }

        public final void setPrimaryNeedsFromAws(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
        }

        @Override
        public final Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAwsWithStrings(String ... primaryNeedsFromAws) {
            this.primaryNeedsFromAwsWithStrings(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        @Override
        public final Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copyEnumToString(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAws(PrimaryNeedFromAws ... primaryNeedsFromAws) {
            this.primaryNeedsFromAws(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        public final String getNationalSecurity() {
            return this.nationalSecurity;
        }

        public final void setNationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
        }

        @Override
        public final Builder nationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
            return this;
        }

        @Override
        public final Builder nationalSecurity(NationalSecurity nationalSecurity) {
            this.nationalSecurity(nationalSecurity == null ? null : nationalSecurity.toString());
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return this.partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        public final Customer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final Project.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final String getOpportunityType() {
            return this.opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final Marketing.Builder getMarketing() {
            return this.marketing != null ? this.marketing.toBuilder() : null;
        }

        public final void setMarketing(Marketing.BuilderImpl marketing) {
            this.marketing = marketing != null ? marketing.build() : null;
        }

        @Override
        public final Builder marketing(Marketing marketing) {
            this.marketing = marketing;
            return this;
        }

        public final SoftwareRevenue.Builder getSoftwareRevenue() {
            return this.softwareRevenue != null ? this.softwareRevenue.toBuilder() : null;
        }

        public final void setSoftwareRevenue(SoftwareRevenue.BuilderImpl softwareRevenue) {
            this.softwareRevenue = softwareRevenue != null ? softwareRevenue.build() : null;
        }

        @Override
        public final Builder softwareRevenue(SoftwareRevenue softwareRevenue) {
            this.softwareRevenue = softwareRevenue;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OpportunityOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final List<Contact.Builder> getOpportunityTeam() {
            List<Contact.Builder> result = PartnerOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<Contact.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<Contact> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Contact ... opportunityTeam) {
            this.opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<Contact.Builder> ... opportunityTeam) {
            this.opportunityTeam(Stream.of(opportunityTeam).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOpportunityRequest build() {
            return new CreateOpportunityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOpportunityRequest> {
        public Builder catalog(String var1);

        public Builder primaryNeedsFromAwsWithStrings(Collection<String> var1);

        public Builder primaryNeedsFromAwsWithStrings(String ... var1);

        public Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> var1);

        public Builder primaryNeedsFromAws(PrimaryNeedFromAws ... var1);

        public Builder nationalSecurity(String var1);

        public Builder nationalSecurity(NationalSecurity var1);

        public Builder partnerOpportunityIdentifier(String var1);

        public Builder customer(Customer var1);

        default public Builder customer(Consumer<Customer.Builder> customer) {
            return this.customer((Customer)((Customer.Builder)Customer.builder().applyMutation(customer)).build());
        }

        public Builder project(Project var1);

        default public Builder project(Consumer<Project.Builder> project) {
            return this.project((Project)((Project.Builder)Project.builder().applyMutation(project)).build());
        }

        public Builder opportunityType(String var1);

        public Builder opportunityType(OpportunityType var1);

        public Builder marketing(Marketing var1);

        default public Builder marketing(Consumer<Marketing.Builder> marketing) {
            return this.marketing((Marketing)((Marketing.Builder)Marketing.builder().applyMutation(marketing)).build());
        }

        public Builder softwareRevenue(SoftwareRevenue var1);

        default public Builder softwareRevenue(Consumer<SoftwareRevenue.Builder> softwareRevenue) {
            return this.softwareRevenue((SoftwareRevenue)((SoftwareRevenue.Builder)SoftwareRevenue.builder().applyMutation(softwareRevenue)).build());
        }

        public Builder clientToken(String var1);

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder origin(String var1);

        public Builder origin(OpportunityOrigin var1);

        public Builder opportunityTeam(Collection<Contact> var1);

        public Builder opportunityTeam(Contact ... var1);

        public Builder opportunityTeam(Consumer<Contact.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

