/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersForImportResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<GetParametersForImportResponse.Builder, GetParametersForImportResponse> {
    private static final SdkField<String> IMPORT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportToken").getter(getter(GetParametersForImportResponse::importToken))
            .setter(setter(Builder::importToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportToken").build()).build();

    private static final SdkField<Instant> PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ParametersValidUntilTimestamp")
            .getter(getter(GetParametersForImportResponse::parametersValidUntilTimestamp))
            .setter(setter(Builder::parametersValidUntilTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersValidUntilTimestamp")
                    .build()).build();

    private static final SdkField<String> WRAPPING_KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyAlgorithm").getter(getter(GetParametersForImportResponse::wrappingKeyAlgorithmAsString))
            .setter(setter(Builder::wrappingKeyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyAlgorithm").build())
            .build();

    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyCertificate").getter(getter(GetParametersForImportResponse::wrappingKeyCertificate))
            .setter(setter(Builder::wrappingKeyCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificate").build())
            .build();

    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_CHAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyCertificateChain")
            .getter(getter(GetParametersForImportResponse::wrappingKeyCertificateChain))
            .setter(setter(Builder::wrappingKeyCertificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificateChain")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TOKEN_FIELD,
            PARAMETERS_VALID_UNTIL_TIMESTAMP_FIELD, WRAPPING_KEY_ALGORITHM_FIELD, WRAPPING_KEY_CERTIFICATE_FIELD,
            WRAPPING_KEY_CERTIFICATE_CHAIN_FIELD));

    private final String importToken;

    private final Instant parametersValidUntilTimestamp;

    private final String wrappingKeyAlgorithm;

    private final String wrappingKeyCertificate;

    private final String wrappingKeyCertificateChain;

    private GetParametersForImportResponse(BuilderImpl builder) {
        super(builder);
        this.importToken = builder.importToken;
        this.parametersValidUntilTimestamp = builder.parametersValidUntilTimestamp;
        this.wrappingKeyAlgorithm = builder.wrappingKeyAlgorithm;
        this.wrappingKeyCertificate = builder.wrappingKeyCertificate;
        this.wrappingKeyCertificateChain = builder.wrappingKeyCertificateChain;
    }

    /**
     * <p>
     * The import token to initiate key import into Amazon Web Services Payment Cryptography. The import token expires
     * after 7 days. You can use the same import token to import multiple keys to the same service account.
     * </p>
     * 
     * @return The import token to initiate key import into Amazon Web Services Payment Cryptography. The import token
     *         expires after 7 days. You can use the same import token to import multiple keys to the same service
     *         account.
     */
    public final String importToken() {
        return importToken;
    }

    /**
     * <p>
     * The validity period of the import token.
     * </p>
     * 
     * @return The validity period of the import token.
     */
    public final Instant parametersValidUntilTimestamp() {
        return parametersValidUntilTimestamp;
    }

    /**
     * <p>
     * The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #wrappingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
     * @see KeyAlgorithm
     */
    public final KeyAlgorithm wrappingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(wrappingKeyAlgorithm);
    }

    /**
     * <p>
     * The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #wrappingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
     * @see KeyAlgorithm
     */
    public final String wrappingKeyAlgorithmAsString() {
        return wrappingKeyAlgorithm;
    }

    /**
     * <p>
     * The wrapping key certificate in PEM format (base64 encoded) of the wrapping key for use within the TR-34 key
     * block. The certificate expires in 7 days.
     * </p>
     * 
     * @return The wrapping key certificate in PEM format (base64 encoded) of the wrapping key for use within the TR-34
     *         key block. The certificate expires in 7 days.
     */
    public final String wrappingKeyCertificate() {
        return wrappingKeyCertificate;
    }

    /**
     * <p>
     * The Amazon Web Services Payment Cryptography root certificate authority (CA) that signed the wrapping key
     * certificate in PEM format (base64 encoded).
     * </p>
     * 
     * @return The Amazon Web Services Payment Cryptography root certificate authority (CA) that signed the wrapping key
     *         certificate in PEM format (base64 encoded).
     */
    public final String wrappingKeyCertificateChain() {
        return wrappingKeyCertificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importToken());
        hashCode = 31 * hashCode + Objects.hashCode(parametersValidUntilTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyCertificateChain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportResponse)) {
            return false;
        }
        GetParametersForImportResponse other = (GetParametersForImportResponse) obj;
        return Objects.equals(importToken(), other.importToken())
                && Objects.equals(parametersValidUntilTimestamp(), other.parametersValidUntilTimestamp())
                && Objects.equals(wrappingKeyAlgorithmAsString(), other.wrappingKeyAlgorithmAsString())
                && Objects.equals(wrappingKeyCertificate(), other.wrappingKeyCertificate())
                && Objects.equals(wrappingKeyCertificateChain(), other.wrappingKeyCertificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetParametersForImportResponse")
                .add("ImportToken", importToken())
                .add("ParametersValidUntilTimestamp", parametersValidUntilTimestamp())
                .add("WrappingKeyAlgorithm", wrappingKeyAlgorithmAsString())
                .add("WrappingKeyCertificate", wrappingKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WrappingKeyCertificateChain",
                        wrappingKeyCertificateChain() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportToken":
            return Optional.ofNullable(clazz.cast(importToken()));
        case "ParametersValidUntilTimestamp":
            return Optional.ofNullable(clazz.cast(parametersValidUntilTimestamp()));
        case "WrappingKeyAlgorithm":
            return Optional.ofNullable(clazz.cast(wrappingKeyAlgorithmAsString()));
        case "WrappingKeyCertificate":
            return Optional.ofNullable(clazz.cast(wrappingKeyCertificate()));
        case "WrappingKeyCertificateChain":
            return Optional.ofNullable(clazz.cast(wrappingKeyCertificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportResponse, T> g) {
        return obj -> g.apply((GetParametersForImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetParametersForImportResponse> {
        /**
         * <p>
         * The import token to initiate key import into Amazon Web Services Payment Cryptography. The import token
         * expires after 7 days. You can use the same import token to import multiple keys to the same service account.
         * </p>
         * 
         * @param importToken
         *        The import token to initiate key import into Amazon Web Services Payment Cryptography. The import
         *        token expires after 7 days. You can use the same import token to import multiple keys to the same
         *        service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importToken(String importToken);

        /**
         * <p>
         * The validity period of the import token.
         * </p>
         * 
         * @param parametersValidUntilTimestamp
         *        The validity period of the import token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp);

        /**
         * <p>
         * The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
         * </p>
         * 
         * @param wrappingKeyAlgorithm
         *        The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm);

        /**
         * <p>
         * The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
         * </p>
         * 
         * @param wrappingKeyAlgorithm
         *        The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm);

        /**
         * <p>
         * The wrapping key certificate in PEM format (base64 encoded) of the wrapping key for use within the TR-34 key
         * block. The certificate expires in 7 days.
         * </p>
         * 
         * @param wrappingKeyCertificate
         *        The wrapping key certificate in PEM format (base64 encoded) of the wrapping key for use within the
         *        TR-34 key block. The certificate expires in 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappingKeyCertificate(String wrappingKeyCertificate);

        /**
         * <p>
         * The Amazon Web Services Payment Cryptography root certificate authority (CA) that signed the wrapping key
         * certificate in PEM format (base64 encoded).
         * </p>
         * 
         * @param wrappingKeyCertificateChain
         *        The Amazon Web Services Payment Cryptography root certificate authority (CA) that signed the wrapping
         *        key certificate in PEM format (base64 encoded).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappingKeyCertificateChain(String wrappingKeyCertificateChain);
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private String importToken;

        private Instant parametersValidUntilTimestamp;

        private String wrappingKeyAlgorithm;

        private String wrappingKeyCertificate;

        private String wrappingKeyCertificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportResponse model) {
            super(model);
            importToken(model.importToken);
            parametersValidUntilTimestamp(model.parametersValidUntilTimestamp);
            wrappingKeyAlgorithm(model.wrappingKeyAlgorithm);
            wrappingKeyCertificate(model.wrappingKeyCertificate);
            wrappingKeyCertificateChain(model.wrappingKeyCertificateChain);
        }

        public final String getImportToken() {
            return importToken;
        }

        public final void setImportToken(String importToken) {
            this.importToken = importToken;
        }

        @Override
        public final Builder importToken(String importToken) {
            this.importToken = importToken;
            return this;
        }

        public final Instant getParametersValidUntilTimestamp() {
            return parametersValidUntilTimestamp;
        }

        public final void setParametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
        }

        @Override
        public final Builder parametersValidUntilTimestamp(Instant parametersValidUntilTimestamp) {
            this.parametersValidUntilTimestamp = parametersValidUntilTimestamp;
            return this;
        }

        public final String getWrappingKeyAlgorithm() {
            return wrappingKeyAlgorithm;
        }

        public final void setWrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm(wrappingKeyAlgorithm == null ? null : wrappingKeyAlgorithm.toString());
            return this;
        }

        public final String getWrappingKeyCertificate() {
            return wrappingKeyCertificate;
        }

        public final void setWrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
        }

        @Override
        public final Builder wrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
            return this;
        }

        public final String getWrappingKeyCertificateChain() {
            return wrappingKeyCertificateChain;
        }

        public final void setWrappingKeyCertificateChain(String wrappingKeyCertificateChain) {
            this.wrappingKeyCertificateChain = wrappingKeyCertificateChain;
        }

        @Override
        public final Builder wrappingKeyCertificateChain(String wrappingKeyCertificateChain) {
            this.wrappingKeyCertificateChain = wrappingKeyCertificateChain;
            return this;
        }

        @Override
        public GetParametersForImportResponse build() {
            return new GetParametersForImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
