/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for IPEK generation during export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportDukptInitialKey implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportDukptInitialKey.Builder, ExportDukptInitialKey> {
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeySerialNumber").getter(getter(ExportDukptInitialKey::keySerialNumber))
            .setter(setter(Builder::keySerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_SERIAL_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keySerialNumber;

    private ExportDukptInitialKey(BuilderImpl builder) {
        this.keySerialNumber = builder.keySerialNumber;
    }

    /**
     * <p>
     * The KSN for IPEK generation using DUKPT.
     * </p>
     * <p>
     * KSN must be padded before sending to Amazon Web Services Payment Cryptography. KSN hex length should be 20 for a
     * TDES_2KEY key or 24 for an AES key.
     * </p>
     * 
     * @return The KSN for IPEK generation using DUKPT. </p>
     *         <p>
     *         KSN must be padded before sending to Amazon Web Services Payment Cryptography. KSN hex length should be
     *         20 for a TDES_2KEY key or 24 for an AES key.
     */
    public final String keySerialNumber() {
        return keySerialNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keySerialNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDukptInitialKey)) {
            return false;
        }
        ExportDukptInitialKey other = (ExportDukptInitialKey) obj;
        return Objects.equals(keySerialNumber(), other.keySerialNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportDukptInitialKey").add("KeySerialNumber", keySerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeySerialNumber":
            return Optional.ofNullable(clazz.cast(keySerialNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportDukptInitialKey, T> g) {
        return obj -> g.apply((ExportDukptInitialKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportDukptInitialKey> {
        /**
         * <p>
         * The KSN for IPEK generation using DUKPT.
         * </p>
         * <p>
         * KSN must be padded before sending to Amazon Web Services Payment Cryptography. KSN hex length should be 20
         * for a TDES_2KEY key or 24 for an AES key.
         * </p>
         * 
         * @param keySerialNumber
         *        The KSN for IPEK generation using DUKPT. </p>
         *        <p>
         *        KSN must be padded before sending to Amazon Web Services Payment Cryptography. KSN hex length should
         *        be 20 for a TDES_2KEY key or 24 for an AES key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySerialNumber(String keySerialNumber);
    }

    static final class BuilderImpl implements Builder {
        private String keySerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDukptInitialKey model) {
            keySerialNumber(model.keySerialNumber);
        }

        public final String getKeySerialNumber() {
            return keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        @Override
        public ExportDukptInitialKey build() {
            return new ExportDukptInitialKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
