/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for key material import into Amazon Web Services Payment Cryptography using TR-31 or TR-34 or
 * RSA wrap and unwrap key exchange method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportKeyMaterial implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportKeyMaterial.Builder, ImportKeyMaterial> {
    private static final SdkField<ImportKeyCryptogram> KEY_CRYPTOGRAM_FIELD = SdkField
            .<ImportKeyCryptogram> builder(MarshallingType.SDK_POJO).memberName("KeyCryptogram")
            .getter(getter(ImportKeyMaterial::keyCryptogram)).setter(setter(Builder::keyCryptogram))
            .constructor(ImportKeyCryptogram::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCryptogram").build()).build();

    private static final SdkField<RootCertificatePublicKey> ROOT_CERTIFICATE_PUBLIC_KEY_FIELD = SdkField
            .<RootCertificatePublicKey> builder(MarshallingType.SDK_POJO).memberName("RootCertificatePublicKey")
            .getter(getter(ImportKeyMaterial::rootCertificatePublicKey)).setter(setter(Builder::rootCertificatePublicKey))
            .constructor(RootCertificatePublicKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCertificatePublicKey").build())
            .build();

    private static final SdkField<ImportTr31KeyBlock> TR31_KEY_BLOCK_FIELD = SdkField
            .<ImportTr31KeyBlock> builder(MarshallingType.SDK_POJO).memberName("Tr31KeyBlock")
            .getter(getter(ImportKeyMaterial::tr31KeyBlock)).setter(setter(Builder::tr31KeyBlock))
            .constructor(ImportTr31KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr31KeyBlock").build()).build();

    private static final SdkField<ImportTr34KeyBlock> TR34_KEY_BLOCK_FIELD = SdkField
            .<ImportTr34KeyBlock> builder(MarshallingType.SDK_POJO).memberName("Tr34KeyBlock")
            .getter(getter(ImportKeyMaterial::tr34KeyBlock)).setter(setter(Builder::tr34KeyBlock))
            .constructor(ImportTr34KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr34KeyBlock").build()).build();

    private static final SdkField<TrustedCertificatePublicKey> TRUSTED_CERTIFICATE_PUBLIC_KEY_FIELD = SdkField
            .<TrustedCertificatePublicKey> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedCertificatePublicKey")
            .getter(getter(ImportKeyMaterial::trustedCertificatePublicKey))
            .setter(setter(Builder::trustedCertificatePublicKey))
            .constructor(TrustedCertificatePublicKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedCertificatePublicKey")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_CRYPTOGRAM_FIELD,
            ROOT_CERTIFICATE_PUBLIC_KEY_FIELD, TR31_KEY_BLOCK_FIELD, TR34_KEY_BLOCK_FIELD, TRUSTED_CERTIFICATE_PUBLIC_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportKeyCryptogram keyCryptogram;

    private final RootCertificatePublicKey rootCertificatePublicKey;

    private final ImportTr31KeyBlock tr31KeyBlock;

    private final ImportTr34KeyBlock tr34KeyBlock;

    private final TrustedCertificatePublicKey trustedCertificatePublicKey;

    private final Type type;

    private ImportKeyMaterial(BuilderImpl builder) {
        this.keyCryptogram = builder.keyCryptogram;
        this.rootCertificatePublicKey = builder.rootCertificatePublicKey;
        this.tr31KeyBlock = builder.tr31KeyBlock;
        this.tr34KeyBlock = builder.tr34KeyBlock;
        this.trustedCertificatePublicKey = builder.trustedCertificatePublicKey;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     * </p>
     * 
     * @return Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     */
    public final ImportKeyCryptogram keyCryptogram() {
        return keyCryptogram;
    }

    /**
     * <p>
     * Parameter information for root public key certificate import.
     * </p>
     * 
     * @return Parameter information for root public key certificate import.
     */
    public final RootCertificatePublicKey rootCertificatePublicKey() {
        return rootCertificatePublicKey;
    }

    /**
     * <p>
     * Parameter information for key material import using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @return Parameter information for key material import using symmetric TR-31 key exchange method.
     */
    public final ImportTr31KeyBlock tr31KeyBlock() {
        return tr31KeyBlock;
    }

    /**
     * <p>
     * Parameter information for key material import using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @return Parameter information for key material import using the asymmetric TR-34 key exchange method.
     */
    public final ImportTr34KeyBlock tr34KeyBlock() {
        return tr34KeyBlock;
    }

    /**
     * <p>
     * Parameter information for trusted public key certificate import.
     * </p>
     * 
     * @return Parameter information for trusted public key certificate import.
     */
    public final TrustedCertificatePublicKey trustedCertificatePublicKey() {
        return trustedCertificatePublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(rootCertificatePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(tr31KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(tr34KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(trustedCertificatePublicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyMaterial)) {
            return false;
        }
        ImportKeyMaterial other = (ImportKeyMaterial) obj;
        return Objects.equals(keyCryptogram(), other.keyCryptogram())
                && Objects.equals(rootCertificatePublicKey(), other.rootCertificatePublicKey())
                && Objects.equals(tr31KeyBlock(), other.tr31KeyBlock()) && Objects.equals(tr34KeyBlock(), other.tr34KeyBlock())
                && Objects.equals(trustedCertificatePublicKey(), other.trustedCertificatePublicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportKeyMaterial").add("KeyCryptogram", keyCryptogram())
                .add("RootCertificatePublicKey", rootCertificatePublicKey()).add("Tr31KeyBlock", tr31KeyBlock())
                .add("Tr34KeyBlock", tr34KeyBlock()).add("TrustedCertificatePublicKey", trustedCertificatePublicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyCryptogram":
            return Optional.ofNullable(clazz.cast(keyCryptogram()));
        case "RootCertificatePublicKey":
            return Optional.ofNullable(clazz.cast(rootCertificatePublicKey()));
        case "Tr31KeyBlock":
            return Optional.ofNullable(clazz.cast(tr31KeyBlock()));
        case "Tr34KeyBlock":
            return Optional.ofNullable(clazz.cast(tr34KeyBlock()));
        case "TrustedCertificatePublicKey":
            return Optional.ofNullable(clazz.cast(trustedCertificatePublicKey()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #keyCryptogram()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     * </p>
     * 
     * @param keyCryptogram
     *        Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     */
    public static ImportKeyMaterial fromKeyCryptogram(ImportKeyCryptogram keyCryptogram) {
        return builder().keyCryptogram(keyCryptogram).build();
    }

    /**
     * Create an instance of this class with {@link #keyCryptogram()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     * </p>
     * 
     * @param keyCryptogram
     *        Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
     */
    public static ImportKeyMaterial fromKeyCryptogram(Consumer<ImportKeyCryptogram.Builder> keyCryptogram) {
        ImportKeyCryptogram.Builder builder = ImportKeyCryptogram.builder();
        keyCryptogram.accept(builder);
        return fromKeyCryptogram(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rootCertificatePublicKey()} initialized to the given value.
     *
     * <p>
     * Parameter information for root public key certificate import.
     * </p>
     * 
     * @param rootCertificatePublicKey
     *        Parameter information for root public key certificate import.
     */
    public static ImportKeyMaterial fromRootCertificatePublicKey(RootCertificatePublicKey rootCertificatePublicKey) {
        return builder().rootCertificatePublicKey(rootCertificatePublicKey).build();
    }

    /**
     * Create an instance of this class with {@link #rootCertificatePublicKey()} initialized to the given value.
     *
     * <p>
     * Parameter information for root public key certificate import.
     * </p>
     * 
     * @param rootCertificatePublicKey
     *        Parameter information for root public key certificate import.
     */
    public static ImportKeyMaterial fromRootCertificatePublicKey(
            Consumer<RootCertificatePublicKey.Builder> rootCertificatePublicKey) {
        RootCertificatePublicKey.Builder builder = RootCertificatePublicKey.builder();
        rootCertificatePublicKey.accept(builder);
        return fromRootCertificatePublicKey(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @param tr31KeyBlock
     *        Parameter information for key material import using symmetric TR-31 key exchange method.
     */
    public static ImportKeyMaterial fromTr31KeyBlock(ImportTr31KeyBlock tr31KeyBlock) {
        return builder().tr31KeyBlock(tr31KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #tr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @param tr31KeyBlock
     *        Parameter information for key material import using symmetric TR-31 key exchange method.
     */
    public static ImportKeyMaterial fromTr31KeyBlock(Consumer<ImportTr31KeyBlock.Builder> tr31KeyBlock) {
        ImportTr31KeyBlock.Builder builder = ImportTr31KeyBlock.builder();
        tr31KeyBlock.accept(builder);
        return fromTr31KeyBlock(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tr34KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @param tr34KeyBlock
     *        Parameter information for key material import using the asymmetric TR-34 key exchange method.
     */
    public static ImportKeyMaterial fromTr34KeyBlock(ImportTr34KeyBlock tr34KeyBlock) {
        return builder().tr34KeyBlock(tr34KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #tr34KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material import using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @param tr34KeyBlock
     *        Parameter information for key material import using the asymmetric TR-34 key exchange method.
     */
    public static ImportKeyMaterial fromTr34KeyBlock(Consumer<ImportTr34KeyBlock.Builder> tr34KeyBlock) {
        ImportTr34KeyBlock.Builder builder = ImportTr34KeyBlock.builder();
        tr34KeyBlock.accept(builder);
        return fromTr34KeyBlock(builder.build());
    }

    /**
     * Create an instance of this class with {@link #trustedCertificatePublicKey()} initialized to the given value.
     *
     * <p>
     * Parameter information for trusted public key certificate import.
     * </p>
     * 
     * @param trustedCertificatePublicKey
     *        Parameter information for trusted public key certificate import.
     */
    public static ImportKeyMaterial fromTrustedCertificatePublicKey(TrustedCertificatePublicKey trustedCertificatePublicKey) {
        return builder().trustedCertificatePublicKey(trustedCertificatePublicKey).build();
    }

    /**
     * Create an instance of this class with {@link #trustedCertificatePublicKey()} initialized to the given value.
     *
     * <p>
     * Parameter information for trusted public key certificate import.
     * </p>
     * 
     * @param trustedCertificatePublicKey
     *        Parameter information for trusted public key certificate import.
     */
    public static ImportKeyMaterial fromTrustedCertificatePublicKey(
            Consumer<TrustedCertificatePublicKey.Builder> trustedCertificatePublicKey) {
        TrustedCertificatePublicKey.Builder builder = TrustedCertificatePublicKey.builder();
        trustedCertificatePublicKey.accept(builder);
        return fromTrustedCertificatePublicKey(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyMaterial, T> g) {
        return obj -> g.apply((ImportKeyMaterial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportKeyMaterial> {
        /**
         * <p>
         * Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
         * </p>
         * 
         * @param keyCryptogram
         *        Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCryptogram(ImportKeyCryptogram keyCryptogram);

        /**
         * <p>
         * Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportKeyCryptogram.Builder} avoiding the
         * need to create one manually via {@link ImportKeyCryptogram#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportKeyCryptogram.Builder#build()} is called immediately and
         * its result is passed to {@link #keyCryptogram(ImportKeyCryptogram)}.
         * 
         * @param keyCryptogram
         *        a consumer that will call methods on {@link ImportKeyCryptogram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyCryptogram(ImportKeyCryptogram)
         */
        default Builder keyCryptogram(Consumer<ImportKeyCryptogram.Builder> keyCryptogram) {
            return keyCryptogram(ImportKeyCryptogram.builder().applyMutation(keyCryptogram).build());
        }

        /**
         * <p>
         * Parameter information for root public key certificate import.
         * </p>
         * 
         * @param rootCertificatePublicKey
         *        Parameter information for root public key certificate import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootCertificatePublicKey(RootCertificatePublicKey rootCertificatePublicKey);

        /**
         * <p>
         * Parameter information for root public key certificate import.
         * </p>
         * This is a convenience method that creates an instance of the {@link RootCertificatePublicKey.Builder}
         * avoiding the need to create one manually via {@link RootCertificatePublicKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RootCertificatePublicKey.Builder#build()} is called immediately
         * and its result is passed to {@link #rootCertificatePublicKey(RootCertificatePublicKey)}.
         * 
         * @param rootCertificatePublicKey
         *        a consumer that will call methods on {@link RootCertificatePublicKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootCertificatePublicKey(RootCertificatePublicKey)
         */
        default Builder rootCertificatePublicKey(Consumer<RootCertificatePublicKey.Builder> rootCertificatePublicKey) {
            return rootCertificatePublicKey(RootCertificatePublicKey.builder().applyMutation(rootCertificatePublicKey).build());
        }

        /**
         * <p>
         * Parameter information for key material import using symmetric TR-31 key exchange method.
         * </p>
         * 
         * @param tr31KeyBlock
         *        Parameter information for key material import using symmetric TR-31 key exchange method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tr31KeyBlock(ImportTr31KeyBlock tr31KeyBlock);

        /**
         * <p>
         * Parameter information for key material import using symmetric TR-31 key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTr31KeyBlock.Builder} avoiding the
         * need to create one manually via {@link ImportTr31KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTr31KeyBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #tr31KeyBlock(ImportTr31KeyBlock)}.
         * 
         * @param tr31KeyBlock
         *        a consumer that will call methods on {@link ImportTr31KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tr31KeyBlock(ImportTr31KeyBlock)
         */
        default Builder tr31KeyBlock(Consumer<ImportTr31KeyBlock.Builder> tr31KeyBlock) {
            return tr31KeyBlock(ImportTr31KeyBlock.builder().applyMutation(tr31KeyBlock).build());
        }

        /**
         * <p>
         * Parameter information for key material import using the asymmetric TR-34 key exchange method.
         * </p>
         * 
         * @param tr34KeyBlock
         *        Parameter information for key material import using the asymmetric TR-34 key exchange method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tr34KeyBlock(ImportTr34KeyBlock tr34KeyBlock);

        /**
         * <p>
         * Parameter information for key material import using the asymmetric TR-34 key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTr34KeyBlock.Builder} avoiding the
         * need to create one manually via {@link ImportTr34KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTr34KeyBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #tr34KeyBlock(ImportTr34KeyBlock)}.
         * 
         * @param tr34KeyBlock
         *        a consumer that will call methods on {@link ImportTr34KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tr34KeyBlock(ImportTr34KeyBlock)
         */
        default Builder tr34KeyBlock(Consumer<ImportTr34KeyBlock.Builder> tr34KeyBlock) {
            return tr34KeyBlock(ImportTr34KeyBlock.builder().applyMutation(tr34KeyBlock).build());
        }

        /**
         * <p>
         * Parameter information for trusted public key certificate import.
         * </p>
         * 
         * @param trustedCertificatePublicKey
         *        Parameter information for trusted public key certificate import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedCertificatePublicKey(TrustedCertificatePublicKey trustedCertificatePublicKey);

        /**
         * <p>
         * Parameter information for trusted public key certificate import.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedCertificatePublicKey.Builder}
         * avoiding the need to create one manually via {@link TrustedCertificatePublicKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedCertificatePublicKey.Builder#build()} is called
         * immediately and its result is passed to {@link #trustedCertificatePublicKey(TrustedCertificatePublicKey)}.
         * 
         * @param trustedCertificatePublicKey
         *        a consumer that will call methods on {@link TrustedCertificatePublicKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedCertificatePublicKey(TrustedCertificatePublicKey)
         */
        default Builder trustedCertificatePublicKey(Consumer<TrustedCertificatePublicKey.Builder> trustedCertificatePublicKey) {
            return trustedCertificatePublicKey(TrustedCertificatePublicKey.builder().applyMutation(trustedCertificatePublicKey)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImportKeyCryptogram keyCryptogram;

        private RootCertificatePublicKey rootCertificatePublicKey;

        private ImportTr31KeyBlock tr31KeyBlock;

        private ImportTr34KeyBlock tr34KeyBlock;

        private TrustedCertificatePublicKey trustedCertificatePublicKey;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyMaterial model) {
            keyCryptogram(model.keyCryptogram);
            rootCertificatePublicKey(model.rootCertificatePublicKey);
            tr31KeyBlock(model.tr31KeyBlock);
            tr34KeyBlock(model.tr34KeyBlock);
            trustedCertificatePublicKey(model.trustedCertificatePublicKey);
        }

        public final ImportKeyCryptogram.Builder getKeyCryptogram() {
            return keyCryptogram != null ? keyCryptogram.toBuilder() : null;
        }

        public final void setKeyCryptogram(ImportKeyCryptogram.BuilderImpl keyCryptogram) {
            Object oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram != null ? keyCryptogram.build() : null;
            handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
        }

        @Override
        public final Builder keyCryptogram(ImportKeyCryptogram keyCryptogram) {
            Object oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram;
            handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
            return this;
        }

        public final RootCertificatePublicKey.Builder getRootCertificatePublicKey() {
            return rootCertificatePublicKey != null ? rootCertificatePublicKey.toBuilder() : null;
        }

        public final void setRootCertificatePublicKey(RootCertificatePublicKey.BuilderImpl rootCertificatePublicKey) {
            Object oldValue = this.rootCertificatePublicKey;
            this.rootCertificatePublicKey = rootCertificatePublicKey != null ? rootCertificatePublicKey.build() : null;
            handleUnionValueChange(Type.ROOT_CERTIFICATE_PUBLIC_KEY, oldValue, this.rootCertificatePublicKey);
        }

        @Override
        public final Builder rootCertificatePublicKey(RootCertificatePublicKey rootCertificatePublicKey) {
            Object oldValue = this.rootCertificatePublicKey;
            this.rootCertificatePublicKey = rootCertificatePublicKey;
            handleUnionValueChange(Type.ROOT_CERTIFICATE_PUBLIC_KEY, oldValue, this.rootCertificatePublicKey);
            return this;
        }

        public final ImportTr31KeyBlock.Builder getTr31KeyBlock() {
            return tr31KeyBlock != null ? tr31KeyBlock.toBuilder() : null;
        }

        public final void setTr31KeyBlock(ImportTr31KeyBlock.BuilderImpl tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock != null ? tr31KeyBlock.build() : null;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
        }

        @Override
        public final Builder tr31KeyBlock(ImportTr31KeyBlock tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
            return this;
        }

        public final ImportTr34KeyBlock.Builder getTr34KeyBlock() {
            return tr34KeyBlock != null ? tr34KeyBlock.toBuilder() : null;
        }

        public final void setTr34KeyBlock(ImportTr34KeyBlock.BuilderImpl tr34KeyBlock) {
            Object oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock != null ? tr34KeyBlock.build() : null;
            handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
        }

        @Override
        public final Builder tr34KeyBlock(ImportTr34KeyBlock tr34KeyBlock) {
            Object oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock;
            handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
            return this;
        }

        public final TrustedCertificatePublicKey.Builder getTrustedCertificatePublicKey() {
            return trustedCertificatePublicKey != null ? trustedCertificatePublicKey.toBuilder() : null;
        }

        public final void setTrustedCertificatePublicKey(TrustedCertificatePublicKey.BuilderImpl trustedCertificatePublicKey) {
            Object oldValue = this.trustedCertificatePublicKey;
            this.trustedCertificatePublicKey = trustedCertificatePublicKey != null ? trustedCertificatePublicKey.build() : null;
            handleUnionValueChange(Type.TRUSTED_CERTIFICATE_PUBLIC_KEY, oldValue, this.trustedCertificatePublicKey);
        }

        @Override
        public final Builder trustedCertificatePublicKey(TrustedCertificatePublicKey trustedCertificatePublicKey) {
            Object oldValue = this.trustedCertificatePublicKey;
            this.trustedCertificatePublicKey = trustedCertificatePublicKey;
            handleUnionValueChange(Type.TRUSTED_CERTIFICATE_PUBLIC_KEY, oldValue, this.trustedCertificatePublicKey);
            return this;
        }

        @Override
        public ImportKeyMaterial build() {
            return new ImportKeyMaterial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ImportKeyMaterial#type()
     */
    public enum Type {
        KEY_CRYPTOGRAM,

        ROOT_CERTIFICATE_PUBLIC_KEY,

        TR31_KEY_BLOCK,

        TR34_KEY_BLOCK,

        TRUSTED_CERTIFICATE_PUBLIC_KEY,

        UNKNOWN_TO_SDK_VERSION
    }
}
