/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is
 * immutable after the key is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyAttributes implements SdkPojo, Serializable, ToCopyableBuilder<KeyAttributes.Builder, KeyAttributes> {
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyUsage").getter(getter(KeyAttributes::keyUsageAsString)).setter(setter(Builder::keyUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()).build();

    private static final SdkField<String> KEY_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyClass").getter(getter(KeyAttributes::keyClassAsString)).setter(setter(Builder::keyClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyClass").build()).build();

    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyAlgorithm").getter(getter(KeyAttributes::keyAlgorithmAsString)).setter(setter(Builder::keyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()).build();

    private static final SdkField<KeyModesOfUse> KEY_MODES_OF_USE_FIELD = SdkField
            .<KeyModesOfUse> builder(MarshallingType.SDK_POJO).memberName("KeyModesOfUse")
            .getter(getter(KeyAttributes::keyModesOfUse)).setter(setter(Builder::keyModesOfUse))
            .constructor(KeyModesOfUse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyModesOfUse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_USAGE_FIELD,
            KEY_CLASS_FIELD, KEY_ALGORITHM_FIELD, KEY_MODES_OF_USE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyUsage;

    private final String keyClass;

    private final String keyAlgorithm;

    private final KeyModesOfUse keyModesOfUse;

    private KeyAttributes(BuilderImpl builder) {
        this.keyUsage = builder.keyUsage;
        this.keyClass = builder.keyClass;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyModesOfUse = builder.keyModesOfUse;
    }

    /**
     * <p>
     * The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of the
     * TR-31 spec.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyUsage} will
     * return {@link KeyUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyUsageAsString}.
     * </p>
     * 
     * @return The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of
     *         the TR-31 spec.
     * @see KeyUsage
     */
    public final KeyUsage keyUsage() {
        return KeyUsage.fromValue(keyUsage);
    }

    /**
     * <p>
     * The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of the
     * TR-31 spec.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyUsage} will
     * return {@link KeyUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyUsageAsString}.
     * </p>
     * 
     * @return The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of
     *         the TR-31 spec.
     * @see KeyUsage
     */
    public final String keyUsageAsString() {
        return keyUsage;
    }

    /**
     * <p>
     * The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of the
     * cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric key or an
     * asymmetric key pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyClass} will
     * return {@link KeyClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyClassAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of
     *         the cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric
     *         key or an asymmetric key pair.
     * @see KeyClass
     */
    public final KeyClass keyClass() {
        return KeyClass.fromValue(keyClass);
    }

    /**
     * <p>
     * The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of the
     * cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric key or an
     * asymmetric key pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyClass} will
     * return {@link KeyClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyClassAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of
     *         the cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric
     *         key or an asymmetric key pair.
     * @see KeyClass
     */
    public final String keyClassAsString() {
        return keyClass;
    }

    /**
     * <p>
     * The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.
     * </p>
     * <p>
     * For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and <code>TDES</code>
     * algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports <code>RSA</code> and
     * <code>ECC_NIST</code> algorithms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyAlgorithm} will
     * return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.</p>
     *         <p>
     *         For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and
     *         <code>TDES</code> algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports
     *         <code>RSA</code> and <code>ECC_NIST</code> algorithms.
     * @see KeyAlgorithm
     */
    public final KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(keyAlgorithm);
    }

    /**
     * <p>
     * The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.
     * </p>
     * <p>
     * For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and <code>TDES</code>
     * algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports <code>RSA</code> and
     * <code>ECC_NIST</code> algorithms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyAlgorithm} will
     * return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.</p>
     *         <p>
     *         For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and
     *         <code>TDES</code> algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports
     *         <code>RSA</code> and <code>ECC_NIST</code> algorithms.
     * @see KeyAlgorithm
     */
    public final String keyAlgorithmAsString() {
        return keyAlgorithm;
    }

    /**
     * <p>
     * The list of cryptographic operations that you can perform using the key.
     * </p>
     * 
     * @return The list of cryptographic operations that you can perform using the key.
     */
    public final KeyModesOfUse keyModesOfUse() {
        return keyModesOfUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyModesOfUse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyAttributes)) {
            return false;
        }
        KeyAttributes other = (KeyAttributes) obj;
        return Objects.equals(keyUsageAsString(), other.keyUsageAsString())
                && Objects.equals(keyClassAsString(), other.keyClassAsString())
                && Objects.equals(keyAlgorithmAsString(), other.keyAlgorithmAsString())
                && Objects.equals(keyModesOfUse(), other.keyModesOfUse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyAttributes").add("KeyUsage", keyUsageAsString()).add("KeyClass", keyClassAsString())
                .add("KeyAlgorithm", keyAlgorithmAsString()).add("KeyModesOfUse", keyModesOfUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyUsage":
            return Optional.ofNullable(clazz.cast(keyUsageAsString()));
        case "KeyClass":
            return Optional.ofNullable(clazz.cast(keyClassAsString()));
        case "KeyAlgorithm":
            return Optional.ofNullable(clazz.cast(keyAlgorithmAsString()));
        case "KeyModesOfUse":
            return Optional.ofNullable(clazz.cast(keyModesOfUse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyAttributes, T> g) {
        return obj -> g.apply((KeyAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyAttributes> {
        /**
         * <p>
         * The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of the
         * TR-31 spec.
         * </p>
         * 
         * @param keyUsage
         *        The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2
         *        of the TR-31 spec.
         * @see KeyUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsage
         */
        Builder keyUsage(String keyUsage);

        /**
         * <p>
         * The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of the
         * TR-31 spec.
         * </p>
         * 
         * @param keyUsage
         *        The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2
         *        of the TR-31 spec.
         * @see KeyUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsage
         */
        Builder keyUsage(KeyUsage keyUsage);

        /**
         * <p>
         * The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of the
         * cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric key or an
         * asymmetric key pair.
         * </p>
         * 
         * @param keyClass
         *        The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation
         *        of the cryptographic method and whether Amazon Web Services Payment Cryptography key contains a
         *        symmetric key or an asymmetric key pair.
         * @see KeyClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyClass
         */
        Builder keyClass(String keyClass);

        /**
         * <p>
         * The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of the
         * cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric key or an
         * asymmetric key pair.
         * </p>
         * 
         * @param keyClass
         *        The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation
         *        of the cryptographic method and whether Amazon Web Services Payment Cryptography key contains a
         *        symmetric key or an asymmetric key pair.
         * @see KeyClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyClass
         */
        Builder keyClass(KeyClass keyClass);

        /**
         * <p>
         * The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.
         * </p>
         * <p>
         * For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and <code>TDES</code>
         * algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports <code>RSA</code> and
         * <code>ECC_NIST</code> algorithms.
         * </p>
         * 
         * @param keyAlgorithm
         *        The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.</p>
         *        <p>
         *        For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and
         *        <code>TDES</code> algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports
         *        <code>RSA</code> and <code>ECC_NIST</code> algorithms.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder keyAlgorithm(String keyAlgorithm);

        /**
         * <p>
         * The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.
         * </p>
         * <p>
         * For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and <code>TDES</code>
         * algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports <code>RSA</code> and
         * <code>ECC_NIST</code> algorithms.
         * </p>
         * 
         * @param keyAlgorithm
         *        The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.</p>
         *        <p>
         *        For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and
         *        <code>TDES</code> algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports
         *        <code>RSA</code> and <code>ECC_NIST</code> algorithms.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder keyAlgorithm(KeyAlgorithm keyAlgorithm);

        /**
         * <p>
         * The list of cryptographic operations that you can perform using the key.
         * </p>
         * 
         * @param keyModesOfUse
         *        The list of cryptographic operations that you can perform using the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyModesOfUse(KeyModesOfUse keyModesOfUse);

        /**
         * <p>
         * The list of cryptographic operations that you can perform using the key.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyModesOfUse.Builder} avoiding the need
         * to create one manually via {@link KeyModesOfUse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyModesOfUse.Builder#build()} is called immediately and its
         * result is passed to {@link #keyModesOfUse(KeyModesOfUse)}.
         * 
         * @param keyModesOfUse
         *        a consumer that will call methods on {@link KeyModesOfUse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyModesOfUse(KeyModesOfUse)
         */
        default Builder keyModesOfUse(Consumer<KeyModesOfUse.Builder> keyModesOfUse) {
            return keyModesOfUse(KeyModesOfUse.builder().applyMutation(keyModesOfUse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String keyUsage;

        private String keyClass;

        private String keyAlgorithm;

        private KeyModesOfUse keyModesOfUse;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyAttributes model) {
            keyUsage(model.keyUsage);
            keyClass(model.keyClass);
            keyAlgorithm(model.keyAlgorithm);
            keyModesOfUse(model.keyModesOfUse);
        }

        public final String getKeyUsage() {
            return keyUsage;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage(keyUsage == null ? null : keyUsage.toString());
            return this;
        }

        public final String getKeyClass() {
            return keyClass;
        }

        public final void setKeyClass(String keyClass) {
            this.keyClass = keyClass;
        }

        @Override
        public final Builder keyClass(String keyClass) {
            this.keyClass = keyClass;
            return this;
        }

        @Override
        public final Builder keyClass(KeyClass keyClass) {
            this.keyClass(keyClass == null ? null : keyClass.toString());
            return this;
        }

        public final String getKeyAlgorithm() {
            return keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final KeyModesOfUse.Builder getKeyModesOfUse() {
            return keyModesOfUse != null ? keyModesOfUse.toBuilder() : null;
        }

        public final void setKeyModesOfUse(KeyModesOfUse.BuilderImpl keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse != null ? keyModesOfUse.build() : null;
        }

        @Override
        public final Builder keyModesOfUse(KeyModesOfUse keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse;
            return this;
        }

        @Override
        public KeyAttributes build() {
            return new KeyAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
