/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportKeyRequest extends PaymentCryptographyRequest implements
        ToCopyableBuilder<ExportKeyRequest.Builder, ExportKeyRequest> {
    private static final SdkField<ExportKeyMaterial> KEY_MATERIAL_FIELD = SdkField
            .<ExportKeyMaterial> builder(MarshallingType.SDK_POJO).memberName("KeyMaterial")
            .getter(getter(ExportKeyRequest::keyMaterial)).setter(setter(Builder::keyMaterial))
            .constructor(ExportKeyMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").build()).build();

    private static final SdkField<String> EXPORT_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportKeyIdentifier").getter(getter(ExportKeyRequest::exportKeyIdentifier))
            .setter(setter(Builder::exportKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportKeyIdentifier").build())
            .build();

    private static final SdkField<ExportAttributes> EXPORT_ATTRIBUTES_FIELD = SdkField
            .<ExportAttributes> builder(MarshallingType.SDK_POJO).memberName("ExportAttributes")
            .getter(getter(ExportKeyRequest::exportAttributes)).setter(setter(Builder::exportAttributes))
            .constructor(ExportAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_FIELD,
            EXPORT_KEY_IDENTIFIER_FIELD, EXPORT_ATTRIBUTES_FIELD));

    private final ExportKeyMaterial keyMaterial;

    private final String exportKeyIdentifier;

    private final ExportAttributes exportAttributes;

    private ExportKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterial = builder.keyMaterial;
        this.exportKeyIdentifier = builder.exportKeyIdentifier;
        this.exportAttributes = builder.exportAttributes;
    }

    /**
     * <p>
     * The key block format type, for example, TR-34 or TR-31, to use during key material export.
     * </p>
     * 
     * @return The key block format type, for example, TR-34 or TR-31, to use during key material export.
     */
    public final ExportKeyMaterial keyMaterial() {
        return keyMaterial;
    }

    /**
     * <p>
     * The <code>KeyARN</code> of the key under export from Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The <code>KeyARN</code> of the key under export from Amazon Web Services Payment Cryptography.
     */
    public final String exportKeyIdentifier() {
        return exportKeyIdentifier;
    }

    /**
     * <p>
     * The attributes for IPEK generation during export.
     * </p>
     * 
     * @return The attributes for IPEK generation during export.
     */
    public final ExportAttributes exportAttributes() {
        return exportAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(exportKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(exportAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyRequest)) {
            return false;
        }
        ExportKeyRequest other = (ExportKeyRequest) obj;
        return Objects.equals(keyMaterial(), other.keyMaterial())
                && Objects.equals(exportKeyIdentifier(), other.exportKeyIdentifier())
                && Objects.equals(exportAttributes(), other.exportAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportKeyRequest").add("KeyMaterial", keyMaterial())
                .add("ExportKeyIdentifier", exportKeyIdentifier()).add("ExportAttributes", exportAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyMaterial":
            return Optional.ofNullable(clazz.cast(keyMaterial()));
        case "ExportKeyIdentifier":
            return Optional.ofNullable(clazz.cast(exportKeyIdentifier()));
        case "ExportAttributes":
            return Optional.ofNullable(clazz.cast(exportAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportKeyRequest, T> g) {
        return obj -> g.apply((ExportKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExportKeyRequest> {
        /**
         * <p>
         * The key block format type, for example, TR-34 or TR-31, to use during key material export.
         * </p>
         * 
         * @param keyMaterial
         *        The key block format type, for example, TR-34 or TR-31, to use during key material export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMaterial(ExportKeyMaterial keyMaterial);

        /**
         * <p>
         * The key block format type, for example, TR-34 or TR-31, to use during key material export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportKeyMaterial.Builder} avoiding the
         * need to create one manually via {@link ExportKeyMaterial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportKeyMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #keyMaterial(ExportKeyMaterial)}.
         * 
         * @param keyMaterial
         *        a consumer that will call methods on {@link ExportKeyMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyMaterial(ExportKeyMaterial)
         */
        default Builder keyMaterial(Consumer<ExportKeyMaterial.Builder> keyMaterial) {
            return keyMaterial(ExportKeyMaterial.builder().applyMutation(keyMaterial).build());
        }

        /**
         * <p>
         * The <code>KeyARN</code> of the key under export from Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param exportKeyIdentifier
         *        The <code>KeyARN</code> of the key under export from Amazon Web Services Payment Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportKeyIdentifier(String exportKeyIdentifier);

        /**
         * <p>
         * The attributes for IPEK generation during export.
         * </p>
         * 
         * @param exportAttributes
         *        The attributes for IPEK generation during export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAttributes(ExportAttributes exportAttributes);

        /**
         * <p>
         * The attributes for IPEK generation during export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportAttributes.Builder} avoiding the
         * need to create one manually via {@link ExportAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #exportAttributes(ExportAttributes)}.
         * 
         * @param exportAttributes
         *        a consumer that will call methods on {@link ExportAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportAttributes(ExportAttributes)
         */
        default Builder exportAttributes(Consumer<ExportAttributes.Builder> exportAttributes) {
            return exportAttributes(ExportAttributes.builder().applyMutation(exportAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyRequest.BuilderImpl implements Builder {
        private ExportKeyMaterial keyMaterial;

        private String exportKeyIdentifier;

        private ExportAttributes exportAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportKeyRequest model) {
            super(model);
            keyMaterial(model.keyMaterial);
            exportKeyIdentifier(model.exportKeyIdentifier);
            exportAttributes(model.exportAttributes);
        }

        public final ExportKeyMaterial.Builder getKeyMaterial() {
            return keyMaterial != null ? keyMaterial.toBuilder() : null;
        }

        public final void setKeyMaterial(ExportKeyMaterial.BuilderImpl keyMaterial) {
            this.keyMaterial = keyMaterial != null ? keyMaterial.build() : null;
        }

        @Override
        public final Builder keyMaterial(ExportKeyMaterial keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final String getExportKeyIdentifier() {
            return exportKeyIdentifier;
        }

        public final void setExportKeyIdentifier(String exportKeyIdentifier) {
            this.exportKeyIdentifier = exportKeyIdentifier;
        }

        @Override
        public final Builder exportKeyIdentifier(String exportKeyIdentifier) {
            this.exportKeyIdentifier = exportKeyIdentifier;
            return this;
        }

        public final ExportAttributes.Builder getExportAttributes() {
            return exportAttributes != null ? exportAttributes.toBuilder() : null;
        }

        public final void setExportAttributes(ExportAttributes.BuilderImpl exportAttributes) {
            this.exportAttributes = exportAttributes != null ? exportAttributes.build() : null;
        }

        @Override
        public final Builder exportAttributes(ExportAttributes exportAttributes) {
            this.exportAttributes = exportAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportKeyRequest build() {
            return new ExportKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
