/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for key material import using symmetric TR-31 key exchange method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTr31KeyBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTr31KeyBlock.Builder, ImportTr31KeyBlock> {
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyIdentifier").getter(getter(ImportTr31KeyBlock::wrappingKeyIdentifier))
            .setter(setter(Builder::wrappingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build())
            .build();

    private static final SdkField<String> WRAPPED_KEY_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappedKeyBlock").getter(getter(ImportTr31KeyBlock::wrappedKeyBlock))
            .setter(setter(Builder::wrappedKeyBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPING_KEY_IDENTIFIER_FIELD,
            WRAPPED_KEY_BLOCK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String wrappingKeyIdentifier;

    private final String wrappedKeyBlock;

    private ImportTr31KeyBlock(BuilderImpl builder) {
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
        this.wrappedKeyBlock = builder.wrappedKeyBlock;
    }

    /**
     * <p>
     * The <code>KeyARN</code> of the key that will decrypt or unwrap a TR-31 key block during import.
     * </p>
     * 
     * @return The <code>KeyARN</code> of the key that will decrypt or unwrap a TR-31 key block during import.
     */
    public final String wrappingKeyIdentifier() {
        return wrappingKeyIdentifier;
    }

    /**
     * <p>
     * The TR-31 wrapped key block to import.
     * </p>
     * 
     * @return The TR-31 wrapped key block to import.
     */
    public final String wrappedKeyBlock() {
        return wrappedKeyBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(wrappedKeyBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTr31KeyBlock)) {
            return false;
        }
        ImportTr31KeyBlock other = (ImportTr31KeyBlock) obj;
        return Objects.equals(wrappingKeyIdentifier(), other.wrappingKeyIdentifier())
                && Objects.equals(wrappedKeyBlock(), other.wrappedKeyBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTr31KeyBlock").add("WrappingKeyIdentifier", wrappingKeyIdentifier())
                .add("WrappedKeyBlock", wrappedKeyBlock() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WrappingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(wrappingKeyIdentifier()));
        case "WrappedKeyBlock":
            return Optional.ofNullable(clazz.cast(wrappedKeyBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTr31KeyBlock, T> g) {
        return obj -> g.apply((ImportTr31KeyBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTr31KeyBlock> {
        /**
         * <p>
         * The <code>KeyARN</code> of the key that will decrypt or unwrap a TR-31 key block during import.
         * </p>
         * 
         * @param wrappingKeyIdentifier
         *        The <code>KeyARN</code> of the key that will decrypt or unwrap a TR-31 key block during import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappingKeyIdentifier(String wrappingKeyIdentifier);

        /**
         * <p>
         * The TR-31 wrapped key block to import.
         * </p>
         * 
         * @param wrappedKeyBlock
         *        The TR-31 wrapped key block to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappedKeyBlock(String wrappedKeyBlock);
    }

    static final class BuilderImpl implements Builder {
        private String wrappingKeyIdentifier;

        private String wrappedKeyBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTr31KeyBlock model) {
            wrappingKeyIdentifier(model.wrappingKeyIdentifier);
            wrappedKeyBlock(model.wrappedKeyBlock);
        }

        public final String getWrappingKeyIdentifier() {
            return wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        public final String getWrappedKeyBlock() {
            return wrappedKeyBlock;
        }

        public final void setWrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
        }

        @Override
        public final Builder wrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
            return this;
        }

        @Override
        public ImportTr31KeyBlock build() {
            return new ImportTr31KeyBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
