/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersForExportRequest extends PaymentCryptographyRequest implements
        ToCopyableBuilder<GetParametersForExportRequest.Builder, GetParametersForExportRequest> {
    private static final SdkField<String> KEY_MATERIAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyMaterialType").getter(getter(GetParametersForExportRequest::keyMaterialTypeAsString))
            .setter(setter(Builder::keyMaterialType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialType").build()).build();

    private static final SdkField<String> SIGNING_KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningKeyAlgorithm").getter(getter(GetParametersForExportRequest::signingKeyAlgorithmAsString))
            .setter(setter(Builder::signingKeyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_TYPE_FIELD,
            SIGNING_KEY_ALGORITHM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyMaterialType;

    private final String signingKeyAlgorithm;

    private GetParametersForExportRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterialType = builder.keyMaterialType;
        this.signingKeyAlgorithm = builder.signingKeyAlgorithm;
    }

    /**
     * <p>
     * The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token is only
     * required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for TR-31 key export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialType}
     * will return {@link KeyMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialTypeAsString}.
     * </p>
     * 
     * @return The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token
     *         is only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for
     *         TR-31 key export.
     * @see KeyMaterialType
     */
    public final KeyMaterialType keyMaterialType() {
        return KeyMaterialType.fromValue(keyMaterialType);
    }

    /**
     * <p>
     * The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token is only
     * required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for TR-31 key export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialType}
     * will return {@link KeyMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialTypeAsString}.
     * </p>
     * 
     * @return The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token
     *         is only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for
     *         TR-31 key export.
     * @see KeyMaterialType
     */
    public final String keyMaterialTypeAsString() {
        return keyMaterialType;
    }

    /**
     * <p>
     * The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key under
     * export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #signingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key
     *         under export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
     * @see KeyAlgorithm
     */
    public final KeyAlgorithm signingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(signingKeyAlgorithm);
    }

    /**
     * <p>
     * The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key under
     * export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #signingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key
     *         under export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
     * @see KeyAlgorithm
     */
    public final String signingKeyAlgorithmAsString() {
        return signingKeyAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingKeyAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForExportRequest)) {
            return false;
        }
        GetParametersForExportRequest other = (GetParametersForExportRequest) obj;
        return Objects.equals(keyMaterialTypeAsString(), other.keyMaterialTypeAsString())
                && Objects.equals(signingKeyAlgorithmAsString(), other.signingKeyAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetParametersForExportRequest").add("KeyMaterialType", keyMaterialTypeAsString())
                .add("SigningKeyAlgorithm", signingKeyAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyMaterialType":
            return Optional.ofNullable(clazz.cast(keyMaterialTypeAsString()));
        case "SigningKeyAlgorithm":
            return Optional.ofNullable(clazz.cast(signingKeyAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyMaterialType", KEY_MATERIAL_TYPE_FIELD);
        map.put("SigningKeyAlgorithm", SIGNING_KEY_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForExportRequest, T> g) {
        return obj -> g.apply((GetParametersForExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetParametersForExportRequest> {
        /**
         * <p>
         * The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token is
         * only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for TR-31 key
         * export.
         * </p>
         * 
         * @param keyMaterialType
         *        The key block format type (for example, TR-34 or TR-31) to use during key material export. Export
         *        token is only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not
         *        required for TR-31 key export.
         * @see KeyMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialType
         */
        Builder keyMaterialType(String keyMaterialType);

        /**
         * <p>
         * The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token is
         * only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for TR-31 key
         * export.
         * </p>
         * 
         * @param keyMaterialType
         *        The key block format type (for example, TR-34 or TR-31) to use during key material export. Export
         *        token is only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not
         *        required for TR-31 key export.
         * @see KeyMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialType
         */
        Builder keyMaterialType(KeyMaterialType keyMaterialType);

        /**
         * <p>
         * The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key under
         * export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
         * </p>
         * 
         * @param signingKeyAlgorithm
         *        The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped
         *        key under export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm
         *        allowed.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder signingKeyAlgorithm(String signingKeyAlgorithm);

        /**
         * <p>
         * The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key under
         * export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.
         * </p>
         * 
         * @param signingKeyAlgorithm
         *        The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped
         *        key under export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm
         *        allowed.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyRequest.BuilderImpl implements Builder {
        private String keyMaterialType;

        private String signingKeyAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForExportRequest model) {
            super(model);
            keyMaterialType(model.keyMaterialType);
            signingKeyAlgorithm(model.signingKeyAlgorithm);
        }

        public final String getKeyMaterialType() {
            return keyMaterialType;
        }

        public final void setKeyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
        }

        @Override
        public final Builder keyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
            return this;
        }

        @Override
        public final Builder keyMaterialType(KeyMaterialType keyMaterialType) {
            this.keyMaterialType(keyMaterialType == null ? null : keyMaterialType.toString());
            return this;
        }

        public final String getSigningKeyAlgorithm() {
            return signingKeyAlgorithm;
        }

        public final void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
        }

        @Override
        public final Builder signingKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm) {
            this.signingKeyAlgorithm(signingKeyAlgorithm == null ? null : signingKeyAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForExportRequest build() {
            return new GetParametersForExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
