/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopKeyUsageResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<StopKeyUsageResponse.Builder, StopKeyUsageResponse> {
    private static final SdkField<Key> KEY_FIELD = SdkField.<Key> builder(MarshallingType.SDK_POJO).memberName("Key")
            .getter(getter(StopKeyUsageResponse::key)).setter(setter(Builder::key)).constructor(Key::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Key key;

    private StopKeyUsageResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
    }

    /**
     * <p>
     * The <code>KeyARN</code> of the key.
     * </p>
     * 
     * @return The <code>KeyARN</code> of the key.
     */
    public final Key key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopKeyUsageResponse)) {
            return false;
        }
        StopKeyUsageResponse other = (StopKeyUsageResponse) obj;
        return Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopKeyUsageResponse").add("Key", key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopKeyUsageResponse, T> g) {
        return obj -> g.apply((StopKeyUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopKeyUsageResponse> {
        /**
         * <p>
         * The <code>KeyARN</code> of the key.
         * </p>
         * 
         * @param key
         *        The <code>KeyARN</code> of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Key key);

        /**
         * <p>
         * The <code>KeyARN</code> of the key.
         * </p>
         * This is a convenience method that creates an instance of the {@link Key.Builder} avoiding the need to create
         * one manually via {@link Key#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Key.Builder#build()} is called immediately and its result is
         * passed to {@link #key(Key)}.
         * 
         * @param key
         *        a consumer that will call methods on {@link Key.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #key(Key)
         */
        default Builder key(Consumer<Key.Builder> key) {
            return key(Key.builder().applyMutation(key).build());
        }
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private Key key;

        private BuilderImpl() {
        }

        private BuilderImpl(StopKeyUsageResponse model) {
            super(model);
            key(model.key);
        }

        public final Key.Builder getKey() {
            return key != null ? key.toBuilder() : null;
        }

        public final void setKey(Key.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        @Override
        public final Builder key(Key key) {
            this.key = key;
            return this;
        }

        @Override
        public StopKeyUsageResponse build() {
            return new StopKeyUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
