/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessDeniedException;
import software.amazon.awssdk.services.pcaconnectorad.model.ConflictException;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.InternalServerException;
import software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdException;
import software.amazon.awssdk.services.pcaconnectorad.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pcaconnectorad.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pcaconnectorad.model.TagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.TagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ThrottlingException;
import software.amazon.awssdk.services.pcaconnectorad.model.UntagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UntagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ValidationException;
import software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable;
import software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable;
import software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable;
import software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable;
import software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable;

/**
 * Service client for accessing PcaConnectorAd. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Private CA Connector for Active Directory creates a connector between Amazon Web Services Private
 * CA and Active Directory (AD) that enables you to provision security certificates for AD signed by a private CA that
 * you own. For more information, see <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/ad-connector.html">Amazon Web Services Private CA
 * Connector for Active Directory</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PcaConnectorAdClient extends AwsClient {
    String SERVICE_NAME = "pca-connector-ad";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "pca-connector-ad";

    /**
     * <p>
     * Creates a connector between Amazon Web Services Private CA and an Active Directory. You must specify the private
     * CA, directory ID, and security groups.
     * </p>
     *
     * @param createConnectorRequest
     * @return Result of the CreateConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorResponse createConnector(CreateConnectorRequest createConnectorRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connector between Amazon Web Services Private CA and an Active Directory. You must specify the private
     * CA, directory ID, and security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.CreateConnectorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorResponse createConnector(Consumer<CreateConnectorRequest.Builder> createConnectorRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Creates a directory registration that authorizes communication between Amazon Web Services Private CA and an
     * Active Directory
     * </p>
     *
     * @param createDirectoryRegistrationRequest
     * @return Result of the CreateDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryRegistrationResponse createDirectoryRegistration(
            CreateDirectoryRegistrationRequest createDirectoryRegistrationRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a directory registration that authorizes communication between Amazon Web Services Private CA and an
     * Active Directory
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDirectoryRegistrationRequest#builder()}
     * </p>
     *
     * @param createDirectoryRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.CreateDirectoryRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryRegistrationResponse createDirectoryRegistration(
            Consumer<CreateDirectoryRegistrationRequest.Builder> createDirectoryRegistrationRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return createDirectoryRegistration(CreateDirectoryRegistrationRequest.builder()
                .applyMutation(createDirectoryRegistrationRequest).build());
    }

    /**
     * <p>
     * Creates a service principal name (SPN) for the service account in Active Directory. Kerberos authentication uses
     * SPNs to associate a service instance with a service sign-in account.
     * </p>
     *
     * @param createServicePrincipalNameRequest
     * @return Result of the CreateServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServicePrincipalNameResponse createServicePrincipalName(
            CreateServicePrincipalNameRequest createServicePrincipalNameRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service principal name (SPN) for the service account in Active Directory. Kerberos authentication uses
     * SPNs to associate a service instance with a service sign-in account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServicePrincipalNameRequest.Builder} avoiding
     * the need to create one manually via {@link CreateServicePrincipalNameRequest#builder()}
     * </p>
     *
     * @param createServicePrincipalNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.CreateServicePrincipalNameRequest.Builder} to
     *        create a request.
     * @return Result of the CreateServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServicePrincipalNameResponse createServicePrincipalName(
            Consumer<CreateServicePrincipalNameRequest.Builder> createServicePrincipalNameRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        return createServicePrincipalName(CreateServicePrincipalNameRequest.builder()
                .applyMutation(createServicePrincipalNameRequest).build());
    }

    /**
     * <p>
     * Creates an Active Directory compatible certificate template. The connectors issues certificates using these
     * templates based on the requester’s Active Directory group membership.
     * </p>
     *
     * @param createTemplateRequest
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Active Directory compatible certificate template. The connectors issues certificates using these
     * templates based on the requester’s Active Directory group membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTemplateResponse createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Create a group access control entry. Allow or deny Active Directory groups from enrolling and/or autoenrolling
     * with the template based on the group security identifiers (SIDs).
     * </p>
     *
     * @param createTemplateGroupAccessControlEntryRequest
     * @return Result of the CreateTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTemplateGroupAccessControlEntryResponse createTemplateGroupAccessControlEntry(
            CreateTemplateGroupAccessControlEntryRequest createTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a group access control entry. Allow or deny Active Directory groups from enrolling and/or autoenrolling
     * with the template based on the group security identifiers (SIDs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTemplateGroupAccessControlEntryRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTemplateGroupAccessControlEntryRequest#builder()}
     * </p>
     *
     * @param createTemplateGroupAccessControlEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateGroupAccessControlEntryRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.CreateTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTemplateGroupAccessControlEntryResponse createTemplateGroupAccessControlEntry(
            Consumer<CreateTemplateGroupAccessControlEntryRequest.Builder> createTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return createTemplateGroupAccessControlEntry(CreateTemplateGroupAccessControlEntryRequest.builder()
                .applyMutation(createTemplateGroupAccessControlEntryRequest).build());
    }

    /**
     * <p>
     * Deletes a connector for Active Directory. You must provide the Amazon Resource Name (ARN) of the connector that
     * you want to delete. You can find the ARN by calling the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors</a> action. Deleting a
     * connector does not deregister your directory with Amazon Web Services Private CA. You can deregister your
     * directory by calling the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration</a> action.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(DeleteConnectorRequest deleteConnectorRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connector for Active Directory. You must provide the Amazon Resource Name (ARN) of the connector that
     * you want to delete. You can find the ARN by calling the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors</a> action. Deleting a
     * connector does not deregister your directory with Amazon Web Services Private CA. You can deregister your
     * directory by calling the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DeleteConnectorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes a directory registration. Deleting a directory registration deauthorizes Amazon Web Services Private CA
     * with the directory.
     * </p>
     *
     * @param deleteDirectoryRegistrationRequest
     * @return Result of the DeleteDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryRegistrationResponse deleteDirectoryRegistration(
            DeleteDirectoryRegistrationRequest deleteDirectoryRegistrationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a directory registration. Deleting a directory registration deauthorizes Amazon Web Services Private CA
     * with the directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDirectoryRegistrationRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DeleteDirectoryRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryRegistrationResponse deleteDirectoryRegistration(
            Consumer<DeleteDirectoryRegistrationRequest.Builder> deleteDirectoryRegistrationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        return deleteDirectoryRegistration(DeleteDirectoryRegistrationRequest.builder()
                .applyMutation(deleteDirectoryRegistrationRequest).build());
    }

    /**
     * <p>
     * Deletes the service principal name (SPN) used by a connector to authenticate with your Active Directory.
     * </p>
     *
     * @param deleteServicePrincipalNameRequest
     * @return Result of the DeleteServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServicePrincipalNameResponse deleteServicePrincipalName(
            DeleteServicePrincipalNameRequest deleteServicePrincipalNameRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the service principal name (SPN) used by a connector to authenticate with your Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServicePrincipalNameRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServicePrincipalNameRequest#builder()}
     * </p>
     *
     * @param deleteServicePrincipalNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DeleteServicePrincipalNameRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServicePrincipalNameResponse deleteServicePrincipalName(
            Consumer<DeleteServicePrincipalNameRequest.Builder> deleteServicePrincipalNameRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return deleteServicePrincipalName(DeleteServicePrincipalNameRequest.builder()
                .applyMutation(deleteServicePrincipalNameRequest).build());
    }

    /**
     * <p>
     * Deletes a template. Certificates issued using the template are still valid until they are revoked or expired.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a template. Certificates issued using the template are still valid until they are revoked or expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(Consumer<DeleteTemplateRequest.Builder> deleteTemplateRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return deleteTemplate(DeleteTemplateRequest.builder().applyMutation(deleteTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a group access control entry.
     * </p>
     *
     * @param deleteTemplateGroupAccessControlEntryRequest
     * @return Result of the DeleteTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTemplateGroupAccessControlEntryResponse deleteTemplateGroupAccessControlEntry(
            DeleteTemplateGroupAccessControlEntryRequest deleteTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group access control entry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTemplateGroupAccessControlEntryRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTemplateGroupAccessControlEntryRequest#builder()}
     * </p>
     *
     * @param deleteTemplateGroupAccessControlEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateGroupAccessControlEntryRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.DeleteTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTemplateGroupAccessControlEntryResponse deleteTemplateGroupAccessControlEntry(
            Consumer<DeleteTemplateGroupAccessControlEntryRequest.Builder> deleteTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return deleteTemplateGroupAccessControlEntry(DeleteTemplateGroupAccessControlEntryRequest.builder()
                .applyMutation(deleteTemplateGroupAccessControlEntryRequest).build());
    }

    /**
     * <p>
     * Lists information about your connector. You specify the connector on input by its ARN (Amazon Resource Name).
     * </p>
     *
     * @param getConnectorRequest
     * @return Result of the GetConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectorResponse getConnector(GetConnectorRequest getConnectorRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about your connector. You specify the connector on input by its ARN (Amazon Resource Name).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectorRequest#builder()}
     * </p>
     *
     * @param getConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.GetConnectorRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnector operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectorResponse getConnector(Consumer<GetConnectorRequest.Builder> getConnectorRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return getConnector(GetConnectorRequest.builder().applyMutation(getConnectorRequest).build());
    }

    /**
     * <p>
     * A structure that contains information about your directory registration.
     * </p>
     *
     * @param getDirectoryRegistrationRequest
     * @return Result of the GetDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDirectoryRegistrationResponse getDirectoryRegistration(
            GetDirectoryRegistrationRequest getDirectoryRegistrationRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A structure that contains information about your directory registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDirectoryRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link GetDirectoryRegistrationRequest#builder()}
     * </p>
     *
     * @param getDirectoryRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.GetDirectoryRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the GetDirectoryRegistration operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetDirectoryRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetDirectoryRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDirectoryRegistrationResponse getDirectoryRegistration(
            Consumer<GetDirectoryRegistrationRequest.Builder> getDirectoryRegistrationRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return getDirectoryRegistration(GetDirectoryRegistrationRequest.builder().applyMutation(getDirectoryRegistrationRequest)
                .build());
    }

    /**
     * <p>
     * Lists the service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     *
     * @param getServicePrincipalNameRequest
     * @return Result of the GetServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServicePrincipalNameResponse getServicePrincipalName(GetServicePrincipalNameRequest getServicePrincipalNameRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServicePrincipalNameRequest.Builder} avoiding
     * the need to create one manually via {@link GetServicePrincipalNameRequest#builder()}
     * </p>
     *
     * @param getServicePrincipalNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.GetServicePrincipalNameRequest.Builder} to
     *        create a request.
     * @return Result of the GetServicePrincipalName operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetServicePrincipalName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetServicePrincipalName"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServicePrincipalNameResponse getServicePrincipalName(
            Consumer<GetServicePrincipalNameRequest.Builder> getServicePrincipalNameRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return getServicePrincipalName(GetServicePrincipalNameRequest.builder().applyMutation(getServicePrincipalNameRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a certificate template that the connector uses to issue certificates from a private CA.
     * </p>
     *
     * @param getTemplateRequest
     * @return Result of the GetTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a certificate template that the connector uses to issue certificates from a private CA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTemplateResponse getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the group access control entries for a template.
     * </p>
     *
     * @param getTemplateGroupAccessControlEntryRequest
     * @return Result of the GetTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateGroupAccessControlEntryResponse getTemplateGroupAccessControlEntry(
            GetTemplateGroupAccessControlEntryRequest getTemplateGroupAccessControlEntryRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the group access control entries for a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateGroupAccessControlEntryRequest.Builder}
     * avoiding the need to create one manually via {@link GetTemplateGroupAccessControlEntryRequest#builder()}
     * </p>
     *
     * @param getTemplateGroupAccessControlEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateGroupAccessControlEntryRequest.Builder}
     *        to create a request.
     * @return Result of the GetTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.GetTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateGroupAccessControlEntryResponse getTemplateGroupAccessControlEntry(
            Consumer<GetTemplateGroupAccessControlEntryRequest.Builder> getTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return getTemplateGroupAccessControlEntry(GetTemplateGroupAccessControlEntryRequest.builder()
                .applyMutation(getTemplateGroupAccessControlEntryRequest).build());
    }

    /**
     * <p>
     * Lists the connectors that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector</a> action.
     * </p>
     *
     * @param listConnectorsRequest
     * @return Result of the ListConnectors operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connectors that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConnectors operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsResponse listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists the connectors that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return new ListConnectorsIterable(this, listConnectorsRequest);
    }

    /**
     * <p>
     * Lists the connectors that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists the directory registrations that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration</a> action.
     * </p>
     *
     * @param listDirectoryRegistrationsRequest
     * @return Result of the ListDirectoryRegistrations operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListDirectoryRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoryRegistrationsResponse listDirectoryRegistrations(
            ListDirectoryRegistrationsRequest listDirectoryRegistrationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the directory registrations that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoryRegistrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDirectoryRegistrationsRequest#builder()}
     * </p>
     *
     * @param listDirectoryRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDirectoryRegistrations operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListDirectoryRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoryRegistrationsResponse listDirectoryRegistrations(
            Consumer<ListDirectoryRegistrationsRequest.Builder> listDirectoryRegistrationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return listDirectoryRegistrations(ListDirectoryRegistrationsRequest.builder()
                .applyMutation(listDirectoryRegistrationsRequest).build());
    }

    /**
     * <p>
     * Lists the directory registrations that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDirectoryRegistrations(software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client.listDirectoryRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client
     *             .listDirectoryRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client.listDirectoryRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectoryRegistrations(software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDirectoryRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListDirectoryRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoryRegistrationsIterable listDirectoryRegistrationsPaginator(
            ListDirectoryRegistrationsRequest listDirectoryRegistrationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return new ListDirectoryRegistrationsIterable(this, listDirectoryRegistrationsRequest);
    }

    /**
     * <p>
     * Lists the directory registrations that you created by using the <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration"
     * >https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDirectoryRegistrations(software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client.listDirectoryRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client
     *             .listDirectoryRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListDirectoryRegistrationsIterable responses = client.listDirectoryRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectoryRegistrations(software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoryRegistrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDirectoryRegistrationsRequest#builder()}
     * </p>
     *
     * @param listDirectoryRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListDirectoryRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoryRegistrationsIterable listDirectoryRegistrationsPaginator(
            Consumer<ListDirectoryRegistrationsRequest.Builder> listDirectoryRegistrationsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return listDirectoryRegistrationsPaginator(ListDirectoryRegistrationsRequest.builder()
                .applyMutation(listDirectoryRegistrationsRequest).build());
    }

    /**
     * <p>
     * Lists the service principal names that the connector uses to authenticate with Active Directory.
     * </p>
     *
     * @param listServicePrincipalNamesRequest
     * @return Result of the ListServicePrincipalNames operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListServicePrincipalNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePrincipalNamesResponse listServicePrincipalNames(
            ListServicePrincipalNamesRequest listServicePrincipalNamesRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service principal names that the connector uses to authenticate with Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicePrincipalNamesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicePrincipalNamesRequest#builder()}
     * </p>
     *
     * @param listServicePrincipalNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest.Builder} to
     *        create a request.
     * @return Result of the ListServicePrincipalNames operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListServicePrincipalNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePrincipalNamesResponse listServicePrincipalNames(
            Consumer<ListServicePrincipalNamesRequest.Builder> listServicePrincipalNamesRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return listServicePrincipalNames(ListServicePrincipalNamesRequest.builder()
                .applyMutation(listServicePrincipalNamesRequest).build());
    }

    /**
     * <p>
     * Lists the service principal names that the connector uses to authenticate with Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServicePrincipalNames(software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client.listServicePrincipalNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client
     *             .listServicePrincipalNamesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client.listServicePrincipalNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePrincipalNames(software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServicePrincipalNamesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListServicePrincipalNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePrincipalNamesIterable listServicePrincipalNamesPaginator(
            ListServicePrincipalNamesRequest listServicePrincipalNamesRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            PcaConnectorAdException {
        return new ListServicePrincipalNamesIterable(this, listServicePrincipalNamesRequest);
    }

    /**
     * <p>
     * Lists the service principal names that the connector uses to authenticate with Active Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServicePrincipalNames(software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client.listServicePrincipalNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client
     *             .listServicePrincipalNamesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListServicePrincipalNamesIterable responses = client.listServicePrincipalNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicePrincipalNames(software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicePrincipalNamesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicePrincipalNamesRequest#builder()}
     * </p>
     *
     * @param listServicePrincipalNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListServicePrincipalNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicePrincipalNamesIterable listServicePrincipalNamesPaginator(
            Consumer<ListServicePrincipalNamesRequest.Builder> listServicePrincipalNamesRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return listServicePrincipalNamesPaginator(ListServicePrincipalNamesRequest.builder()
                .applyMutation(listServicePrincipalNamesRequest).build());
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists group access control entries you created.
     * </p>
     *
     * @param listTemplateGroupAccessControlEntriesRequest
     * @return Result of the ListTemplateGroupAccessControlEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplateGroupAccessControlEntries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateGroupAccessControlEntriesResponse listTemplateGroupAccessControlEntries(
            ListTemplateGroupAccessControlEntriesRequest listTemplateGroupAccessControlEntriesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists group access control entries you created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListTemplateGroupAccessControlEntriesRequest.Builder} avoiding the need to create one manually via
     * {@link ListTemplateGroupAccessControlEntriesRequest#builder()}
     * </p>
     *
     * @param listTemplateGroupAccessControlEntriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest.Builder}
     *        to create a request.
     * @return Result of the ListTemplateGroupAccessControlEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplateGroupAccessControlEntries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateGroupAccessControlEntriesResponse listTemplateGroupAccessControlEntries(
            Consumer<ListTemplateGroupAccessControlEntriesRequest.Builder> listTemplateGroupAccessControlEntriesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return listTemplateGroupAccessControlEntries(ListTemplateGroupAccessControlEntriesRequest.builder()
                .applyMutation(listTemplateGroupAccessControlEntriesRequest).build());
    }

    /**
     * <p>
     * Lists group access control entries you created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateGroupAccessControlEntries(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client.listTemplateGroupAccessControlEntriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client
     *             .listTemplateGroupAccessControlEntriesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client.listTemplateGroupAccessControlEntriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateGroupAccessControlEntries(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateGroupAccessControlEntriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplateGroupAccessControlEntries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateGroupAccessControlEntriesIterable listTemplateGroupAccessControlEntriesPaginator(
            ListTemplateGroupAccessControlEntriesRequest listTemplateGroupAccessControlEntriesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return new ListTemplateGroupAccessControlEntriesIterable(this, listTemplateGroupAccessControlEntriesRequest);
    }

    /**
     * <p>
     * Lists group access control entries you created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateGroupAccessControlEntries(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client.listTemplateGroupAccessControlEntriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client
     *             .listTemplateGroupAccessControlEntriesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplateGroupAccessControlEntriesIterable responses = client.listTemplateGroupAccessControlEntriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateGroupAccessControlEntries(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListTemplateGroupAccessControlEntriesRequest.Builder} avoiding the need to create one manually via
     * {@link ListTemplateGroupAccessControlEntriesRequest#builder()}
     * </p>
     *
     * @param listTemplateGroupAccessControlEntriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplateGroupAccessControlEntries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateGroupAccessControlEntriesIterable listTemplateGroupAccessControlEntriesPaginator(
            Consumer<ListTemplateGroupAccessControlEntriesRequest.Builder> listTemplateGroupAccessControlEntriesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return listTemplateGroupAccessControlEntriesPaginator(ListTemplateGroupAccessControlEntriesRequest.builder()
                .applyMutation(listTemplateGroupAccessControlEntriesRequest).build());
    }

    /**
     * <p>
     * Lists the templates, if any, that are associated with a connector.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the templates, if any, that are associated with a connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListTemplates operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesResponse listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the templates, if any, that are associated with a connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        return new ListTemplatesIterable(this, listTemplatesRequest);
    }

    /**
     * <p>
     * Lists the templates, if any, that are associated with a connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorad.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return listTemplatesPaginator(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to your resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to your resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from your resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from your resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update template configuration to define the information included in certificates.
     * </p>
     *
     * @param updateTemplateRequest
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update template configuration to define the information included in certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    /**
     * <p>
     * Update a group access control entry you created using <a href=
     * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplateGroupAccessControlEntry.html"
     * >CreateTemplateGroupAccessControlEntry</a>.
     * </p>
     *
     * @param updateTemplateGroupAccessControlEntryRequest
     * @return Result of the UpdateTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UpdateTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplateGroupAccessControlEntryResponse updateTemplateGroupAccessControlEntry(
            UpdateTemplateGroupAccessControlEntryRequest updateTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a group access control entry you created using <a href=
     * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplateGroupAccessControlEntry.html"
     * >CreateTemplateGroupAccessControlEntry</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateTemplateGroupAccessControlEntryRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateTemplateGroupAccessControlEntryRequest#builder()}
     * </p>
     *
     * @param updateTemplateGroupAccessControlEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateGroupAccessControlEntryRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateTemplateGroupAccessControlEntry operation returned by the service.
     * @throws AccessDeniedException
     *         You can receive this error if you attempt to create a resource share when you don't have the required
     *         permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web
     *         Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in
     *         place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web
     *         Services account.
     * @throws ValidationException
     *         An input validation error occurred. For example, invalid characters in a template name, or if a
     *         pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent resource. The resource might not be specified correctly, or
     *         its status might not be ACTIVE.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure with an internal
     *         server.
     * @throws ConflictException
     *         This request cannot be completed for one of the following reasons because the requested resource was
     *         being concurrently modified by another request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PcaConnectorAdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PcaConnectorAdClient.UpdateTemplateGroupAccessControlEntry
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplateGroupAccessControlEntry"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplateGroupAccessControlEntryResponse updateTemplateGroupAccessControlEntry(
            Consumer<UpdateTemplateGroupAccessControlEntryRequest.Builder> updateTemplateGroupAccessControlEntryRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        return updateTemplateGroupAccessControlEntry(UpdateTemplateGroupAccessControlEntryRequest.builder()
                .applyMutation(updateTemplateGroupAccessControlEntryRequest).build());
    }

    /**
     * Create a {@link PcaConnectorAdClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PcaConnectorAdClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PcaConnectorAdClient}.
     */
    static PcaConnectorAdClientBuilder builder() {
        return new DefaultPcaConnectorAdClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PcaConnectorAdServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
