/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the attributes of the private key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateKeyAttributesV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateKeyAttributesV2.Builder, PrivateKeyAttributesV2> {
    private static final SdkField<List<String>> CRYPTO_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CryptoProviders")
            .getter(getter(PrivateKeyAttributesV2::cryptoProviders))
            .setter(setter(Builder::cryptoProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CryptoProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KEY_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeySpec").getter(getter(PrivateKeyAttributesV2::keySpecAsString)).setter(setter(Builder::keySpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySpec").build()).build();

    private static final SdkField<Integer> MINIMAL_KEY_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimalKeyLength").getter(getter(PrivateKeyAttributesV2::minimalKeyLength))
            .setter(setter(Builder::minimalKeyLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimalKeyLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRYPTO_PROVIDERS_FIELD,
            KEY_SPEC_FIELD, MINIMAL_KEY_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cryptoProviders;

    private final String keySpec;

    private final Integer minimalKeyLength;

    private PrivateKeyAttributesV2(BuilderImpl builder) {
        this.cryptoProviders = builder.cryptoProviders;
        this.keySpec = builder.keySpec;
        this.minimalKeyLength = builder.minimalKeyLength;
    }

    /**
     * For responses, this returns true if the service returned a value for the CryptoProviders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCryptoProviders() {
        return cryptoProviders != null && !(cryptoProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the cryptographic providers used to generate the private key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCryptoProviders} method.
     * </p>
     * 
     * @return Defines the cryptographic providers used to generate the private key.
     */
    public final List<String> cryptoProviders() {
        return cryptoProviders;
    }

    /**
     * <p>
     * Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keySpec} will
     * return {@link KeySpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keySpecAsString}.
     * </p>
     * 
     * @return Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
     * @see KeySpec
     */
    public final KeySpec keySpec() {
        return KeySpec.fromValue(keySpec);
    }

    /**
     * <p>
     * Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keySpec} will
     * return {@link KeySpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keySpecAsString}.
     * </p>
     * 
     * @return Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
     * @see KeySpec
     */
    public final String keySpecAsString() {
        return keySpec;
    }

    /**
     * <p>
     * Set the minimum key length of the private key.
     * </p>
     * 
     * @return Set the minimum key length of the private key.
     */
    public final Integer minimalKeyLength() {
        return minimalKeyLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCryptoProviders() ? cryptoProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minimalKeyLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyAttributesV2)) {
            return false;
        }
        PrivateKeyAttributesV2 other = (PrivateKeyAttributesV2) obj;
        return hasCryptoProviders() == other.hasCryptoProviders() && Objects.equals(cryptoProviders(), other.cryptoProviders())
                && Objects.equals(keySpecAsString(), other.keySpecAsString())
                && Objects.equals(minimalKeyLength(), other.minimalKeyLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateKeyAttributesV2").add("CryptoProviders", hasCryptoProviders() ? cryptoProviders() : null)
                .add("KeySpec", keySpecAsString()).add("MinimalKeyLength", minimalKeyLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CryptoProviders":
            return Optional.ofNullable(clazz.cast(cryptoProviders()));
        case "KeySpec":
            return Optional.ofNullable(clazz.cast(keySpecAsString()));
        case "MinimalKeyLength":
            return Optional.ofNullable(clazz.cast(minimalKeyLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyAttributesV2, T> g) {
        return obj -> g.apply((PrivateKeyAttributesV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateKeyAttributesV2> {
        /**
         * <p>
         * Defines the cryptographic providers used to generate the private key.
         * </p>
         * 
         * @param cryptoProviders
         *        Defines the cryptographic providers used to generate the private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cryptoProviders(Collection<String> cryptoProviders);

        /**
         * <p>
         * Defines the cryptographic providers used to generate the private key.
         * </p>
         * 
         * @param cryptoProviders
         *        Defines the cryptographic providers used to generate the private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cryptoProviders(String... cryptoProviders);

        /**
         * <p>
         * Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * </p>
         * 
         * @param keySpec
         *        Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * @see KeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeySpec
         */
        Builder keySpec(String keySpec);

        /**
         * <p>
         * Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * </p>
         * 
         * @param keySpec
         *        Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.
         * @see KeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeySpec
         */
        Builder keySpec(KeySpec keySpec);

        /**
         * <p>
         * Set the minimum key length of the private key.
         * </p>
         * 
         * @param minimalKeyLength
         *        Set the minimum key length of the private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimalKeyLength(Integer minimalKeyLength);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cryptoProviders = DefaultSdkAutoConstructList.getInstance();

        private String keySpec;

        private Integer minimalKeyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyAttributesV2 model) {
            cryptoProviders(model.cryptoProviders);
            keySpec(model.keySpec);
            minimalKeyLength(model.minimalKeyLength);
        }

        public final Collection<String> getCryptoProviders() {
            if (cryptoProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return cryptoProviders;
        }

        public final void setCryptoProviders(Collection<String> cryptoProviders) {
            this.cryptoProviders = CryptoProvidersListCopier.copy(cryptoProviders);
        }

        @Override
        public final Builder cryptoProviders(Collection<String> cryptoProviders) {
            this.cryptoProviders = CryptoProvidersListCopier.copy(cryptoProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cryptoProviders(String... cryptoProviders) {
            cryptoProviders(Arrays.asList(cryptoProviders));
            return this;
        }

        public final String getKeySpec() {
            return keySpec;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(KeySpec keySpec) {
            this.keySpec(keySpec == null ? null : keySpec.toString());
            return this;
        }

        public final Integer getMinimalKeyLength() {
            return minimalKeyLength;
        }

        public final void setMinimalKeyLength(Integer minimalKeyLength) {
            this.minimalKeyLength = minimalKeyLength;
        }

        @Override
        public final Builder minimalKeyLength(Integer minimalKeyLength) {
            this.minimalKeyLength = minimalKeyLength;
            return this;
        }

        @Override
        public PrivateKeyAttributesV2 build() {
            return new PrivateKeyAttributesV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
