/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeySpec {
    KEY_EXCHANGE("KEY_EXCHANGE"),
    SIGNATURE("SIGNATURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeySpec> VALUE_MAP;
    private final String value;

    private KeySpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeySpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeySpec> knownValues() {
        EnumSet<KeySpec> knownValues = EnumSet.allOf(KeySpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeySpec.class, KeySpec::toString);
    }
}

