/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The revision version of the template. Template updates will increment the minor revision. Re-enrolling all
 * certificate holders will increment the major revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateRevision implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateRevision.Builder, TemplateRevision> {
    private static final SdkField<Integer> MAJOR_REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MajorRevision").getter(getter(TemplateRevision::majorRevision)).setter(setter(Builder::majorRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorRevision").build()).build();

    private static final SdkField<Integer> MINOR_REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinorRevision").getter(getter(TemplateRevision::minorRevision)).setter(setter(Builder::minorRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinorRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_REVISION_FIELD,
            MINOR_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer majorRevision;

    private final Integer minorRevision;

    private TemplateRevision(BuilderImpl builder) {
        this.majorRevision = builder.majorRevision;
        this.minorRevision = builder.minorRevision;
    }

    /**
     * <p>
     * The revision version of the template. Re-enrolling all certificate holders will increment the major revision.
     * </p>
     * 
     * @return The revision version of the template. Re-enrolling all certificate holders will increment the major
     *         revision.
     */
    public final Integer majorRevision() {
        return majorRevision;
    }

    /**
     * <p>
     * The revision version of the template. Re-enrolling all certificate holders will increment the major revision.
     * </p>
     * 
     * @return The revision version of the template. Re-enrolling all certificate holders will increment the major
     *         revision.
     */
    public final Integer minorRevision() {
        return minorRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(majorRevision());
        hashCode = 31 * hashCode + Objects.hashCode(minorRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateRevision)) {
            return false;
        }
        TemplateRevision other = (TemplateRevision) obj;
        return Objects.equals(majorRevision(), other.majorRevision()) && Objects.equals(minorRevision(), other.minorRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateRevision").add("MajorRevision", majorRevision()).add("MinorRevision", minorRevision())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MajorRevision":
            return Optional.ofNullable(clazz.cast(majorRevision()));
        case "MinorRevision":
            return Optional.ofNullable(clazz.cast(minorRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateRevision, T> g) {
        return obj -> g.apply((TemplateRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateRevision> {
        /**
         * <p>
         * The revision version of the template. Re-enrolling all certificate holders will increment the major revision.
         * </p>
         * 
         * @param majorRevision
         *        The revision version of the template. Re-enrolling all certificate holders will increment the major
         *        revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorRevision(Integer majorRevision);

        /**
         * <p>
         * The revision version of the template. Re-enrolling all certificate holders will increment the major revision.
         * </p>
         * 
         * @param minorRevision
         *        The revision version of the template. Re-enrolling all certificate holders will increment the major
         *        revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minorRevision(Integer minorRevision);
    }

    static final class BuilderImpl implements Builder {
        private Integer majorRevision;

        private Integer minorRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateRevision model) {
            majorRevision(model.majorRevision);
            minorRevision(model.minorRevision);
        }

        public final Integer getMajorRevision() {
            return majorRevision;
        }

        public final void setMajorRevision(Integer majorRevision) {
            this.majorRevision = majorRevision;
        }

        @Override
        public final Builder majorRevision(Integer majorRevision) {
            this.majorRevision = majorRevision;
            return this;
        }

        public final Integer getMinorRevision() {
            return minorRevision;
        }

        public final void setMinorRevision(Integer minorRevision) {
            this.minorRevision = minorRevision;
        }

        @Override
        public final Builder minorRevision(Integer minorRevision) {
            this.minorRevision = minorRevision;
            return this;
        }

        @Override
        public TemplateRevision build() {
            return new TemplateRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
