/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Template configurations for v2 template schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnrollmentFlagsV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<EnrollmentFlagsV2.Builder, EnrollmentFlagsV2> {
    private static final SdkField<Boolean> ENABLE_KEY_REUSE_ON_NT_TOKEN_KEYSET_STORAGE_FULL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableKeyReuseOnNtTokenKeysetStorageFull")
            .getter(getter(EnrollmentFlagsV2::enableKeyReuseOnNtTokenKeysetStorageFull))
            .setter(setter(Builder::enableKeyReuseOnNtTokenKeysetStorageFull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableKeyReuseOnNtTokenKeysetStorageFull").build()).build();

    private static final SdkField<Boolean> INCLUDE_SYMMETRIC_ALGORITHMS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSymmetricAlgorithms")
            .getter(getter(EnrollmentFlagsV2::includeSymmetricAlgorithms))
            .setter(setter(Builder::includeSymmetricAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSymmetricAlgorithms").build())
            .build();

    private static final SdkField<Boolean> NO_SECURITY_EXTENSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoSecurityExtension").getter(getter(EnrollmentFlagsV2::noSecurityExtension))
            .setter(setter(Builder::noSecurityExtension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoSecurityExtension").build())
            .build();

    private static final SdkField<Boolean> REMOVE_INVALID_CERTIFICATE_FROM_PERSONAL_STORE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveInvalidCertificateFromPersonalStore")
            .getter(getter(EnrollmentFlagsV2::removeInvalidCertificateFromPersonalStore))
            .setter(setter(Builder::removeInvalidCertificateFromPersonalStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RemoveInvalidCertificateFromPersonalStore").build()).build();

    private static final SdkField<Boolean> USER_INTERACTION_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserInteractionRequired").getter(getter(EnrollmentFlagsV2::userInteractionRequired))
            .setter(setter(Builder::userInteractionRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInteractionRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_KEY_REUSE_ON_NT_TOKEN_KEYSET_STORAGE_FULL_FIELD, INCLUDE_SYMMETRIC_ALGORITHMS_FIELD,
            NO_SECURITY_EXTENSION_FIELD, REMOVE_INVALID_CERTIFICATE_FROM_PERSONAL_STORE_FIELD, USER_INTERACTION_REQUIRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableKeyReuseOnNtTokenKeysetStorageFull;

    private final Boolean includeSymmetricAlgorithms;

    private final Boolean noSecurityExtension;

    private final Boolean removeInvalidCertificateFromPersonalStore;

    private final Boolean userInteractionRequired;

    private EnrollmentFlagsV2(BuilderImpl builder) {
        this.enableKeyReuseOnNtTokenKeysetStorageFull = builder.enableKeyReuseOnNtTokenKeysetStorageFull;
        this.includeSymmetricAlgorithms = builder.includeSymmetricAlgorithms;
        this.noSecurityExtension = builder.noSecurityExtension;
        this.removeInvalidCertificateFromPersonalStore = builder.removeInvalidCertificateFromPersonalStore;
        this.userInteractionRequired = builder.userInteractionRequired;
    }

    /**
     * <p>
     * Allow renewal using the same key.
     * </p>
     * 
     * @return Allow renewal using the same key.
     */
    public final Boolean enableKeyReuseOnNtTokenKeysetStorageFull() {
        return enableKeyReuseOnNtTokenKeysetStorageFull;
    }

    /**
     * <p>
     * Include symmetric algorithms allowed by the subject.
     * </p>
     * 
     * @return Include symmetric algorithms allowed by the subject.
     */
    public final Boolean includeSymmetricAlgorithms() {
        return includeSymmetricAlgorithms;
    }

    /**
     * <p>
     * This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
     * (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued
     * certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
     * </p>
     * 
     * @return This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
     *         (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the
     *         issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
     */
    public final Boolean noSecurityExtension() {
        return noSecurityExtension;
    }

    /**
     * <p>
     * Delete expired or revoked certificates instead of archiving them.
     * </p>
     * 
     * @return Delete expired or revoked certificates instead of archiving them.
     */
    public final Boolean removeInvalidCertificateFromPersonalStore() {
        return removeInvalidCertificateFromPersonalStore;
    }

    /**
     * <p>
     * Require user interaction when the subject is enrolled and the private key associated with the certificate is
     * used.
     * </p>
     * 
     * @return Require user interaction when the subject is enrolled and the private key associated with the certificate
     *         is used.
     */
    public final Boolean userInteractionRequired() {
        return userInteractionRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableKeyReuseOnNtTokenKeysetStorageFull());
        hashCode = 31 * hashCode + Objects.hashCode(includeSymmetricAlgorithms());
        hashCode = 31 * hashCode + Objects.hashCode(noSecurityExtension());
        hashCode = 31 * hashCode + Objects.hashCode(removeInvalidCertificateFromPersonalStore());
        hashCode = 31 * hashCode + Objects.hashCode(userInteractionRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrollmentFlagsV2)) {
            return false;
        }
        EnrollmentFlagsV2 other = (EnrollmentFlagsV2) obj;
        return Objects.equals(enableKeyReuseOnNtTokenKeysetStorageFull(), other.enableKeyReuseOnNtTokenKeysetStorageFull())
                && Objects.equals(includeSymmetricAlgorithms(), other.includeSymmetricAlgorithms())
                && Objects.equals(noSecurityExtension(), other.noSecurityExtension())
                && Objects.equals(removeInvalidCertificateFromPersonalStore(), other.removeInvalidCertificateFromPersonalStore())
                && Objects.equals(userInteractionRequired(), other.userInteractionRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnrollmentFlagsV2")
                .add("EnableKeyReuseOnNtTokenKeysetStorageFull", enableKeyReuseOnNtTokenKeysetStorageFull())
                .add("IncludeSymmetricAlgorithms", includeSymmetricAlgorithms())
                .add("NoSecurityExtension", noSecurityExtension())
                .add("RemoveInvalidCertificateFromPersonalStore", removeInvalidCertificateFromPersonalStore())
                .add("UserInteractionRequired", userInteractionRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableKeyReuseOnNtTokenKeysetStorageFull":
            return Optional.ofNullable(clazz.cast(enableKeyReuseOnNtTokenKeysetStorageFull()));
        case "IncludeSymmetricAlgorithms":
            return Optional.ofNullable(clazz.cast(includeSymmetricAlgorithms()));
        case "NoSecurityExtension":
            return Optional.ofNullable(clazz.cast(noSecurityExtension()));
        case "RemoveInvalidCertificateFromPersonalStore":
            return Optional.ofNullable(clazz.cast(removeInvalidCertificateFromPersonalStore()));
        case "UserInteractionRequired":
            return Optional.ofNullable(clazz.cast(userInteractionRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnrollmentFlagsV2, T> g) {
        return obj -> g.apply((EnrollmentFlagsV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnrollmentFlagsV2> {
        /**
         * <p>
         * Allow renewal using the same key.
         * </p>
         * 
         * @param enableKeyReuseOnNtTokenKeysetStorageFull
         *        Allow renewal using the same key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull);

        /**
         * <p>
         * Include symmetric algorithms allowed by the subject.
         * </p>
         * 
         * @param includeSymmetricAlgorithms
         *        Include symmetric algorithms allowed by the subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms);

        /**
         * <p>
         * This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
         * (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the
         * issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
         * </p>
         * 
         * @param noSecurityExtension
         *        This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
         *        (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in
         *        the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noSecurityExtension(Boolean noSecurityExtension);

        /**
         * <p>
         * Delete expired or revoked certificates instead of archiving them.
         * </p>
         * 
         * @param removeInvalidCertificateFromPersonalStore
         *        Delete expired or revoked certificates instead of archiving them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore);

        /**
         * <p>
         * Require user interaction when the subject is enrolled and the private key associated with the certificate is
         * used.
         * </p>
         * 
         * @param userInteractionRequired
         *        Require user interaction when the subject is enrolled and the private key associated with the
         *        certificate is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInteractionRequired(Boolean userInteractionRequired);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableKeyReuseOnNtTokenKeysetStorageFull;

        private Boolean includeSymmetricAlgorithms;

        private Boolean noSecurityExtension;

        private Boolean removeInvalidCertificateFromPersonalStore;

        private Boolean userInteractionRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(EnrollmentFlagsV2 model) {
            enableKeyReuseOnNtTokenKeysetStorageFull(model.enableKeyReuseOnNtTokenKeysetStorageFull);
            includeSymmetricAlgorithms(model.includeSymmetricAlgorithms);
            noSecurityExtension(model.noSecurityExtension);
            removeInvalidCertificateFromPersonalStore(model.removeInvalidCertificateFromPersonalStore);
            userInteractionRequired(model.userInteractionRequired);
        }

        public final Boolean getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return enableKeyReuseOnNtTokenKeysetStorageFull;
        }

        public final void setEnableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
            this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
        }

        @Override
        public final Builder enableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
            this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
            return this;
        }

        public final Boolean getIncludeSymmetricAlgorithms() {
            return includeSymmetricAlgorithms;
        }

        public final void setIncludeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms) {
            this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
        }

        @Override
        public final Builder includeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms) {
            this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
            return this;
        }

        public final Boolean getNoSecurityExtension() {
            return noSecurityExtension;
        }

        public final void setNoSecurityExtension(Boolean noSecurityExtension) {
            this.noSecurityExtension = noSecurityExtension;
        }

        @Override
        public final Builder noSecurityExtension(Boolean noSecurityExtension) {
            this.noSecurityExtension = noSecurityExtension;
            return this;
        }

        public final Boolean getRemoveInvalidCertificateFromPersonalStore() {
            return removeInvalidCertificateFromPersonalStore;
        }

        public final void setRemoveInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore) {
            this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
        }

        @Override
        public final Builder removeInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore) {
            this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
            return this;
        }

        public final Boolean getUserInteractionRequired() {
            return userInteractionRequired;
        }

        public final void setUserInteractionRequired(Boolean userInteractionRequired) {
            this.userInteractionRequired = userInteractionRequired;
        }

        @Override
        public final Builder userInteractionRequired(Boolean userInteractionRequired) {
            this.userInteractionRequired = userInteractionRequired;
            return this;
        }

        @Override
        public EnrollmentFlagsV2 build() {
            return new EnrollmentFlagsV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
