/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDirectoryRegistrationsResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<ListDirectoryRegistrationsResponse.Builder, ListDirectoryRegistrationsResponse> {
    private static final SdkField<List<DirectoryRegistrationSummary>> DIRECTORY_REGISTRATIONS_FIELD = SdkField
            .<List<DirectoryRegistrationSummary>> builder(MarshallingType.LIST)
            .memberName("DirectoryRegistrations")
            .getter(getter(ListDirectoryRegistrationsResponse::directoryRegistrations))
            .setter(setter(Builder::directoryRegistrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectoryRegistrationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectoryRegistrationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDirectoryRegistrationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_REGISTRATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DirectoryRegistrationSummary> directoryRegistrations;

    private final String nextToken;

    private ListDirectoryRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryRegistrations = builder.directoryRegistrations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectoryRegistrations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDirectoryRegistrations() {
        return directoryRegistrations != null && !(directoryRegistrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about each directory registration you have created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectoryRegistrations} method.
     * </p>
     * 
     * @return Summary information about each directory registration you have created.
     */
    public final List<DirectoryRegistrationSummary> directoryRegistrations() {
        return directoryRegistrations;
    }

    /**
     * <p>
     * Use this parameter when paginating results in a subsequent request after you receive a response with truncated
     * results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.
     * </p>
     * 
     * @return Use this parameter when paginating results in a subsequent request after you receive a response with
     *         truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
     *         received.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectoryRegistrations() ? directoryRegistrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoryRegistrationsResponse)) {
            return false;
        }
        ListDirectoryRegistrationsResponse other = (ListDirectoryRegistrationsResponse) obj;
        return hasDirectoryRegistrations() == other.hasDirectoryRegistrations()
                && Objects.equals(directoryRegistrations(), other.directoryRegistrations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDirectoryRegistrationsResponse")
                .add("DirectoryRegistrations", hasDirectoryRegistrations() ? directoryRegistrations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryRegistrations":
            return Optional.ofNullable(clazz.cast(directoryRegistrations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDirectoryRegistrationsResponse, T> g) {
        return obj -> g.apply((ListDirectoryRegistrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDirectoryRegistrationsResponse> {
        /**
         * <p>
         * Summary information about each directory registration you have created.
         * </p>
         * 
         * @param directoryRegistrations
         *        Summary information about each directory registration you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistrations(Collection<DirectoryRegistrationSummary> directoryRegistrations);

        /**
         * <p>
         * Summary information about each directory registration you have created.
         * </p>
         * 
         * @param directoryRegistrations
         *        Summary information about each directory registration you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistrations(DirectoryRegistrationSummary... directoryRegistrations);

        /**
         * <p>
         * Summary information about each directory registration you have created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #directoryRegistrations(List<DirectoryRegistrationSummary>)}.
         * 
         * @param directoryRegistrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryRegistrations(java.util.Collection<DirectoryRegistrationSummary>)
         */
        Builder directoryRegistrations(Consumer<DirectoryRegistrationSummary.Builder>... directoryRegistrations);

        /**
         * <p>
         * Use this parameter when paginating results in a subsequent request after you receive a response with
         * truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
         * received.
         * </p>
         * 
         * @param nextToken
         *        Use this parameter when paginating results in a subsequent request after you receive a response with
         *        truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you
         *        just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private List<DirectoryRegistrationSummary> directoryRegistrations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoryRegistrationsResponse model) {
            super(model);
            directoryRegistrations(model.directoryRegistrations);
            nextToken(model.nextToken);
        }

        public final List<DirectoryRegistrationSummary.Builder> getDirectoryRegistrations() {
            List<DirectoryRegistrationSummary.Builder> result = DirectoryRegistrationListCopier
                    .copyToBuilder(this.directoryRegistrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectoryRegistrations(Collection<DirectoryRegistrationSummary.BuilderImpl> directoryRegistrations) {
            this.directoryRegistrations = DirectoryRegistrationListCopier.copyFromBuilder(directoryRegistrations);
        }

        @Override
        public final Builder directoryRegistrations(Collection<DirectoryRegistrationSummary> directoryRegistrations) {
            this.directoryRegistrations = DirectoryRegistrationListCopier.copy(directoryRegistrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryRegistrations(DirectoryRegistrationSummary... directoryRegistrations) {
            directoryRegistrations(Arrays.asList(directoryRegistrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryRegistrations(Consumer<DirectoryRegistrationSummary.Builder>... directoryRegistrations) {
            directoryRegistrations(Stream.of(directoryRegistrations)
                    .map(c -> DirectoryRegistrationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDirectoryRegistrationsResponse build() {
            return new ListDirectoryRegistrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
