/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date
 * for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be
 * expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in
 * days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when
 * ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will
 * expire 20 days from issuance time regardless of the ValidityNotBefore value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateValidity implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateValidity.Builder, CertificateValidity> {
    private static final SdkField<ValidityPeriod> RENEWAL_PERIOD_FIELD = SdkField
            .<ValidityPeriod> builder(MarshallingType.SDK_POJO).memberName("RenewalPeriod")
            .getter(getter(CertificateValidity::renewalPeriod)).setter(setter(Builder::renewalPeriod))
            .constructor(ValidityPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalPeriod").build()).build();

    private static final SdkField<ValidityPeriod> VALIDITY_PERIOD_FIELD = SdkField
            .<ValidityPeriod> builder(MarshallingType.SDK_POJO).memberName("ValidityPeriod")
            .getter(getter(CertificateValidity::validityPeriod)).setter(setter(Builder::validityPeriod))
            .constructor(ValidityPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_PERIOD_FIELD,
            VALIDITY_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ValidityPeriod renewalPeriod;

    private final ValidityPeriod validityPeriod;

    private CertificateValidity(BuilderImpl builder) {
        this.renewalPeriod = builder.renewalPeriod;
        this.validityPeriod = builder.validityPeriod;
    }

    /**
     * <p>
     * Renewal period is the period of time before certificate expiration when a new certificate will be requested.
     * </p>
     * 
     * @return Renewal period is the period of time before certificate expiration when a new certificate will be
     *         requested.
     */
    public final ValidityPeriod renewalPeriod() {
        return renewalPeriod;
    }

    /**
     * <p>
     * Information describing the end of the validity period of the certificate. This parameter sets the “Not After”
     * date for the certificate. Certificate validity is the period of time during which a certificate is valid.
     * Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after
     * issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is
     * unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future,
     * the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
     * </p>
     * 
     * @return Information describing the end of the validity period of the certificate. This parameter sets the “Not
     *         After” date for the certificate. Certificate validity is the period of time during which a certificate is
     *         valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span
     *         of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280.
     *         This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20
     *         days in the future, the certificate will expire 20 days from issuance time regardless of the
     *         ValidityNotBefore value.
     */
    public final ValidityPeriod validityPeriod() {
        return validityPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renewalPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(validityPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateValidity)) {
            return false;
        }
        CertificateValidity other = (CertificateValidity) obj;
        return Objects.equals(renewalPeriod(), other.renewalPeriod()) && Objects.equals(validityPeriod(), other.validityPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateValidity").add("RenewalPeriod", renewalPeriod())
                .add("ValidityPeriod", validityPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenewalPeriod":
            return Optional.ofNullable(clazz.cast(renewalPeriod()));
        case "ValidityPeriod":
            return Optional.ofNullable(clazz.cast(validityPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RenewalPeriod", RENEWAL_PERIOD_FIELD);
        map.put("ValidityPeriod", VALIDITY_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateValidity, T> g) {
        return obj -> g.apply((CertificateValidity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateValidity> {
        /**
         * <p>
         * Renewal period is the period of time before certificate expiration when a new certificate will be requested.
         * </p>
         * 
         * @param renewalPeriod
         *        Renewal period is the period of time before certificate expiration when a new certificate will be
         *        requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalPeriod(ValidityPeriod renewalPeriod);

        /**
         * <p>
         * Renewal period is the period of time before certificate expiration when a new certificate will be requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidityPeriod.Builder} avoiding the need
         * to create one manually via {@link ValidityPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidityPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #renewalPeriod(ValidityPeriod)}.
         * 
         * @param renewalPeriod
         *        a consumer that will call methods on {@link ValidityPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalPeriod(ValidityPeriod)
         */
        default Builder renewalPeriod(Consumer<ValidityPeriod.Builder> renewalPeriod) {
            return renewalPeriod(ValidityPeriod.builder().applyMutation(renewalPeriod).build());
        }

        /**
         * <p>
         * Information describing the end of the validity period of the certificate. This parameter sets the “Not After”
         * date for the certificate. Certificate validity is the period of time during which a certificate is valid.
         * Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time
         * after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value
         * is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the
         * future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
         * </p>
         * 
         * @param validityPeriod
         *        Information describing the end of the validity period of the certificate. This parameter sets the “Not
         *        After” date for the certificate. Certificate validity is the period of time during which a certificate
         *        is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a
         *        span of time after issuance, stated in days, months, or years. For more information, see Validity in
         *        RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity
         *        is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of
         *        the ValidityNotBefore value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityPeriod(ValidityPeriod validityPeriod);

        /**
         * <p>
         * Information describing the end of the validity period of the certificate. This parameter sets the “Not After”
         * date for the certificate. Certificate validity is the period of time during which a certificate is valid.
         * Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time
         * after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value
         * is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the
         * future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidityPeriod.Builder} avoiding the need
         * to create one manually via {@link ValidityPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidityPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #validityPeriod(ValidityPeriod)}.
         * 
         * @param validityPeriod
         *        a consumer that will call methods on {@link ValidityPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validityPeriod(ValidityPeriod)
         */
        default Builder validityPeriod(Consumer<ValidityPeriod.Builder> validityPeriod) {
            return validityPeriod(ValidityPeriod.builder().applyMutation(validityPeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ValidityPeriod renewalPeriod;

        private ValidityPeriod validityPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateValidity model) {
            renewalPeriod(model.renewalPeriod);
            validityPeriod(model.validityPeriod);
        }

        public final ValidityPeriod.Builder getRenewalPeriod() {
            return renewalPeriod != null ? renewalPeriod.toBuilder() : null;
        }

        public final void setRenewalPeriod(ValidityPeriod.BuilderImpl renewalPeriod) {
            this.renewalPeriod = renewalPeriod != null ? renewalPeriod.build() : null;
        }

        @Override
        public final Builder renewalPeriod(ValidityPeriod renewalPeriod) {
            this.renewalPeriod = renewalPeriod;
            return this;
        }

        public final ValidityPeriod.Builder getValidityPeriod() {
            return validityPeriod != null ? validityPeriod.toBuilder() : null;
        }

        public final void setValidityPeriod(ValidityPeriod.BuilderImpl validityPeriod) {
            this.validityPeriod = validityPeriod != null ? validityPeriod.build() : null;
        }

        @Override
        public final Builder validityPeriod(ValidityPeriod validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        @Override
        public CertificateValidity build() {
            return new CertificateValidity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
