/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary description of the Amazon Web Services Private CA AD connectors belonging to an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorSummary.Builder, ConnectorSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ConnectorSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(ConnectorSummary::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> CERTIFICATE_ENROLLMENT_POLICY_SERVER_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateEnrollmentPolicyServerEndpoint")
            .getter(getter(ConnectorSummary::certificateEnrollmentPolicyServerEndpoint))
            .setter(setter(Builder::certificateEnrollmentPolicyServerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CertificateEnrollmentPolicyServerEndpoint").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ConnectorSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ConnectorSummary::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ConnectorSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ConnectorSummary::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ConnectorSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<VpcInformation> VPC_INFORMATION_FIELD = SdkField
            .<VpcInformation> builder(MarshallingType.SDK_POJO).memberName("VpcInformation")
            .getter(getter(ConnectorSummary::vpcInformation)).setter(setter(Builder::vpcInformation))
            .constructor(VpcInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_ENROLLMENT_POLICY_SERVER_ENDPOINT_FIELD, CREATED_AT_FIELD,
            DIRECTORY_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD, VPC_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String certificateAuthorityArn;

    private final String certificateEnrollmentPolicyServerEndpoint;

    private final Instant createdAt;

    private final String directoryId;

    private final String status;

    private final String statusReason;

    private final Instant updatedAt;

    private final VpcInformation vpcInformation;

    private ConnectorSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificateEnrollmentPolicyServerEndpoint = builder.certificateEnrollmentPolicyServerEndpoint;
        this.createdAt = builder.createdAt;
        this.directoryId = builder.directoryId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
        this.vpcInformation = builder.vpcInformation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     * >CreateConnector</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     *         >CreateConnector</a>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate authority being used.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate authority being used.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * Certificate enrollment endpoint for Active Directory domain-joined objects to request certificates.
     * </p>
     * 
     * @return Certificate enrollment endpoint for Active Directory domain-joined objects to request certificates.
     */
    public final String certificateEnrollmentPolicyServerEndpoint() {
        return certificateEnrollmentPolicyServerEndpoint;
    }

    /**
     * <p>
     * The date and time that the connector was created.
     * </p>
     * 
     * @return The date and time that the connector was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the Active Directory.
     * </p>
     * 
     * @return The identifier of the Active Directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * Status of the connector. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the connector. Status can be creating, active, deleting, or failed.
     * @see ConnectorStatus
     */
    public final ConnectorStatus status() {
        return ConnectorStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the connector. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the connector. Status can be creating, active, deleting, or failed.
     * @see ConnectorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the connector status if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ConnectorStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information about the connector status if the status is failed.
     * @see ConnectorStatusReason
     */
    public final ConnectorStatusReason statusReason() {
        return ConnectorStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * Additional information about the connector status if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ConnectorStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information about the connector status if the status is failed.
     * @see ConnectorStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time that the connector was updated.
     * </p>
     * 
     * @return The date and time that the connector was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Information of the VPC and security group(s) used with the connector.
     * </p>
     * 
     * @return Information of the VPC and security group(s) used with the connector.
     */
    public final VpcInformation vpcInformation() {
        return vpcInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateEnrollmentPolicyServerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSummary)) {
            return false;
        }
        ConnectorSummary other = (ConnectorSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(certificateEnrollmentPolicyServerEndpoint(), other.certificateEnrollmentPolicyServerEndpoint())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(vpcInformation(), other.vpcInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorSummary").add("Arn", arn()).add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("CertificateEnrollmentPolicyServerEndpoint", certificateEnrollmentPolicyServerEndpoint())
                .add("CreatedAt", createdAt()).add("DirectoryId", directoryId()).add("Status", statusAsString())
                .add("StatusReason", statusReasonAsString()).add("UpdatedAt", updatedAt())
                .add("VpcInformation", vpcInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "CertificateEnrollmentPolicyServerEndpoint":
            return Optional.ofNullable(clazz.cast(certificateEnrollmentPolicyServerEndpoint()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "VpcInformation":
            return Optional.ofNullable(clazz.cast(vpcInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("CertificateEnrollmentPolicyServerEndpoint", CERTIFICATE_ENROLLMENT_POLICY_SERVER_ENDPOINT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("VpcInformation", VPC_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSummary, T> g) {
        return obj -> g.apply((ConnectorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         * >CreateConnector</a>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         *        >CreateConnector</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate authority being used.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) of the certificate authority being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * Certificate enrollment endpoint for Active Directory domain-joined objects to request certificates.
         * </p>
         * 
         * @param certificateEnrollmentPolicyServerEndpoint
         *        Certificate enrollment endpoint for Active Directory domain-joined objects to request certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateEnrollmentPolicyServerEndpoint(String certificateEnrollmentPolicyServerEndpoint);

        /**
         * <p>
         * The date and time that the connector was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the connector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the Active Directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * Status of the connector. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        Status of the connector. Status can be creating, active, deleting, or failed.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the connector. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        Status of the connector. Status can be creating, active, deleting, or failed.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(ConnectorStatus status);

        /**
         * <p>
         * Additional information about the connector status if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the connector status if the status is failed.
         * @see ConnectorStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Additional information about the connector status if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the connector status if the status is failed.
         * @see ConnectorStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatusReason
         */
        Builder statusReason(ConnectorStatusReason statusReason);

        /**
         * <p>
         * The date and time that the connector was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the connector was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Information of the VPC and security group(s) used with the connector.
         * </p>
         * 
         * @param vpcInformation
         *        Information of the VPC and security group(s) used with the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInformation(VpcInformation vpcInformation);

        /**
         * <p>
         * Information of the VPC and security group(s) used with the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcInformation.Builder} avoiding the need
         * to create one manually via {@link VpcInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcInformation(VpcInformation)}.
         * 
         * @param vpcInformation
         *        a consumer that will call methods on {@link VpcInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInformation(VpcInformation)
         */
        default Builder vpcInformation(Consumer<VpcInformation.Builder> vpcInformation) {
            return vpcInformation(VpcInformation.builder().applyMutation(vpcInformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String certificateAuthorityArn;

        private String certificateEnrollmentPolicyServerEndpoint;

        private Instant createdAt;

        private String directoryId;

        private String status;

        private String statusReason;

        private Instant updatedAt;

        private VpcInformation vpcInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSummary model) {
            arn(model.arn);
            certificateAuthorityArn(model.certificateAuthorityArn);
            certificateEnrollmentPolicyServerEndpoint(model.certificateEnrollmentPolicyServerEndpoint);
            createdAt(model.createdAt);
            directoryId(model.directoryId);
            status(model.status);
            statusReason(model.statusReason);
            updatedAt(model.updatedAt);
            vpcInformation(model.vpcInformation);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCertificateEnrollmentPolicyServerEndpoint() {
            return certificateEnrollmentPolicyServerEndpoint;
        }

        public final void setCertificateEnrollmentPolicyServerEndpoint(String certificateEnrollmentPolicyServerEndpoint) {
            this.certificateEnrollmentPolicyServerEndpoint = certificateEnrollmentPolicyServerEndpoint;
        }

        @Override
        public final Builder certificateEnrollmentPolicyServerEndpoint(String certificateEnrollmentPolicyServerEndpoint) {
            this.certificateEnrollmentPolicyServerEndpoint = certificateEnrollmentPolicyServerEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ConnectorStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final VpcInformation.Builder getVpcInformation() {
            return vpcInformation != null ? vpcInformation.toBuilder() : null;
        }

        public final void setVpcInformation(VpcInformation.BuilderImpl vpcInformation) {
            this.vpcInformation = vpcInformation != null ? vpcInformation.build() : null;
        }

        @Override
        public final Builder vpcInformation(VpcInformation vpcInformation) {
            this.vpcInformation = vpcInformation;
            return this;
        }

        @Override
        public ConnectorSummary build() {
            return new ConnectorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
