/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Certificate extensions for v3 template schema
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtensionsV3 implements SdkPojo, Serializable, ToCopyableBuilder<ExtensionsV3.Builder, ExtensionsV3> {
    private static final SdkField<ApplicationPolicies> APPLICATION_POLICIES_FIELD = SdkField
            .<ApplicationPolicies> builder(MarshallingType.SDK_POJO).memberName("ApplicationPolicies")
            .getter(getter(ExtensionsV3::applicationPolicies)).setter(setter(Builder::applicationPolicies))
            .constructor(ApplicationPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationPolicies").build())
            .build();

    private static final SdkField<KeyUsage> KEY_USAGE_FIELD = SdkField.<KeyUsage> builder(MarshallingType.SDK_POJO)
            .memberName("KeyUsage").getter(getter(ExtensionsV3::keyUsage)).setter(setter(Builder::keyUsage))
            .constructor(KeyUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_POLICIES_FIELD,
            KEY_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ApplicationPolicies applicationPolicies;

    private final KeyUsage keyUsage;

    private ExtensionsV3(BuilderImpl builder) {
        this.applicationPolicies = builder.applicationPolicies;
        this.keyUsage = builder.keyUsage;
    }

    /**
     * <p>
     * Application policies specify what the certificate is used for and its purpose.
     * </p>
     * 
     * @return Application policies specify what the certificate is used for and its purpose.
     */
    public final ApplicationPolicies applicationPolicies() {
        return applicationPolicies;
    }

    /**
     * <p>
     * The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key
     * contained in the certificate.
     * </p>
     * 
     * @return The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the
     *         key contained in the certificate.
     */
    public final KeyUsage keyUsage() {
        return keyUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(keyUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionsV3)) {
            return false;
        }
        ExtensionsV3 other = (ExtensionsV3) obj;
        return Objects.equals(applicationPolicies(), other.applicationPolicies()) && Objects.equals(keyUsage(), other.keyUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtensionsV3").add("ApplicationPolicies", applicationPolicies()).add("KeyUsage", keyUsage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationPolicies":
            return Optional.ofNullable(clazz.cast(applicationPolicies()));
        case "KeyUsage":
            return Optional.ofNullable(clazz.cast(keyUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationPolicies", APPLICATION_POLICIES_FIELD);
        map.put("KeyUsage", KEY_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtensionsV3, T> g) {
        return obj -> g.apply((ExtensionsV3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtensionsV3> {
        /**
         * <p>
         * Application policies specify what the certificate is used for and its purpose.
         * </p>
         * 
         * @param applicationPolicies
         *        Application policies specify what the certificate is used for and its purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPolicies(ApplicationPolicies applicationPolicies);

        /**
         * <p>
         * Application policies specify what the certificate is used for and its purpose.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationPolicies.Builder} avoiding the
         * need to create one manually via {@link ApplicationPolicies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationPolicies.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationPolicies(ApplicationPolicies)}.
         * 
         * @param applicationPolicies
         *        a consumer that will call methods on {@link ApplicationPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationPolicies(ApplicationPolicies)
         */
        default Builder applicationPolicies(Consumer<ApplicationPolicies.Builder> applicationPolicies) {
            return applicationPolicies(ApplicationPolicies.builder().applyMutation(applicationPolicies).build());
        }

        /**
         * <p>
         * The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key
         * contained in the certificate.
         * </p>
         * 
         * @param keyUsage
         *        The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of
         *        the key contained in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsage(KeyUsage keyUsage);

        /**
         * <p>
         * The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key
         * contained in the certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyUsage.Builder} avoiding the need to
         * create one manually via {@link KeyUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyUsage.Builder#build()} is called immediately and its result is
         * passed to {@link #keyUsage(KeyUsage)}.
         * 
         * @param keyUsage
         *        a consumer that will call methods on {@link KeyUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyUsage(KeyUsage)
         */
        default Builder keyUsage(Consumer<KeyUsage.Builder> keyUsage) {
            return keyUsage(KeyUsage.builder().applyMutation(keyUsage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApplicationPolicies applicationPolicies;

        private KeyUsage keyUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtensionsV3 model) {
            applicationPolicies(model.applicationPolicies);
            keyUsage(model.keyUsage);
        }

        public final ApplicationPolicies.Builder getApplicationPolicies() {
            return applicationPolicies != null ? applicationPolicies.toBuilder() : null;
        }

        public final void setApplicationPolicies(ApplicationPolicies.BuilderImpl applicationPolicies) {
            this.applicationPolicies = applicationPolicies != null ? applicationPolicies.build() : null;
        }

        @Override
        public final Builder applicationPolicies(ApplicationPolicies applicationPolicies) {
            this.applicationPolicies = applicationPolicies;
            return this;
        }

        public final KeyUsage.Builder getKeyUsage() {
            return keyUsage != null ? keyUsage.toBuilder() : null;
        }

        public final void setKeyUsage(KeyUsage.BuilderImpl keyUsage) {
            this.keyUsage = keyUsage != null ? keyUsage.build() : null;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public ExtensionsV3 build() {
            return new ExtensionsV3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
