/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDirectoryRegistrationResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<GetDirectoryRegistrationResponse.Builder, GetDirectoryRegistrationResponse> {
    private static final SdkField<DirectoryRegistration> DIRECTORY_REGISTRATION_FIELD = SdkField
            .<DirectoryRegistration> builder(MarshallingType.SDK_POJO).memberName("DirectoryRegistration")
            .getter(getter(GetDirectoryRegistrationResponse::directoryRegistration))
            .setter(setter(Builder::directoryRegistration)).constructor(DirectoryRegistration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_REGISTRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DirectoryRegistration directoryRegistration;

    private GetDirectoryRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.directoryRegistration = builder.directoryRegistration;
    }

    /**
     * <p>
     * The directory registration represents the authorization of the connector service with a directory.
     * </p>
     * 
     * @return The directory registration represents the authorization of the connector service with a directory.
     */
    public final DirectoryRegistration directoryRegistration() {
        return directoryRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryRegistration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDirectoryRegistrationResponse)) {
            return false;
        }
        GetDirectoryRegistrationResponse other = (GetDirectoryRegistrationResponse) obj;
        return Objects.equals(directoryRegistration(), other.directoryRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDirectoryRegistrationResponse").add("DirectoryRegistration", directoryRegistration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryRegistration":
            return Optional.ofNullable(clazz.cast(directoryRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryRegistration", DIRECTORY_REGISTRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDirectoryRegistrationResponse, T> g) {
        return obj -> g.apply((GetDirectoryRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDirectoryRegistrationResponse> {
        /**
         * <p>
         * The directory registration represents the authorization of the connector service with a directory.
         * </p>
         * 
         * @param directoryRegistration
         *        The directory registration represents the authorization of the connector service with a directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistration(DirectoryRegistration directoryRegistration);

        /**
         * <p>
         * The directory registration represents the authorization of the connector service with a directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectoryRegistration.Builder} avoiding
         * the need to create one manually via {@link DirectoryRegistration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryRegistration.Builder#build()} is called immediately and
         * its result is passed to {@link #directoryRegistration(DirectoryRegistration)}.
         * 
         * @param directoryRegistration
         *        a consumer that will call methods on {@link DirectoryRegistration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryRegistration(DirectoryRegistration)
         */
        default Builder directoryRegistration(Consumer<DirectoryRegistration.Builder> directoryRegistration) {
            return directoryRegistration(DirectoryRegistration.builder().applyMutation(directoryRegistration).build());
        }
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private DirectoryRegistration directoryRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDirectoryRegistrationResponse model) {
            super(model);
            directoryRegistration(model.directoryRegistration);
        }

        public final DirectoryRegistration.Builder getDirectoryRegistration() {
            return directoryRegistration != null ? directoryRegistration.toBuilder() : null;
        }

        public final void setDirectoryRegistration(DirectoryRegistration.BuilderImpl directoryRegistration) {
            this.directoryRegistration = directoryRegistration != null ? directoryRegistration.build() : null;
        }

        @Override
        public final Builder directoryRegistration(DirectoryRegistration directoryRegistration) {
            this.directoryRegistration = directoryRegistration;
            return this;
        }

        @Override
        public GetDirectoryRegistrationResponse build() {
            return new GetDirectoryRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
