/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateGroupAccessControlEntryResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<GetTemplateGroupAccessControlEntryResponse.Builder, GetTemplateGroupAccessControlEntryResponse> {
    private static final SdkField<AccessControlEntry> ACCESS_CONTROL_ENTRY_FIELD = SdkField
            .<AccessControlEntry> builder(MarshallingType.SDK_POJO).memberName("AccessControlEntry")
            .getter(getter(GetTemplateGroupAccessControlEntryResponse::accessControlEntry))
            .setter(setter(Builder::accessControlEntry)).constructor(AccessControlEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlEntry").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccessControlEntry accessControlEntry;

    private GetTemplateGroupAccessControlEntryResponse(BuilderImpl builder) {
        super(builder);
        this.accessControlEntry = builder.accessControlEntry;
    }

    /**
     * <p>
     * An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling with a
     * template.
     * </p>
     * 
     * @return An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling
     *         with a template.
     */
    public final AccessControlEntry accessControlEntry() {
        return accessControlEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessControlEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateGroupAccessControlEntryResponse)) {
            return false;
        }
        GetTemplateGroupAccessControlEntryResponse other = (GetTemplateGroupAccessControlEntryResponse) obj;
        return Objects.equals(accessControlEntry(), other.accessControlEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateGroupAccessControlEntryResponse").add("AccessControlEntry", accessControlEntry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlEntry":
            return Optional.ofNullable(clazz.cast(accessControlEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessControlEntry", ACCESS_CONTROL_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateGroupAccessControlEntryResponse, T> g) {
        return obj -> g.apply((GetTemplateGroupAccessControlEntryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemplateGroupAccessControlEntryResponse> {
        /**
         * <p>
         * An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling with a
         * template.
         * </p>
         * 
         * @param accessControlEntry
         *        An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling
         *        with a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlEntry(AccessControlEntry accessControlEntry);

        /**
         * <p>
         * An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling with a
         * template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessControlEntry.Builder} avoiding the
         * need to create one manually via {@link AccessControlEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessControlEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #accessControlEntry(AccessControlEntry)}.
         * 
         * @param accessControlEntry
         *        a consumer that will call methods on {@link AccessControlEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlEntry(AccessControlEntry)
         */
        default Builder accessControlEntry(Consumer<AccessControlEntry.Builder> accessControlEntry) {
            return accessControlEntry(AccessControlEntry.builder().applyMutation(accessControlEntry).build());
        }
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private AccessControlEntry accessControlEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateGroupAccessControlEntryResponse model) {
            super(model);
            accessControlEntry(model.accessControlEntry);
        }

        public final AccessControlEntry.Builder getAccessControlEntry() {
            return accessControlEntry != null ? accessControlEntry.toBuilder() : null;
        }

        public final void setAccessControlEntry(AccessControlEntry.BuilderImpl accessControlEntry) {
            this.accessControlEntry = accessControlEntry != null ? accessControlEntry.build() : null;
        }

        @Override
        public final Builder accessControlEntry(AccessControlEntry accessControlEntry) {
            this.accessControlEntry = accessControlEntry;
            return this;
        }

        @Override
        public GetTemplateGroupAccessControlEntryResponse build() {
            return new GetTemplateGroupAccessControlEntryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
