/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyUsageFlags implements SdkPojo, Serializable, ToCopyableBuilder<KeyUsageFlags.Builder, KeyUsageFlags> {
    private static final SdkField<Boolean> DATA_ENCIPHERMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataEncipherment").getter(getter(KeyUsageFlags::dataEncipherment))
            .setter(setter(Builder::dataEncipherment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncipherment").build()).build();

    private static final SdkField<Boolean> DIGITAL_SIGNATURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DigitalSignature").getter(getter(KeyUsageFlags::digitalSignature))
            .setter(setter(Builder::digitalSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignature").build()).build();

    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyAgreement").getter(getter(KeyUsageFlags::keyAgreement)).setter(setter(Builder::keyAgreement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()).build();

    private static final SdkField<Boolean> KEY_ENCIPHERMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyEncipherment").getter(getter(KeyUsageFlags::keyEncipherment))
            .setter(setter(Builder::keyEncipherment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyEncipherment").build()).build();

    private static final SdkField<Boolean> NON_REPUDIATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NonRepudiation").getter(getter(KeyUsageFlags::nonRepudiation)).setter(setter(Builder::nonRepudiation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRepudiation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ENCIPHERMENT_FIELD,
            DIGITAL_SIGNATURE_FIELD, KEY_AGREEMENT_FIELD, KEY_ENCIPHERMENT_FIELD, NON_REPUDIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean dataEncipherment;

    private final Boolean digitalSignature;

    private final Boolean keyAgreement;

    private final Boolean keyEncipherment;

    private final Boolean nonRepudiation;

    private KeyUsageFlags(BuilderImpl builder) {
        this.dataEncipherment = builder.dataEncipherment;
        this.digitalSignature = builder.digitalSignature;
        this.keyAgreement = builder.keyAgreement;
        this.keyEncipherment = builder.keyEncipherment;
        this.nonRepudiation = builder.nonRepudiation;
    }

    /**
     * <p>
     * DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data without
     * the use of an intermediate symmetric cipher.
     * </p>
     * 
     * @return DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data
     *         without the use of an intermediate symmetric cipher.
     */
    public final Boolean dataEncipherment() {
        return dataEncipherment;
    }

    /**
     * <p>
     * The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
     * </p>
     * 
     * @return The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
     */
    public final Boolean digitalSignature() {
        return digitalSignature;
    }

    /**
     * <p>
     * KeyAgreement is asserted when the subject public key is used for key agreement.
     * </p>
     * 
     * @return KeyAgreement is asserted when the subject public key is used for key agreement.
     */
    public final Boolean keyAgreement() {
        return keyAgreement;
    }

    /**
     * <p>
     * KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e., for
     * key transport.
     * </p>
     * 
     * @return KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys,
     *         i.e., for key transport.
     */
    public final Boolean keyEncipherment() {
        return keyEncipherment;
    }

    /**
     * <p>
     * NonRepudiation is asserted when the subject public key is used to verify digital signatures.
     * </p>
     * 
     * @return NonRepudiation is asserted when the subject public key is used to verify digital signatures.
     */
    public final Boolean nonRepudiation() {
        return nonRepudiation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(digitalSignature());
        hashCode = 31 * hashCode + Objects.hashCode(keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(keyEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(nonRepudiation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsageFlags)) {
            return false;
        }
        KeyUsageFlags other = (KeyUsageFlags) obj;
        return Objects.equals(dataEncipherment(), other.dataEncipherment())
                && Objects.equals(digitalSignature(), other.digitalSignature())
                && Objects.equals(keyAgreement(), other.keyAgreement())
                && Objects.equals(keyEncipherment(), other.keyEncipherment())
                && Objects.equals(nonRepudiation(), other.nonRepudiation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyUsageFlags").add("DataEncipherment", dataEncipherment())
                .add("DigitalSignature", digitalSignature()).add("KeyAgreement", keyAgreement())
                .add("KeyEncipherment", keyEncipherment()).add("NonRepudiation", nonRepudiation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataEncipherment":
            return Optional.ofNullable(clazz.cast(dataEncipherment()));
        case "DigitalSignature":
            return Optional.ofNullable(clazz.cast(digitalSignature()));
        case "KeyAgreement":
            return Optional.ofNullable(clazz.cast(keyAgreement()));
        case "KeyEncipherment":
            return Optional.ofNullable(clazz.cast(keyEncipherment()));
        case "NonRepudiation":
            return Optional.ofNullable(clazz.cast(nonRepudiation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataEncipherment", DATA_ENCIPHERMENT_FIELD);
        map.put("DigitalSignature", DIGITAL_SIGNATURE_FIELD);
        map.put("KeyAgreement", KEY_AGREEMENT_FIELD);
        map.put("KeyEncipherment", KEY_ENCIPHERMENT_FIELD);
        map.put("NonRepudiation", NON_REPUDIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsageFlags, T> g) {
        return obj -> g.apply((KeyUsageFlags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyUsageFlags> {
        /**
         * <p>
         * DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data
         * without the use of an intermediate symmetric cipher.
         * </p>
         * 
         * @param dataEncipherment
         *        DataEncipherment is asserted when the subject public key is used for directly enciphering raw user
         *        data without the use of an intermediate symmetric cipher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncipherment(Boolean dataEncipherment);

        /**
         * <p>
         * The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
         * </p>
         * 
         * @param digitalSignature
         *        The digitalSignature is asserted when the subject public key is used for verifying digital signatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digitalSignature(Boolean digitalSignature);

        /**
         * <p>
         * KeyAgreement is asserted when the subject public key is used for key agreement.
         * </p>
         * 
         * @param keyAgreement
         *        KeyAgreement is asserted when the subject public key is used for key agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAgreement(Boolean keyAgreement);

        /**
         * <p>
         * KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e.,
         * for key transport.
         * </p>
         * 
         * @param keyEncipherment
         *        KeyEncipherment is asserted when the subject public key is used for enciphering private or secret
         *        keys, i.e., for key transport.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyEncipherment(Boolean keyEncipherment);

        /**
         * <p>
         * NonRepudiation is asserted when the subject public key is used to verify digital signatures.
         * </p>
         * 
         * @param nonRepudiation
         *        NonRepudiation is asserted when the subject public key is used to verify digital signatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonRepudiation(Boolean nonRepudiation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean dataEncipherment;

        private Boolean digitalSignature;

        private Boolean keyAgreement;

        private Boolean keyEncipherment;

        private Boolean nonRepudiation;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsageFlags model) {
            dataEncipherment(model.dataEncipherment);
            digitalSignature(model.digitalSignature);
            keyAgreement(model.keyAgreement);
            keyEncipherment(model.keyEncipherment);
            nonRepudiation(model.nonRepudiation);
        }

        public final Boolean getDataEncipherment() {
            return dataEncipherment;
        }

        public final void setDataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
        }

        @Override
        public final Builder dataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
            return this;
        }

        public final Boolean getDigitalSignature() {
            return digitalSignature;
        }

        public final void setDigitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
        }

        @Override
        public final Builder digitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
            return this;
        }

        public final Boolean getKeyAgreement() {
            return keyAgreement;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final Boolean getKeyEncipherment() {
            return keyEncipherment;
        }

        public final void setKeyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
        }

        @Override
        public final Builder keyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
            return this;
        }

        public final Boolean getNonRepudiation() {
            return nonRepudiation;
        }

        public final void setNonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
        }

        @Override
        public final Builder nonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
            return this;
        }

        @Override
        public KeyUsageFlags build() {
            return new KeyUsageFlags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
