/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The key usage property defines the purpose of the private key contained in the certificate. You can specify specific
 * purposes using property flags or all by using property type ALL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyUsageProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyUsageProperty.Builder, KeyUsageProperty> {
    private static final SdkField<KeyUsagePropertyFlags> PROPERTY_FLAGS_FIELD = SdkField
            .<KeyUsagePropertyFlags> builder(MarshallingType.SDK_POJO).memberName("PropertyFlags")
            .getter(getter(KeyUsageProperty::propertyFlags)).setter(setter(Builder::propertyFlags))
            .constructor(KeyUsagePropertyFlags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFlags").build()).build();

    private static final SdkField<String> PROPERTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyType").getter(getter(KeyUsageProperty::propertyTypeAsString))
            .setter(setter(Builder::propertyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_FLAGS_FIELD,
            PROPERTY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KeyUsagePropertyFlags propertyFlags;

    private final String propertyType;

    private final Type type;

    private KeyUsageProperty(BuilderImpl builder) {
        this.propertyFlags = builder.propertyFlags;
        this.propertyType = builder.propertyType;
        this.type = builder.type;
    }

    /**
     * <p>
     * You can specify key usage for encryption, key agreement, and signature. You can use property flags or property
     * type but not both.
     * </p>
     * 
     * @return You can specify key usage for encryption, key agreement, and signature. You can use property flags or
     *         property type but not both.
     */
    public final KeyUsagePropertyFlags propertyFlags() {
        return propertyFlags;
    }

    /**
     * <p>
     * You can specify all key usages using property type ALL. You can use property type or property flags but not both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyType} will
     * return {@link KeyUsagePropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #propertyTypeAsString}.
     * </p>
     * 
     * @return You can specify all key usages using property type ALL. You can use property type or property flags but
     *         not both.
     * @see KeyUsagePropertyType
     */
    public final KeyUsagePropertyType propertyType() {
        return KeyUsagePropertyType.fromValue(propertyType);
    }

    /**
     * <p>
     * You can specify all key usages using property type ALL. You can use property type or property flags but not both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyType} will
     * return {@link KeyUsagePropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #propertyTypeAsString}.
     * </p>
     * 
     * @return You can specify all key usages using property type ALL. You can use property type or property flags but
     *         not both.
     * @see KeyUsagePropertyType
     */
    public final String propertyTypeAsString() {
        return propertyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(propertyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsageProperty)) {
            return false;
        }
        KeyUsageProperty other = (KeyUsageProperty) obj;
        return Objects.equals(propertyFlags(), other.propertyFlags())
                && Objects.equals(propertyTypeAsString(), other.propertyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyUsageProperty").add("PropertyFlags", propertyFlags())
                .add("PropertyType", propertyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyFlags":
            return Optional.ofNullable(clazz.cast(propertyFlags()));
        case "PropertyType":
            return Optional.ofNullable(clazz.cast(propertyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #propertyFlags()} initialized to the given value.
     *
     * <p>
     * You can specify key usage for encryption, key agreement, and signature. You can use property flags or property
     * type but not both.
     * </p>
     * 
     * @param propertyFlags
     *        You can specify key usage for encryption, key agreement, and signature. You can use property flags or
     *        property type but not both.
     */
    public static KeyUsageProperty fromPropertyFlags(KeyUsagePropertyFlags propertyFlags) {
        return builder().propertyFlags(propertyFlags).build();
    }

    /**
     * Create an instance of this class with {@link #propertyFlags()} initialized to the given value.
     *
     * <p>
     * You can specify key usage for encryption, key agreement, and signature. You can use property flags or property
     * type but not both.
     * </p>
     * 
     * @param propertyFlags
     *        You can specify key usage for encryption, key agreement, and signature. You can use property flags or
     *        property type but not both.
     */
    public static KeyUsageProperty fromPropertyFlags(Consumer<KeyUsagePropertyFlags.Builder> propertyFlags) {
        KeyUsagePropertyFlags.Builder builder = KeyUsagePropertyFlags.builder();
        propertyFlags.accept(builder);
        return fromPropertyFlags(builder.build());
    }

    /**
     * Create an instance of this class with {@link #propertyTypeAsString()} initialized to the given value.
     *
     * <p>
     * You can specify all key usages using property type ALL. You can use property type or property flags but not both.
     * </p>
     * 
     * @param propertyType
     *        You can specify all key usages using property type ALL. You can use property type or property flags but
     *        not both.
     * @see KeyUsagePropertyType
     */
    public static KeyUsageProperty fromPropertyType(String propertyType) {
        return builder().propertyType(propertyType).build();
    }

    /**
     * Create an instance of this class with {@link #propertyTypeAsString()} initialized to the given value.
     *
     * <p>
     * You can specify all key usages using property type ALL. You can use property type or property flags but not both.
     * </p>
     * 
     * @param propertyType
     *        You can specify all key usages using property type ALL. You can use property type or property flags but
     *        not both.
     * @see KeyUsagePropertyType
     */
    public static KeyUsageProperty fromPropertyType(KeyUsagePropertyType propertyType) {
        return builder().propertyType(propertyType).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PropertyFlags", PROPERTY_FLAGS_FIELD);
        map.put("PropertyType", PROPERTY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsageProperty, T> g) {
        return obj -> g.apply((KeyUsageProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyUsageProperty> {
        /**
         * <p>
         * You can specify key usage for encryption, key agreement, and signature. You can use property flags or
         * property type but not both.
         * </p>
         * 
         * @param propertyFlags
         *        You can specify key usage for encryption, key agreement, and signature. You can use property flags or
         *        property type but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFlags(KeyUsagePropertyFlags propertyFlags);

        /**
         * <p>
         * You can specify key usage for encryption, key agreement, and signature. You can use property flags or
         * property type but not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyUsagePropertyFlags.Builder} avoiding
         * the need to create one manually via {@link KeyUsagePropertyFlags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyUsagePropertyFlags.Builder#build()} is called immediately and
         * its result is passed to {@link #propertyFlags(KeyUsagePropertyFlags)}.
         * 
         * @param propertyFlags
         *        a consumer that will call methods on {@link KeyUsagePropertyFlags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyFlags(KeyUsagePropertyFlags)
         */
        default Builder propertyFlags(Consumer<KeyUsagePropertyFlags.Builder> propertyFlags) {
            return propertyFlags(KeyUsagePropertyFlags.builder().applyMutation(propertyFlags).build());
        }

        /**
         * <p>
         * You can specify all key usages using property type ALL. You can use property type or property flags but not
         * both.
         * </p>
         * 
         * @param propertyType
         *        You can specify all key usages using property type ALL. You can use property type or property flags
         *        but not both.
         * @see KeyUsagePropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsagePropertyType
         */
        Builder propertyType(String propertyType);

        /**
         * <p>
         * You can specify all key usages using property type ALL. You can use property type or property flags but not
         * both.
         * </p>
         * 
         * @param propertyType
         *        You can specify all key usages using property type ALL. You can use property type or property flags
         *        but not both.
         * @see KeyUsagePropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyUsagePropertyType
         */
        Builder propertyType(KeyUsagePropertyType propertyType);
    }

    static final class BuilderImpl implements Builder {
        private KeyUsagePropertyFlags propertyFlags;

        private String propertyType;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsageProperty model) {
            propertyFlags(model.propertyFlags);
            propertyType(model.propertyType);
        }

        public final KeyUsagePropertyFlags.Builder getPropertyFlags() {
            return propertyFlags != null ? propertyFlags.toBuilder() : null;
        }

        public final void setPropertyFlags(KeyUsagePropertyFlags.BuilderImpl propertyFlags) {
            Object oldValue = this.propertyFlags;
            this.propertyFlags = propertyFlags != null ? propertyFlags.build() : null;
            handleUnionValueChange(Type.PROPERTY_FLAGS, oldValue, this.propertyFlags);
        }

        @Override
        public final Builder propertyFlags(KeyUsagePropertyFlags propertyFlags) {
            Object oldValue = this.propertyFlags;
            this.propertyFlags = propertyFlags;
            handleUnionValueChange(Type.PROPERTY_FLAGS, oldValue, this.propertyFlags);
            return this;
        }

        public final String getPropertyType() {
            return propertyType;
        }

        public final void setPropertyType(String propertyType) {
            Object oldValue = this.propertyType;
            this.propertyType = propertyType;
            handleUnionValueChange(Type.PROPERTY_TYPE, oldValue, this.propertyType);
        }

        @Override
        public final Builder propertyType(String propertyType) {
            Object oldValue = this.propertyType;
            this.propertyType = propertyType;
            handleUnionValueChange(Type.PROPERTY_TYPE, oldValue, this.propertyType);
            return this;
        }

        @Override
        public final Builder propertyType(KeyUsagePropertyType propertyType) {
            this.propertyType(propertyType == null ? null : propertyType.toString());
            return this;
        }

        @Override
        public KeyUsageProperty build() {
            return new KeyUsageProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see KeyUsageProperty#type()
     */
    public enum Type {
        PROPERTY_FLAGS,

        PROPERTY_TYPE,

        UNKNOWN_TO_SDK_VERSION
    }
}
