/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allow or deny permissions for an Active Directory group to enroll or autoenroll certificates for a template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessRights implements SdkPojo, Serializable, ToCopyableBuilder<AccessRights.Builder, AccessRights> {
    private static final SdkField<String> AUTO_ENROLL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEnroll").getter(getter(AccessRights::autoEnrollAsString)).setter(setter(Builder::autoEnroll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnroll").build()).build();

    private static final SdkField<String> ENROLL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Enroll")
            .getter(getter(AccessRights::enrollAsString)).setter(setter(Builder::enroll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enroll").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENROLL_FIELD,
            ENROLL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autoEnroll;

    private final String enroll;

    private AccessRights(BuilderImpl builder) {
        this.autoEnroll = builder.autoEnroll;
        this.enroll = builder.enroll;
    }

    /**
     * <p>
     * Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The Active
     * Directory group must be allowed to enroll to allow autoenrollment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnroll} will
     * return {@link AccessRight#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnrollAsString}.
     * </p>
     * 
     * @return Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The
     *         Active Directory group must be allowed to enroll to allow autoenrollment
     * @see AccessRight
     */
    public final AccessRight autoEnroll() {
        return AccessRight.fromValue(autoEnroll);
    }

    /**
     * <p>
     * Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The Active
     * Directory group must be allowed to enroll to allow autoenrollment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnroll} will
     * return {@link AccessRight#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnrollAsString}.
     * </p>
     * 
     * @return Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The
     *         Active Directory group must be allowed to enroll to allow autoenrollment
     * @see AccessRight
     */
    public final String autoEnrollAsString() {
        return autoEnroll;
    }

    /**
     * <p>
     * Allow or deny an Active Directory group from enrolling certificates issued against a template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enroll} will
     * return {@link AccessRight#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enrollAsString}.
     * </p>
     * 
     * @return Allow or deny an Active Directory group from enrolling certificates issued against a template.
     * @see AccessRight
     */
    public final AccessRight enroll() {
        return AccessRight.fromValue(enroll);
    }

    /**
     * <p>
     * Allow or deny an Active Directory group from enrolling certificates issued against a template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enroll} will
     * return {@link AccessRight#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enrollAsString}.
     * </p>
     * 
     * @return Allow or deny an Active Directory group from enrolling certificates issued against a template.
     * @see AccessRight
     */
    public final String enrollAsString() {
        return enroll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoEnrollAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enrollAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessRights)) {
            return false;
        }
        AccessRights other = (AccessRights) obj;
        return Objects.equals(autoEnrollAsString(), other.autoEnrollAsString())
                && Objects.equals(enrollAsString(), other.enrollAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessRights").add("AutoEnroll", autoEnrollAsString()).add("Enroll", enrollAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnroll":
            return Optional.ofNullable(clazz.cast(autoEnrollAsString()));
        case "Enroll":
            return Optional.ofNullable(clazz.cast(enrollAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoEnroll", AUTO_ENROLL_FIELD);
        map.put("Enroll", ENROLL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessRights, T> g) {
        return obj -> g.apply((AccessRights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessRights> {
        /**
         * <p>
         * Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The Active
         * Directory group must be allowed to enroll to allow autoenrollment
         * </p>
         * 
         * @param autoEnroll
         *        Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The
         *        Active Directory group must be allowed to enroll to allow autoenrollment
         * @see AccessRight
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRight
         */
        Builder autoEnroll(String autoEnroll);

        /**
         * <p>
         * Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The Active
         * Directory group must be allowed to enroll to allow autoenrollment
         * </p>
         * 
         * @param autoEnroll
         *        Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The
         *        Active Directory group must be allowed to enroll to allow autoenrollment
         * @see AccessRight
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRight
         */
        Builder autoEnroll(AccessRight autoEnroll);

        /**
         * <p>
         * Allow or deny an Active Directory group from enrolling certificates issued against a template.
         * </p>
         * 
         * @param enroll
         *        Allow or deny an Active Directory group from enrolling certificates issued against a template.
         * @see AccessRight
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRight
         */
        Builder enroll(String enroll);

        /**
         * <p>
         * Allow or deny an Active Directory group from enrolling certificates issued against a template.
         * </p>
         * 
         * @param enroll
         *        Allow or deny an Active Directory group from enrolling certificates issued against a template.
         * @see AccessRight
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRight
         */
        Builder enroll(AccessRight enroll);
    }

    static final class BuilderImpl implements Builder {
        private String autoEnroll;

        private String enroll;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessRights model) {
            autoEnroll(model.autoEnroll);
            enroll(model.enroll);
        }

        public final String getAutoEnroll() {
            return autoEnroll;
        }

        public final void setAutoEnroll(String autoEnroll) {
            this.autoEnroll = autoEnroll;
        }

        @Override
        public final Builder autoEnroll(String autoEnroll) {
            this.autoEnroll = autoEnroll;
            return this;
        }

        @Override
        public final Builder autoEnroll(AccessRight autoEnroll) {
            this.autoEnroll(autoEnroll == null ? null : autoEnroll.toString());
            return this;
        }

        public final String getEnroll() {
            return enroll;
        }

        public final void setEnroll(String enroll) {
            this.enroll = enroll;
        }

        @Override
        public final Builder enroll(String enroll) {
            this.enroll = enroll;
            return this;
        }

        @Override
        public final Builder enroll(AccessRight enroll) {
            this.enroll(enroll == null ? null : enroll.toString());
            return this;
        }

        @Override
        public AccessRights build() {
            return new AccessRights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
