/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectoryRegistrationResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<CreateDirectoryRegistrationResponse.Builder, CreateDirectoryRegistrationResponse> {
    private static final SdkField<String> DIRECTORY_REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryRegistrationArn").getter(getter(CreateDirectoryRegistrationResponse::directoryRegistrationArn))
            .setter(setter(Builder::directoryRegistrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistrationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECTORY_REGISTRATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryRegistrationArn;

    private CreateDirectoryRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.directoryRegistrationArn = builder.directoryRegistrationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     * >CreateDirectoryRegistration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     *         >CreateDirectoryRegistration</a>.
     */
    public final String directoryRegistrationArn() {
        return directoryRegistrationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryRegistrationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryRegistrationResponse)) {
            return false;
        }
        CreateDirectoryRegistrationResponse other = (CreateDirectoryRegistrationResponse) obj;
        return Objects.equals(directoryRegistrationArn(), other.directoryRegistrationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDirectoryRegistrationResponse")
                .add("DirectoryRegistrationArn", directoryRegistrationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryRegistrationArn":
            return Optional.ofNullable(clazz.cast(directoryRegistrationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryRegistrationArn", DIRECTORY_REGISTRATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryRegistrationResponse, T> g) {
        return obj -> g.apply((CreateDirectoryRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDirectoryRegistrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a href=
         * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         * >CreateDirectoryRegistration</a>.
         * </p>
         * 
         * @param directoryRegistrationArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a href=
         *        "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         *        >CreateDirectoryRegistration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistrationArn(String directoryRegistrationArn);
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private String directoryRegistrationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryRegistrationResponse model) {
            super(model);
            directoryRegistrationArn(model.directoryRegistrationArn);
        }

        public final String getDirectoryRegistrationArn() {
            return directoryRegistrationArn;
        }

        public final void setDirectoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
        }

        @Override
        public final Builder directoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
            return this;
        }

        @Override
        public CreateDirectoryRegistrationResponse build() {
            return new CreateDirectoryRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
