/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user
 * input is required when using a private key, and if an alternate signature algorithm should be used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateKeyFlagsV3 implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateKeyFlagsV3.Builder, PrivateKeyFlagsV3> {
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVersion").getter(getter(PrivateKeyFlagsV3::clientVersionAsString))
            .setter(setter(Builder::clientVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()).build();

    private static final SdkField<Boolean> EXPORTABLE_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExportableKey").getter(getter(PrivateKeyFlagsV3::exportableKey)).setter(setter(Builder::exportableKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableKey").build()).build();

    private static final SdkField<Boolean> REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireAlternateSignatureAlgorithm")
            .getter(getter(PrivateKeyFlagsV3::requireAlternateSignatureAlgorithm))
            .setter(setter(Builder::requireAlternateSignatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireAlternateSignatureAlgorithm")
                    .build()).build();

    private static final SdkField<Boolean> STRONG_KEY_PROTECTION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StrongKeyProtectionRequired")
            .getter(getter(PrivateKeyFlagsV3::strongKeyProtectionRequired))
            .setter(setter(Builder::strongKeyProtectionRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrongKeyProtectionRequired")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VERSION_FIELD,
            EXPORTABLE_KEY_FIELD, REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD, STRONG_KEY_PROTECTION_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientVersion;

    private final Boolean exportableKey;

    private final Boolean requireAlternateSignatureAlgorithm;

    private final Boolean strongKeyProtectionRequired;

    private PrivateKeyFlagsV3(BuilderImpl builder) {
        this.clientVersion = builder.clientVersion;
        this.exportableKey = builder.exportableKey;
        this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
        this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV3#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV3
     */
    public final ClientCompatibilityV3 clientVersion() {
        return ClientCompatibilityV3.fromValue(clientVersion);
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV3#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV3
     */
    public final String clientVersionAsString() {
        return clientVersion;
    }

    /**
     * <p>
     * Allows the private key to be exported.
     * </p>
     * 
     * @return Allows the private key to be exported.
     */
    public final Boolean exportableKey() {
        return exportableKey;
    }

    /**
     * <p>
     * Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
     * applications can accept this signature format.
     * </p>
     * 
     * @return Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
     *         applications can accept this signature format.
     */
    public final Boolean requireAlternateSignatureAlgorithm() {
        return requireAlternateSignatureAlgorithm;
    }

    /**
     * <p>
     * Requirer user input when using the private key for enrollment.
     * </p>
     * 
     * @return Requirer user input when using the private key for enrollment.
     */
    public final Boolean strongKeyProtectionRequired() {
        return strongKeyProtectionRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportableKey());
        hashCode = 31 * hashCode + Objects.hashCode(requireAlternateSignatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(strongKeyProtectionRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyFlagsV3)) {
            return false;
        }
        PrivateKeyFlagsV3 other = (PrivateKeyFlagsV3) obj;
        return Objects.equals(clientVersionAsString(), other.clientVersionAsString())
                && Objects.equals(exportableKey(), other.exportableKey())
                && Objects.equals(requireAlternateSignatureAlgorithm(), other.requireAlternateSignatureAlgorithm())
                && Objects.equals(strongKeyProtectionRequired(), other.strongKeyProtectionRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateKeyFlagsV3").add("ClientVersion", clientVersionAsString())
                .add("ExportableKey", exportableKey())
                .add("RequireAlternateSignatureAlgorithm", requireAlternateSignatureAlgorithm())
                .add("StrongKeyProtectionRequired", strongKeyProtectionRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVersion":
            return Optional.ofNullable(clazz.cast(clientVersionAsString()));
        case "ExportableKey":
            return Optional.ofNullable(clazz.cast(exportableKey()));
        case "RequireAlternateSignatureAlgorithm":
            return Optional.ofNullable(clazz.cast(requireAlternateSignatureAlgorithm()));
        case "StrongKeyProtectionRequired":
            return Optional.ofNullable(clazz.cast(strongKeyProtectionRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientVersion", CLIENT_VERSION_FIELD);
        map.put("ExportableKey", EXPORTABLE_KEY_FIELD);
        map.put("RequireAlternateSignatureAlgorithm", REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD);
        map.put("StrongKeyProtectionRequired", STRONG_KEY_PROTECTION_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyFlagsV3, T> g) {
        return obj -> g.apply((PrivateKeyFlagsV3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateKeyFlagsV3> {
        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV3
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV3
         */
        Builder clientVersion(String clientVersion);

        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV3
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV3
         */
        Builder clientVersion(ClientCompatibilityV3 clientVersion);

        /**
         * <p>
         * Allows the private key to be exported.
         * </p>
         * 
         * @param exportableKey
         *        Allows the private key to be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableKey(Boolean exportableKey);

        /**
         * <p>
         * Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
         * applications can accept this signature format.
         * </p>
         * 
         * @param requireAlternateSignatureAlgorithm
         *        Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects,
         *        and applications can accept this signature format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm);

        /**
         * <p>
         * Requirer user input when using the private key for enrollment.
         * </p>
         * 
         * @param strongKeyProtectionRequired
         *        Requirer user input when using the private key for enrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired);
    }

    static final class BuilderImpl implements Builder {
        private String clientVersion;

        private Boolean exportableKey;

        private Boolean requireAlternateSignatureAlgorithm;

        private Boolean strongKeyProtectionRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyFlagsV3 model) {
            clientVersion(model.clientVersion);
            exportableKey(model.exportableKey);
            requireAlternateSignatureAlgorithm(model.requireAlternateSignatureAlgorithm);
            strongKeyProtectionRequired(model.strongKeyProtectionRequired);
        }

        public final String getClientVersion() {
            return clientVersion;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientCompatibilityV3 clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final Boolean getExportableKey() {
            return exportableKey;
        }

        public final void setExportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
        }

        @Override
        public final Builder exportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
            return this;
        }

        public final Boolean getRequireAlternateSignatureAlgorithm() {
            return requireAlternateSignatureAlgorithm;
        }

        public final void setRequireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
        }

        @Override
        public final Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
            return this;
        }

        public final Boolean getStrongKeyProtectionRequired() {
            return strongKeyProtectionRequired;
        }

        public final void setStrongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
        }

        @Override
        public final Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
            return this;
        }

        @Override
        public PrivateKeyFlagsV3 build() {
            return new PrivateKeyFlagsV3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
