/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Template configuration to define the information included in certificates. Define certificate validity and renewal
 * periods, certificate request handling and enrollment options, key usage extensions, application policies, and
 * cryptography settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateDefinition.Builder, TemplateDefinition> {
    private static final SdkField<TemplateV2> TEMPLATE_V2_FIELD = SdkField.<TemplateV2> builder(MarshallingType.SDK_POJO)
            .memberName("TemplateV2").getter(getter(TemplateDefinition::templateV2)).setter(setter(Builder::templateV2))
            .constructor(TemplateV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV2").build()).build();

    private static final SdkField<TemplateV3> TEMPLATE_V3_FIELD = SdkField.<TemplateV3> builder(MarshallingType.SDK_POJO)
            .memberName("TemplateV3").getter(getter(TemplateDefinition::templateV3)).setter(setter(Builder::templateV3))
            .constructor(TemplateV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV3").build()).build();

    private static final SdkField<TemplateV4> TEMPLATE_V4_FIELD = SdkField.<TemplateV4> builder(MarshallingType.SDK_POJO)
            .memberName("TemplateV4").getter(getter(TemplateDefinition::templateV4)).setter(setter(Builder::templateV4))
            .constructor(TemplateV4::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV4").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_V2_FIELD,
            TEMPLATE_V3_FIELD, TEMPLATE_V4_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TemplateV2 templateV2;

    private final TemplateV3 templateV3;

    private final TemplateV4 templateV4;

    private final Type type;

    private TemplateDefinition(BuilderImpl builder) {
        this.templateV2 = builder.templateV2;
        this.templateV3 = builder.templateV3;
        this.templateV4 = builder.templateV4;
        this.type = builder.type;
    }

    /**
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @return Template configuration to define the information included in certificates. Define certificate validity
     *         and renewal periods, certificate request handling and enrollment options, key usage extensions,
     *         application policies, and cryptography settings.
     */
    public final TemplateV2 templateV2() {
        return templateV2;
    }

    /**
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @return Template configuration to define the information included in certificates. Define certificate validity
     *         and renewal periods, certificate request handling and enrollment options, key usage extensions,
     *         application policies, and cryptography settings.
     */
    public final TemplateV3 templateV3() {
        return templateV3;
    }

    /**
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @return Template configuration to define the information included in certificates. Define certificate validity
     *         and renewal periods, certificate request handling and enrollment options, key usage extensions,
     *         application policies, and cryptography settings.
     */
    public final TemplateV4 templateV4() {
        return templateV4;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateV2());
        hashCode = 31 * hashCode + Objects.hashCode(templateV3());
        hashCode = 31 * hashCode + Objects.hashCode(templateV4());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateDefinition)) {
            return false;
        }
        TemplateDefinition other = (TemplateDefinition) obj;
        return Objects.equals(templateV2(), other.templateV2()) && Objects.equals(templateV3(), other.templateV3())
                && Objects.equals(templateV4(), other.templateV4());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateDefinition").add("TemplateV2", templateV2()).add("TemplateV3", templateV3())
                .add("TemplateV4", templateV4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateV2":
            return Optional.ofNullable(clazz.cast(templateV2()));
        case "TemplateV3":
            return Optional.ofNullable(clazz.cast(templateV3()));
        case "TemplateV4":
            return Optional.ofNullable(clazz.cast(templateV4()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #templateV2()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV2
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV2(TemplateV2 templateV2) {
        return builder().templateV2(templateV2).build();
    }

    /**
     * Create an instance of this class with {@link #templateV2()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV2
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV2(Consumer<TemplateV2.Builder> templateV2) {
        TemplateV2.Builder builder = TemplateV2.builder();
        templateV2.accept(builder);
        return fromTemplateV2(builder.build());
    }

    /**
     * Create an instance of this class with {@link #templateV3()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV3
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV3(TemplateV3 templateV3) {
        return builder().templateV3(templateV3).build();
    }

    /**
     * Create an instance of this class with {@link #templateV3()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV3
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV3(Consumer<TemplateV3.Builder> templateV3) {
        TemplateV3.Builder builder = TemplateV3.builder();
        templateV3.accept(builder);
        return fromTemplateV3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #templateV4()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV4
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV4(TemplateV4 templateV4) {
        return builder().templateV4(templateV4).build();
    }

    /**
     * Create an instance of this class with {@link #templateV4()} initialized to the given value.
     *
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @param templateV4
     *        Template configuration to define the information included in certificates. Define certificate validity and
     *        renewal periods, certificate request handling and enrollment options, key usage extensions, application
     *        policies, and cryptography settings.
     */
    public static TemplateDefinition fromTemplateV4(Consumer<TemplateV4.Builder> templateV4) {
        TemplateV4.Builder builder = TemplateV4.builder();
        templateV4.accept(builder);
        return fromTemplateV4(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateV2", TEMPLATE_V2_FIELD);
        map.put("TemplateV3", TEMPLATE_V3_FIELD);
        map.put("TemplateV4", TEMPLATE_V4_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateDefinition, T> g) {
        return obj -> g.apply((TemplateDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateDefinition> {
        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * 
         * @param templateV2
         *        Template configuration to define the information included in certificates. Define certificate validity
         *        and renewal periods, certificate request handling and enrollment options, key usage extensions,
         *        application policies, and cryptography settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateV2(TemplateV2 templateV2);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateV2.Builder} avoiding the need to
         * create one manually via {@link TemplateV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateV2.Builder#build()} is called immediately and its result
         * is passed to {@link #templateV2(TemplateV2)}.
         * 
         * @param templateV2
         *        a consumer that will call methods on {@link TemplateV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateV2(TemplateV2)
         */
        default Builder templateV2(Consumer<TemplateV2.Builder> templateV2) {
            return templateV2(TemplateV2.builder().applyMutation(templateV2).build());
        }

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * 
         * @param templateV3
         *        Template configuration to define the information included in certificates. Define certificate validity
         *        and renewal periods, certificate request handling and enrollment options, key usage extensions,
         *        application policies, and cryptography settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateV3(TemplateV3 templateV3);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateV3.Builder} avoiding the need to
         * create one manually via {@link TemplateV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateV3.Builder#build()} is called immediately and its result
         * is passed to {@link #templateV3(TemplateV3)}.
         * 
         * @param templateV3
         *        a consumer that will call methods on {@link TemplateV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateV3(TemplateV3)
         */
        default Builder templateV3(Consumer<TemplateV3.Builder> templateV3) {
            return templateV3(TemplateV3.builder().applyMutation(templateV3).build());
        }

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * 
         * @param templateV4
         *        Template configuration to define the information included in certificates. Define certificate validity
         *        and renewal periods, certificate request handling and enrollment options, key usage extensions,
         *        application policies, and cryptography settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateV4(TemplateV4 templateV4);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateV4.Builder} avoiding the need to
         * create one manually via {@link TemplateV4#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateV4.Builder#build()} is called immediately and its result
         * is passed to {@link #templateV4(TemplateV4)}.
         * 
         * @param templateV4
         *        a consumer that will call methods on {@link TemplateV4.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateV4(TemplateV4)
         */
        default Builder templateV4(Consumer<TemplateV4.Builder> templateV4) {
            return templateV4(TemplateV4.builder().applyMutation(templateV4).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TemplateV2 templateV2;

        private TemplateV3 templateV3;

        private TemplateV4 templateV4;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateDefinition model) {
            templateV2(model.templateV2);
            templateV3(model.templateV3);
            templateV4(model.templateV4);
        }

        public final TemplateV2.Builder getTemplateV2() {
            return templateV2 != null ? templateV2.toBuilder() : null;
        }

        public final void setTemplateV2(TemplateV2.BuilderImpl templateV2) {
            Object oldValue = this.templateV2;
            this.templateV2 = templateV2 != null ? templateV2.build() : null;
            handleUnionValueChange(Type.TEMPLATE_V2, oldValue, this.templateV2);
        }

        @Override
        public final Builder templateV2(TemplateV2 templateV2) {
            Object oldValue = this.templateV2;
            this.templateV2 = templateV2;
            handleUnionValueChange(Type.TEMPLATE_V2, oldValue, this.templateV2);
            return this;
        }

        public final TemplateV3.Builder getTemplateV3() {
            return templateV3 != null ? templateV3.toBuilder() : null;
        }

        public final void setTemplateV3(TemplateV3.BuilderImpl templateV3) {
            Object oldValue = this.templateV3;
            this.templateV3 = templateV3 != null ? templateV3.build() : null;
            handleUnionValueChange(Type.TEMPLATE_V3, oldValue, this.templateV3);
        }

        @Override
        public final Builder templateV3(TemplateV3 templateV3) {
            Object oldValue = this.templateV3;
            this.templateV3 = templateV3;
            handleUnionValueChange(Type.TEMPLATE_V3, oldValue, this.templateV3);
            return this;
        }

        public final TemplateV4.Builder getTemplateV4() {
            return templateV4 != null ? templateV4.toBuilder() : null;
        }

        public final void setTemplateV4(TemplateV4.BuilderImpl templateV4) {
            Object oldValue = this.templateV4;
            this.templateV4 = templateV4 != null ? templateV4.build() : null;
            handleUnionValueChange(Type.TEMPLATE_V4, oldValue, this.templateV4);
        }

        @Override
        public final Builder templateV4(TemplateV4 templateV4) {
            Object oldValue = this.templateV4;
            this.templateV4 = templateV4;
            handleUnionValueChange(Type.TEMPLATE_V4, oldValue, this.templateV4);
            return this;
        }

        @Override
        public TemplateDefinition build() {
            return new TemplateDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TemplateDefinition#type()
     */
    public enum Type {
        TEMPLATE_V2,

        TEMPLATE_V3,

        TEMPLATE_V4,

        UNKNOWN_TO_SDK_VERSION
    }
}
