/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune. For more information about using Connector
 * for SCEP for Microsoft Intune, see <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html">Using
 * Connector for SCEP for Microsoft Intune</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenIdConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenIdConfiguration.Builder, OpenIdConfiguration> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(OpenIdConfiguration::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(OpenIdConfiguration::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> AUDIENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Audience").getter(getter(OpenIdConfiguration::audience)).setter(setter(Builder::audience))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audience").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, SUBJECT_FIELD,
            AUDIENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String issuer;

    private final String subject;

    private final String audience;

    private OpenIdConfiguration(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.subject = builder.subject;
        this.audience = builder.audience;
    }

    /**
     * <p>
     * The issuer value to copy into your Microsoft Entra app registration's OIDC.
     * </p>
     * 
     * @return The issuer value to copy into your Microsoft Entra app registration's OIDC.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The subject value to copy into your Microsoft Entra app registration's OIDC.
     * </p>
     * 
     * @return The subject value to copy into your Microsoft Entra app registration's OIDC.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The audience value to copy into your Microsoft Entra app registration's OIDC.
     * </p>
     * 
     * @return The audience value to copy into your Microsoft Entra app registration's OIDC.
     */
    public final String audience() {
        return audience;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(audience());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConfiguration)) {
            return false;
        }
        OpenIdConfiguration other = (OpenIdConfiguration) obj;
        return Objects.equals(issuer(), other.issuer()) && Objects.equals(subject(), other.subject())
                && Objects.equals(audience(), other.audience());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenIdConfiguration").add("Issuer", issuer()).add("Subject", subject())
                .add("Audience", audience()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Audience":
            return Optional.ofNullable(clazz.cast(audience()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenIdConfiguration, T> g) {
        return obj -> g.apply((OpenIdConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenIdConfiguration> {
        /**
         * <p>
         * The issuer value to copy into your Microsoft Entra app registration's OIDC.
         * </p>
         * 
         * @param issuer
         *        The issuer value to copy into your Microsoft Entra app registration's OIDC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The subject value to copy into your Microsoft Entra app registration's OIDC.
         * </p>
         * 
         * @param subject
         *        The subject value to copy into your Microsoft Entra app registration's OIDC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The audience value to copy into your Microsoft Entra app registration's OIDC.
         * </p>
         * 
         * @param audience
         *        The audience value to copy into your Microsoft Entra app registration's OIDC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);
    }

    static final class BuilderImpl implements Builder {
        private String issuer;

        private String subject;

        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIdConfiguration model) {
            issuer(model.issuer);
            subject(model.subject);
            audience(model.audience);
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getAudience() {
            return audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        @Override
        public OpenIdConfiguration build() {
            return new OpenIdConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
