/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChallengeMetadataRequest extends PcaConnectorScepRequest implements
        ToCopyableBuilder<GetChallengeMetadataRequest.Builder, GetChallengeMetadataRequest> {
    private static final SdkField<String> CHALLENGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeArn").getter(getter(GetChallengeMetadataRequest::challengeArn))
            .setter(setter(Builder::challengeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChallengeArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ChallengeArn", CHALLENGE_ARN_FIELD);
                }
            });

    private final String challengeArn;

    private GetChallengeMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.challengeArn = builder.challengeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the challenge.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the challenge.
     */
    public final String challengeArn() {
        return challengeArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(challengeArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChallengeMetadataRequest)) {
            return false;
        }
        GetChallengeMetadataRequest other = (GetChallengeMetadataRequest) obj;
        return Objects.equals(challengeArn(), other.challengeArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChallengeMetadataRequest").add("ChallengeArn", challengeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeArn":
            return Optional.ofNullable(clazz.cast(challengeArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetChallengeMetadataRequest, T> g) {
        return obj -> g.apply((GetChallengeMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorScepRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetChallengeMetadataRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the challenge.
         * </p>
         * 
         * @param challengeArn
         *        The Amazon Resource Name (ARN) of the challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeArn(String challengeArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcaConnectorScepRequest.BuilderImpl implements Builder {
        private String challengeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChallengeMetadataRequest model) {
            super(model);
            challengeArn(model.challengeArn);
        }

        public final String getChallengeArn() {
            return challengeArn;
        }

        public final void setChallengeArn(String challengeArn) {
            this.challengeArn = challengeArn;
        }

        @Override
        public final Builder challengeArn(String challengeArn) {
            this.challengeArn = challengeArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetChallengeMetadataRequest build() {
            return new GetChallengeMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
